/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.test;

public class BinaryTreeTest {
    public static void main(String[] args) {
        new BinaryTreeTest().run();
    }

    public void run() {
        Node root = new Node(5);
        System.out.println("Binary Tree Example");
        System.out.println("Building tree with root value " + root.value);
        this.insert(root, 1);
        this.insert(root, 8);
        this.insert(root, 6);
        this.insert(root, 3);
        this.insert(root, 9);
        System.out.println("Traversing tree in order");
        this.printInOrder(root);
        System.out.println("Traversing tree front-to-back from location 7");
        this.printFrontToBack(root, 7);
    }

    public void insert(Node node, int value) {
        if (value < node.value) {
            if (node.left != null) {
                this.insert(node.left, value);
            } else {
                System.out.println("  Inserted " + value + " to left of " + node.value);
                node.left = new Node(value);
            }
        } else if (value > node.value) {
            if (node.right != null) {
                this.insert(node.right, value);
            } else {
                System.out.println("  Inserted " + value + " to right of " + node.value);
                node.right = new Node(value);
            }
        }
    }

    public void printInOrder(Node node) {
        if (node != null) {
            this.printInOrder(node.left);
            System.out.println("  Traversed " + node.value);
            this.printInOrder(node.right);
        }
    }

    public void printFrontToBack(Node node, int camera) {
        if (node == null) {
            return;
        }
        if (node.value > camera) {
            this.printFrontToBack(node.left, camera);
            System.out.println("  Traversed " + node.value);
            this.printFrontToBack(node.right, camera);
        } else if (node.value < camera) {
            this.printFrontToBack(node.right, camera);
            System.out.println("  Traversed " + node.value);
            this.printFrontToBack(node.left, camera);
        } else {
            this.printFrontToBack(node.left, camera);
            this.printFrontToBack(node.right, camera);
        }
    }

    static class Node {
        Node left;
        Node right;
        int value;

        public Node(int value) {
            this.value = value;
        }
    }
}

