/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.util;

import java.util.Random;
import java.util.Vector;

public class MoreMath {
    private static final int TABLE_SIZE_BITS = 12;
    private static final int TABLE_SIZE = 4096;
    private static final int TABLE_SIZE_MASK = 4095;
    private static final int HALF_PI = 1024;
    private static final float CONVERSION_FACTOR = 651.8986f;
    private static float[] sinTable;
    private static Random random;
    private static final double PI_L = 1.2246467991473532E-16;
    private static final double TWO_60 = 1.152921504606847E18;
    private static final double ATAN_0_5H = 0.4636476090008061;
    private static final double ATAN_0_5L = 2.2698777452961687E-17;
    private static final double ATAN_1_5H = 0.982793723247329;
    private static final double ATAN_1_5L = 1.3903311031230998E-17;
    private static final double AT0 = 0.3333333333333293;
    private static final double AT1 = -0.19999999999876483;
    private static final double AT2 = 0.14285714272503466;
    private static final double AT3 = -0.11111110405462356;
    private static final double AT4 = 0.09090887133436507;
    private static final double AT5 = -0.0769187620504483;
    private static final double AT6 = 0.06661073137387531;
    private static final double AT7 = -0.058335701337905735;
    private static final double AT8 = 0.049768779946159324;
    private static final double AT9 = -0.036531572744216916;
    private static final double AT10 = 0.016285820115365782;
    private static final double TWO_29 = 5.36870912E8;
    private static final double TWO_66 = 7.378697629483821E19;

    private static void init() {
        sinTable = new float[4096];
        for (int i = 0; i < 4096; ++i) {
            MoreMath.sinTable[i] = (float)Math.sin((float)i / 651.8986f);
        }
    }

    public static float cos(int angle) {
        return sinTable[1024 - angle & 0xFFF];
    }

    public static float sin(int angle) {
        return sinTable[angle & 0xFFF];
    }

    public static int angleConvert(float angleInRadians) {
        return (int)(angleInRadians * 651.8986f);
    }

    public static int sign(short v) {
        return v > 0 ? 1 : (v < 0 ? -1 : 0);
    }

    public static int sign(int v) {
        return v > 0 ? 1 : (v < 0 ? -1 : 0);
    }

    public static int sign(long v) {
        return v > 0L ? 1 : (v < 0L ? -1 : 0);
    }

    public static int sign(float v) {
        return v > 0.0f ? 1 : (v < 0.0f ? -1 : 0);
    }

    public static int sign(double v) {
        return v > 0.0 ? 1 : (v < 0.0 ? -1 : 0);
    }

    public static int ceil(float f) {
        if (f > 0.0f) {
            return (int)f + 1;
        }
        return (int)f;
    }

    public static int floor(float f) {
        if (f >= 0.0f) {
            return (int)f;
        }
        return (int)f - 1;
    }

    public static float random() {
        return random.nextFloat();
    }

    public static int random(int max) {
        return (int)Math.floor((double)(random.nextFloat() * (float)max) + 0.5);
    }

    public static int random(int min, int max) {
        return min + MoreMath.random(max - min);
    }

    public static float random(float max) {
        return random.nextFloat() * max;
    }

    public static float random(float min, float max) {
        return min + MoreMath.random(max - min);
    }

    public static Object random(Vector list) {
        if (list.size() == 0) {
            return null;
        }
        return list.elementAt(MoreMath.random(list.size() - 1));
    }

    public static boolean chance(float p) {
        return random.nextFloat() <= p;
    }

    public static boolean isPowerOfTwo(int n) {
        return (n & n - 1) == 0;
    }

    public static int getBitCount(int n) {
        int count = 0;
        while (n > 0) {
            count += n & 1;
            n >>= 1;
        }
        return count;
    }

    public static double atan2(double y, double x) {
        if (x != x || y != y) {
            return Double.NaN;
        }
        if (x == 1.0) {
            return MoreMath.atan(y);
        }
        if (x == Double.POSITIVE_INFINITY) {
            if (y == Double.POSITIVE_INFINITY) {
                return 0.7853981633974483;
            }
            if (y == Double.NEGATIVE_INFINITY) {
                return -0.7853981633974483;
            }
            return 0.0 * y;
        }
        if (x == Double.NEGATIVE_INFINITY) {
            if (y == Double.POSITIVE_INFINITY) {
                return 2.356194490192345;
            }
            if (y == Double.NEGATIVE_INFINITY) {
                return -2.356194490192345;
            }
            return 1.0 / (0.0 * y) == Double.POSITIVE_INFINITY ? Math.PI : -Math.PI;
        }
        if (y == 0.0) {
            if (1.0 / (0.0 * x) == Double.POSITIVE_INFINITY) {
                return y;
            }
            return 1.0 / y == Double.POSITIVE_INFINITY ? Math.PI : -Math.PI;
        }
        if (y == Double.POSITIVE_INFINITY || y == Double.NEGATIVE_INFINITY || x == 0.0) {
            return y < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
        }
        double z = Math.abs(y / x);
        z = z > 1.152921504606847E18 ? 1.5707963267948966 : (x < 0.0 && z < 8.673617379884035E-19 ? 0.0 : MoreMath.atan(z));
        if (x > 0.0) {
            return y > 0.0 ? z : -z;
        }
        return y > 0.0 ? Math.PI - (z - 1.2246467991473532E-16) : z - 1.2246467991473532E-16 - Math.PI;
    }

    public static double atan(double x) {
        double lo;
        double hi;
        boolean negative;
        boolean bl = negative = x < 0.0;
        if (negative) {
            x = -x;
        }
        if (x >= 7.378697629483821E19) {
            return negative ? -1.5707963267948966 : 1.5707963267948966;
        }
        if (!(x >= 0.4375)) {
            if (!(x >= 1.862645149230957E-9)) {
                return negative ? -x : x;
            }
            hi = 0.0;
            lo = 0.0;
        } else if (x < 1.1875) {
            if (x < 0.6875) {
                x = (2.0 * x - 1.0) / (2.0 + x);
                hi = 0.4636476090008061;
                lo = 2.2698777452961687E-17;
            } else {
                x = (x - 1.0) / (x + 1.0);
                hi = 0.7853981633974483;
                lo = 3.061616997868383E-17;
            }
        } else if (x < 2.4375) {
            x = (x - 1.5) / (1.0 + 1.5 * x);
            hi = 0.982793723247329;
            lo = 1.3903311031230998E-17;
        } else {
            x = -1.0 / x;
            hi = 1.5707963267948966;
            lo = 6.123233995736766E-17;
        }
        double z = x * x;
        double w = z * z;
        double s1 = z * (0.3333333333333293 + w * (0.14285714272503466 + w * (0.09090887133436507 + w * (0.06661073137387531 + w * (0.049768779946159324 + w * 0.016285820115365782)))));
        double s2 = w * (-0.19999999999876483 + w * (-0.11111110405462356 + w * (-0.0769187620504483 + w * (-0.058335701337905735 + w * -0.036531572744216916))));
        if (hi == 0.0) {
            return negative ? x * (s1 + s2) - x : x - x * (s1 + s2);
        }
        z = hi - (x * (s1 + s2) - lo - x);
        return negative ? -z : z;
    }

    static {
        random = new Random();
        MoreMath.init();
    }
}

