/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.ai;

import org.thenesis.planetino2.ai.AIBot;
import org.thenesis.planetino2.ai.EvolutionGenePool;
import org.thenesis.planetino2.game.CollisionDetection;
import org.thenesis.planetino2.math3D.PolygonGroup;

public class EvolutionBot
extends AIBot {
    private EvolutionGenePool genePool;
    private long damagedCaused;

    public EvolutionBot(PolygonGroup polygonGroup, CollisionDetection collisionDetection, EvolutionGenePool genePool, PolygonGroup blastModel) {
        super(polygonGroup, collisionDetection, genePool.getNewBrain(), blastModel);
        this.genePool = genePool;
        this.setRegenerating(true);
    }

    public void regenerate() {
        this.genePool.notifyDead(this.brain, this.damagedCaused);
        this.brain = this.genePool.getNewBrain();
        this.damagedCaused = 0L;
        super.regenerate();
    }

    public void notifyHitPlayer(long damage) {
        this.damagedCaused += damage;
    }
}

