/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.ai.pattern;

import java.util.Enumeration;
import java.util.Vector;
import org.thenesis.planetino2.ai.pattern.AIPattern;
import org.thenesis.planetino2.bsp2D.BSPTree;
import org.thenesis.planetino2.game.GameObject;
import org.thenesis.planetino2.math3D.Vector3D;
import org.thenesis.planetino2.util.MoreMath;

public class DodgePatternRandom
extends AIPattern {
    private float radiusSq;

    public DodgePatternRandom(BSPTree tree) {
        this(tree, 500.0f);
    }

    public DodgePatternRandom(BSPTree tree, float radius) {
        super(tree);
        this.radiusSq = radius * radius;
    }

    public Enumeration find(GameObject bot, GameObject player) {
        Vector3D goal = this.getLocationFromPlayer(bot, player, this.radiusSq);
        float maxAngle = 1.5707964f;
        float angle = MoreMath.random(-maxAngle, maxAngle);
        goal.subtract(player.getLocation());
        goal.rotateY(angle);
        goal.add(player.getLocation());
        this.calcFloorHeight(goal, bot.getFloorHeight());
        Vector<Vector3D> v = new Vector<Vector3D>();
        v.addElement(goal);
        return v.elements();
    }
}

