/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.graphics3D;

import javax.microedition.lcdui.Graphics;
import org.thenesis.planetino2.graphics.Screen;
import org.thenesis.planetino2.graphics3D.ScanConverter;
import org.thenesis.planetino2.math3D.Polygon3D;
import org.thenesis.planetino2.math3D.Transform3D;
import org.thenesis.planetino2.math3D.ViewWindow;

public abstract class PolygonRenderer {
    protected ScanConverter scanConverter;
    protected Transform3D camera;
    protected ViewWindow viewWindow;
    protected boolean clearViewEveryFrame;
    protected Polygon3D sourcePolygon;
    protected Polygon3D destPolygon;

    public PolygonRenderer(Transform3D camera, ViewWindow viewWindow) {
        this(camera, viewWindow, true);
    }

    public PolygonRenderer(Transform3D camera, ViewWindow viewWindow, boolean clearViewEveryFrame) {
        this.camera = camera;
        this.viewWindow = viewWindow;
        this.clearViewEveryFrame = clearViewEveryFrame;
        this.init();
    }

    protected void init() {
        this.destPolygon = new Polygon3D();
        this.scanConverter = new ScanConverter(this.viewWindow);
    }

    public Transform3D getCamera() {
        return this.camera;
    }

    public void startFrame(Screen screen) {
        Graphics g = screen.getGraphics();
        if (this.clearViewEveryFrame) {
            g.setColor(0);
            g.fillRect(this.viewWindow.getLeftOffset(), this.viewWindow.getTopOffset(), this.viewWindow.getWidth(), this.viewWindow.getHeight());
        }
    }

    public void endFrame(Screen screen) {
    }

    public boolean draw(Graphics g, Polygon3D poly) {
        if (poly.isFacing(this.camera.getLocation())) {
            this.sourcePolygon = poly;
            this.destPolygon.setTo(poly);
            this.destPolygon.subtract(this.camera);
            boolean visible = this.destPolygon.clip(-1.0f);
            if (visible) {
                this.destPolygon.project(this.viewWindow);
                visible = this.scanConverter.convert(this.destPolygon);
                if (visible) {
                    this.drawCurrentPolygon(g);
                    return true;
                }
            }
        }
        return false;
    }

    protected abstract void drawCurrentPolygon(Graphics var1);
}

