/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.graphics3D;

import javax.microedition.lcdui.Graphics;
import org.thenesis.planetino2.graphics3D.FastTexturedPolygonRenderer;
import org.thenesis.planetino2.graphics3D.texture.ShadedTexture;
import org.thenesis.planetino2.graphics3D.texture.Texture;
import org.thenesis.planetino2.math3D.PointLight3D;
import org.thenesis.planetino2.math3D.TexturedPolygon3D;
import org.thenesis.planetino2.math3D.Transform3D;
import org.thenesis.planetino2.math3D.Vector3D;
import org.thenesis.planetino2.math3D.ViewWindow;

public class ShadedTexturedPolygonRenderer
extends FastTexturedPolygonRenderer {
    private PointLight3D lightSource;
    private float ambientLightIntensity = 0.5f;
    private Vector3D directionToLight = new Vector3D();

    public ShadedTexturedPolygonRenderer(Transform3D camera, ViewWindow viewWindow) {
        this(camera, viewWindow, true);
    }

    public ShadedTexturedPolygonRenderer(Transform3D camera, ViewWindow viewWindow, boolean clearViewEveryFrame) {
        super(camera, viewWindow, clearViewEveryFrame);
    }

    public PointLight3D getLightSource() {
        return this.lightSource;
    }

    public void setLightSource(PointLight3D lightSource) {
        this.lightSource = lightSource;
    }

    public float getAmbientLightIntensity() {
        return this.ambientLightIntensity;
    }

    public void setAmbientLightIntensity(float i) {
        this.ambientLightIntensity = i;
    }

    protected void drawCurrentPolygon(Graphics g) {
        TexturedPolygon3D poly;
        Texture texture;
        if (this.sourcePolygon instanceof TexturedPolygon3D && (texture = (poly = (TexturedPolygon3D)this.sourcePolygon).getTexture()) instanceof ShadedTexture) {
            this.calcShadeLevel();
        }
        super.drawCurrentPolygon(g);
    }

    private void calcShadeLevel() {
        TexturedPolygon3D poly = (TexturedPolygon3D)this.sourcePolygon;
        float intensity = 0.0f;
        if (this.lightSource != null) {
            this.directionToLight.setTo(0.0f, 0.0f, 0.0f);
            for (int i = 0; i < poly.getNumVertices(); ++i) {
                this.directionToLight.add(poly.getVertex(i));
            }
            this.directionToLight.divide(poly.getNumVertices());
            this.directionToLight.subtract(this.lightSource);
            this.directionToLight.multiply(-1.0f);
            float distance = this.directionToLight.length();
            this.directionToLight.normalize();
            Vector3D normal = poly.getNormal();
            intensity = this.lightSource.getIntensity(distance) * this.directionToLight.getDotProduct(normal);
            intensity = Math.min(intensity, 1.0f);
            intensity = Math.max(intensity, 0.0f);
        }
        intensity += this.ambientLightIntensity;
        intensity = Math.min(intensity, 1.0f);
        intensity = Math.max(intensity, 0.0f);
        int level = (int)Math.floor((double)(intensity * 63.0f) + 0.5);
        ((ShadedTexture)poly.getTexture()).setDefaultShadeLevel(level);
    }
}

