/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.graphics3D.texture;

import org.thenesis.planetino2.graphics.Color;
import org.thenesis.planetino2.graphics3D.texture.Texture;

public final class PowerOf2Texture
extends Texture {
    private int[] buffer;
    private int widthBits;
    private int widthMask;
    private int heightBits;
    private int heightMask;

    public PowerOf2Texture(int[] buffer, int widthBits, int heightBits) {
        super(1 << widthBits, 1 << heightBits);
        this.buffer = buffer;
        this.widthBits = widthBits;
        this.heightBits = heightBits;
        this.widthMask = this.getWidth() - 1;
        this.heightMask = this.getHeight() - 1;
    }

    public int getColor(int x, int y) {
        return Color.convertRBG565To888(this.buffer[(x & this.widthMask) + ((y & this.heightMask) << this.widthBits)]);
    }

    public int[] getRawData() {
        return this.buffer;
    }

    public int getHeightBits() {
        return this.heightBits;
    }

    public int getHeightMask() {
        return this.heightMask;
    }

    public int getWidthBits() {
        return this.widthBits;
    }

    public int getWidthMask() {
        return this.widthMask;
    }
}

