/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.input;

import java.util.Vector;
import org.thenesis.planetino2.input.GameAction;
import org.thenesis.planetino2.math3D.Point;

public abstract class InputManager {
    public static final int MOUSE_MOVE_LEFT = 0;
    public static final int MOUSE_MOVE_RIGHT = 1;
    public static final int MOUSE_MOVE_UP = 2;
    public static final int MOUSE_MOVE_DOWN = 3;
    public static final int MOUSE_WHEEL_UP = 4;
    public static final int MOUSE_WHEEL_DOWN = 5;
    public static final int MOUSE_BUTTON_1 = 6;
    public static final int MOUSE_BUTTON_2 = 7;
    public static final int MOUSE_BUTTON_3 = 8;
    public static final int KEYCODE_OFFSET = 100;
    private static final int NUM_MOUSE_CODES = 9;
    private static final int NUM_KEY_CODES = 700;
    private GameAction[] keyActions = new GameAction[700];
    private GameAction[] mouseActions = new GameAction[9];
    private Point mouseLocation = new Point();
    private Point centerLocation = new Point();
    private boolean isRecentering;

    public void setRelativeMouseMode(boolean mode) {
    }

    public boolean isRelativeMouseMode() {
        return false;
    }

    public void mapToKey(GameAction gameAction, int keyCode) {
        this.keyActions[keyCode + 100] = gameAction;
    }

    public void mapToMouse(GameAction gameAction, int mouseCode) {
        this.mouseActions[mouseCode] = gameAction;
    }

    public void clearMap(GameAction gameAction) {
        int i;
        for (i = 0; i < this.keyActions.length; ++i) {
            if (this.keyActions[i] != gameAction) continue;
            this.keyActions[i] = null;
        }
        for (i = 0; i < this.mouseActions.length; ++i) {
            if (this.mouseActions[i] != gameAction) continue;
            this.mouseActions[i] = null;
        }
        gameAction.reset();
    }

    public Vector getMaps(GameAction gameCode) {
        int i;
        Vector<String> list = new Vector<String>();
        for (i = 0; i < this.keyActions.length; ++i) {
            if (this.keyActions[i] != gameCode) continue;
            list.addElement(this.getKeyName(i));
        }
        for (i = 0; i < this.mouseActions.length; ++i) {
            if (this.mouseActions[i] != gameCode) continue;
            list.addElement(InputManager.getMouseName(i));
        }
        return list;
    }

    public void resetAllGameActions() {
        int i;
        for (i = 0; i < this.keyActions.length; ++i) {
            if (this.keyActions[i] == null) continue;
            this.keyActions[i].reset();
        }
        for (i = 0; i < this.mouseActions.length; ++i) {
            if (this.mouseActions[i] == null) continue;
            this.mouseActions[i].reset();
        }
    }

    public abstract String getKeyName(int var1);

    public static String getMouseName(int mouseCode) {
        switch (mouseCode) {
            case 0: {
                return "Mouse Left";
            }
            case 1: {
                return "Mouse Right";
            }
            case 2: {
                return "Mouse Up";
            }
            case 3: {
                return "Mouse Down";
            }
            case 4: {
                return "Mouse Wheel Up";
            }
            case 5: {
                return "Mouse Wheel Down";
            }
            case 6: {
                return "Mouse Button 1";
            }
            case 7: {
                return "Mouse Button 2";
            }
            case 8: {
                return "Mouse Button 3";
            }
        }
        return "Unknown mouse code " + mouseCode;
    }

    public int getMouseX() {
        return this.mouseLocation.x;
    }

    public int getMouseY() {
        return this.mouseLocation.y;
    }

    private synchronized void recenterMouse() {
    }

    private GameAction getKeyAction(int keyCode) {
        if (keyCode < this.keyActions.length) {
            return this.keyActions[keyCode + 100];
        }
        return null;
    }

    private GameAction getMouseButtonAction() {
        if (this.mouseActions[6] != null) {
            return this.mouseActions[6];
        }
        return null;
    }

    public void keyPressed(int keyCode) {
        GameAction gameAction = this.getKeyAction(keyCode);
        if (gameAction != null) {
            gameAction.press();
        }
    }

    public void keyReleased(int keyCode) {
        GameAction gameAction = this.getKeyAction(keyCode);
        if (gameAction != null) {
            gameAction.release();
        }
    }

    public void pointerPressed(int x, int y) {
        this.mouseLocation.x = x;
        this.mouseLocation.y = y;
        GameAction gameAction = this.getMouseButtonAction();
        if (gameAction != null) {
            gameAction.press();
        }
    }

    public void pointerReleased() {
        GameAction gameAction = this.getMouseButtonAction();
        if (gameAction != null) {
            gameAction.release();
        }
    }

    public synchronized void pointerDragged(int x, int y) {
        if (this.isRecentering) {
            this.isRecentering = false;
        } else {
            int dx = x - this.mouseLocation.x;
            int dy = y - this.mouseLocation.y;
            this.mouseHelper(0, 1, dx);
            this.mouseHelper(2, 3, dy);
            if (this.isRelativeMouseMode()) {
                this.recenterMouse();
            }
        }
        this.mouseLocation.x = x;
        this.mouseLocation.y = y;
    }

    private void mouseHelper(int codeNeg, int codePos, int amount) {
        GameAction gameAction = amount < 0 ? this.mouseActions[codeNeg] : this.mouseActions[codePos];
        if (gameAction != null) {
            gameAction.press(Math.abs(amount));
            gameAction.release();
        }
    }
}

