/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.math3D;

import org.thenesis.planetino2.graphics3D.texture.Texture;
import org.thenesis.planetino2.math3D.Polygon3D;
import org.thenesis.planetino2.math3D.Rectangle3D;
import org.thenesis.planetino2.math3D.Transform3D;
import org.thenesis.planetino2.math3D.Vector3D;

public class TexturedPolygon3D
extends Polygon3D {
    protected Rectangle3D textureBounds = new Rectangle3D();
    protected Texture texture;

    public TexturedPolygon3D() {
    }

    public TexturedPolygon3D(Vector3D v0, Vector3D v1, Vector3D v2) {
        this(new Vector3D[]{v0, v1, v2});
    }

    public TexturedPolygon3D(Vector3D v0, Vector3D v1, Vector3D v2, Vector3D v3) {
        this(new Vector3D[]{v0, v1, v2, v3});
    }

    public TexturedPolygon3D(Vector3D[] vertices) {
        super(vertices);
    }

    public void setTo(Polygon3D poly) {
        super.setTo(poly);
        if (poly instanceof TexturedPolygon3D) {
            TexturedPolygon3D tPoly = (TexturedPolygon3D)poly;
            this.textureBounds.setTo(tPoly.textureBounds);
            this.texture = tPoly.texture;
        }
    }

    public Texture getTexture() {
        return this.texture;
    }

    public Rectangle3D getTextureBounds() {
        return this.textureBounds;
    }

    public void setTexture(Texture texture) {
        this.texture = texture;
        this.textureBounds.setWidth(texture.getWidth());
        this.textureBounds.setHeight(texture.getHeight());
    }

    public void setTexture(Texture texture, Rectangle3D bounds) {
        this.setTexture(texture);
        this.textureBounds.setTo(bounds);
    }

    public void add(Vector3D u) {
        super.add(u);
        this.textureBounds.add(u);
    }

    public void subtract(Vector3D u) {
        super.subtract(u);
        this.textureBounds.subtract(u);
    }

    public void addRotation(Transform3D xform) {
        super.addRotation(xform);
        this.textureBounds.addRotation(xform);
    }

    public void subtractRotation(Transform3D xform) {
        super.subtractRotation(xform);
        this.textureBounds.subtractRotation(xform);
    }

    public Rectangle3D calcBoundingRectangle() {
        Vector3D u = new Vector3D(this.textureBounds.getDirectionU());
        Vector3D v = new Vector3D(this.textureBounds.getDirectionV());
        Vector3D d = new Vector3D();
        u.normalize();
        v.normalize();
        float uMin = 0.0f;
        float uMax = 0.0f;
        float vMin = 0.0f;
        float vMax = 0.0f;
        for (int i = 0; i < this.getNumVertices(); ++i) {
            d.setTo(this.getVertex(i));
            d.subtract(this.getVertex(0));
            float uLength = d.getDotProduct(u);
            float vLength = d.getDotProduct(v);
            uMin = Math.min(uLength, uMin);
            uMax = Math.max(uLength, uMax);
            vMin = Math.min(vLength, vMin);
            vMax = Math.max(vLength, vMax);
        }
        Rectangle3D boundingRect = new Rectangle3D();
        Vector3D origin = boundingRect.getOrigin();
        origin.setTo(this.getVertex(0));
        d.setTo(u);
        d.multiply(uMin);
        origin.add(d);
        d.setTo(v);
        d.multiply(vMin);
        origin.add(d);
        boundingRect.getDirectionU().setTo(u);
        boundingRect.getDirectionV().setTo(v);
        boundingRect.setWidth(uMax - uMin);
        boundingRect.setHeight(vMax - vMin);
        boundingRect.setNormal(this.getNormal());
        return boundingRect;
    }
}

