/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.test;

import java.util.Enumeration;
import java.util.Vector;
import org.thenesis.planetino2.ai.AIBot;
import org.thenesis.planetino2.ai.Brain;
import org.thenesis.planetino2.ai.pattern.AimPattern;
import org.thenesis.planetino2.ai.pattern.AttackPatternRush;
import org.thenesis.planetino2.ai.pattern.AttackPatternStrafe;
import org.thenesis.planetino2.ai.pattern.DodgePatternRandom;
import org.thenesis.planetino2.ai.pattern.DodgePatternZigZag;
import org.thenesis.planetino2.ai.pattern.RunAwayPattern;
import org.thenesis.planetino2.engine.shooter3D.Bot;
import org.thenesis.planetino2.engine.shooter3D.HeadsUpDisplay;
import org.thenesis.planetino2.game.GameObject;
import org.thenesis.planetino2.game.MessageQueue;
import org.thenesis.planetino2.game.Player;
import org.thenesis.planetino2.graphics.Screen;
import org.thenesis.planetino2.input.InputManager;
import org.thenesis.planetino2.math3D.PolygonGroup;
import org.thenesis.planetino2.path.AStarSearchWithBSP;
import org.thenesis.planetino2.test.PathFindingTest;

public class AIBotTest
extends PathFindingTest {
    private Brain averageBrain;
    private Brain aggressiveBrain;
    private Brain scaredBrain;

    public AIBotTest(Screen screen, InputManager inputManager) {
        super(screen, inputManager, "sample3.map");
        this.inputManager = inputManager;
    }

    protected void createBrains() {
        this.averageBrain = new Brain();
        this.averageBrain.attackPathFinder = new AttackPatternRush(this.bspTree);
        this.averageBrain.aimPathFinder = new AimPattern(this.bspTree);
        this.averageBrain.dodgePathFinder = new DodgePatternRandom(this.bspTree);
        this.averageBrain.idlePathFinder = null;
        this.averageBrain.chasePathFinder = new AStarSearchWithBSP(this.bspTree);
        this.averageBrain.runAwayPathFinder = new RunAwayPattern(this.bspTree);
        this.averageBrain.attackProbability = 0.5f;
        this.averageBrain.dodgeProbability = 0.4f;
        this.averageBrain.runAwayProbability = 0.1f;
        this.averageBrain.decisionTime = 4000L;
        this.averageBrain.aimTime = 1000L;
        this.averageBrain.hearDistance = 1000.0f;
        this.aggressiveBrain = new Brain();
        this.aggressiveBrain.attackPathFinder = new AttackPatternStrafe(this.bspTree);
        this.aggressiveBrain.aimPathFinder = new AimPattern(this.bspTree);
        this.aggressiveBrain.dodgePathFinder = new DodgePatternZigZag(this.bspTree);
        this.aggressiveBrain.idlePathFinder = null;
        this.aggressiveBrain.chasePathFinder = new AStarSearchWithBSP(this.bspTree);
        this.aggressiveBrain.runAwayPathFinder = null;
        this.aggressiveBrain.attackProbability = 0.8f;
        this.aggressiveBrain.dodgeProbability = 0.2f;
        this.aggressiveBrain.runAwayProbability = 0.0f;
        this.aggressiveBrain.decisionTime = 2000L;
        this.aggressiveBrain.aimTime = 300L;
        this.aggressiveBrain.hearDistance = 1000.0f;
        this.scaredBrain = new Brain();
        this.scaredBrain.attackPathFinder = new AttackPatternRush(this.bspTree);
        this.scaredBrain.aimPathFinder = new AimPattern(this.bspTree);
        this.scaredBrain.dodgePathFinder = new DodgePatternZigZag(this.bspTree);
        this.scaredBrain.idlePathFinder = null;
        this.scaredBrain.chasePathFinder = new AStarSearchWithBSP(this.bspTree);
        this.scaredBrain.runAwayPathFinder = new RunAwayPattern(this.bspTree);
        this.scaredBrain.attackProbability = 0.2f;
        this.scaredBrain.dodgeProbability = 0.4f;
        this.scaredBrain.runAwayProbability = 0.4f;
        this.scaredBrain.decisionTime = 4000L;
        this.scaredBrain.aimTime = 1000L;
        this.scaredBrain.hearDistance = 2000.0f;
    }

    protected void createGameObjects(Vector mapObjects) {
        this.drawInstructions = false;
        MessageQueue queue = MessageQueue.getInstance();
        this.addOverlay(queue);
        this.addOverlay(new HeadsUpDisplay((Player)this.gameObjectManager.getPlayer()));
        queue.setDebug(true);
        queue.add("Use the mouse/arrow keys to move.");
        queue.add("Press Esc to exit.");
        this.createBrains();
        Enumeration i = mapObjects.elements();
        while (i.hasMoreElements()) {
            AIBot bot;
            PolygonGroup group = (PolygonGroup)i.nextElement();
            String filename = group.getFilename();
            if ("robot.obj3d".equals(filename)) {
                this.gameObjectManager.add(new Bot(group));
                continue;
            }
            if ("averagebot.obj3d".equals(filename)) {
                bot = new AIBot(group, this.collisionDetection, this.averageBrain, this.botProjectileModel);
                this.gameObjectManager.add(bot);
                continue;
            }
            if ("aggressivebot.obj3d".equals(filename)) {
                bot = new AIBot(group, this.collisionDetection, this.aggressiveBrain, this.botProjectileModel);
                this.gameObjectManager.add(bot);
                continue;
            }
            if ("scaredybot.obj3d".equals(filename)) {
                bot = new AIBot(group, this.collisionDetection, this.scaredBrain, this.botProjectileModel);
                this.gameObjectManager.add(bot);
                continue;
            }
            this.gameObjectManager.add(new GameObject(group));
        }
    }
}

