/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.util;

public class MemMonitor {
    private Data heapSize = new Data();
    private Data allocSize = new Data();
    private Data allocIncPerUpdate = new Data();
    private int numHeapIncs = 0;
    private long startTime = System.currentTimeMillis();

    public void takeSample() {
        Runtime runtime = Runtime.getRuntime();
        long currHeapSize = runtime.totalMemory();
        long currAllocSize = currHeapSize - runtime.freeMemory();
        if ((float)currHeapSize > this.heapSize.lastValue) {
            ++this.numHeapIncs;
        }
        if ((float)currAllocSize >= this.allocSize.lastValue) {
            this.allocIncPerUpdate.addValue((float)currAllocSize - this.allocSize.lastValue);
        }
        this.heapSize.addValue(currHeapSize);
        this.allocSize.addValue(currAllocSize);
    }

    public static String toByteFormat(float numBytes) {
        int labelIndex;
        String[] labels = new String[]{" bytes", " KB", " MB", " GB"};
        for (labelIndex = 0; labelIndex < labels.length - 1 && numBytes > 1024.0f; numBytes /= 1024.0f, ++labelIndex) {
        }
        return Math.floor((double)(numBytes * 10.0f) + 0.5) / 10.0 + labels[labelIndex];
    }

    public String toString() {
        long time = System.currentTimeMillis() - this.startTime;
        float timeSecs = (float)time / 1000.0f;
        return "Total Time: " + timeSecs + "s\n" + "Heap: " + this.heapSize + "\n" + "Allocation: " + this.allocSize + "\n" + "Allocation inc/update: " + this.allocIncPerUpdate + "\n" + "Num Heap Incs: " + this.numHeapIncs;
    }

    public static class Data {
        float lastValue = 0.0f;
        float min = Float.MAX_VALUE;
        float max = Float.MIN_VALUE;
        float sum = 0.0f;
        int count = 0;

        public void addValue(float value) {
            this.lastValue = value;
            this.sum += value;
            ++this.count;
            this.min = Math.min(this.min, value);
            this.max = Math.max(this.max, value);
        }

        public String toString() {
            return "Min: " + MemMonitor.toByteFormat(this.min) + "  " + "Max: " + MemMonitor.toByteFormat(this.max) + "  " + "Avg: " + MemMonitor.toByteFormat(this.sum / (float)this.count);
        }
    }
}

