/*
 * Decompiled with CFR 0.152.
 */
package code.Gameplay;

import code.AI.Player;
import code.Gameplay.GameScreen;
import code.Gameplay.Inventory.ItemList;
import code.Gameplay.Inventory.ItemsEngine;
import code.HUD.Base.Font;
import code.HUD.GUIScreen;
import code.utils.GameIni;
import code.utils.ImageResize;
import code.utils.IniFile;
import code.utils.Main;
import code.utils.StringTools;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class InventoryScreen
extends GUIScreen {
    public static boolean proportionalInventory = true;
    private static boolean side = false;
    private static long sideAnimBegin = 0L;
    private static int sideAnimOld = 0;
    private static long sideAnimTime = 130L;
    private static boolean paint = false;
    private GameScreen gameScreen;
    private Player player;
    private ItemList items;
    private int index = 0;
    private String itemName;
    private String itemScript;
    private String itemPath;
    private int itemCount;
    private Image iconItem;

    public InventoryScreen(Main main, GameScreen gameScreen, Player player) {
        this.gameScreen = gameScreen;
        this.items = player.items;
        this.player = player;
        IniFile lang = Main.getGameText();
        this.set(Main.getFont(), lang.get("THROW_ITEM"), lang.get("BACK"));
        this.loadItem();
        sideAnimBegin = 0L;
        this.inverseHScroll = true;
        this.inverseVScroll = true;
    }

    public final void destroy() {
        super.destroy();
        this.iconItem = null;
        this.itemPath = null;
        this.itemScript = null;
        this.itemName = null;
        this.items = null;
        this.player = null;
    }

    private void loadItem() {
        String tmp;
        if (this.items.size() <= 0) {
            this.itemName = null;
            this.itemScript = null;
            this.itemPath = null;
            this.iconItem = null;
            return;
        }
        GameIni item = ItemsEngine.items[this.items.itemAt(this.index)];
        String path = ((IniFile)item).get("ICON");
        this.itemCount = this.items.itemAtCount(this.index);
        this.itemName = ((IniFile)item).get("NAME");
        if (this.itemName != null && (tmp = Main.getGameText().get(this.itemName + "_ITEM")) != null) {
            this.itemName = tmp;
        }
        this.itemScript = ((IniFile)item).get("ON_ACTIVATE");
        if (path.equals(this.itemPath)) {
            return;
        }
        this.itemPath = path;
        this.iconItem = proportionalInventory ? ImageResize.createImageProportional(path, (float)this.getWidth() / 240.0f, (float)this.getHeight() / 320.0f) : ImageResize.createImage(path, this.getWidth(), this.getHeight());
    }

    protected final void paint(Graphics g) {
        int coof;
        paint = true;
        int w = this.getWidth();
        int h = this.getHeight();
        int n = coof = Main.verticalShopScroll ? h : w;
        if (System.currentTimeMillis() - sideAnimBegin < sideAnimTime && sideAnimTime != 0L) {
            coof = (int)((System.currentTimeMillis() - sideAnimBegin) * (long)coof / sideAnimTime);
        }
        if (coof < w && !Main.verticalShopScroll) {
            if (!side) {
                g.setClip(sideAnimOld, 0, coof - sideAnimOld, h);
            }
            if (side) {
                g.setClip(w - coof, 0, coof - sideAnimOld, h);
            }
        } else if (coof < h && Main.verticalShopScroll) {
            if (!side) {
                g.setClip(0, sideAnimOld, w, coof - sideAnimOld);
            }
            if (side) {
                g.setClip(0, h - coof, w, coof - sideAnimOld);
            }
        } else {
            g.setClip(0, 0, w, h);
        }
        g.setColor(0);
        g.fillRect(0, 0, w, h);
        IniFile lang = Main.getGameText();
        int arWidth = w / 34;
        int arHeight = h / 34;
        if (!Main.verticalShopScroll && this.items.size() > 0) {
            this.drawArrow(g, 4, h / 4, arWidth + 4, h / 4 - arHeight / 2, arWidth + 4, h / 4 + arHeight / 2);
            this.drawArrow(g, w - 4, h / 4, w - 4 - arWidth, h / 4 - arHeight / 2, w - 4 - arWidth, h / 4 + arHeight / 2);
        }
        Font font = this.getFont();
        if (this.items.size() > 0) {
            g.drawImage(this.iconItem, w / 2, h / 2, 3);
        }
        font.drawString(g, lang.get("HEALTH") + ":" + this.player.getHp(), w - 2, 2, 24);
        font.drawString(g, lang.get("MONEY") + ":" + this.player.money, 0, 0, 0);
        if (this.items.size() > 0) {
            int ymove = this.iconItem.getHeight() / 2 + 2;
            if (!proportionalInventory) {
                ymove = h / 2 - font.height();
            }
            font.drawString(g, this.itemName, w / 2, h / 2 - ymove - font.height(), 17);
            if (this.itemCount > 1) {
                font.drawString(g, lang.get("ITEMS_COUNT") + ":" + String.valueOf(this.itemCount), w / 2, h / 2 - ymove, 17);
            }
            if (this.itemScript != null) {
                font.drawString(g, lang.get("USE"), w / 2, h - font.height(), 17);
            }
        } else {
            this.set(Main.getFont(), null, lang.get("BACK"));
            font.drawString(g, lang.get("EMPTY_INVENTORY"), w / 2, h / 2, 17);
        }
        this.drawSoftKeys(g);
        sideAnimOld = coof;
        if (coof < w && !Main.verticalShopScroll || coof < h && Main.verticalShopScroll) {
            try {
                Thread.sleep(5L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.repaint();
        } else {
            paint = false;
            this.dragIgnore = false;
        }
    }

    private void drawArrow(Graphics g, int x1, int y1, int x2, int y2, int x3, int y3) {
        int miny = Math.min(y1, Math.min(y2, y3));
        int maxy = Math.max(y1, Math.max(y2, y3));
        int sizey = (maxy - miny) / 3;
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        for (int i = 0; i < sizey; ++i) {
            int bright = Math.min(255, i * 255 / sizey);
            g.setColor(bright, bright, bright);
            g.setClip(clipX, Math.max(clipY, miny + (maxy - miny) * i / sizey), clipWidth, Math.min(clipHeight, maxy));
            g.fillTriangle(x1, y1, x2, y2, x3, y3);
        }
        g.setClip(clipX, clipY, clipWidth, clipHeight);
    }

    protected final void onRightSoftKey() {
        try {
            this.destroy();
            System.gc();
            Thread.sleep(20L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.gameScreen.start();
        Main.setCurrent(this.gameScreen);
        this.gameScreen = null;
    }

    protected final void onLeftSoftKey() {
        if (this.items.size() <= 0) {
            return;
        }
        int oldCount = this.items.itemAtCount(this.index);
        this.gameScreen.scene.dropItem(ItemsEngine.items[this.items.itemAt(this.index)].getNoLang("NAME"), 1, this.player);
        this.items.removeItem(this.items.itemAt(this.index), 1);
        String rmsScript = ItemsEngine.items[this.items.itemAt(this.index)].get("ON_THROW");
        if (rmsScript != null) {
            this.gameScreen.runScript(StringTools.cutOnStrings(rmsScript, ';'));
        }
        if (oldCount == 1) {
            if (this.index >= this.items.size()) {
                this.index = this.items.size() - 1;
            }
            this.loadItem();
        } else {
            --this.itemCount;
        }
        if (!paint) {
            this.repaint();
        }
    }

    protected final void onKey5() {
        if (this.items.size() <= 0 || this.itemScript == null) {
            return;
        }
        this.gameScreen.runScript(StringTools.cutOnStrings(this.itemScript, ';'));
        if (this.index >= this.items.size()) {
            this.index = this.items.size() - 1;
        }
        this.loadItem();
        if (!paint) {
            this.repaint();
        }
    }

    protected final void onKey6() {
        if (this.items.size() <= 0) {
            return;
        }
        if (Main.verticalShopScroll || paint) {
            return;
        }
        this.dragIgnore = true;
        ++this.index;
        this.index %= this.items.size();
        this.loadItem();
        side = true;
        sideAnimBegin = System.currentTimeMillis();
        sideAnimOld = 0;
        if (!paint) {
            this.repaint();
        }
    }

    protected final void onKey4() {
        if (this.items.size() <= 0) {
            return;
        }
        if (Main.verticalShopScroll || paint) {
            return;
        }
        this.dragIgnore = true;
        --this.index;
        if (this.index < 0) {
            this.index += this.items.size();
        }
        this.loadItem();
        side = false;
        sideAnimBegin = System.currentTimeMillis();
        sideAnimOld = 0;
        if (!paint) {
            this.repaint();
        }
    }

    protected final void onKey8() {
        if (this.items.size() <= 0) {
            return;
        }
        if (!Main.verticalShopScroll || paint) {
            return;
        }
        this.dragIgnore = true;
        ++this.index;
        this.index %= this.items.size();
        this.loadItem();
        side = true;
        sideAnimBegin = System.currentTimeMillis();
        sideAnimOld = 0;
        if (!paint) {
            this.repaint();
        }
    }

    protected final void onKey2() {
        if (this.items.size() <= 0) {
            return;
        }
        if (!Main.verticalShopScroll || paint) {
            return;
        }
        this.dragIgnore = true;
        --this.index;
        if (this.index < 0) {
            this.index += this.items.size();
        }
        this.loadItem();
        side = false;
        sideAnimBegin = System.currentTimeMillis();
        sideAnimOld = 0;
        if (!paint) {
            this.repaint();
        }
    }
}

