/*
 * Decompiled with CFR 0.152.
 */
package code.utils.scriptEngine;

import code.utils.scriptEngine.ScriptEngine;
import code.utils.scriptEngine.Utils;
import java.util.Calendar;
import java.util.Random;

public class Functions {
    private static final String NO_SUCH_FUNCTION = "No such function ";
    private static final int[] output = new int[1];
    private static final Random rand = new Random(System.currentTimeMillis());

    static boolean functionVoid(ScriptEngine eng, String line) {
        String[] args;
        Object[] stuff = Utils.funcNameAndArgs(line);
        String name = (String)stuff[0];
        boolean ret = Functions.functionVoid(eng, name, args = (String[])stuff[1]);
        if (!ret) {
            System.out.println(NO_SUCH_FUNCTION + line);
        }
        return ret;
    }

    private static boolean functionVoid(ScriptEngine eng, String name, String[] args) {
        if (name.equals("print")) {
            System.out.print(eng.readString(args[0]));
            return true;
        }
        if (name.equals("println")) {
            System.out.println(eng.readString(args[0]));
            return true;
        }
        if (name.equals("removeVar")) {
            for (int i = 0; i < args.length; ++i) {
                String varName = eng.readString(args[i]);
                eng.removeVar(varName);
            }
            return true;
        }
        if (name.equals("removeAllVars")) {
            String[] except = null;
            if (args.length > 1) {
                except = new String[args.length - 1];
                for (int i = 0; i < except.length; ++i) {
                    except[i] = eng.readString(args[i + 1]);
                }
            }
            eng.removeAllVars(except);
            return true;
        }
        if (name.equals("exec")) {
            eng.runScriptFromFile(eng.readString(args[0]));
            return true;
        }
        if (name.equals("setVar")) {
            String varName = eng.readString(args[0]);
            if (varName.startsWith("str.")) {
                eng.setVariableString(varName, eng.readString(args[1]));
            } else {
                eng.setVariableValue(varName, eng.readValue(args[1]));
            }
            return true;
        }
        boolean cmd = eng.env.functionEnvVoid(name, args);
        if (!cmd) {
            int[] fn = Functions.functionNumber(eng, name, args);
            if (fn == null) {
                return Functions.functionString(eng, name, args) != null;
            }
            return true;
        }
        return true;
    }

    static int[] functionNumber(ScriptEngine eng, String line) {
        String[] args;
        Object[] stuff = Utils.funcNameAndArgs(line);
        String name = (String)stuff[0];
        int[] out = Functions.functionNumber(eng, name, args = (String[])stuff[1]);
        if (out == null) {
            System.out.println(NO_SUCH_FUNCTION + line);
        }
        return out;
    }

    private static int[] functionNumber(ScriptEngine eng, String name, String[] args) {
        if (name.equals("abs")) {
            Functions.output[0] = Math.abs(eng.readValue(args[0]));
        } else if (name.equals("max")) {
            Functions.output[0] = Functions.max(eng, args, 0);
        } else if (name.equals("min")) {
            Functions.output[0] = Functions.min(eng, args, 0);
        } else if (name.equals("sqrt")) {
            Functions.output[0] = (int)Math.sqrt(eng.readValue(args[0]));
        } else if (name.equals("pow")) {
            Functions.output[0] = Functions.pow(eng.readValue(args[0]), eng.readValue(args[1]));
        } else if (name.equals("random")) {
            int max = eng.readValue(args[0]);
            int min = 0;
            if (args.length == 2) {
                min = max;
                max = eng.readValue(args[1]) - min;
            }
            Functions.output[0] = rand.nextInt(max + 1) + min;
        } else if (name.equals("distance")) {
            Functions.output[0] = Functions.distance(eng, args);
        } else if (name.equals("int")) {
            Functions.output[0] = Integer.parseInt(eng.readString(args[0]));
        } else if (name.equals("String.length")) {
            Functions.output[0] = eng.readString(args[0]).length();
        } else if (name.equals("String.equals")) {
            Functions.output[0] = eng.readString(args[0]).equals(eng.readString(args[1])) ? 1 : 0;
        } else if (name.equals("String.equalsIgnoreCase")) {
            Functions.output[0] = eng.readString(args[0]).equalsIgnoreCase(eng.readString(args[1])) ? 1 : 0;
        } else if (name.equals("String.compare")) {
            Functions.output[0] = eng.readString(args[0]).compareTo(eng.readString(args[1]));
        } else if (name.equals("String.regionMatches")) {
            Functions.output[0] = eng.readString(args[0]).regionMatches(eng.readBoolean(args[1]), eng.readValue(args[2]), eng.readString(args[3]), eng.readValue(args[4]), eng.readValue(args[5])) ? 1 : 0;
        } else if (name.equals("String.startsWith")) {
            Functions.output[0] = eng.readString(args[0]).startsWith(eng.readString(args[1]), args.length == 2 ? 0 : eng.readValue(args[2])) ? 1 : 0;
        } else if (name.equals("String.endsWith")) {
            Functions.output[0] = eng.readString(args[0]).endsWith(eng.readString(args[1])) ? 1 : 0;
        } else if (name.equals("String.indexOf")) {
            Functions.output[0] = eng.readString(args[0]).indexOf(eng.readString(args[1]), args.length == 2 ? 0 : eng.readValue(args[2]));
        } else if (name.equals("String.lastIndexOf")) {
            char ch = eng.readString(args[1]).charAt(0);
            Functions.output[0] = eng.readString(args[0]).lastIndexOf(ch, args.length == 2 ? 0 : eng.readValue(args[2]));
        } else if (name.equals("getVar")) {
            Functions.output[0] = eng.getVariable(eng.readString(args[0]));
        } else if (name.equals("getYear")) {
            Calendar cal = Calendar.getInstance();
            Functions.output[0] = cal.get(1);
        } else if (name.equals("getMonth")) {
            Calendar cal = Calendar.getInstance();
            Functions.output[0] = cal.get(2) + 1;
        } else if (name.equals("getDayOfWeek")) {
            Calendar cal = Calendar.getInstance();
            int dayOfWeek = cal.get(7);
            dayOfWeek = dayOfWeek == 1 ? 6 : (dayOfWeek -= 2);
            Functions.output[0] = dayOfWeek;
        } else if (name.equals("getDay")) {
            Calendar cal = Calendar.getInstance();
            Functions.output[0] = cal.get(5);
        } else if (name.equals("getHour")) {
            Calendar cal = Calendar.getInstance();
            Functions.output[0] = cal.get(10);
        } else if (name.equals("getMinute")) {
            Calendar cal = Calendar.getInstance();
            Functions.output[0] = cal.get(12);
        } else if (name.equals("getSecond")) {
            Calendar cal = Calendar.getInstance();
            Functions.output[0] = cal.get(13);
        } else {
            return eng.env.functionEnvValue(name, args);
        }
        return output;
    }

    static String functionString(ScriptEngine eng, String line) {
        String[] args;
        Object[] stuff = Utils.funcNameAndArgs(line);
        String name = (String)stuff[0];
        String out = Functions.functionString(eng, name, args = (String[])stuff[1]);
        if (out == null) {
            System.out.println(NO_SUCH_FUNCTION + line);
        }
        return out;
    }

    private static String functionString(ScriptEngine eng, String name, String[] args) {
        if (name.equals("str")) {
            return String.valueOf(eng.readValue(args[0]));
        }
        if (name.equals("String.replace")) {
            char oldChar = eng.readString(args[1]).charAt(0);
            char newChar = eng.readString(args[2]).charAt(0);
            return eng.readString(args[0]).replace(oldChar, newChar);
        }
        if (name.equals("String.toLowerCase")) {
            return eng.readString(args[0]).toLowerCase();
        }
        if (name.equals("String.toUpperCase")) {
            return eng.readString(args[0]).toUpperCase();
        }
        if (name.equals("String.trim")) {
            return eng.readString(args[0]).trim();
        }
        if (name.equals("String.charAt")) {
            return "" + eng.readString(args[0]).charAt(eng.readValue(args[1]));
        }
        if (name.equals("String.substring")) {
            String str = eng.readString(args[0]);
            return str.substring(eng.readValue(args[1]), args.length == 2 ? str.length() : eng.readValue(args[2]));
        }
        if (name.equals("getStringVar")) {
            return eng.getVariableString(eng.readString(args[0]));
        }
        return eng.env.functionEnvString(name, args);
    }

    static int distance(ScriptEngine eng, String[] args) {
        double dist = 0.0;
        if (args.length == 2) {
            return Math.abs(eng.readValue(args[0]) - eng.readValue(args[1]));
        }
        int[] vals = new int[args.length];
        for (int i = 0; i < vals.length; ++i) {
            vals[i] = eng.readValue(args[i]);
        }
        int half = vals.length / 2;
        for (int i = 0; i < half; ++i) {
            int vl = vals[i] - vals[i + half];
            dist += (double)(vl * vl);
        }
        return (int)Math.sqrt(dist);
    }

    static int pow(int num, int pow) {
        int out = num;
        for (int i = 1; i < pow; ++i) {
            out *= num;
        }
        return out;
    }

    static int max(ScriptEngine eng, String[] args, int begin) {
        if (begin == args.length - 2) {
            return Math.max(eng.readValue(args[args.length - 2]), eng.readValue(args[args.length - 1]));
        }
        return Math.max(eng.readValue(args[begin]), Functions.max(eng, args, begin + 1));
    }

    static int min(ScriptEngine eng, String[] args, int begin) {
        if (begin == args.length - 2) {
            return Math.min(eng.readValue(args[args.length - 2]), eng.readValue(args[args.length - 1]));
        }
        return Math.min(eng.readValue(args[begin]), Functions.min(eng, args, begin + 1));
    }
}

