/*
 * Decompiled with CFR 0.152.
 */
package code.Rendering.Meshes;

import code.Math.MathUtils;
import code.Math.Matrix;
import code.Rendering.DirectX7;
import code.Rendering.RenderObject;
import code.Rendering.Texture;
import code.Rendering.Vertex;

public final class Sprite
extends RenderObject {
    public Texture[] textures;
    public Vertex pos = new Vertex();
    public Vertex size = new Vertex();
    public boolean mirX = false;
    public boolean mirY = false;
    public int scale = 5;
    public int offsetX = 0;
    public int offsetY = 0;
    public byte mode = 0;
    public byte cutoff = 0;
    public int anim_index = 0;
    public boolean fog = false;
    public long animationBegin = 0L;
    public float animation_speed = 1.0f;
    public boolean limiter = false;
    public int color = 0;

    public Sprite(int var1) {
    }

    public Sprite(Texture[] texs, int sc, float animsp) {
        this.textures = texs;
        this.scale = sc;
        this.animation_speed = animsp;
    }

    public Sprite(Texture texs, int sc) {
        this.textures = new Texture[1];
        this.textures[0] = texs;
        this.scale = sc;
    }

    public final void setScale(int scale) {
        this.scale = scale;
    }

    public final void destroy() {
        this.textures = null;
        this.pos = null;
        this.size = null;
    }

    public final void setOffset(int x, int y) {
        this.offsetX = x;
        this.offsetY = y;
    }

    public final Vertex getPosition() {
        return this.pos;
    }

    public final void setTextures(Texture[] textures) {
        this.textures = textures;
    }

    public final int getHeight() {
        if (this.textures[0].mip != null) {
            this.textures[0].rImg = this.textures[0].mip[0];
        }
        return this.textures[this.anim_index].rImg.h * this.scale;
    }

    public final int getWidth() {
        if (this.textures[0].mip != null) {
            this.textures[0].rImg = this.textures[0].mip[0];
        }
        return this.textures[this.anim_index].rImg.w * this.scale;
    }

    public final boolean isVisible(int x1, int y1, int x2, int y2) {
        this.sz = this.pos.rz * 4 - MathUtils.pLength(this.size.sx - this.pos.sx, this.size.sy - this.pos.sy);
        if (-this.pos.rz > DirectX7.drDist) {
            return false;
        }
        if (this.cutoff == 0) {
            if (this.sz > 0) {
                return false;
            }
            if (this.pos.sx >= x2 || this.pos.sy >= y2) {
                return false;
            }
            return this.size.sx > x1 && this.size.sy > y1;
        }
        if (this.cutoff == 1) {
            if (this.sz > this.getHeight() * 4) {
                return false;
            }
            if (this.pos.sx - this.scale >= x2 || this.pos.sy - this.scale >= y2) {
                return false;
            }
            return this.size.sx + this.scale > x1 && this.size.sy + this.scale > y1;
        }
        return false;
    }

    public final void project(Matrix matrix, DirectX7 g3d) {
        if (this.textures[0].mip != null) {
            this.textures[0].rImg = this.textures[0].mip[0];
        }
        int var3 = this.textures[this.anim_index].rImg.w * this.scale * (this.textures[0].rImg.scale == 0 ? 2 : 1);
        int var4 = this.getHeight() * (this.textures[0].rImg.scale < 2 ? 2 : 1);
        this.pos.transform(matrix);
        this.pos.sx = this.pos.sx + this.offsetX * (this.textures[0].rImg.scale == 0 ? 2 : 1);
        this.pos.sy = this.pos.sy + this.offsetY * (this.textures[0].rImg.scale < 2 ? 2 : 1);
        this.pos.sx -= var3 / 2;
        this.pos.sy += var4;
        this.size.sx = this.pos.sx + var3;
        this.size.sy = this.pos.sy - var4;
        this.size.rz = this.pos.rz;
        if (this.pos.rz > 0 && this.cutoff == 1) {
            this.size.sy += this.pos.rz;
        }
        this.pos.project(g3d);
        this.size.project(g3d);
    }

    public final void project(DirectX7 g3d) {
        if (this.textures[0].mip != null) {
            this.textures[0].rImg = this.textures[0].mip[0];
        }
        int var3 = this.textures[this.anim_index].rImg.w * this.scale * (this.textures[0].rImg.scale == 0 ? 2 : 1);
        int var4 = this.getHeight() * (this.textures[0].rImg.scale < 2 ? 2 : 1);
        this.pos.sx = this.pos.sx + this.offsetX * (this.textures[0].rImg.scale == 0 ? 2 : 1);
        this.pos.sy = this.pos.sy + this.offsetY * (this.textures[0].rImg.scale < 2 ? 2 : 1);
        this.pos.sx -= var3 / 2;
        this.pos.sy += var4;
        this.size.sx = this.pos.sx + var3;
        this.size.sy = this.pos.sy - var4;
        this.size.rz = this.pos.rz;
        if (this.pos.rz > 0 && this.cutoff == 1) {
            this.size.sy += this.pos.rz;
        }
        this.pos.project(g3d);
        this.size.project(g3d);
    }

    public final void renderFast(DirectX7 g3d, Texture texture) {
        this.render(g3d, null);
    }

    public final void updateFrame() {
        if (this.textures.length > 1) {
            long time = System.currentTimeMillis() - this.animationBegin;
            this.anim_index = (int)((float)(time %= (long)((float)(this.textures.length * 1000) / this.animation_speed)) * this.animation_speed / 1000.0f) % this.textures.length;
            if (this.limiter) {
                time = System.currentTimeMillis() - this.animationBegin;
                this.anim_index = (int)((float)time * this.animation_speed / 1000.0f);
                if (this.anim_index >= this.textures.length) {
                    this.anim_index = this.textures.length - 1;
                }
            }
        }
    }

    public final void render(DirectX7 g3d, Texture texture) {
        int tmp;
        texture = this.textures[this.anim_index];
        if (texture.mip != null) {
            texture.rImg = texture.mip[0];
        }
        int x_start = this.pos.sx;
        int y_start = this.pos.sy;
        int x_end = this.size.sx;
        int y_end = this.size.sy;
        if (x_start > x_end) {
            tmp = x_start;
            x_start = x_end;
            x_end = tmp;
        }
        if (y_start > y_end) {
            tmp = y_start;
            y_start = y_end;
            y_end = tmp;
        }
        int[] tex = texture.rImg.img;
        int texw = texture.rImg.w;
        int texh = texture.rImg.h;
        int texLength = tex.length;
        int[] rgb = g3d.display;
        int rgbWidth = g3d.width;
        int u1 = 0;
        int v1 = 0;
        int u2 = texture.rImg.w;
        int v2 = texture.rImg.h;
        if (this.mirX) {
            u1 = texw;
            u2 = 0;
        }
        if (this.mirY) {
            v1 = texh;
            v2 = 0;
        }
        u1 <<= 12;
        u2 <<= 12;
        v1 <<= 12;
        v2 <<= 12;
        if (x_end != x_start && y_end != y_start) {
            int du = (u2 - u1) / (x_end - x_start);
            int dv = (v2 - v1) / (y_end - y_start);
            int u_start = u1;
            int v_start = v1;
            if (y_start < 0) {
                v_start -= dv * y_start;
                y_start = 0;
            }
            if (y_end > g3d.height) {
                y_end = g3d.height;
            }
            if (x_start < 0) {
                u_start = u1 - du * x_start;
                x_start = 0;
            }
            if (x_end > rgbWidth) {
                x_end = rgbWidth;
            }
            if (this.mode == 1) {
                this.renderAdd(g3d, texture, x_start, y_start, x_end, y_end, u_start, v_start, du, dv);
                return;
            }
            if (this.mode == 2 && this.color == 0) {
                this.renderMul(g3d, texture, x_start, y_start, x_end, y_end, u_start, v_start, du, dv);
                return;
            }
            if (this.mode == 2 && this.color == 1) {
                this.renderMulRed(g3d, texture, x_start, y_start, x_end, y_end, u_start, v_start, du, dv);
                return;
            }
            if (this.mode == 2 && this.color == 2) {
                this.renderMulGreen(g3d, texture, x_start, y_start, x_end, y_end, u_start, v_start, du, dv);
                return;
            }
            if (this.mode == 2 && this.color == 3) {
                this.renderMulBlue(g3d, texture, x_start, y_start, x_end, y_end, u_start, v_start, du, dv);
                return;
            }
            if (this.mode == 2 && this.color == 4) {
                this.renderMulViolet(g3d, texture, x_start, y_start, x_end, y_end, u_start, v_start, du, dv);
                return;
            }
            if (this.mode == 2 && this.color == 5) {
                this.renderMulYellow(g3d, texture, x_start, y_start, x_end, y_end, u_start, v_start, du, dv);
                return;
            }
            if (this.mode == 2 && this.color == 6) {
                this.renderMulAqua(g3d, texture, x_start, y_start, x_end, y_end, u_start, v_start, du, dv);
                return;
            }
            if (this.mode == 3 && texture.rImg.alphaMixing && this.fog) {
                this.renderOpaqueFog(g3d, texture, x_start, y_start, x_end, y_end, u_start, v_start, du, dv);
                return;
            }
            if (this.mode == 3 && texture.rImg.alphaMixing) {
                this.renderOpaque(g3d, texture, x_start, y_start, x_end, y_end, u_start, v_start, du, dv);
                return;
            }
            if (this.fog) {
                this.renderF(g3d, texture, x_start, y_start, x_end, y_end, u_start, v_start, du, dv);
                return;
            }
            while (y_start < y_end) {
                int col;
                int x1 = x_start + rgbWidth * y_start;
                texh = x_end + rgbWidth * y_start;
                u2 = (v_start & 0xFFFFF000) * texw + u_start;
                while (texh - x1 >= 4) {
                    col = tex[(u2 >> 12 & Integer.MAX_VALUE) % texLength];
                    if (col != 0) {
                        rgb[x1] = col;
                    }
                    if ((col = tex[((u2 += du) >> 12 & Integer.MAX_VALUE) % texLength]) != 0) {
                        rgb[x1 + 1] = col;
                    }
                    if ((col = tex[((u2 += du) >> 12 & Integer.MAX_VALUE) % texLength]) != 0) {
                        rgb[x1 + 2] = col;
                    }
                    if ((col = tex[((u2 += du) >> 12 & Integer.MAX_VALUE) % texLength]) != 0) {
                        rgb[x1 + 3] = col;
                    }
                    u2 += du;
                    x1 += 4;
                }
                while (x1 < texh) {
                    col = tex[(u2 >> 12 & Integer.MAX_VALUE) % texLength];
                    if (col != 0) {
                        rgb[x1] = col;
                    }
                    u2 += du;
                    ++x1;
                }
                ++y_start;
                v_start += dv;
            }
        }
    }

    final void rendernF(DirectX7 g3d, Texture texture, int x_start, int y_start, int x_end, int y_end, int u_start, int v_start, int du, int dv) {
        int[] tex = texture.rImg.img;
        int[] rgb = g3d.display;
        int rgbWidth = g3d.width;
        int texw = texture.rImg.w;
        int texh = texture.rImg.h;
        int texLength = tex.length;
        while (y_start < y_end) {
            int col;
            int x1 = x_start + rgbWidth * y_start;
            texh = x_end + rgbWidth * y_start;
            int u2 = (v_start & 0xFFFFF000) * texw + u_start;
            while (texh - x1 >= 2) {
                col = tex[(u2 >> 12 & Integer.MAX_VALUE) % texLength];
                if (col != 0) {
                    rgb[x1] = col;
                }
                if ((col = tex[((u2 += du) >> 12 & Integer.MAX_VALUE) % texLength]) != 0) {
                    rgb[x1 + 1] = col;
                }
                u2 += du;
                x1 += 2;
            }
            while (x1 < texh) {
                col = tex[(u2 >> 12 & Integer.MAX_VALUE) % texLength];
                if (col != 0) {
                    rgb[x1] = col;
                }
                u2 += du;
                ++x1;
            }
            ++y_start;
            v_start += dv;
        }
    }

    final void renderF(DirectX7 g3d, Texture texture, int x_start, int y_start, int x_end, int y_end, int u_start, int v_start, int du, int dv) {
        int[] tex = texture.rImg.img;
        int[] rgb = g3d.display;
        int rgbWidth = g3d.width;
        int texw = texture.rImg.w;
        int texh = texture.rImg.h;
        int texLength = tex.length;
        int power = 0;
        if (DirectX7.fDist != 0) {
            power = -this.pos.rz * 255 / DirectX7.fDist;
        }
        if (power > 255) {
            power = 255;
        }
        if (power < 0) {
            power = 0;
        }
        int invpower = 255 - power;
        int f2 = (DirectX7.fogc & 0xFF00FF) * power;
        int f22 = (DirectX7.fogc & 0xFF00) * power;
        if (DirectX7.standartDrawmode == 6) {
            f22 = 0;
            f2 = 0;
        }
        while (y_start < y_end) {
            texh = x_end + rgbWidth * y_start;
            int u2 = (v_start & 0xFFFFF000) * texw + u_start;
            for (int x1 = x_start + rgbWidth * y_start; x1 < texh; ++x1) {
                int col = tex[(u2 >> 12 & Integer.MAX_VALUE) % texLength];
                if (col != 0) {
                    rgb[x1] = ((col & 0xFF00FF) * invpower + f2 & 0xFF00FF00 | (col & 0xFF00) * invpower + f22 & 0xFF0000) >>> 8;
                }
                u2 += du;
            }
            ++y_start;
            v_start += dv;
        }
    }

    final void renderAdd(DirectX7 g3d, Texture texture, int x_start, int y_start, int x_end, int y_end, int u_start, int v_start, int du, int dv) {
        int[] tex = texture.rImg.img;
        int[] rgb = g3d.display;
        int rgbWidth = g3d.width;
        int texw = texture.rImg.w;
        int texh = texture.rImg.h;
        int texLength = tex.length;
        while (y_start < y_end) {
            texh = x_end + rgbWidth * y_start;
            int u2 = (v_start & 0xFFFFF000) * texw + u_start;
            for (int x1 = x_start + rgbWidth * y_start; x1 < texh; ++x1) {
                int col = tex[(u2 >> 12 & Integer.MAX_VALUE) % texLength];
                col = (col & 0xFEFEFE) + (rgb[x1] & 0xFEFEFE);
                col |= (col >> 8 & 0x10101) * 255;
                rgb[x1] = col;
                u2 += du;
            }
            ++y_start;
            v_start += dv;
        }
    }

    final void renderMulRed(DirectX7 g3d, Texture texture, int x_start, int y_start, int x_end, int y_end, int u_start, int v_start, int du, int dv) {
        int[] tex = texture.rImg.img;
        int[] rgb = g3d.display;
        int rgbWidth = g3d.width;
        int texw = texture.rImg.w;
        int texh = texture.rImg.h;
        int texLength = tex.length;
        while (y_start < y_end) {
            texh = x_end + rgbWidth * y_start;
            int u2 = (v_start & 0xFFFFF000) * texw + u_start;
            for (int x1 = x_start + rgbWidth * y_start; x1 < texh; ++x1) {
                int bri = tex[(u2 >> 12 & Integer.MAX_VALUE) % texLength] & 0xFF;
                if (bri != 69) {
                    int col;
                    int col2 = col = rgb[x1];
                    col = ((col & 0xFF0000) * bri & 0xFE000000) >>> 6;
                    rgb[x1] = col | (col >> 8 & 0x30303) * 255 | col2 & 0xFFFF;
                }
                u2 += du;
            }
            ++y_start;
            v_start += dv;
        }
    }

    final void renderMulGreen(DirectX7 g3d, Texture texture, int x_start, int y_start, int x_end, int y_end, int u_start, int v_start, int du, int dv) {
        int[] tex = texture.rImg.img;
        int[] rgb = g3d.display;
        int rgbWidth = g3d.width;
        int texw = texture.rImg.w;
        int texh = texture.rImg.h;
        int texLength = tex.length;
        while (y_start < y_end) {
            texh = x_end + rgbWidth * y_start;
            int u2 = (v_start & 0xFFFFF000) * texw + u_start;
            for (int x1 = x_start + rgbWidth * y_start; x1 < texh; ++x1) {
                int bri = tex[(u2 >> 12 & Integer.MAX_VALUE) % texLength] & 0xFF;
                if (bri != 69) {
                    int col;
                    int col2 = col = rgb[x1];
                    col = ((col & 0xFF00) * bri & 0xFE0000) >>> 6;
                    rgb[x1] = col | (col >> 8 & 0x30303) * 255 | col2 & 0xFF00FF;
                }
                u2 += du;
            }
            ++y_start;
            v_start += dv;
        }
    }

    final void renderMulBlue(DirectX7 g3d, Texture texture, int x_start, int y_start, int x_end, int y_end, int u_start, int v_start, int du, int dv) {
        int[] tex = texture.rImg.img;
        int[] rgb = g3d.display;
        int rgbWidth = g3d.width;
        int texw = texture.rImg.w;
        int texh = texture.rImg.h;
        int texLength = tex.length;
        while (y_start < y_end) {
            texh = x_end + rgbWidth * y_start;
            int u2 = (v_start & 0xFFFFF000) * texw + u_start;
            for (int x1 = x_start + rgbWidth * y_start; x1 < texh; ++x1) {
                int bri = tex[(u2 >> 12 & Integer.MAX_VALUE) % texLength] & 0xFF;
                if (bri != 69) {
                    int col;
                    int col2 = col = rgb[x1];
                    col = ((col & 0xFF) * bri & 0xFE00) >>> 6;
                    rgb[x1] = col | (col >> 8 & 0x30303) * 255 | col2 & 0xFFFF00;
                }
                u2 += du;
            }
            ++y_start;
            v_start += dv;
        }
    }

    final void renderMulViolet(DirectX7 g3d, Texture texture, int x_start, int y_start, int x_end, int y_end, int u_start, int v_start, int du, int dv) {
        int[] tex = texture.rImg.img;
        int[] rgb = g3d.display;
        int rgbWidth = g3d.width;
        int texw = texture.rImg.w;
        int texh = texture.rImg.h;
        int texLength = tex.length;
        while (y_start < y_end) {
            texh = x_end + rgbWidth * y_start;
            int u2 = (v_start & 0xFFFFF000) * texw + u_start;
            for (int x1 = x_start + rgbWidth * y_start; x1 < texh; ++x1) {
                int bri = tex[(u2 >> 12 & Integer.MAX_VALUE) % texLength] & 0xFF;
                if (bri != 69) {
                    int col;
                    int col2 = col = rgb[x1];
                    col = ((col & 0xFF00FF) * bri & 0xFE00FE00) >>> 6;
                    rgb[x1] = col | (col >> 8 & 0x30303) * 255 | col2 & 0xFF00;
                }
                u2 += du;
            }
            ++y_start;
            v_start += dv;
        }
    }

    final void renderMulYellow(DirectX7 g3d, Texture texture, int x_start, int y_start, int x_end, int y_end, int u_start, int v_start, int du, int dv) {
        int[] tex = texture.rImg.img;
        int[] rgb = g3d.display;
        int rgbWidth = g3d.width;
        int texw = texture.rImg.w;
        int texh = texture.rImg.h;
        int texLength = tex.length;
        while (y_start < y_end) {
            texh = x_end + rgbWidth * y_start;
            int u2 = (v_start & 0xFFFFF000) * texw + u_start;
            for (int x1 = x_start + rgbWidth * y_start; x1 < texh; ++x1) {
                int bri = tex[(u2 >> 12 & Integer.MAX_VALUE) % texLength] & 0xFF;
                if (bri != 69) {
                    int col;
                    int col2 = col = rgb[x1];
                    col = ((col & 0xFF0000) * bri & 0xFE000000 | (col & 0xFF00) * bri & 0xFE0000) >>> 6;
                    rgb[x1] = col | (col >> 8 & 0x30303) * 255 | col2 & 0xFF;
                }
                u2 += du;
            }
            ++y_start;
            v_start += dv;
        }
    }

    final void renderMulAqua(DirectX7 g3d, Texture texture, int x_start, int y_start, int x_end, int y_end, int u_start, int v_start, int du, int dv) {
        int[] tex = texture.rImg.img;
        int[] rgb = g3d.display;
        int rgbWidth = g3d.width;
        int texw = texture.rImg.w;
        int texh = texture.rImg.h;
        int texLength = tex.length;
        while (y_start < y_end) {
            texh = x_end + rgbWidth * y_start;
            int u2 = (v_start & 0xFFFFF000) * texw + u_start;
            for (int x1 = x_start + rgbWidth * y_start; x1 < texh; ++x1) {
                int bri = tex[(u2 >> 12 & Integer.MAX_VALUE) % texLength] & 0xFF;
                if (bri != 69) {
                    int col;
                    int col2 = col = rgb[x1];
                    col = ((col & 0xFF) * bri & 0xFE00 | (col & 0xFF00) * bri & 0xFE0000) >>> 6;
                    rgb[x1] = col | (col >> 8 & 0x30303) * 255 | col2 & 0xFF0000;
                }
                u2 += du;
            }
            ++y_start;
            v_start += dv;
        }
    }

    final void renderMul(DirectX7 g3d, Texture texture, int x_start, int y_start, int x_end, int y_end, int u_start, int v_start, int du, int dv) {
        int[] tex = texture.rImg.img;
        int[] rgb = g3d.display;
        int rgbWidth = g3d.width;
        int texw = texture.rImg.w;
        int texh = texture.rImg.h;
        int texLength = tex.length;
        while (y_start < y_end) {
            texh = x_end + rgbWidth * y_start;
            int u2 = (v_start & 0xFFFFF000) * texw + u_start;
            for (int x1 = x_start + rgbWidth * y_start; x1 < texh; ++x1) {
                int bri = tex[(u2 >> 12 & Integer.MAX_VALUE) % texLength] & 0xFF;
                if (bri != 69) {
                    int col = rgb[x1];
                    col = ((col & 0xFF00FF) * bri & 0xFE00FE00 | (col & 0xFF00) * bri & 0xFE0000) >>> 6;
                    rgb[x1] = col | (col >> 8 & 0x30303) * 255;
                }
                u2 += du;
            }
            ++y_start;
            v_start += dv;
        }
    }

    final void renderOpaque(DirectX7 g3d, Texture texture, int x_start, int y_start, int x_end, int y_end, int u_start, int v_start, int du, int dv) {
        int[] tex = texture.rImg.img;
        int[] rgb = g3d.display;
        int rgbWidth = g3d.width;
        int texw = texture.rImg.w;
        int texh = texture.rImg.h;
        int texLength = tex.length;
        while (y_start < y_end) {
            texh = x_end + rgbWidth * y_start;
            int u2 = (v_start & 0xFFFFF000) * texw + u_start;
            for (int x1 = x_start + rgbWidth * y_start; x1 < texh; ++x1) {
                int col = tex[(u2 >> 12 & Integer.MAX_VALUE) % texLength];
                int ca = col >> 24 & 0xFF;
                if (ca != 0) {
                    int cols = rgb[x1];
                    rgb[x1] = ((col & 0xFF00FF) * ca + (cols & 0xFF00FF) * (255 - ca) & 0xFF00FF00 | (col & 0xFF00) * ca + (cols & 0xFF00) * (255 - ca) & 0xFF0000) >>> 8;
                }
                u2 += du;
            }
            ++y_start;
            v_start += dv;
        }
    }

    final void renderOpaqueFog(DirectX7 g3d, Texture texture, int x_start, int y_start, int x_end, int y_end, int u_start, int v_start, int du, int dv) {
        int[] tex = texture.rImg.img;
        int[] rgb = g3d.display;
        int rgbWidth = g3d.width;
        int texw = texture.rImg.w;
        int texh = texture.rImg.h;
        int texLength = tex.length;
        int power = 0;
        if (DirectX7.fDist != 0) {
            power = -this.pos.rz * 255 / DirectX7.fDist;
        }
        if (power > 255) {
            power = 255;
        }
        if (power < 0) {
            power = 0;
        }
        int invpower = 255 - power;
        int f2 = (DirectX7.fogc & 0xFF00FF) * power;
        int f22 = (DirectX7.fogc & 0xFF00) * power;
        if (DirectX7.standartDrawmode == 6) {
            f22 = 0;
            f2 = 0;
        }
        while (y_start < y_end) {
            texh = x_end + rgbWidth * y_start;
            int u2 = (v_start & 0xFFFFF000) * texw + u_start;
            for (int x1 = x_start + rgbWidth * y_start; x1 < texh; ++x1) {
                int col = tex[(u2 >> 12 & Integer.MAX_VALUE) % texLength];
                int ca = col >> 24 & 0xFF;
                if (ca != 0) {
                    int cols = rgb[x1];
                    col = ((col & 0xFF00FF) * invpower + f2 & 0xFF00FF00 | (col & 0xFF00) * invpower + f22 & 0xFF0000) >>> 8;
                    rgb[x1] = ((col & 0xFF00FF) * ca + (cols & 0xFF00FF) * (255 - ca) & 0xFF00FF00 | (col & 0xFF00) * ca + (cols & 0xFF00) * (255 - ca) & 0xFF0000) >>> 8;
                }
                u2 += du;
            }
            ++y_start;
            v_start += dv;
        }
    }
}

