/*
 * Decompiled with CFR 0.152.
 */
package code.Rendering;

import code.utils.Asset;
import code.utils.ImageResize;
import code.utils.Main;
import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Image;

public class RawImage {
    public int[] img;
    public int w;
    public int h;
    public byte scale = (byte)2;
    public boolean isPalette = false;
    public int widthBIT;
    public int widthBITmode10;
    public int W_UNIT;
    public boolean alphaMixing = false;
    static RawImage error = new RawImage(new int[]{0xFF0000, 0xFF0000, 0xFF0000, 0xFF0000}, 2, 2);

    public RawImage(int[] rgb, int w2, int h2) {
        this.img = rgb;
        this.w = w2;
        this.h = h2;
        this.widthBIT = RawImage.widthToBIT(this.w);
        this.widthBITmode10 = RawImage.widthToBIT(this.w * this.w);
        this.W_UNIT = RawImage.wUnitGen(Math.max(this.w, this.h));
        this.alphaMixing = RawImage.prepareAlpha(rgb);
    }

    private static RawImage imageToRawImage(Image img) throws Throwable {
        return RawImage.imageToRawImage(img, 2);
    }

    private static RawImage imageToRawImage(Image image, int size) {
        try {
            int w = image.getWidth();
            int h = image.getHeight();
            int[] img = new int[w * h];
            image.getRGB(img, 0, w, 0, 0, w, h);
            int scale = size;
            if (scale > Main.pixelsQ) {
                scale = Main.pixelsQ;
            }
            if (Main.pixelsQ == 0 && w > 1 && h > 1) {
                img = ImageResize.cubic2XDesize(img, w, h);
                w /= 2;
                h /= 2;
                scale = 0;
            } else if (Main.pixelsQ != 2 && h > 1) {
                img = ImageResize.cubic2XVertDesize(img, w, h);
                h /= 2;
                scale = 1;
            }
            RawImage ri = new RawImage(img, w, h);
            ri.scale = (byte)scale;
            return ri;
        }
        catch (Throwable ex) {
            boolean desized;
            if (ex instanceof OutOfMemoryError && (desized = Asset.desizeSomething())) {
                return RawImage.imageToRawImage(image, size - 1);
            }
            System.err.println("ERROR in imageToRawImage: " + ex);
            return error;
        }
    }

    private static RawImage qctToRawImage(String path) {
        InputStream is = new Object().getClass().getResourceAsStream(path);
        DataInputStream dis = new DataInputStream(is);
        try {
            dis.skip(3L);
            int headerSize = dis.readUnsignedShort();
            dis.readUnsignedByte();
            int w = dis.readUnsignedShort();
            int h = dis.readUnsignedShort();
            int colorCount = 1 << dis.readUnsignedByte() + 1;
            int alphaType = dis.readUnsignedByte();
            headerSize -= 7;
            int lastColorReplace = 0;
            if (alphaType >= 1) {
                lastColorReplace = dis.readUnsignedByte();
                --headerSize;
            }
            if (headerSize > 0) {
                dis.skip(headerSize);
            }
            int[] img = new int[w * h];
            int[] colors = new int[colorCount];
            for (int i = 0; i < colorCount; ++i) {
                colors[i] = 0xFF000000 | dis.readUnsignedByte() << 16 | dis.readUnsignedByte() << 8 | dis.readUnsignedByte();
            }
            int[] tmpColors = new int[4];
            for (int y = 0; y < h / 2; ++y) {
                int yp = y * w << 1;
                for (int x = 0; x < w / 2; ++x) {
                    int c3id;
                    int xp = yp + (x << 1);
                    int c0id = dis.readUnsignedByte();
                    boolean hasAlpha = c0id > (c3id = dis.readUnsignedByte());
                    tmpColors[0] = colors[c0id];
                    tmpColors[3] = colors[c3id];
                    int rb0 = tmpColors[0] & 0xFF00FF;
                    int rb3 = tmpColors[3] & 0xFF00FF;
                    int g0 = tmpColors[0] & 0xFF00;
                    int g3 = tmpColors[3] & 0xFF00;
                    if (hasAlpha) {
                        tmpColors[2] = 0;
                        tmpColors[1] = (rb0 + rb3 & 0x1FE01DE | g0 + g3 & 0x1FE00) >> 1 | 0xFF000000;
                    } else {
                        tmpColors[1] = (rb0 * 171 + rb3 * 85 & 0xFF00FF00 | g0 * 171 + g3 * 85 & 0xFF0000) >> 8 | 0xFF000000;
                        tmpColors[2] = (rb0 * 85 + rb3 * 171 & 0xFF00FF00 | g0 * 85 + g3 * 171 & 0xFF0000) >> 8 | 0xFF000000;
                    }
                    byte ids = dis.readByte();
                    img[xp] = tmpColors[ids & 3];
                    img[xp + 1] = tmpColors[ids >>> 2 & 3];
                    img[xp + w] = tmpColors[ids >>> 4 & 3];
                    img[xp + w + 1] = tmpColors[ids >>> 6 & 3];
                }
            }
            if (alphaType == 2) {
                block7: for (int i = 0; i < img.length; ++i) {
                    if (img[i] >>> 24 == 0) continue;
                    int solid = dis.readUnsignedByte();
                    int transparent = dis.readUnsignedByte();
                    i += solid;
                    if (transparent == 0) {
                        --i;
                        continue;
                    }
                    int c = 0;
                    while (i < img.length) {
                        if (img[i] >>> 24 != 0) {
                            img[i] = dis.readUnsignedByte() << 24 | img[i] & 0xFFFFFF;
                            if (++c == transparent) continue block7;
                        }
                        ++i;
                    }
                }
            }
            if (Main.pixelsQ == 0) {
                img = ImageResize.cubic2XDesize(img, w, h);
                w /= 2;
                h /= 2;
            }
            if (Main.pixelsQ == 1) {
                img = ImageResize.cubic2XVertDesize(img, w, h);
                h /= 2;
            }
            RawImage ri = new RawImage(img, w, h);
            ri.scale = (byte)Main.pixelsQ;
            dis.close();
            return ri;
        }
        catch (Throwable ex) {
            try {
                dis.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.err.println("ERROR in qctToRawImage: " + ex);
            return error;
        }
    }

    public static RawImage createRawImage(String file) {
        try {
            String format = file;
            format = format.indexOf(46) > -1 ? format.substring(format.indexOf(46) + 1).toLowerCase() : null;
            if (format.equals("qct")) {
                return RawImage.qctToRawImage(file);
            }
            return RawImage.imageToRawImage(Image.createImage((String)file));
        }
        catch (Throwable ex) {
            if (ex instanceof OutOfMemoryError) {
                return error;
            }
            System.err.println("ERROR in createRawImage " + file + ": " + ex);
            return error;
        }
    }

    public static RawImage createMipRawImage(RawImage base) {
        if (base.w < 2 || base.h < 2) {
            return null;
        }
        try {
            int[] img = ImageResize.mipMap(base.img, base.w, base.h);
            return new RawImage(img, base.w / 2, base.h / 2);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static int widthToBIT(int w) {
        for (int var1 = 0; var1 < 32; ++var1) {
            if (w >> var1 != 1 || 1 << var1 != w) continue;
            return var1;
        }
        return 0;
    }

    private static int wUnitGen(int w) {
        if (w <= 256) {
            return 0x40000000;
        }
        if (w <= 512) {
            return 0x20000000;
        }
        if (w <= 1024) {
            return 0x10000000;
        }
        if (w <= 2048) {
            return 0x8000000;
        }
        if (w <= 4096) {
            return 0x4000000;
        }
        if (w <= 8192) {
            return 0x2000000;
        }
        return 0x1000000;
    }

    private static final boolean prepareAlpha(int[] pix) {
        boolean alphaMixing = false;
        for (int i = 0; i < pix.length; ++i) {
            int alpha = pix[i] >> 24 & 0xFF;
            if (alpha > 1 && alpha < 255) {
                alphaMixing = true;
            }
            if (alpha > 1) continue;
            pix[i] = 0;
        }
        return alphaMixing;
    }
}

