/*
 * Decompiled with CFR 0.152.
 */
package code.Rendering;

import code.Rendering.Meshes.Polygon3V;
import code.Rendering.Meshes.Polygon4V;
import code.Rendering.MultyTexture;
import code.Rendering.RenderObject;
import code.Rendering.TMPElement;
import code.Rendering.Texture;

public class RenderObjectBuffer {
    private TMPElement[] buffer = new TMPElement[0];
    private int size = 0;

    public void addRenderObjects(RenderObject[] objects, Texture tex, int x1, int y1, int x2, int y2) {
        int count = objects.length;
        for (int i = 0; i < count; ++i) {
            RenderObject obj = objects[i];
            if (!obj.isVisible(x1, y1, x2, y2)) continue;
            if (this.size >= this.buffer.length) {
                this.increaseBuffer();
            }
            TMPElement el = this.buffer[this.size];
            el.obj = obj;
            el.tex = tex;
            ++this.size;
        }
    }

    public void addRenderObjects(RenderObject[] objects, int x1, int y1, int x2, int y2) {
        int count = objects.length;
        for (int i = 0; i < count; ++i) {
            RenderObject obj = objects[i];
            if (!obj.isVisible(x1, y1, x2, y2)) continue;
            if (this.size >= this.buffer.length) {
                this.increaseBuffer();
            }
            TMPElement el = this.buffer[this.size];
            el.obj = obj;
            el.tex = null;
            ++this.size;
        }
    }

    public void addRenderObjects(RenderObject[] objects, MultyTexture tex, int x1, int y1, int x2, int y2) {
        int count = objects.length;
        for (int i = 0; i < count; ++i) {
            RenderObject obj = objects[i];
            if (!obj.isVisible(x1, y1, x2, y2)) continue;
            if (this.size >= this.buffer.length) {
                this.increaseBuffer();
            }
            TMPElement el = this.buffer[this.size];
            el.obj = obj;
            el.tex = tex.textures[0];
            if (obj instanceof Polygon4V) {
                el.tex = tex.textures[((Polygon4V)obj).tex];
            }
            if (obj instanceof Polygon3V) {
                el.tex = tex.textures[((Polygon3V)obj).tex];
            }
            ++this.size;
        }
    }

    public void addRenderObject(TMPElement obj, int x1, int y1, int x2, int y2) {
        RenderObject objz = obj.obj;
        if (objz.isVisible(x1, y1, x2, y2)) {
            if (this.size >= this.buffer.length) {
                this.increaseBuffer();
            }
            TMPElement el = this.buffer[this.size];
            el.obj = obj.obj;
            el.tex = obj.tex;
            ++this.size;
        }
    }

    public void addRenderObject(RenderObject obj, Texture tex, int x1, int y1, int x2, int y2) {
        if (obj.isVisible(x1, y1, x2, y2)) {
            if (this.size >= this.buffer.length) {
                this.increaseBuffer();
            }
            TMPElement el = this.buffer[this.size];
            el.obj = obj;
            el.tex = tex;
            ++this.size;
        }
    }

    public void addRenderObjectDT(RenderObject obj, Texture tex, int x1, int y1, int x2, int y2) {
        if (this.size >= this.buffer.length) {
            this.increaseBuffer();
        }
        TMPElement el = this.buffer[this.size];
        el.obj = obj;
        el.tex = tex;
        ++this.size;
    }

    public void addRenderObject(RenderObject obj, MultyTexture tex, int x1, int y1, int x2, int y2) {
        if (obj.isVisible(x1, y1, x2, y2)) {
            if (this.size >= this.buffer.length) {
                this.increaseBuffer();
            }
            TMPElement el = this.buffer[this.size];
            el.obj = obj;
            el.tex = tex.textures[0];
            if (obj instanceof Polygon4V) {
                el.tex = tex.textures[((Polygon4V)obj).tex];
            }
            if (obj instanceof Polygon3V) {
                el.tex = tex.textures[((Polygon3V)obj).tex];
            }
            ++this.size;
        }
    }

    public void addRenderObject(RenderObject obj, int x1, int y1, int x2, int y2) {
        if (obj.isVisible(x1, y1, x2, y2)) {
            if (this.size >= this.buffer.length) {
                this.increaseBuffer();
            }
            TMPElement el = this.buffer[this.size];
            el.obj = obj;
            el.tex = null;
            ++this.size;
        }
    }

    private void increaseBuffer() {
        int increase = 50;
        TMPElement[] newBuffer = new TMPElement[this.buffer.length + 50];
        System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
        for (int i = this.buffer.length; i < newBuffer.length; ++i) {
            newBuffer[i] = new TMPElement();
        }
        this.buffer = newBuffer;
    }

    public void sort(int start, int end) {
        if (start >= end) {
            return;
        }
        int opora = this.buffer[start + end >> 1].obj.sz;
        int first = start;
        int second = end;
        while (first <= second) {
            while (this.buffer[first].obj.sz > opora) {
                ++first;
            }
            while (this.buffer[second].obj.sz < opora) {
                --second;
            }
            if (first > second) continue;
            TMPElement tmp = this.buffer[first];
            this.buffer[first] = this.buffer[second];
            this.buffer[second] = tmp;
            ++first;
            --second;
        }
        if (start < second) {
            this.sort(start, second);
        }
        if (end > first) {
            this.sort(first, end);
        }
    }

    public void reset() {
        this.size = 0;
    }

    public void resetTex() {
        for (int i = 0; i < this.buffer.length; ++i) {
            this.buffer[i].tex = null;
        }
    }

    public TMPElement[] getBuffer() {
        return this.buffer;
    }

    public int getSize() {
        return this.size;
    }
}

