/*
 * Decompiled with CFR 0.152.
 */
package code.utils;

import code.utils.StringTools;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class IniFile {
    final Hashtable hashtable;

    public static IniFile createFromResource(String file) {
        return IniFile.createFromResource(file, false);
    }

    public static IniFile createFromResource(String file, boolean keys) {
        file = StringTools.getStringFromResource(file);
        return new IniFile(file, keys);
    }

    public static Object[] createGroups(String file) {
        file = StringTools.getStringFromResource(file);
        String[] lines = StringTools.cutOnStrings(file, '\n');
        Vector<String> names = new Vector<String>();
        Vector<IniFile> groups = new Vector<IniFile>();
        Hashtable<String, String> tmp = null;
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i].length() <= 0) continue;
            if (lines[i].charAt(0) == '[') {
                names.addElement(lines[i].substring(1, lines[i].length() - 1));
                tmp = new Hashtable<String, String>();
                groups.addElement(new IniFile(tmp));
                continue;
            }
            int charIndex = lines[i].indexOf(61);
            if (charIndex < 0) continue;
            String key = lines[i].substring(0, charIndex).trim();
            String val = lines[i].substring(charIndex + 1).trim();
            tmp.put(key, val);
        }
        String[] namesM = new String[names.size()];
        IniFile[] groupsM = new IniFile[namesM.length];
        for (int i = 0; i < namesM.length; ++i) {
            namesM[i] = (String)names.elementAt(i);
            groupsM[i] = (IniFile)groups.elementAt(i);
        }
        return new Object[]{namesM, groupsM};
    }

    public IniFile(Hashtable hash) {
        this.hashtable = hash;
    }

    public IniFile(String str, boolean keys) {
        this.hashtable = new Hashtable();
        String[] lines = StringTools.cutOnStrings(str, '\n');
        this.set(lines, keys);
    }

    private void set(String[] lines, boolean keys) {
        Hashtable<String, String> tmp = this.hashtable;
        for (int i = 0; i < lines.length; ++i) {
            String key;
            if (lines[i].length() <= 0) continue;
            if (lines[i].charAt(0) == '[' && keys) {
                key = lines[i].substring(1, lines[i].length() - 1);
                tmp = new Hashtable<String, String>();
                this.hashtable.put(key, tmp);
                continue;
            }
            int charIndex = lines[i].indexOf(61);
            if (charIndex < 0) continue;
            key = lines[i].substring(0, charIndex).trim();
            String val = lines[i].substring(charIndex + 1).trim();
            tmp.put(key, val);
        }
    }

    public String[] keys() {
        String[] out = new String[this.hashtable.size()];
        Enumeration keys = this.hashtable.keys();
        for (int i = 0; i < out.length; ++i) {
            out[i] = (String)keys.nextElement();
        }
        return out;
    }

    public Hashtable[] hashtables() {
        Hashtable[] out = new Hashtable[this.hashtable.size()];
        Enumeration hashtables = this.hashtable.elements();
        for (int i = 0; i < out.length; ++i) {
            out[i] = (Hashtable)hashtables.nextElement();
        }
        return out;
    }

    public void put(String group, String key, String value) {
        Object val = this.hashtable.get(key);
        if (val instanceof Hashtable) {
            ((Hashtable)val).put(key, value);
        } else {
            Hashtable<String, String> n = new Hashtable<String, String>();
            n.put(key, value);
            this.hashtable.put(group, n);
        }
    }

    public void put(String key, String value) {
        this.hashtable.put(key, value);
    }

    public boolean groupExists(String group) {
        return this.hashtable.get(group) != null;
    }

    public String get(String group, String key) {
        Object val = this.hashtable.get(group);
        if (val != null && val instanceof Hashtable) {
            return (String)((Hashtable)val).get(key);
        }
        return null;
    }

    public String getDef(String group, String key, String def) {
        String val = null;
        Object hash = this.hashtable.get(group);
        if (hash != null && hash instanceof Hashtable) {
            val = (String)((Hashtable)hash).get(key);
        }
        if (val == null) {
            return def;
        }
        return val;
    }

    public byte getByte(String group, String key) {
        return StringTools.parseByte(this.get(group, key));
    }

    public float getFloat(String group, String key) {
        return StringTools.parseFloat(this.get(group, key));
    }

    public int getInt(String group, String key) {
        return StringTools.parseInt(this.get(group, key));
    }

    public long getLong(String group, String key) {
        return StringTools.parseLong(this.get(group, key));
    }

    public float getFloat(String group, String key, float def) {
        String tmp = this.get(group, key);
        if (tmp == null) {
            return def;
        }
        return StringTools.parseFloat(tmp);
    }

    public int getInt(String group, String key, int def) {
        String tmp = this.get(group, key);
        if (tmp == null) {
            return def;
        }
        return StringTools.parseInt(tmp);
    }

    public String get(String key) {
        Object val = this.hashtable.get(key);
        if (val != null && val instanceof String) {
            return (String)val;
        }
        return null;
    }

    public String getDef(String key, String def) {
        Object val = this.hashtable.get(key);
        if (val != null && val instanceof String) {
            return (String)val;
        }
        return def;
    }

    public byte getByte(String key) {
        return StringTools.parseByte(this.get(key));
    }

    public float getFloat(String key) {
        return StringTools.parseFloat(this.get(key));
    }

    public int getInt(String key) {
        return StringTools.parseInt(this.get(key));
    }

    public long getLong(String key) {
        return StringTools.parseLong(this.get(key));
    }

    public float getFloat(String key, float def) {
        String tmp = this.get(key);
        if (tmp == null) {
            return def;
        }
        return StringTools.parseFloat(tmp);
    }

    public int getInt(String key, int def) {
        String tmp = this.get(key);
        if (tmp == null) {
            return def;
        }
        return StringTools.parseInt(tmp);
    }
}

