/*
 * Decompiled with CFR 0.152.
 */
package code.utils.scriptEngine;

import code.utils.StringTools;
import code.utils.scriptEngine.EnvironmentBase;
import code.utils.scriptEngine.Functions;
import code.utils.scriptEngine.Utils;
import java.io.DataInputStream;
import java.io.DataOutputStream;

public class ScriptEngine {
    public static final int END_WITH_BREAK = 0;
    public static final int END_WITH_END = 1;
    public static final int END_WITH_CODE_END = 2;
    public static final int END_WITH_ERROR = 3;
    private static final int BUFFER_INCREASE = 10;
    static final String STRING_PREFIX = "str.";
    static final String UNCLOSED_LITERAL = "Unclosed literal ";
    private int[] vars;
    private String[] varNames;
    private int varsCount;
    private String[] strVars;
    private String[] strNames;
    private int strVarsCount;
    EnvironmentBase env;

    ScriptEngine(EnvironmentBase env) {
        this.env = env;
        this.init(10);
    }

    ScriptEngine(EnvironmentBase env, DataInputStream dis) {
        this.env = env;
        if (!this.loadData(dis)) {
            this.init(10);
        }
    }

    private void init(int size) {
        this.vars = new int[size];
        this.varNames = new String[size];
        this.strVars = new String[size];
        this.strNames = new String[size];
        this.strVarsCount = 0;
        this.varsCount = 0;
    }

    boolean loadData(DataInputStream dis) {
        try {
            int i;
            short ver = dis.readShort();
            this.varsCount = dis.readInt();
            this.vars = new int[Math.max(this.varsCount, 10)];
            this.varNames = new String[Math.max(this.varsCount, 10)];
            for (i = 0; i < this.varsCount; ++i) {
                this.varNames[i] = dis.readUTF();
                this.vars[i] = dis.readInt();
            }
            this.strVarsCount = dis.readInt();
            this.strVars = new String[Math.max(this.strVarsCount, 10)];
            this.strNames = new String[Math.max(this.strVarsCount, 10)];
            for (i = 0; i < this.strVarsCount; ++i) {
                this.strNames[i] = dis.readUTF();
                this.strVars[i] = dis.readUTF();
            }
            return true;
        }
        catch (Exception e) {
            System.out.println("Error in script engine data load!");
            e.printStackTrace();
            return false;
        }
    }

    boolean saveData(DataOutputStream dos) {
        try {
            int i;
            dos.writeShort(0);
            dos.writeInt(this.varsCount);
            for (i = 0; i < this.varsCount; ++i) {
                dos.writeUTF(this.varNames[i]);
                dos.writeInt(this.vars[i]);
            }
            dos.writeInt(this.strVarsCount);
            for (i = 0; i < this.strVarsCount; ++i) {
                dos.writeUTF(this.strNames[i]);
                dos.writeUTF(this.strVars[i]);
            }
            return true;
        }
        catch (Exception e) {
            System.out.println("Error in script engine data save!");
            e.printStackTrace();
            return false;
        }
    }

    public void removeAllVars() {
        this.removeAllVars(null);
    }

    public void removeAllVars(String[] except) {
        int i;
        int newCount = 0;
        for (i = 0; i < this.varsCount; ++i) {
            if (except != null && Utils.findString(except, this.varNames[i], except.length) != -1) {
                this.varNames[newCount] = this.varNames[i];
                this.vars[newCount] = this.vars[i];
                ++newCount;
            }
            this.varNames[i] = null;
        }
        this.varsCount = newCount;
        newCount = 0;
        for (i = 0; i < this.strVarsCount; ++i) {
            if (except != null && Utils.findString(except, this.strNames[i], except.length) != -1) {
                this.strNames[newCount] = this.strNames[i];
                this.strVars[newCount] = this.strVars[i];
                ++newCount;
            }
            this.strNames[i] = null;
            this.strVars[i] = null;
        }
        this.strVarsCount = newCount;
    }

    int runCode(String[] code) {
        return this.runCode(code, 0, code.length);
    }

    int runCode(String[] code, int begin, int end) {
        block0: for (int i = begin; i < end; ++i) {
            int rc;
            int codeEnd;
            int codeBegin;
            if (code[i].startsWith("if")) {
                boolean val = this.readBoolean(code[i].substring(2));
                codeBegin = i + 1;
                codeEnd = codeBegin + 1;
                if (code[i + 1].equals("{")) {
                    codeBegin = i + 2;
                    codeEnd = Utils.findBracketEnd(code, i + 1, "{", "}");
                    if (codeEnd == -1) {
                        System.out.println("Unclosed literal  { " + code[i]);
                        return 3;
                    }
                    i = codeEnd;
                } else {
                    i = codeEnd - 1;
                }
                if (val) {
                    rc = this.runCode(code, codeBegin, codeEnd);
                    if (rc != 1 && rc != 3) continue;
                    return rc;
                }
                ++i;
                while (i < end) {
                    if (!code[i].startsWith("else")) {
                        --i;
                        continue block0;
                    }
                    codeBegin = i + 1;
                    codeEnd = codeBegin + 1;
                    boolean elseif = true;
                    if (code[i].startsWith("else if")) {
                        elseif = this.readBoolean(code[i].substring(7));
                    }
                    if (code[i + 1].equals("{")) {
                        codeBegin = i + 2;
                        codeEnd = Utils.findBracketEnd(code, i + 1, "{", "}");
                        if (codeEnd == -1) {
                            System.out.println("Unclosed literal  { " + code[i]);
                            return 3;
                        }
                        i = codeEnd + 1;
                    } else {
                        i = codeEnd;
                    }
                    if (!elseif) continue;
                    int rc2 = this.runCode(code, codeBegin, codeEnd);
                    if (rc2 == 1 || rc2 == 3) {
                        return rc2;
                    }
                    --i;
                    continue block0;
                }
                continue;
            }
            if (code[i].startsWith("else")) {
                if (code[i + 1].equals("{")) {
                    int ti = Utils.findBracketEnd(code, i + 1, "{", "}");
                    if (ti == -1) {
                        System.out.println("Unclosed literal  { " + code[i]);
                        return 3;
                    }
                    i = ti;
                    continue;
                }
                ++i;
                continue;
            }
            if (code[i].startsWith("while")) {
                String val = code[i].substring(5);
                codeBegin = i + 1;
                codeEnd = codeBegin + 1;
                if (code[i + 1].equals("{")) {
                    codeBegin = i + 2;
                    codeEnd = Utils.findBracketEnd(code, i + 1, "{", "}");
                    if (codeEnd == -1) {
                        System.out.println("Unclosed literal  { " + code[i]);
                        return 3;
                    }
                    i = codeEnd;
                } else {
                    i = codeEnd - 1;
                }
                while (this.readBoolean(val)) {
                    rc = this.runCode(code, codeBegin, codeEnd);
                    if (rc == 1 || rc == 3) {
                        return rc;
                    }
                    if (rc != 0) continue;
                    continue block0;
                }
                continue;
            }
            if (code[i].equals("end")) {
                return 1;
            }
            if (code[i].equals("break")) {
                return 0;
            }
            this.runLine(code[i]);
        }
        return 2;
    }

    void runLine(String line) {
        if (line.startsWith("//")) {
            return;
        }
        int skobkaPos = line.indexOf(40);
        int equalPos = line.indexOf(61);
        if (equalPos != -1 && (equalPos < skobkaPos || skobkaPos == -1)) {
            String variable;
            int varNameEnd = equalPos;
            char charBefore = line.charAt(equalPos - 1);
            boolean justEq = true;
            if (charBefore == '/' || charBefore == '*' || charBefore == '+' || charBefore == '-' || charBefore == '|' || charBefore == '&' || charBefore == '^' || charBefore == '%') {
                --varNameEnd;
                justEq = false;
            }
            if ((variable = line.substring(0, varNameEnd).trim()).startsWith(STRING_PREFIX)) {
                String setTo = this.readString(line.substring(equalPos + 1));
                this.setVariableString(variable, justEq ? setTo : this.getVariableString(variable) + setTo);
            } else {
                int oldValue = justEq ? 1 : this.getVariable(variable);
                int newValue = this.readValue(line.substring(equalPos + 1));
                if (!justEq) {
                    if (charBefore == '/') {
                        oldValue /= newValue;
                        newValue = oldValue;
                    } else if (charBefore == '*') {
                        oldValue *= newValue;
                        newValue = oldValue;
                    } else if (charBefore == '+') {
                        oldValue += newValue;
                        newValue = oldValue;
                    } else if (charBefore == '-') {
                        oldValue -= newValue;
                        newValue = oldValue;
                    } else if (charBefore == '|') {
                        oldValue |= newValue;
                        newValue = oldValue;
                    } else if (charBefore == '&') {
                        oldValue &= newValue;
                        newValue = oldValue;
                    } else if (charBefore == '^') {
                        oldValue ^= newValue;
                        newValue = oldValue;
                    } else if (charBefore == '%') {
                        oldValue %= newValue;
                        newValue = oldValue;
                    }
                }
                this.setVariableValue(variable, newValue);
            }
        } else if (skobkaPos != -1) {
            Functions.functionVoid(this, line);
        }
    }

    void setVariableString(String name, String value) {
        int index = Utils.findString(this.strNames, name, this.strVarsCount);
        if (index != -1) {
            this.strVars[index] = value;
        } else {
            if (this.env.getsetEnvString(name, value, true) != null) {
                return;
            }
            if (this.strVarsCount == this.strVars.length) {
                String[] nstrVars = new String[this.strVarsCount + 10];
                String[] nstrNames = new String[this.strVarsCount + 10];
                System.arraycopy(this.strVars, 0, nstrVars, 0, this.strVarsCount);
                System.arraycopy(this.strNames, 0, nstrNames, 0, this.strVarsCount);
                this.strVars = nstrVars;
                this.strNames = nstrNames;
            }
            this.strNames[this.strVarsCount] = name;
            this.strVars[this.strVarsCount] = value;
            ++this.strVarsCount;
        }
    }

    String getVariableString(String name) {
        int index = Utils.findString(this.strNames, name, this.strVarsCount);
        if (index == -1) {
            String tmp = this.env.getsetEnvString(name, null, false);
            return tmp == null ? "null" : tmp;
        }
        return this.strVars[index];
    }

    void setVariableValue(String name, int value) {
        int index = Utils.findString(this.varNames, name, this.varsCount);
        if (index != -1) {
            this.vars[index] = value;
        } else {
            if (this.env.getsetEnvValue(name, value, true) != null) {
                return;
            }
            if (this.varsCount == this.vars.length) {
                int[] nVars = new int[this.varsCount + 10];
                String[] nvarNames = new String[this.varsCount + 10];
                System.arraycopy(this.vars, 0, nVars, 0, this.varsCount);
                System.arraycopy(this.varNames, 0, nvarNames, 0, this.varsCount);
                this.vars = nVars;
                this.varNames = nvarNames;
            }
            this.varNames[this.varsCount] = name;
            this.vars[this.varsCount] = value;
            ++this.varsCount;
        }
    }

    int getVariable(String name) {
        int index = Utils.findString(this.varNames, name, this.varsCount);
        if (index == -1) {
            int[] tmp = this.env.getsetEnvValue(name, 0, false);
            return tmp == null ? 0 : tmp[0];
        }
        return this.vars[index];
    }

    void removeVar(String name) {
        if (name.startsWith(STRING_PREFIX)) {
            int index = Utils.findString(this.strNames, name, this.strVarsCount);
            if (index != -1) {
                --this.strVarsCount;
                this.strVars[index] = this.strVars[this.strVarsCount];
                this.strVars[this.strVarsCount] = null;
            }
        } else {
            int index = Utils.findString(this.varNames, name, this.varsCount);
            if (index != -1) {
                --this.varsCount;
                this.vars[index] = this.vars[this.varsCount];
            }
        }
    }

    boolean readBoolean(String val) {
        return (this.readValue(val) & 1) == 1;
    }

    int readValue(String val) {
        if (val.equals("")) {
            return 0;
        }
        int skobka = val.indexOf(40);
        if (skobka != -1) {
            String s;
            int end = Utils.findBracketEnd(val, skobka, '(', ')');
            if (end == -1) {
                System.out.println("Unclosed literal  ( " + val);
                return 0;
            }
            int functionNameBegin = Utils.findFunctionNameBeginning(val, skobka);
            if (functionNameBegin == -1) {
                s = "" + this.readValue(val.substring(skobka + 1, end));
            } else {
                skobka = functionNameBegin;
                s = "" + Functions.functionNumber(this, val.substring(skobka, end + 1))[0];
            }
            if (0 < skobka) {
                s = val.substring(0, skobka) + s;
            }
            if (end + 1 < val.length()) {
                s = s + val.substring(end + 1);
            }
            return this.readValue(s);
        }
        int cond = val.indexOf(63);
        if (cond != -1) {
            int cond2 = val.indexOf(58, cond + 1);
            boolean bol = this.readBoolean(val.substring(0, cond));
            String vl = bol ? val.substring(cond + 1, cond2) : val.substring(cond2 + 1);
            return this.readValue(vl);
        }
        int orp = val.indexOf(124);
        if (orp != -1) {
            return this.readValue(val.substring(0, orp)) | this.readValue(val.substring(orp + 1));
        }
        int xorp = val.indexOf(94);
        if (xorp != -1) {
            return this.readValue(val.substring(0, xorp)) ^ this.readValue(val.substring(xorp + 1));
        }
        int andp = val.indexOf(38);
        if (andp != -1) {
            return this.readValue(val.substring(0, andp)) & this.readValue(val.substring(andp + 1));
        }
        int equalp = val.indexOf(61);
        int lessp = val.indexOf(60);
        int morep = val.indexOf(62);
        if (equalp != -1 || lessp != -1 || morep != -1) {
            int pos = equalp;
            int type = 0;
            boolean notEqual = false;
            if (pos == -1 || lessp < pos && lessp != -1) {
                pos = lessp;
                type = 1;
            }
            if (pos == -1 || morep < pos && morep != -1) {
                pos = morep;
                type = 2;
            }
            if (type == 0 && pos - 1 >= 0 && val.charAt(pos - 1) == '!') {
                notEqual = true;
            }
            if (type == 0) {
                if (notEqual) {
                    return this.readValue(val.substring(0, pos - 1)) == this.readValue(val.substring(pos + 1)) ? 0 : 1;
                }
                return this.readValue(val.substring(0, pos)) == this.readValue(val.substring(pos + 2)) ? 1 : 0;
            }
            if (type == 1) {
                boolean lessEqual = equalp == pos + 1;
                int len = lessEqual ? 2 : 1;
                int val1 = this.readValue(val.substring(0, pos));
                int val2 = this.readValue(val.substring(pos + len));
                if (lessEqual) {
                    return val1 <= val2 ? 1 : 0;
                }
                return val1 < val2 ? 1 : 0;
            }
            if (type == 2) {
                boolean moreEqual = equalp == pos + 1;
                int len = moreEqual ? 2 : 1;
                int val1 = this.readValue(val.substring(0, pos));
                int val2 = this.readValue(val.substring(pos + len));
                if (moreEqual) {
                    return val1 >= val2 ? 1 : 0;
                }
                return val1 > val2 ? 1 : 0;
            }
        }
        int addp = val.indexOf(43);
        int subp = val.indexOf(45);
        if (addp != -1 || subp != -1) {
            boolean add = addp != -1 && (addp < subp || subp == -1);
            int pos = add ? addp : subp;
            int val1 = this.readValue(val.substring(0, pos));
            int val2 = this.readValue(val.substring(pos + 1));
            if (add) {
                return val1 + val2;
            }
            return val1 - val2;
        }
        int mulp = val.indexOf(42);
        int divp = val.indexOf(47);
        int modp = val.indexOf(37);
        if (mulp != -1 || divp != -1) {
            int pos = mulp;
            int type = 0;
            if (pos == -1 || divp < pos && divp != -1) {
                pos = divp;
                type = 1;
            }
            if (pos == -1 || modp < pos && modp != -1) {
                pos = modp;
                type = 2;
            }
            int val1 = this.readValue(val.substring(0, pos));
            int val2 = this.readValue(val.substring(pos + 1));
            if (type == 1) {
                return val1 / val2;
            }
            if (type == 2) {
                return val1 % val2;
            }
            return val1 * val2;
        }
        int invp = val.indexOf(33);
        int inv2p = val.indexOf(126);
        if (invp != -1 && (invp + 1 >= val.length() || val.charAt(invp + 1) != '=') || inv2p != -1) {
            if (invp == -1 || inv2p < invp && inv2p != -1) {
                return this.readValue(val.substring(0, inv2p) + ~this.readValue(val.substring(inv2p + 1)));
            }
            return this.readValue(val.substring(0, invp) + (1 - (this.readValue(val.substring(invp + 1)) & 1)));
        }
        char ch = (val = val.trim()).charAt(0);
        if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') {
            if (val.equals("true")) {
                return 1;
            }
            if (val.equals("false")) {
                return 0;
            }
            return this.getVariable(val);
        }
        return Integer.parseInt(val);
    }

    String readString(String val) {
        int skobka = Utils.indexOf(val, '(');
        if (skobka != -1) {
            String s;
            int end = Utils.findBracketEnd(val, skobka, '(', ')');
            if (end == -1) {
                System.out.println("Unclosed literal  ( " + val);
                return "";
            }
            int functionNameBegin = Utils.findFunctionNameBeginning(val, skobka);
            if (functionNameBegin == -1) {
                s = this.readString(val.substring(skobka + 1, end));
            } else {
                skobka = functionNameBegin;
                s = '\"' + Functions.functionString(this, val.substring(skobka, end + 1)) + '\"';
            }
            if (0 < skobka) {
                s = val.substring(0, skobka) + s;
            }
            if (end + 1 < val.length()) {
                s = s + val.substring(end + 1);
            }
            return this.readString(s);
        }
        int cond = Utils.indexOf(val, '?');
        if (cond != -1) {
            int cond2 = Utils.indexOf(val, ':', cond + 1);
            boolean bol = this.readBoolean(val.substring(0, cond));
            String vl = bol ? val.substring(cond + 1, cond2) : val.substring(cond2 + 1);
            return this.readString(vl);
        }
        int addp = Utils.indexOf(val, '+');
        if (addp != -1) {
            return this.readString(val.substring(0, addp)) + this.readString(val.substring(addp + 1));
        }
        char ch = (val = val.trim()).charAt(0);
        if (ch == '\"') {
            return Utils.fixEscapeCharacters(val.substring(1, val.length() - 1));
        }
        return this.getVariableString(val);
    }

    void runScriptFromFile(String file) {
        String[] code = this.loadScript(file);
        this.runCode(code);
    }

    String[] loadScript(String file) {
        String[] code = StringTools.cutOnStrings(StringTools.getStringFromResource(file), '\n');
        int curlys = 0;
        for (int i = 0; i < code.length; ++i) {
            String line = code[i].trim();
            if (line.equals("{")) {
                ++curlys;
            } else if (line.equals("}")) {
                --curlys;
            }
            code[i] = line;
        }
        if (curlys != 0) {
            System.out.println("Unclosed literal  {} " + file);
            return new String[]{"println(\"please fix error in " + file + "\")"};
        }
        return code;
    }
}

