/*
 * Decompiled with CFR 0.152.
 */
package code.Gameplay;

import code.AI.Bot;
import code.AI.Player;
import code.AI.misc.Splinter;
import code.AI.misc.Trace;
import code.Collision.Ray;
import code.Gameplay.Magazine;
import code.Gameplay.Map.Character;
import code.Gameplay.Map.House;
import code.Gameplay.Objects.GameObject;
import code.Gameplay.Objects.MeshObject;
import code.HUD.DeveloperMenu;
import code.Math.MathUtils2;
import code.Math.Matrix;
import code.Math.Vector3D;
import code.Rendering.DirectX7;
import code.Rendering.Meshes.Polygon3V;
import code.Rendering.Meshes.Polygon4V;
import code.Rendering.RenderObject;
import code.utils.Asset;
import code.utils.FPS;
import code.utils.ImageResize;
import code.utils.Main;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class Weapon {
    private static final Splinter splinter = new Splinter();
    private static final Ray ray = new Ray();
    private final short damageValue;
    private final short delay;
    private final short shotTime;
    public float frame = -1.0f;
    private final String fileWeapon;
    private final String fileFire;
    public String fileSight;
    public String fileSightWeapon;
    public String filePatron;
    public String filePatronLow;
    private final float kW;
    private final float kH;
    public boolean patronbuy = true;
    private Image imgWeapon;
    private Image imgFire;
    private Image sight;
    private Image sightWeapon;
    public Image imgPatron;
    public Image imgPatronLow;
    private long distance = 999999999L;
    public boolean meleeAnim = false;
    private short dx_fire = 1;
    private short dy_fire = 1;
    public short dx_max = 0;
    public short dy_max = 0;
    private short dx = 0;
    private short dy = 0;
    private short widthShift = (short)2;
    private short heightShift = (short)5;
    private boolean twoHands = false;
    public boolean leftHand = false;
    private boolean shake = false;
    public boolean newanim = false;
    public Magazine magazine;
    public int stdFov;
    public int zoomFov;
    public boolean hasZoom;
    public String shoot = null;
    public String reload = null;
    public boolean canShoot = true;
    public boolean ignoreSightOnDraw = false;
    public float attackIntensity = 1.0f;
    public boolean debugWeapon = false;
    public int weaponId = 1;
    public boolean customPos = false;
    public float customPosX = 1.0f;
    public boolean centreAlign = false;
    public boolean shootLight = true;
    public int playerPose = 0;

    public Weapon(String fileWeapon, String fileFire, float kW, float kH, int damageValue, int delay, int shotTime, boolean twoHands, int capacity, int reloadTime, long distance, boolean pb, int weaponId) {
        this.distance = distance;
        this.patronbuy = pb;
        this.fileWeapon = fileWeapon;
        this.fileFire = fileFire;
        this.kW = kW;
        this.kH = kH;
        this.damageValue = (short)damageValue;
        this.delay = (short)delay;
        this.shotTime = (short)shotTime;
        this.twoHands = twoHands;
        this.magazine = new Magazine(capacity, reloadTime);
        this.newanim = false;
        this.weaponId = weaponId;
        this.stdFov = Main.stdFov;
        this.zoomFov = Main.zoomFov;
        this.hasZoom = Main.hasZoom;
    }

    public final void reset() {
        this.sightWeapon = null;
        this.sight = null;
        this.imgFire = null;
        this.imgWeapon = null;
    }

    public final void createSprite(int width_g3d, int height_g3d) {
        float coof = (float)height_g3d / 256.0f;
        float coof2 = (float)width_g3d / 240.0f;
        if (this.customPos || !Main.resizeWeapons) {
            coof2 = coof;
        }
        if (this.fileWeapon != null) {
            this.imgWeapon = ImageResize.createImage(this.fileWeapon, coof2, coof);
            this.dx_fire = (short)((float)this.imgWeapon.getWidth() * this.kW);
            this.dy_fire = (short)((float)this.imgWeapon.getHeight() * this.kH);
            this.dx_max = (short)(this.imgWeapon.getWidth() / 5);
            this.dy_max = (short)(this.imgWeapon.getHeight() / 5);
            if (this.attackIntensity > 1.0f) {
                this.dx_max = (short)(this.imgWeapon.getWidth() / 2);
                this.dy_max = (short)(this.imgWeapon.getHeight() / 2);
            }
        }
        if (this.fileFire != null) {
            this.imgFire = ImageResize.createImage(this.fileFire, coof2, coof);
        }
    }

    private void createSights(int width, int height) {
        float coof = (float)height / 256.0f;
        if (this.sight == null && this.fileSight != null) {
            this.sight = ImageResize.createImage(this.fileSight, width, height);
        }
        if (this.sightWeapon == null && this.fileSightWeapon != null) {
            this.sightWeapon = ImageResize.createImage(this.fileSightWeapon, coof, coof);
        }
    }

    private boolean isFire() {
        return this.frame >= 0.0f;
    }

    public short getDamageValue() {
        return this.damageValue;
    }

    public final void draw(Graphics g, int x, int y, int width, int height) {
        if (this.imgWeapon == null && this.fileWeapon != null) {
            this.createSprite(width, height);
        }
        if (this.sight == null && this.fileSight != null || this.sightWeapon == null && this.fileSightWeapon != null) {
            this.createSights(width, height);
        }
        short dxb = this.dx;
        short dxmb = this.dx_max;
        if (this.meleeAnim) {
            this.dx = (short)(this.dx_max - this.dx);
            this.dy = (short)(this.dy_max - this.dy);
        }
        int oldWidth = width;
        if (this.customPos) {
            x = (int)((float)(width - height * 240 / 256) * this.customPosX / 2.0f);
            width = (int)((float)(height * 240) * this.customPosX / 256.0f);
        } else {
            x = 0;
        }
        if (this.centreAlign && this.imgWeapon != null) {
            x += this.imgWeapon.getWidth() / 2;
        }
        if (!this.newanim) {
            if (this.twoHands || !this.leftHand) {
                if (this.isFire() && this.imgFire != null) {
                    g.drawImage(this.imgFire, width - this.dx_fire + this.dx + x, height - this.dy_fire + this.dy + y, 3);
                }
                if (this.imgWeapon != null) {
                    g.drawImage(this.imgWeapon, width + this.dx + x, height + this.dy + y, 40);
                }
            }
            if (this.twoHands || this.leftHand) {
                if (this.isFire() && this.imgFire != null) {
                    g.drawRegion(this.imgFire, 0, 0, this.imgFire.getWidth(), this.imgFire.getHeight(), 2, oldWidth - (width - this.dx_fire + this.dx + x), height - this.dy_fire + this.dy + y, 3);
                }
                if (this.imgWeapon != null) {
                    g.drawRegion(this.imgWeapon, 0, 0, this.imgWeapon.getWidth(), this.imgWeapon.getHeight(), 2, oldWidth - (width + this.dx + x), height + this.dy + y, 36);
                }
            }
        } else {
            if (this.twoHands || !this.leftHand) {
                if (this.isFire()) {
                    if (this.imgFire != null) {
                        g.drawImage(this.imgFire, width + this.dx + x, height + this.dy + y, 40);
                    }
                } else if (this.imgWeapon != null) {
                    g.drawImage(this.imgWeapon, width + this.dx + x, height + this.dy + y, 40);
                }
            }
            if (this.twoHands || this.leftHand) {
                if (this.isFire()) {
                    if (this.imgFire != null) {
                        g.drawRegion(this.imgFire, 0, 0, this.imgFire.getWidth(), this.imgFire.getHeight(), 2, oldWidth - (width + this.dx + x), height + this.dy + y, 36);
                    }
                } else if (this.imgWeapon != null) {
                    g.drawRegion(this.imgWeapon, 0, 0, this.imgWeapon.getWidth(), this.imgWeapon.getHeight(), 2, oldWidth - (width + this.dx + x), height + this.dy + y, 36);
                }
            }
        }
        if (this.meleeAnim) {
            this.dy = (short)(this.dy_max - this.dy);
        }
        this.dx_max = dxmb;
        this.dx = dxb;
    }

    public final void drawSight(Graphics g, int x, int y, int width, int height) {
        if (this.ignoreSightOnDraw) {
            this.draw(g, x, y, width, height);
        }
        if (this.sight == null && this.fileSight != null || this.sightWeapon == null && this.fileSightWeapon != null) {
            this.createSights(width, height);
        }
        if (this.sight == null && this.sightWeapon == null) {
            return;
        }
        if (this.meleeAnim) {
            this.dx = (short)(this.dx_max - this.dx);
            this.dy = (short)(this.dy_max - this.dy);
        }
        if (this.sightWeapon != null) {
            if (!this.twoHands) {
                g.drawImage(this.sightWeapon, width / 2, height + y + this.dy, 33);
            } else {
                g.drawImage(this.sightWeapon, width / 2, height + y + this.dy, 36);
                g.drawRegion(this.sightWeapon, 0, 0, this.sightWeapon.getWidth(), this.sightWeapon.getHeight(), 2, width / 2, height + y + this.dy, 40);
            }
        }
        if (this.sight != null) {
            g.drawImage(this.sight, 0, y, 20);
        }
        if (this.meleeAnim) {
            this.dx = (short)(this.dx_max - this.dx);
            this.dy = (short)(this.dy_max - this.dy);
        }
    }

    public void renderSplinter(DirectX7 g3d) {
        splinter.project(g3d);
        if (splinter.isShatters()) {
            splinter.render(g3d, 1500);
        }
    }

    public final void enableShake() {
        this.shake = true;
    }

    public final int getRounds() {
        return this.magazine.rounds;
    }

    public int getAmmo() {
        return this.magazine.ammo;
    }

    public void setAmmo(int number) {
        this.magazine.setAmmo(number);
        this.magazine.recount();
    }

    public final boolean isReloading() {
        return this.magazine.isReloading();
    }

    public final int reloadingPercentage() {
        return this.magazine.percentage();
    }

    public final GameObject update(House house, GameObject player) {
        boolean fire;
        if (this.canShoot) {
            this.magazine.update();
        }
        int anima = 29;
        if (this.attackIntensity > 1.0f) {
            anima = 17;
        }
        boolean bl = fire = this.frame == 0.0f;
        if (this.isFire() && this.canShoot) {
            this.frame += 1.0f * (float)FPS.frameTime / 50.0f;
            if (this.frame > (float)this.shotTime) {
                this.frame = -this.delay;
            }
        }
        if (this.frame < -1.0f) {
            this.frame += 1.0f * (float)FPS.frameTime / 16.6f;
            if (this.frame > -1.0f) {
                this.frame = -1.0f;
            }
        }
        if (this.isFire() && this.canShoot) {
            this.dx = (short)((float)this.dx + (float)((Math.abs(this.widthShift) << 1) * FPS.frameTime / anima) * this.attackIntensity);
            this.dy = (short)((float)this.dy + (float)((Math.abs(this.heightShift) << 1) * FPS.frameTime / anima) * this.attackIntensity);
        }
        if (this.shake && this.frame >= -1.0f) {
            if (anima != 17) {
                this.dx = (short)(this.dx + (byte)(this.widthShift * FPS.frameTime / anima));
                this.dy = (short)(this.dy + (byte)(this.heightShift * FPS.frameTime / anima));
            }
            this.shake = false;
        } else {
            this.dx = (short)(this.dx + -this.dx * FPS.frameTime / anima / 6);
            this.dy = (short)(this.dy + -this.dy * FPS.frameTime / anima / 6);
        }
        if (this.dy <= 0) {
            this.dy = 0;
            this.heightShift = -this.heightShift;
        }
        if (this.dy > this.dy_max) {
            this.dy = this.dy_max;
            this.heightShift = -this.heightShift;
        }
        if (this.dx <= 0) {
            this.dx = 0;
            this.widthShift = -this.widthShift;
        }
        if (this.dx >= this.dx_max) {
            this.dx = this.dx_max;
            this.widthShift = -this.widthShift;
        }
        if (fire && this.canShoot) {
            Matrix mat = player.getCharacter().getTransform();
            ray.reset();
            Vector3D start = ray.getStart();
            Vector3D end = ray.getDir();
            start.set(mat.m03, mat.m13 + ((Player)player).getEyesHeight(), mat.m23);
            end.set(-mat.m02 << 1, -mat.m12 << 1, -mat.m22 << 1);
            ray.reset();
            house.rayCast(player.getPart(), ray, true);
            if (ray.isCollision()) {
                end.setLength(ray.getDistance());
            }
            GameObject pobj = player;
            Character pchar = player.getCharacter();
            GameObject damagedEnemy = null;
            long dist = Integer.MAX_VALUE;
            Vector objects = house.getObjects();
            Vector3D headPos = new Vector3D();
            for (int var8 = 0; var8 < objects.size(); ++var8) {
                long dist2;
                GameObject obj;
                if (!(objects.elementAt(var8) instanceof GameObject) || (obj = (GameObject)objects.elementAt(var8)) instanceof MeshObject && ((MeshObject)obj).ignoreWeaponRayCast || obj == pobj || obj.isDead()) continue;
                Character chr = obj.getCharacter();
                Matrix mat2 = chr.getTransform();
                headPos.set(mat2.m03, mat2.m13 + chr.getHeight(), mat2.m23);
                int radius = chr.getRadius();
                if (MathUtils2.distanceToRay(headPos, start, end) < radius * radius) {
                    int x = headPos.x - start.x;
                    int y = headPos.y - start.y;
                    int z = headPos.z - start.z;
                    dist2 = (long)x * (long)x + (long)y * (long)y + (long)z * (long)z;
                } else {
                    dist2 = Integer.MAX_VALUE;
                }
                if (dist2 >= dist) continue;
                damagedEnemy = obj;
                dist = dist2;
            }
            fire = damagedEnemy != null;
            boolean damaged = false;
            if (fire && damagedEnemy.getCharacter().distance(pchar) < this.distance * this.distance) {
                damaged = damagedEnemy.damage(player, this.damageValue);
            }
            if (ray.isCollision()) {
                Vector3D colPoint = ray.getCollisionPoint();
                if (!fire && (long)ray.getDistance() < this.distance) {
                    splinter.set(colPoint.x, colPoint.y, colPoint.z);
                }
                if (fire && Main.blood && pobj instanceof Bot && this.damageValue > 0 && ((Bot)pobj).hasBlood) {
                    Trace trace = this.createTrace(colPoint, ray.getTriangle());
                    trace.setPart(ray.getNumRoom());
                    house.addObject(trace);
                }
                if (DeveloperMenu.debugMode && (this.debugWeapon || DeveloperMenu.showShootCollision)) {
                    System.out.println("Shoot Collision: " + colPoint.x + "," + colPoint.y + "," + colPoint.z);
                }
            }
            if (damaged) {
                return damagedEnemy;
            }
        }
        return null;
    }

    public final boolean fire(DirectX7 g3d) {
        if (!this.canShoot) {
            return false;
        }
        if (!this.patronbuy) {
            this.magazine.addAmmo(1);
            this.magazine.takeRounds(-1);
            if (this.twoHands) {
                this.magazine.addAmmo(1);
                this.magazine.takeRounds(-1);
            }
        }
        if (this.frame == -1.0f) {
            if (this.magazine.rounds > 0) {
                this.frame = 0.0f;
                if (this.shootLight) {
                    g3d.shootIntensity = g3d.shootLength = this.shotTime * 90;
                }
                if (this.shoot != null && Main.isSounds && Main.sounds != 0) {
                    Asset.getSound(this.reload).stop();
                    Asset.getSound(this.shoot).setVolume(Main.sounds);
                    Asset.getSound(this.shoot).start();
                }
                this.magazine.takeRounds(this.twoHands ? 2 : 1);
                return true;
            }
            if (!this.magazine.isReloading()) {
                this.magazine.reload();
                if (this.magazine.isReloading() && this.reload != null && Main.isSounds && Main.sounds != 0) {
                    Asset.getSound(this.reload).stop();
                    Asset.getSound(this.reload).setVolume(Main.sounds);
                    Asset.getSound(this.reload).start(0L);
                }
            }
        }
        return false;
    }

    public final boolean isTwoHands() {
        return this.twoHands;
    }

    public final void addAmmo(int number) {
        this.magazine.addAmmo(number);
    }

    public Trace createTrace(Vector3D vector3f, RenderObject meshr) {
        int posz;
        int posy;
        int posx;
        int minx = 0;
        int miny = 0;
        int minz = 0;
        int maxx = 0;
        int maxy = 0;
        int maxz = 0;
        Vector3D v1 = new Vector3D(0, 0, 0);
        Vector3D v2 = new Vector3D(0, 0, 0);
        Vector3D v3 = new Vector3D(0, 0, 0);
        Vector3D v4 = new Vector3D(0, 0, 0);
        if (meshr instanceof Polygon4V) {
            Polygon4V p4v = (Polygon4V)meshr;
            posx = (p4v.a.x + p4v.b.x + p4v.c.x + p4v.d.x) / 4;
            posy = (p4v.a.y + p4v.b.y + p4v.c.y + p4v.d.y) / 4;
            posz = (p4v.a.z + p4v.b.z + p4v.c.z + p4v.d.z) / 4;
            minx = Math.min(Math.min(Math.min(p4v.a.x, p4v.b.x), p4v.c.x), p4v.d.x) - posx;
            miny = Math.min(Math.min(Math.min(p4v.a.y, p4v.b.y), p4v.c.y), p4v.d.y) - posy;
            minz = Math.min(Math.min(Math.min(p4v.a.z, p4v.b.z), p4v.c.z), p4v.d.z) - posz;
            maxx = Math.max(Math.max(Math.max(p4v.a.x, p4v.b.x), p4v.c.x), p4v.d.x) - posx;
            maxy = Math.max(Math.max(Math.max(p4v.a.y, p4v.b.y), p4v.c.y), p4v.d.y) - posy;
            maxz = Math.max(Math.max(Math.max(p4v.a.z, p4v.b.z), p4v.c.z), p4v.d.z) - posz;
            v1.set(p4v.a.x - posx, p4v.a.y - posy, p4v.a.z - posz);
            v2.set(p4v.b.x - posx, p4v.b.y - posy, p4v.b.z - posz);
            v3.set(p4v.c.x - posx, p4v.c.y - posy, p4v.c.z - posz);
            v4.set(p4v.d.x - posx, p4v.d.y - posy, p4v.d.z - posz);
        }
        if (meshr instanceof Polygon3V) {
            Polygon3V p3v = (Polygon3V)meshr;
            posx = (p3v.a.x + p3v.b.x + p3v.c.x) / 3;
            posy = (p3v.a.y + p3v.b.y + p3v.c.y) / 3;
            posz = (p3v.a.z + p3v.b.z + p3v.c.z) / 3;
            minx = Math.min(Math.min(p3v.a.x, p3v.b.x), p3v.c.x) - posx;
            miny = Math.min(Math.min(p3v.a.y, p3v.b.y), p3v.c.y) - posy;
            minz = Math.min(Math.min(p3v.a.z, p3v.b.z), p3v.c.z) - posz;
            maxx = Math.max(Math.max(p3v.a.x, p3v.b.x), p3v.c.x) - posx;
            maxy = Math.max(Math.max(p3v.a.y, p3v.b.y), p3v.c.y) - posy;
            maxz = Math.max(Math.max(p3v.a.z, p3v.b.z), p3v.c.z) - posz;
            v1.set(p3v.a.x - posx, p3v.a.y - posy, p3v.a.z - posz);
            v2.set(p3v.b.x - posx, p3v.b.y - posy, p3v.b.z - posz);
            v3.set(p3v.c.x - posx, p3v.c.y - posy, p3v.c.z - posz);
            v4.set(p3v.c.x - posx, p3v.c.y - posy, p3v.c.z - posz);
        }
        return new Trace(vector3f.x, vector3f.y, vector3f.z, v1, v2, v3, v4, new Vector3D(Math.abs(minx) + Math.abs(maxx), Math.abs(miny) + Math.abs(maxy), Math.abs(minz) + Math.abs(maxz)));
    }
}

