/*
 * Decompiled with CFR 0.152.
 */
package com.Rendering;

import com.Rendering.Meshes.Polygon3V;
import com.Rendering.Meshes.Polygon4V;
import com.Rendering.MultyTexture;
import com.Rendering.RenderObject;
import com.Rendering.TMPElement;
import com.Rendering.Texture;

public class RenderObjectBuffer {
    private static final int[] sort = new int[]{1, 4, 10, 23, 57, 145, 356, 911, 1968, 4711, 11969, 27901, 84801};
    private TMPElement[] buffer = new TMPElement[0];
    private int size = 0;

    public void addRenderObjects(RenderObject[] objects, Texture tex, int x1, int y1, int x2, int y2) {
        int count = objects.length;
        for (int i = 0; i < count; ++i) {
            RenderObject obj = objects[i];
            if (!obj.isVisible(x1, y1, x2, y2)) continue;
            if (this.size >= this.buffer.length) {
                this.increaseBuffer();
            }
            TMPElement el = this.buffer[this.size];
            el.obj = obj;
            el.tex = tex;
            ++this.size;
        }
    }

    public void addRenderObjects(RenderObject[] objects, int x1, int y1, int x2, int y2) {
        int count = objects.length;
        for (int i = 0; i < count; ++i) {
            RenderObject obj = objects[i];
            if (!obj.isVisible(x1, y1, x2, y2)) continue;
            if (this.size >= this.buffer.length) {
                this.increaseBuffer();
            }
            TMPElement el = this.buffer[this.size];
            el.obj = obj;
            el.tex = null;
            ++this.size;
        }
    }

    public void addRenderObjects(RenderObject[] objects, MultyTexture tex, int x1, int y1, int x2, int y2) {
        int count = objects.length;
        for (int i = 0; i < count; ++i) {
            RenderObject obj = objects[i];
            if (!obj.isVisible(x1, y1, x2, y2)) continue;
            if (this.size >= this.buffer.length) {
                this.increaseBuffer();
            }
            TMPElement el = this.buffer[this.size];
            el.obj = obj;
            el.tex = tex.textures[0];
            if (obj instanceof Polygon4V) {
                el.tex = tex.textures[((Polygon4V)obj).tex];
            }
            if (obj instanceof Polygon3V) {
                el.tex = tex.textures[((Polygon3V)obj).tex];
            }
            ++this.size;
        }
    }

    public void addRenderObject(TMPElement obj, int x1, int y1, int x2, int y2) {
        RenderObject objz = obj.obj;
        if (objz.isVisible(x1, y1, x2, y2)) {
            if (this.size >= this.buffer.length) {
                this.increaseBuffer();
            }
            TMPElement el = this.buffer[this.size];
            el.obj = obj.obj;
            el.tex = obj.tex;
            ++this.size;
        }
    }

    public void addRenderObject(RenderObject obj, Texture tex, int x1, int y1, int x2, int y2) {
        if (obj.isVisible(x1, y1, x2, y2)) {
            if (this.size >= this.buffer.length) {
                this.increaseBuffer();
            }
            TMPElement el = this.buffer[this.size];
            el.obj = obj;
            el.tex = tex;
            ++this.size;
        }
    }

    public void addRenderObjectDT(RenderObject obj, Texture tex, int x1, int y1, int x2, int y2) {
        if (this.size >= this.buffer.length) {
            this.increaseBuffer();
        }
        TMPElement el = this.buffer[this.size];
        el.obj = obj;
        el.tex = tex;
        ++this.size;
    }

    public void addRenderObject(RenderObject obj, MultyTexture tex, int x1, int y1, int x2, int y2) {
        if (obj.isVisible(x1, y1, x2, y2)) {
            if (this.size >= this.buffer.length) {
                this.increaseBuffer();
            }
            TMPElement el = this.buffer[this.size];
            el.obj = obj;
            el.tex = tex.textures[0];
            if (obj instanceof Polygon4V) {
                el.tex = tex.textures[((Polygon4V)obj).tex];
            }
            if (obj instanceof Polygon3V) {
                el.tex = tex.textures[((Polygon3V)obj).tex];
            }
            ++this.size;
        }
    }

    public void addRenderObject(RenderObject obj, int x1, int y1, int x2, int y2) {
        if (obj.isVisible(x1, y1, x2, y2)) {
            if (this.size >= this.buffer.length) {
                this.increaseBuffer();
            }
            TMPElement el = this.buffer[this.size];
            el.obj = obj;
            el.tex = null;
            ++this.size;
        }
    }

    private void increaseBuffer() {
        int increase = 50;
        TMPElement[] newBuffer = new TMPElement[this.buffer.length + 50];
        System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
        for (int i = this.buffer.length; i < newBuffer.length; ++i) {
            newBuffer[i] = new TMPElement();
        }
        this.buffer = newBuffer;
    }

    public void sort() {
        int[] sort = RenderObjectBuffer.sort;
        int m = 0;
        while (sort[m] < this.size) {
            ++m;
        }
        while (--m >= 0) {
            int k;
            for (int i = k = sort[m]; i < this.size; ++i) {
                TMPElement e = this.buffer[i];
                int elSZ = e.obj.sz;
                for (int j = i; j >= k && this.buffer[j - k].obj.sz < elSZ; j -= k) {
                    this.buffer[j] = this.buffer[j - k];
                }
                this.buffer[j] = e;
            }
        }
    }

    public void reset() {
        this.size = 0;
    }

    public void resetTex() {
        for (int i = 0; i < this.buffer.length; ++i) {
            this.buffer[i].tex = null;
        }
    }

    public TMPElement[] getBuffer() {
        return this.buffer;
    }

    public int getSize() {
        return this.size;
    }
}

