/*
 * Decompiled with CFR 0.152.
 */
package com.Gameplay.Map;

import com.Collision.Height;
import com.Collision.HeightComputer;
import com.Collision.Ray;
import com.Collision.RayCast;
import com.Collision.SphereCast;
import com.Gameplay.Map.Portal;
import com.Gameplay.Map.RoomMesh;
import com.Gameplay.Map.RoomObject;
import com.Gameplay.Map.Scene;
import com.HUD.DeveloperMenu;
import com.Math.MathUtils;
import com.Math.MathUtils2;
import com.Math.Vector3D;
import com.Rendering.Graphics3D;
import com.Rendering.Meshes.LightedPolygon3V;
import com.Rendering.Meshes.LightedPolygon4V;
import com.Rendering.Meshes.Mesh;
import com.Rendering.Meshes.Polygon3V;
import com.Rendering.Meshes.Polygon4V;
import com.Rendering.MultyTexture;
import com.Rendering.RenderObject;
import com.Rendering.Vertex;
import com.misc.Main;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.util.Vector;

public class Room {
    private final int id;
    private final int rid;
    private RoomMesh[][] mesh;
    public Mesh fullMesh = null;
    private RoomMesh[][] renderMesh;
    private final int minx;
    private final int maxx;
    private final int minz;
    private final int maxz;
    private final int miny;
    private final int maxy;
    private boolean openSky;
    private Portal[] portals;
    private int x1;
    private int y1;
    private int x2;
    private int y2;
    public String[] stepSound = null;
    public String jumpSound = null;
    public static int chunkSize;
    public static int chunkSizeRender;
    private Vector objects = new Vector();

    public Room(Mesh meshs, int id) {
        this.rid = id;
        this.id = id;
        this.minx = meshs.minX();
        this.maxx = meshs.maxX();
        this.minz = meshs.minZ();
        this.maxz = meshs.maxZ();
        this.miny = meshs.minY();
        this.maxy = meshs.maxY();
        this.openSky = this.openSkyTest(meshs);
        this.fullMesh = meshs;
        if (Main.chunksSupport) {
            this.mesh = this.cut(meshs, chunkSize);
        }
        if (chunkSizeRender != 0) {
            this.renderMesh = this.cut(meshs, chunkSizeRender);
            if (this.renderMesh.length <= 2 || this.renderMesh[0].length <= 2) {
                this.renderMesh = null;
            }
        }
    }

    private RoomMesh[][] cut(Mesh mesh, int size) {
        int minxx = this.minx;
        int maxxx = this.maxx;
        int minzz = this.minz;
        int maxzz = this.maxz;
        Vertex[] vers = mesh.getVertices();
        maxxx -= minxx;
        maxzz -= minzz;
        minzz = 0;
        minxx = 0;
        int sizex = maxxx - minxx;
        int sizez = maxzz - minzz;
        int mapw = sizex / size + 1;
        int maph = sizez / size + 1;
        RoomMesh[][] map = new RoomMesh[mapw][maph];
        Vector bufPol = new Vector();
        Vector bufVer = new Vector();
        for (int z = 0; z < maph; ++z) {
            for (int x = 0; x < mapw; ++x) {
                bufPol.removeAllElements();
                bufVer.removeAllElements();
                Room.getPolygonsInSquare(x * size + this.minx, z * size + this.minz, size, mesh.getPolygons(), bufVer, bufPol);
                Object[] nVertexs = new Vertex[bufVer.size()];
                bufVer.copyInto(nVertexs);
                Object[] nPolygons = new RenderObject[bufPol.size()];
                bufPol.copyInto(nPolygons);
                map[x][z] = new RoomMesh((Vertex[])nVertexs, (RenderObject[])nPolygons, mesh.getTexture());
            }
        }
        return map;
    }

    private static void getPolygonsInSquare(int x1, int z1, int size, RenderObject[] polygons, Vector putVer, Vector putPol) {
        for (int i = 0; i < polygons.length; ++i) {
            RenderObject pol;
            RenderObject el = polygons[i];
            if (!Room.ifInSquare(el, x1, z1, size)) continue;
            putPol.addElement(el);
            if (el instanceof Polygon3V) {
                pol = (Polygon3V)el;
                if (!putVer.contains(pol.a)) {
                    putVer.addElement(pol.a);
                }
                if (!putVer.contains(pol.b)) {
                    putVer.addElement(pol.b);
                }
                if (!putVer.contains(pol.c)) {
                    putVer.addElement(pol.c);
                }
            }
            if (!(el instanceof Polygon4V)) continue;
            pol = (Polygon4V)el;
            if (!putVer.contains(((Polygon4V)pol).a)) {
                putVer.addElement(((Polygon4V)pol).a);
            }
            if (!putVer.contains(((Polygon4V)pol).b)) {
                putVer.addElement(((Polygon4V)pol).b);
            }
            if (!putVer.contains(((Polygon4V)pol).c)) {
                putVer.addElement(((Polygon4V)pol).c);
            }
            if (putVer.contains(((Polygon4V)pol).d)) continue;
            putVer.addElement(((Polygon4V)pol).d);
        }
    }

    private static boolean ifInSquare(RenderObject el, int x, int z, int size) {
        if (el instanceof Polygon3V) {
            Polygon3V pol = (Polygon3V)el;
            return Room.ifInSquare(x, z, size, pol.a.x, pol.a.z) || Room.ifInSquare(x, z, size, pol.b.x, pol.b.z) || Room.ifInSquare(x, z, size, pol.c.x, pol.c.z);
        }
        if (el instanceof Polygon4V) {
            Polygon4V pol = (Polygon4V)el;
            return Room.ifInSquare(x, z, size, pol.a.x, pol.a.z) || Room.ifInSquare(x, z, size, pol.b.x, pol.b.z) || Room.ifInSquare(x, z, size, pol.c.x, pol.c.z) || Room.ifInSquare(x, z, size, pol.d.x, pol.d.z);
        }
        return false;
    }

    private static boolean ifInSquare(int x, int z, int size, int poinx, int pointz) {
        return poinx >= x && poinx <= x + size && pointz >= z && pointz <= z + size;
    }

    private boolean openSkyTest(Mesh meshs) {
        int cx = (this.maxx + this.minx) / 2;
        int cz = (this.maxz + this.minz) / 2;
        int cy = (this.maxy * 2 + this.miny * 4) / 6;
        RenderObject[] pols = meshs.getPolygons();
        for (int i = 0; i < pols.length; ++i) {
            RenderObject pol;
            RenderObject obj = pols[i];
            if (!Room.isPointOnPolygon(cx, cz, obj) || obj.ny <= 2048) continue;
            int centerY = 0;
            if (obj instanceof Polygon3V) {
                pol = (Polygon3V)obj;
                centerY = (pol.a.y + pol.b.y + pol.c.y) / 3;
            } else if (obj instanceof Polygon4V) {
                pol = (Polygon4V)obj;
                centerY = (((Polygon4V)pol).a.y + ((Polygon4V)pol).b.y + ((Polygon4V)pol).c.y + ((Polygon4V)pol).d.y) / 4;
            }
            if (cy > centerY) continue;
            return false;
        }
        return true;
    }

    public final void destroy() {
        this.mesh = null;
        this.fullMesh = null;
        for (int var1 = 0; var1 < this.portals.length; ++var1) {
            this.portals[var1].destroy();
            this.portals[var1] = null;
        }
        this.portals = null;
    }

    public final void setPortals(Portal[] portals) {
        this.portals = portals;
    }

    public final void addPortal(Portal portal) {
        Portal[] ports = new Portal[this.portals.length + 1];
        for (int i = 0; i < this.portals.length; ++i) {
            ports[i] = this.portals[i];
        }
        ports[i + 1] = portal;
        this.portals = null;
        this.portals = ports;
        System.gc();
    }

    public final Portal[] getPortals() {
        return this.portals;
    }

    public final Mesh getMesh() {
        return this.fullMesh;
    }

    public final int getId() {
        return this.id;
    }

    public final boolean isOpenSky() {
        return this.openSky;
    }

    public final void setViewport(int x1, int y1, int x2, int y2) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    public final void render(Graphics3D g3d, int x, int z) {
        if (this.renderMesh != null) {
            int xx = (x - this.minx) / chunkSizeRender - 1;
            int zstart = (z - this.minz) / chunkSizeRender - 1;
            int xend = (x - this.minx) / chunkSizeRender + 1;
            int zend = (z - this.minz) / chunkSizeRender + 1;
            if (xx > this.renderMesh.length - 1) {
                return;
            }
            if (zstart > this.renderMesh[0].length - 1) {
                return;
            }
            if (xend < 0) {
                return;
            }
            if (zend < 0) {
                return;
            }
            xend = Math.min(Math.max(xend, 0), this.renderMesh.length - 1);
            zstart = Math.min(Math.max(zstart, 0), this.renderMesh[0].length - 1);
            zend = Math.min(Math.max(zend, 0), this.renderMesh[0].length - 1);
            for (xx = Math.min(Math.max(xx, 0), this.renderMesh.length - 1); xx <= xend; ++xx) {
                for (int zz = zstart; zz <= zend; ++zz) {
                    if (!this.renderMesh[xx][zz].isVisible(g3d, this.x1, this.y1, this.x2, this.y2)) continue;
                    g3d.transformAndProjectVertices(this.renderMesh[xx][zz].mesh, g3d.getInvCamera());
                    g3d.addMesh(this.renderMesh[xx][zz].mesh, this.x1, this.y1, this.x2, this.y2);
                    this.renderMesh[xx][zz].mesh.applySz();
                }
            }
        } else {
            g3d.transformAndProjectVertices(this.fullMesh, g3d.getInvCamera());
            g3d.addMesh(this.fullMesh, this.x1, this.y1, this.x2, this.y2);
            this.fullMesh.applySz();
        }
    }

    public final void render(Graphics3D g3d) {
        for (int var3 = 0; var3 < this.objects.size(); ++var3) {
            RoomObject var4 = (RoomObject)this.objects.elementAt(var3);
            var4.render(g3d, this.x1, this.y1, this.x2, this.y2);
        }
    }

    public final void render(Graphics3D g3d, int x1, int y1, int x2, int y2) {
        for (int var3 = 0; var3 < this.objects.size(); ++var3) {
            RoomObject var4 = (RoomObject)this.objects.elementAt(var3);
            var4.render(g3d, x1, y1, x2, y2);
        }
    }

    public final void rayCast(Ray ray) {
        Vector3D var2 = ray.getStart();
        Vector3D var3 = ray.getDir();
        RayCast.rayCast(this.fullMesh, ray, this.rid);
    }

    public final void rayCastNonCheck(Ray ray) {
        RayCast.rayCast(this.fullMesh, ray, this.rid);
    }

    public final boolean sphereCast(Vector3D pos, int rad) {
        boolean collision = false;
        if (this.mesh != null) {
            int xx = 0;
            int zz = 0;
            int zstart = 0;
            int xend = this.mesh.length - 1;
            int zend = this.mesh[0].length - 1;
            xx = (pos.x - this.minx) / chunkSize - 1;
            zstart = (pos.z - this.minz) / chunkSize - 1;
            xend = (pos.x - this.minx) / chunkSize + 1;
            zend = (pos.z - this.minz) / chunkSize + 1;
            if (xx > this.mesh.length - 1) {
                return false;
            }
            if (zstart > this.mesh[0].length - 1) {
                return false;
            }
            if (xend < 0) {
                return false;
            }
            if (zend < 0) {
                return false;
            }
            xend = Math.min(Math.max(xend, 0), this.mesh.length - 1);
            zstart = Math.min(Math.max(zstart, 0), this.mesh[0].length - 1);
            zend = Math.min(Math.max(zend, 0), this.mesh[0].length - 1);
            for (xx = Math.min(Math.max(xx, 0), this.mesh.length - 1); xx <= xend; ++xx) {
                for (zz = zstart; zz <= zend; ++zz) {
                    collision |= pos.x + rad >= this.mesh[xx][zz].minx && pos.z + rad >= this.mesh[xx][zz].minz && pos.x - rad <= this.mesh[xx][zz].maxx && pos.z - rad <= this.mesh[xx][zz].maxz ? SphereCast.sphereCast(this.mesh[xx][zz].mesh, pos, rad) : false;
                }
            }
        } else {
            collision |= pos.x + rad >= this.minx && pos.z + rad >= this.minz && pos.x - rad <= this.maxx && pos.z - rad <= this.maxz ? SphereCast.sphereCast(this.fullMesh, pos, rad) : false;
        }
        return collision;
    }

    public final boolean a_int_sub(int x, int y, int z) {
        return x >= this.minx && z >= this.minz && y >= this.miny && (this.openSky || y <= this.maxy) && x <= this.maxx && z <= this.maxz;
    }

    public final int isPointOnMesh(int x, int y, int z) {
        if (x >= this.minx && z >= this.minz && x <= this.maxx && z <= this.maxz && y >= this.miny && (this.openSky || y <= this.maxy)) {
            RenderObject[] objs = this.fullMesh.getPoligons();
            for (int i = 0; i < objs.length; ++i) {
                if (!Room.isPointOnPolygon2(x, z, objs[i])) continue;
                return i;
            }
            return -1;
        }
        return -1;
    }

    public final int a_int_sub2(int x, int y, int z) {
        int func = Integer.MAX_VALUE;
        if (this.mesh != null) {
            int xx = (x - this.minx) / chunkSize;
            int zz = (z - this.minz) / chunkSize;
            if (xx > this.mesh.length - 1) {
                return func;
            }
            if (zz > this.mesh[0].length - 1) {
                return func;
            }
            if (xx < 0) {
                return func;
            }
            if (zz < 0) {
                return func;
            }
            if (x >= this.mesh[xx][zz].minx && z >= this.mesh[xx][zz].minz && y >= this.mesh[xx][zz].miny && (this.openSky || y <= this.mesh[xx][zz].maxy) && x <= this.mesh[xx][zz].maxx && z <= this.mesh[xx][zz].maxz) {
                func = Scene.isPointOnMesh(this.mesh[xx][zz].mesh, x, y, z);
            }
        } else if (x >= this.minx && z >= this.minz && y >= this.miny && (this.openSky || y <= this.maxy) && x <= this.maxx && z <= this.maxz) {
            func = Scene.isPointOnMesh(this.fullMesh, x, y, z);
        }
        return func;
    }

    public void computeHeight(Height height) {
        Vector3D pos = height.getPosition();
        if (this.mesh != null) {
            int xx = 0;
            int zz = 0;
            int zstart = 0;
            int xend = this.mesh.length - 1;
            int zend = this.mesh[0].length - 1;
            xx = (pos.x - this.minx) / chunkSize - 1;
            zstart = (pos.z - this.minz) / chunkSize - 1;
            xend = (pos.x - this.minx) / chunkSize + 1;
            zend = (pos.z - this.minz) / chunkSize + 1;
            if (xx > this.mesh.length - 1) {
                return;
            }
            if (zstart > this.mesh[0].length - 1) {
                return;
            }
            if (xend < 0) {
                return;
            }
            if (zend < 0) {
                return;
            }
            xend = Math.min(Math.max(xend, 0), this.mesh.length - 1);
            zstart = Math.min(Math.max(zstart, 0), this.mesh[0].length - 1);
            zend = Math.min(Math.max(zend, 0), this.mesh[0].length - 1);
            for (xx = Math.min(Math.max(xx, 0), this.mesh.length - 1); xx <= xend; ++xx) {
                for (zz = zstart; zz <= zend; ++zz) {
                    if (!HeightComputer.isPointAABBCollision(pos.x, pos.z, this.mesh[xx][zz].minx - 500, this.mesh[xx][zz].maxx + 500, this.mesh[xx][zz].minz - 500, this.mesh[xx][zz].maxz + 500)) continue;
                    HeightComputer.computeHeight(this.mesh[xx][zz].mesh, height);
                }
            }
        } else if (HeightComputer.isPointAABBCollision(pos.x, pos.z, this.minx - 500, this.maxx + 500, this.minz - 500, this.maxz + 500)) {
            HeightComputer.computeHeight(this.fullMesh, height);
        }
    }

    private static boolean isPointOnPolygon(int x, int z, RenderObject obj) {
        if (obj instanceof Polygon3V) {
            Polygon3V p = (Polygon3V)obj;
            Vertex v1 = p.c;
            Vertex v2 = p.b;
            Vertex v3 = p.a;
            return MathUtils2.isPointOnPolygon(x, z, v1.x, v1.z, v2.x, v2.z, v3.x, v3.z, p.ny);
        }
        if (obj instanceof Polygon4V) {
            Polygon4V p = (Polygon4V)obj;
            Vertex v1 = p.a;
            Vertex v2 = p.b;
            Vertex v3 = p.c;
            Vertex v4 = p.d;
            return MathUtils2.isPointOnPolygon(x, z, v1.x, v1.z, v2.x, v2.z, v3.x, v3.z, v4.x, v4.z, p.ny);
        }
        return false;
    }

    private static boolean isPointOnPolygon2(int x, int z, RenderObject obj) {
        if (obj instanceof Polygon3V) {
            Polygon3V pol = (Polygon3V)obj;
            short norm = pol.ny;
            Vertex a = pol.a;
            Vertex b = pol.b;
            Vertex c = pol.c;
            if (norm > 0) {
                return MathUtils.isPointOnPolygon(x, z, a.x, a.z, b.x, b.z, c.x, c.z);
            }
            if (norm < 0) {
                return MathUtils.isPointOnPolygon(x, z, c.x, c.z, b.x, b.z, a.x, a.z);
            }
            return false;
        }
        if (obj instanceof Polygon4V) {
            Polygon4V pol = (Polygon4V)obj;
            short norm = pol.ny;
            Vertex a = pol.a;
            Vertex b = pol.b;
            Vertex c = pol.c;
            Vertex d = pol.d;
            if (norm > 0) {
                return MathUtils.isPointOnPolygon(x, z, a.x, a.z, b.x, b.z, c.x, c.z, d.x, d.z);
            }
            if (norm < 0) {
                return MathUtils.isPointOnPolygon(x, z, d.x, d.z, c.x, c.z, b.x, b.z, a.x, a.z);
            }
            return false;
        }
        return false;
    }

    public final int getMinX() {
        return this.minx;
    }

    public final int getMaxZ() {
        return this.maxz;
    }

    public final int getMinZ() {
        return this.minz;
    }

    public final int getMaxX() {
        return this.maxx;
    }

    public final int getMinY() {
        return this.miny;
    }

    public final int getMaxY() {
        return this.maxy;
    }

    public boolean isOnRoom(int x, int y) {
        return x <= this.x2 + 10 && x >= this.x1 - 10 && y <= this.y2 + 10 && y >= this.y1 - 10;
    }

    public void addObject(RoomObject obj) {
        if (!this.objects.contains(obj)) {
            this.objects.addElement(obj);
        } else if (DeveloperMenu.debugMode) {
            System.out.println("Room: \u0442\u0430\u043a\u043e\u0439 \u043e\u0431\u044c\u0435\u043a\u0442 \u0443\u0436\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442\u0441\u044f");
        }
    }

    public void removeObject(RoomObject obj) {
        boolean remove = this.objects.removeElement(obj);
        if (!remove && DeveloperMenu.debugMode) {
            System.out.println("Room: \u0442\u0430\u043a\u043e\u0433\u043e \u043e\u0431\u044c\u0435\u043a\u0442\u0430 \u043d\u0435 \u0431\u044b\u043b\u043e");
        }
    }

    public Vector getObjects() {
        return this.objects;
    }

    public void getObjects(Vector buf) {
        for (int i = 0; i < this.objects.size(); ++i) {
            RoomObject obj = (RoomObject)this.objects.elementAt(i);
            if (buf.contains(obj)) continue;
            buf.addElement(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Mesh loadMesh(String file, float scaleX, float scaleY, float scaleZ, MultyTexture texs) {
        Mesh var12 = null;
        InputStream var13 = null;
        FilterInputStream var14 = null;
        try {
            var13 = new Object().getClass().getResourceAsStream(file);
            var14 = new DataInputStream(var13);
            var12 = Room.createFrom3d(file, (DataInputStream)var14, 1.0f, 1.0f, 1.0f, texs);
        }
        catch (Exception var10) {
            System.err.println("ERROR in Loader.Load: " + var10);
        }
        finally {
            try {
                var14.close();
                var13.close();
            }
            catch (Exception exception) {}
        }
        return var12;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Mesh[] loadMeshes(String file, float scaleX, float scaleY, float scaleZ, MultyTexture texs) {
        Mesh[] var4 = null;
        InputStream var5 = null;
        FilterInputStream var6 = null;
        try {
            var5 = new Object().getClass().getResourceAsStream(file);
            var6 = new DataInputStream(var5);
            var4 = new Mesh[((DataInputStream)var6).readInt()];
            for (int var7 = 0; var7 < var4.length; ++var7) {
                var4[var7] = Room.createFrom3d(file, (DataInputStream)var6, scaleX, scaleY, scaleZ, texs);
            }
        }
        catch (Exception var14) {
            System.err.println("ERROR in Loader.Load: " + var14);
        }
        finally {
            try {
                var6.close();
                var5.close();
            }
            catch (Exception exception) {}
        }
        return var4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Mesh[] loadMeshes(String file, float scaleX, float scaleY, float scaleZ) {
        Mesh[] var4 = null;
        InputStream var5 = null;
        FilterInputStream var6 = null;
        try {
            var5 = new Object().getClass().getResourceAsStream(file);
            var6 = new DataInputStream(var5);
            var4 = new Mesh[((DataInputStream)var6).readInt()];
            for (int var7 = 0; var7 < var4.length; ++var7) {
                var4[var7] = Room.createFrom3d(file, (DataInputStream)var6, scaleX, scaleY, scaleZ, null);
            }
        }
        catch (Exception var14) {
            System.err.println("ERROR in Loader.Load: " + var14);
        }
        finally {
            try {
                var6.close();
                var5.close();
            }
            catch (Exception exception) {}
        }
        return var4;
    }

    private static Mesh createFrom3d(String file, DataInputStream is, float scaleX, float scaleY, float scaleZ, MultyTexture mt) throws Exception {
        int var20;
        byte var13;
        byte var12;
        byte var11;
        byte var10;
        short var18;
        short var31;
        int var9;
        int var8;
        int var7;
        Vertex[] var5 = new Vertex[is.readShort()];
        short thisMaterial = 0;
        for (int var6 = 0; var6 < var5.length; ++var6) {
            var7 = (int)((float)is.readShort() * scaleX);
            var8 = (int)((float)is.readShort() * scaleY);
            var9 = (int)((float)is.readShort() * scaleZ);
            var5[var6] = new Vertex(var7, var8, var9);
        }
        Polygon3V[] var27 = new Polygon3V[is.readShort()];
        for (var7 = 0; var7 < var27.length; ++var7) {
            short var29 = is.readShort();
            if (var29 == Short.MIN_VALUE) {
                thisMaterial = is.readShort();
                var29 = is.readShort();
            }
            var31 = is.readShort();
            var18 = is.readShort();
            byte var21 = is.readByte();
            byte var24 = is.readByte();
            var10 = is.readByte();
            var11 = is.readByte();
            var12 = is.readByte();
            var13 = is.readByte();
            Vertex var14 = var5[var29];
            Vertex var15 = var5[var31];
            Vertex var16 = var5[var18];
            var27[var7] = Graphics3D.fog != 9 || Main.fogQ < 2 ? new Polygon3V(var16, var15, var14, var12, var13, var10, var11, var21, var24) : new LightedPolygon3V(var16, var15, var14, var12, var13, var10, var11, var21, var24);
            var27[var7].tex = (byte)thisMaterial;
        }
        Polygon4V[] var28 = new Polygon4V[is.readShort()];
        thisMaterial = 0;
        for (var8 = 0; var8 < var28.length; ++var8) {
            var31 = is.readShort();
            if (var31 == Short.MIN_VALUE) {
                thisMaterial = is.readShort();
                var31 = is.readShort();
            }
            var18 = is.readShort();
            short var22 = is.readShort();
            short var25 = is.readShort();
            var10 = is.readByte();
            var11 = is.readByte();
            var12 = is.readByte();
            var13 = is.readByte();
            byte var34 = is.readByte();
            byte var33 = is.readByte();
            byte var35 = is.readByte();
            byte var17 = is.readByte();
            Vertex var32 = var5[var31];
            Vertex var19 = var5[var18];
            Vertex var23 = var5[var22];
            Vertex var26 = var5[var25];
            var28[var8] = Graphics3D.fog != 9 || Main.fogQ < 2 ? new Polygon4V(var26, var23, var19, var32, var35, var17, var34, var33, var12, var13, var10, var11) : new LightedPolygon4V(var26, var23, var19, var32, var35, var17, var34, var33, var12, var13, var10, var11);
            var28[var8].tex = (byte)thisMaterial;
        }
        RenderObject[] var30 = new RenderObject[var27.length + var28.length];
        var9 = 0;
        for (var20 = 0; var20 < var27.length; ++var20) {
            var30[var9] = var27[var20];
            ++var9;
        }
        for (var20 = 0; var20 < var28.length; ++var20) {
            var30[var9] = var28[var20];
            ++var9;
        }
        System.out.println("Mesh [" + file + "] \u0432\u0435\u0440\u0448\u0438\u043d: " + var5.length + " \u043f\u043e\u043b\u0438\u0433\u043e\u043d\u043e\u0432: " + var30.length);
        return new Mesh(var5, var30, mt);
    }

    private static Mesh createFrom3dOld(String file, DataInputStream is, float scaleX, float scaleY, float scaleZ) throws Exception {
        int var20;
        byte var13;
        byte var12;
        byte var11;
        byte var10;
        short var18;
        short var31;
        int var9;
        int var8;
        int var7;
        Vertex[] var5 = new Vertex[is.readShort()];
        short thisMaterial = 0;
        for (int var6 = 0; var6 < var5.length; ++var6) {
            var7 = (int)((float)is.readShort() * scaleX);
            var8 = (int)((float)is.readShort() * scaleY);
            var9 = (int)((float)is.readShort() * scaleZ);
            var5[var6] = new Vertex(var7, var8, var9);
        }
        Polygon3V[] var27 = new Polygon3V[is.readShort()];
        for (var7 = 0; var7 < var27.length; ++var7) {
            short var29 = is.readShort();
            if (var29 == Short.MIN_VALUE) {
                thisMaterial = is.readShort();
                var29 = is.readShort();
            }
            var31 = is.readShort();
            var18 = is.readShort();
            byte var21 = is.readByte();
            byte var24 = is.readByte();
            var10 = is.readByte();
            var11 = is.readByte();
            var12 = is.readByte();
            var13 = is.readByte();
            Vertex var14 = var5[var29];
            Vertex var15 = var5[var31];
            Vertex var16 = var5[var18];
            var27[var7] = Graphics3D.fog != 9 || Main.fogQ < 2 ? new Polygon3V(var16, var15, var14, var12, var13, var10, var11, var21, var24) : new LightedPolygon3V(var16, var15, var14, var12, var13, var10, var11, var21, var24);
        }
        Polygon4V[] var28 = new Polygon4V[is.readShort()];
        thisMaterial = 0;
        for (var8 = 0; var8 < var28.length; ++var8) {
            var31 = is.readShort();
            if (var31 == Short.MIN_VALUE) {
                thisMaterial = is.readShort();
                var31 = is.readShort();
            }
            var18 = is.readShort();
            short var22 = is.readShort();
            short var25 = is.readShort();
            var10 = is.readByte();
            var11 = is.readByte();
            var12 = is.readByte();
            var13 = is.readByte();
            byte var34 = is.readByte();
            byte var33 = is.readByte();
            byte var35 = is.readByte();
            byte var17 = is.readByte();
            Vertex var32 = var5[var31];
            Vertex var19 = var5[var18];
            Vertex var23 = var5[var22];
            Vertex var26 = var5[var25];
            var28[var8] = Graphics3D.fog != 9 || Main.fogQ < 2 ? new Polygon4V(var26, var23, var19, var32, var35, var17, var34, var33, var12, var13, var10, var11) : new LightedPolygon4V(var26, var23, var19, var32, var35, var17, var34, var33, var12, var13, var10, var11);
        }
        RenderObject[] var30 = new RenderObject[var27.length + var28.length];
        var9 = 0;
        for (var20 = 0; var20 < var27.length; ++var20) {
            var30[var9] = var27[var20];
            ++var9;
        }
        for (var20 = 0; var20 < var28.length; ++var20) {
            var30[var9] = var28[var20];
            ++var9;
        }
        System.out.println("Mesh [" + file + "] \u0432\u0435\u0440\u0448\u0438\u043d: " + var5.length + " \u043f\u043e\u043b\u0438\u0433\u043e\u043d\u043e\u0432: " + var30.length);
        return new Mesh(var5, var30);
    }

    static {
        chunkSizeRender = 0;
    }
}

