/*
 * Decompiled with CFR 0.152.
 */
package com.Rendering;

import com.Rendering.Graphics3D;
import com.Rendering.RawImage;
import com.misc.ImageResize;
import com.misc.Main;
import javax.microedition.lcdui.Image;

public class Texture {
    public boolean perspectiveCorrection;
    public int widthBIT;
    public int widthBITmode10;
    public int interp;
    public RawImage rImg;
    public Texture mip = null;
    public byte drawmode = Graphics3D.fog;
    public int addsz = 0;
    public boolean alphaMixing = false;
    public byte scale = (byte)2;
    public int W_UNIT;

    Texture() {
    }

    private Texture(Image img, int interpz) {
        this.perspectiveCorrection = false;
        int w = img.getWidth();
        int h = img.getHeight();
        int[] pixels = new int[w * h];
        this.interp = interpz;
        img.getRGB(pixels, 0, w, 0, 0, w, h);
        this.prepareAlpha(pixels);
        if (Main.pixelsQ == 0) {
            pixels = ImageResize.cubic2XDesize(pixels, w, h);
            w /= 2;
            h /= 2;
            this.scale = 0;
        }
        if (Main.pixelsQ == 1) {
            pixels = ImageResize.cubic2XVertDesize(pixels, w, h);
            h /= 2;
            this.scale = 1;
        }
        this.widthBIT = Texture.widthToBIT(w);
        this.widthBITmode10 = Texture.widthToBIT(w * w);
        this.W_UNIT = Texture.wUnitGen(Math.max(w, h));
        this.rImg = new RawImage(pixels, w, h);
        this.drawmode = Graphics3D.fog;
    }

    public Texture(RawImage ri, boolean perspectiveCorrection) {
        this.perspectiveCorrection = perspectiveCorrection;
        this.widthBIT = Texture.widthToBIT(ri.w);
        this.widthBITmode10 = Texture.widthToBIT(ri.w * ri.w);
        this.W_UNIT = Texture.wUnitGen(Math.max(ri.w, ri.h));
        this.prepareAlpha(ri.img);
        this.rImg = ri;
        this.drawmode = Graphics3D.fog;
    }

    public void destroy() {
        this.rImg = null;
        this.mip = null;
    }

    private static int widthToBIT(int w) {
        for (int var1 = 0; var1 < 32; ++var1) {
            if (w >> var1 != 1 || 1 << var1 != w) continue;
            return var1;
        }
        return 0;
    }

    private static int wUnitGen(int w) {
        if (w <= 256) {
            return 0x40000000;
        }
        if (w <= 512) {
            return 0x20000000;
        }
        if (w <= 1024) {
            return 0x10000000;
        }
        if (w <= 2048) {
            return 0x8000000;
        }
        if (w <= 4096) {
            return 0x4000000;
        }
        if (w <= 8192) {
            return 0x2000000;
        }
        return 0x1000000;
    }

    public int[] getPixels() {
        return this.rImg.img;
    }

    public int getInterp() {
        return this.interp;
    }

    public byte getDrawMode() {
        return this.drawmode;
    }

    public void setDrawMode(byte dr) {
        this.drawmode = dr;
        if (this.mip != null) {
            this.mip.setDrawMode(dr);
        }
    }

    public void setInterp(int i) {
        this.interp = i;
    }

    public void setPerspectiveCorrection(boolean perspectiveCorrection) {
        this.perspectiveCorrection = perspectiveCorrection;
        if (this.mip != null) {
            this.mip.setPerspectiveCorrection(perspectiveCorrection);
        }
    }

    public static Texture createTexture(String file) {
        try {
            int type = -1;
            String format = file;
            format = format.substring(format.indexOf(46) - 3, format.indexOf(46)).trim();
            if (format.compareTo("pix") == 0) {
                type = 0;
            }
            if (format.compareTo("int") == 0) {
                type = 1;
            }
            return new Texture(Image.createImage((String)file), type);
        }
        catch (Exception var2) {
            System.err.println("ERROR in createTexture " + file + ": " + var2);
            return null;
        }
    }

    private final void prepareAlpha(int[] pix) {
        for (int i = 0; i < pix.length; ++i) {
            int col = pix[i];
            int alpha = pix[i] >> 24 & 0xFF;
            if (alpha > 1 && alpha < 255) {
                this.alphaMixing = true;
            }
            if (alpha > 1) continue;
            pix[i] = 0;
        }
    }
}

