/*
 * Decompiled with CFR 0.152.
 */
package com.Rendering;

import com.Rendering.Graphics3D;
import com.Rendering.Texture;
import com.Rendering.TexturingPers;
import com.Rendering.Vertex;
import com.misc.Main;

public class TexturingFloorsWalls {
    public static final int fp = 12;
    public static final int FP = 4096;

    static final void paintWall(Graphics3D g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dy_start, int dwz_start, int duz_start, int dvz_start, int dy_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, int sz2) {
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int duz4 = duz * sz2;
        int dvz4 = dvz * sz2;
        int dwz4 = dwz * sz2;
        int width6 = g3d.width * 6;
        for (int x = x_start; x < x_end; ++x) {
            int wz_b;
            int wz_a;
            int vz_b;
            int vz_a;
            int uz_b;
            int uz_a;
            int y2;
            int y1;
            if (y_start > y_end) {
                y1 = y_end;
                y2 = y_start;
                uz_a = uz_end;
                uz_b = uz_start;
                vz_a = vz_end;
                vz_b = vz_start;
                wz_a = wz_end;
                wz_b = wz_start;
            } else {
                y1 = y_start;
                y2 = y_end;
                uz_a = uz_start;
                uz_b = uz_end;
                vz_a = vz_start;
                vz_b = vz_end;
                wz_a = wz_start;
                wz_b = wz_end;
            }
            long subtexel_a = y1 % 4096;
            long subtexel_b = y2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            y2 >>= 12;
            if ((y1 >>= 12) < 0) {
                uz_a -= duz * y1;
                vz_a -= dvz * y1;
                wz_a -= dwz * y1;
                y1 = 0;
            }
            if (y2 > g3d.height) {
                uz_b -= duz * (y2 -= g3d.height);
                vz_b -= dvz * y2;
                wz_b -= dwz * y2;
                y2 = g3d.height;
            }
            if (wz_a == 0 || wz_b == 0) {
                return;
            }
            int length = y2 - y1;
            y1 = y1 * g3d.width + x;
            y2 = y2 * g3d.width + x;
            if (length != 0) {
                int col;
                int u = (int)(((long)uz_a << 12) / (long)wz_a);
                int v = (int)(((long)vz_a << 12) / (long)wz_a);
                int u_2 = (int)(((long)uz_b << 12) / (long)wz_b);
                int v_2 = (int)(((long)vz_b << 12) / (long)wz_b);
                int du = (u_2 - u) / length;
                int dv = (v_2 - v) / length;
                while (y2 - y1 >= width6) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[y1] = col;
                    }
                    y1 += g3d.width;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[y1] = col;
                    }
                    y1 += g3d.width;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[y1] = col;
                    }
                    y1 += g3d.width;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[y1] = col;
                    }
                    y1 += g3d.width;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[y1] = col;
                    }
                    y1 += g3d.width;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[y1] = col;
                    }
                    y1 += g3d.width;
                }
                while (y1 < y2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[y1] = col;
                    }
                    y1 += g3d.width;
                }
            }
            y_start += dy_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            y_end += dy_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
        }
    }

    static final void paintFloor(Graphics3D g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, int fogc, int sz2) {
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int duz4 = duz * sz2;
        int dvz4 = dvz * sz2;
        int dwz4 = dwz * sz2;
        int dv = 0;
        int du = 0;
        for (int y = y_start; y < y_end; ++y) {
            int wz_b;
            int wz_a;
            int vz_b;
            int vz_a;
            int uz_b;
            int uz_a;
            int x2;
            int x1;
            if (x_start > x_end) {
                x1 = x_end;
                x2 = x_start;
                uz_a = uz_end;
                uz_b = uz_start;
                vz_a = vz_end;
                vz_b = vz_start;
                wz_a = wz_end;
                wz_b = wz_start;
            } else {
                x1 = x_start;
                x2 = x_end;
                uz_a = uz_start;
                uz_b = uz_end;
                vz_a = vz_start;
                vz_b = vz_end;
                wz_a = wz_start;
                wz_b = wz_end;
            }
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            if (wz_a == 0 || wz_b == 0) {
                return;
            }
            int tempI = y * g3d.width;
            int length = (x2 += tempI) - (x1 += tempI);
            if (length != 0) {
                int col;
                int u = (int)(((long)uz_a << 12) / (long)wz_a);
                int v = (int)(((long)vz_a << 12) / (long)wz_a);
                int u_2 = (int)(((long)uz_b << 12) / (long)wz_b);
                int v_2 = (int)(((long)vz_b << 12) / (long)wz_b);
                du = (u_2 - u) / length;
                dv = (v_2 - v) / length;
                while (x2 - x1 >= 7) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = col;
                    }
                    if ((col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT]) != 0) {
                        rgb[x1 + 1] = col;
                    }
                    if ((col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT]) != 0) {
                        rgb[x1 + 2] = col;
                    }
                    if ((col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT]) != 0) {
                        rgb[x1 + 3] = col;
                    }
                    if ((col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT]) != 0) {
                        rgb[x1 + 4] = col;
                    }
                    if ((col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT]) != 0) {
                        rgb[x1 + 5] = col;
                    }
                    if ((col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT]) != 0) {
                        rgb[x1 + 6] = col;
                    }
                    x1 += 7;
                }
                while (x1 < x2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = col;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
        }
    }

    static final void paintWall_1(Graphics3D g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dy_start, int dwz_start, int duz_start, int dvz_start, int dy_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, int sz2) {
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int width2 = g3d.width * 2;
        int width4 = g3d.width * 4;
        int colf = sz2 & 0xFEFEFE;
        for (int x = x_start; x < x_end; ++x) {
            int wz_b;
            int wz_a;
            int vz_b;
            int vz_a;
            int uz_b;
            int uz_a;
            int y2;
            int y1;
            if (y_start > y_end) {
                y1 = y_end;
                y2 = y_start;
                uz_a = uz_end;
                uz_b = uz_start;
                vz_a = vz_end;
                vz_b = vz_start;
                wz_a = wz_end;
                wz_b = wz_start;
            } else {
                y1 = y_start;
                y2 = y_end;
                uz_a = uz_start;
                uz_b = uz_end;
                vz_a = vz_start;
                vz_b = vz_end;
                wz_a = wz_start;
                wz_b = wz_end;
            }
            long subtexel_a = y1 % 4096;
            long subtexel_b = y2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            y2 >>= 12;
            if ((y1 >>= 12) < 0) {
                uz_a -= duz * y1;
                vz_a -= dvz * y1;
                wz_a -= dwz * y1;
                y1 = 0;
            }
            if (y2 > g3d.height) {
                uz_b -= duz * (y2 -= g3d.height);
                vz_b -= dvz * y2;
                wz_b -= dwz * y2;
                y2 = g3d.height;
            }
            if (wz_a == 0 || wz_b == 0) {
                return;
            }
            int length = y2 - y1;
            y1 = y1 * g3d.width + x;
            y2 = y2 * g3d.width + x;
            if (length != 0) {
                int col;
                int u = (int)(((long)uz_a << 12) / (long)wz_a);
                int v = (int)(((long)vz_a << 12) / (long)wz_a);
                int u_2 = (int)(((long)uz_b << 12) / (long)wz_b);
                int v_2 = (int)(((long)vz_b << 12) / (long)wz_b);
                int du = (u_2 - u) / length;
                int dv = (v_2 - v) / length;
                while (y2 - y1 >= width4) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        col = (col & 0xFEFEFE) + colf;
                        rgb[y1] = col | (col >> 8 & 0x10101) * 255;
                    }
                    y1 += g3d.width;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        col = (col & 0xFEFEFE) + colf;
                        rgb[y1] = col | (col >> 8 & 0x10101) * 255;
                    }
                    y1 += g3d.width;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        col = (col & 0xFEFEFE) + colf;
                        rgb[y1] = col | (col >> 8 & 0x10101) * 255;
                    }
                    y1 += g3d.width;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        col = (col & 0xFEFEFE) + colf;
                        rgb[y1] = col | (col >> 8 & 0x10101) * 255;
                    }
                    y1 += g3d.width;
                }
                while (y1 < y2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        col = (col & 0xFEFEFE) + colf;
                        rgb[y1] = col | (col >> 8 & 0x10101) * 255;
                    }
                    y1 += g3d.width;
                }
            }
            y_start += dy_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            y_end += dy_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
        }
    }

    static final void paintFloor_1(Graphics3D g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, int sz2) {
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int colf = sz2 & 0xFEFEFE;
        for (int y = y_start; y < y_end; ++y) {
            int wz_b;
            int wz_a;
            int vz_b;
            int vz_a;
            int uz_b;
            int uz_a;
            int x2;
            int x1;
            if (x_start > x_end) {
                x1 = x_end;
                x2 = x_start;
                uz_a = uz_end;
                uz_b = uz_start;
                vz_a = vz_end;
                vz_b = vz_start;
                wz_a = wz_end;
                wz_b = wz_start;
            } else {
                x1 = x_start;
                x2 = x_end;
                uz_a = uz_start;
                uz_b = uz_end;
                vz_a = vz_start;
                vz_b = vz_end;
                wz_a = wz_start;
                wz_b = wz_end;
            }
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            if (wz_a == 0 || wz_b == 0) {
                return;
            }
            int tempI = y * g3d.width;
            int length = (x2 += tempI) - (x1 += tempI);
            if (length != 0) {
                int col;
                int u = (int)(((long)uz_a << 12) / (long)wz_a);
                int v = (int)(((long)vz_a << 12) / (long)wz_a);
                int u_2 = (int)(((long)uz_b << 12) / (long)wz_b);
                int v_2 = (int)(((long)vz_b << 12) / (long)wz_b);
                int du = (u_2 - u) / length;
                int dv = (v_2 - v) / length;
                while (x2 - x1 >= 4) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        col = (col & 0xFEFEFE) + colf;
                        rgb[x1] = col | (col >> 8 & 0x10101) * 255;
                    }
                    if ((col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT]) != 0) {
                        col = (col & 0xFEFEFE) + colf;
                        rgb[x1 + 1] = col | (col >> 8 & 0x10101) * 255;
                    }
                    if ((col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT]) != 0) {
                        col = (col & 0xFEFEFE) + colf;
                        rgb[x1 + 2] = col | (col >> 8 & 0x10101) * 255;
                    }
                    if ((col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT]) != 0) {
                        col = (col & 0xFEFEFE) + colf;
                        rgb[x1 + 3] = col | (col >> 8 & 0x10101) * 255;
                    }
                    x1 += 4;
                }
                while (x1 < x2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        col = (col & 0xFEFEFE) + colf;
                        rgb[x1] = col | (col >> 8 & 0x10101) * 255;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
        }
    }

    static final void paintWall_2(Graphics3D g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dy_start, int dwz_start, int duz_start, int dvz_start, int dy_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz) {
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int width2 = g3d.width * 2;
        int width4 = g3d.width * 4;
        for (int x = x_start; x < x_end; ++x) {
            int wz_b;
            int wz_a;
            int vz_b;
            int vz_a;
            int uz_b;
            int uz_a;
            int y2;
            int y1;
            if (y_start > y_end) {
                y1 = y_end;
                y2 = y_start;
                uz_a = uz_end;
                uz_b = uz_start;
                vz_a = vz_end;
                vz_b = vz_start;
                wz_a = wz_end;
                wz_b = wz_start;
            } else {
                y1 = y_start;
                y2 = y_end;
                uz_a = uz_start;
                uz_b = uz_end;
                vz_a = vz_start;
                vz_b = vz_end;
                wz_a = wz_start;
                wz_b = wz_end;
            }
            long subtexel_a = y1 % 4096;
            long subtexel_b = y2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            y2 >>= 12;
            if ((y1 >>= 12) < 0) {
                uz_a -= duz * y1;
                vz_a -= dvz * y1;
                wz_a -= dwz * y1;
                y1 = 0;
            }
            if (y2 > g3d.height) {
                uz_b -= duz * (y2 -= g3d.height);
                vz_b -= dvz * y2;
                wz_b -= dwz * y2;
                y2 = g3d.height;
            }
            if (wz_a == 0 || wz_b == 0) {
                return;
            }
            int length = y2 - y1;
            y1 = y1 * g3d.width + x;
            y2 = y2 * g3d.width + x;
            if (length != 0) {
                int col;
                int u = (int)(((long)uz_a << 12) / (long)wz_a);
                int v = (int)(((long)vz_a << 12) / (long)wz_a);
                int u_2 = (int)(((long)uz_b << 12) / (long)wz_b);
                int v_2 = (int)(((long)vz_b << 12) / (long)wz_b);
                int du = (u_2 - u) / length;
                int dv = (v_2 - v) / length;
                while (y2 - y1 >= width4) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        col = (col & 0xFEFEFE) + (rgb[y1] & 0xFEFEFE);
                        rgb[y1] = col | (col >> 8 & 0x10101) * 255;
                    }
                    y1 += g3d.width;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        col = (col & 0xFEFEFE) + (rgb[y1] & 0xFEFEFE);
                        rgb[y1] = col | (col >> 8 & 0x10101) * 255;
                    }
                    y1 += g3d.width;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        col = (col & 0xFEFEFE) + (rgb[y1] & 0xFEFEFE);
                        rgb[y1] = col | (col >> 8 & 0x10101) * 255;
                    }
                    y1 += g3d.width;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        col = (col & 0xFEFEFE) + (rgb[y1] & 0xFEFEFE);
                        rgb[y1] = col | (col >> 8 & 0x10101) * 255;
                    }
                    y1 += g3d.width;
                }
                while (y1 < y2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        col = (col & 0xFEFEFE) + (rgb[y1] & 0xFEFEFE);
                        rgb[y1] = col | (col >> 8 & 0x10101) * 255;
                    }
                    y1 += g3d.width;
                }
            }
            y_start += dy_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            y_end += dy_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
        }
    }

    static final void paintFloor_2(Graphics3D g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz) {
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        for (int y = y_start; y < y_end; ++y) {
            int wz_b;
            int wz_a;
            int vz_b;
            int vz_a;
            int uz_b;
            int uz_a;
            int x2;
            int x1;
            if (x_start > x_end) {
                x1 = x_end;
                x2 = x_start;
                uz_a = uz_end;
                uz_b = uz_start;
                vz_a = vz_end;
                vz_b = vz_start;
                wz_a = wz_end;
                wz_b = wz_start;
            } else {
                x1 = x_start;
                x2 = x_end;
                uz_a = uz_start;
                uz_b = uz_end;
                vz_a = vz_start;
                vz_b = vz_end;
                wz_a = wz_start;
                wz_b = wz_end;
            }
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            if (wz_a == 0 || wz_b == 0) {
                return;
            }
            int tempI = y * g3d.width;
            int length = (x2 += tempI) - (x1 += tempI);
            if (length != 0) {
                int col;
                int u = (int)(((long)uz_a << 12) / (long)wz_a);
                int v = (int)(((long)vz_a << 12) / (long)wz_a);
                int u_2 = (int)(((long)uz_b << 12) / (long)wz_b);
                int v_2 = (int)(((long)vz_b << 12) / (long)wz_b);
                int du = (u_2 - u) / length;
                int dv = (v_2 - v) / length;
                while (x2 - x1 >= 4) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        col = (col & 0xFEFEFE) + (rgb[x1] & 0xFEFEFE);
                        rgb[x1] = col | (col >> 8 & 0x10101) * 255;
                    }
                    if ((col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT]) != 0) {
                        col = (col & 0xFEFEFE) + (rgb[x1 + 1] & 0xFEFEFE);
                        rgb[x1 + 1] = col | (col >> 8 & 0x10101) * 255;
                    }
                    if ((col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT]) != 0) {
                        col = (col & 0xFEFEFE) + (rgb[x1 + 2] & 0xFEFEFE);
                        rgb[x1 + 2] = col | (col >> 8 & 0x10101) * 255;
                    }
                    if ((col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT]) != 0) {
                        col = (col & 0xFEFEFE) + (rgb[x1 + 2] & 0xFEFEFE);
                        rgb[x1 + 3] = col | (col >> 8 & 0x10101) * 255;
                    }
                    x1 += 4;
                }
                while (x1 < x2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        col = (col & 0xFEFEFE) + (rgb[x1] & 0xFEFEFE);
                        rgb[x1] = col | (col >> 8 & 0x10101) * 255;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
        }
    }

    static final void paintWall_3(Graphics3D g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dy_start, int dwz_start, int duz_start, int dvz_start, int dy_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, int fogc, int sz2, Vertex a, Vertex b, Vertex c, int f_start, int f_end, int df_start, int df_end, int df) {
        if (Main.fogQ == 0) {
            TexturingFloorsWalls.paintWall(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dy_start, dwz_start, duz_start, dvz_start, dy_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, sz2);
            return;
        }
        if (Main.fogQ == 2 && !Main.forceLQFog) {
            TexturingFloorsWalls.paintWall_3_HQ(g3d, texture, y_start, y_end, x_start, wz_start, uz_start, vz_start, x_end, wz_end, uz_end, vz_end, dy_start, dwz_start, duz_start, dvz_start, dy_end, dwz_end, duz_end, dvz_end, dwz, duz, dvz, a, b, c, f_start, f_end, df_start, df_end, df);
            return;
        }
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int width3 = g3d.width * 3;
        int width4 = g3d.width * 4;
        if (Graphics3D.fDist / 255 != 0) {
            sz2 = -TexturingPers.max(a.rz, b.rz, c.rz) / (Graphics3D.fDist / 255);
        }
        if (sz2 > 255) {
            sz2 = 255;
        }
        if (sz2 < 0) {
            sz2 = 0;
        }
        int isz2 = 255 - sz2;
        int f2 = (fogc & 0xFF00FF) * sz2;
        int f22 = (fogc & 0xFF00) * sz2;
        for (int x = x_start; x < x_end; ++x) {
            int wz_b;
            int wz_a;
            int vz_b;
            int vz_a;
            int uz_b;
            int uz_a;
            int y2;
            int y1;
            if (y_start > y_end) {
                y1 = y_end;
                y2 = y_start;
                uz_a = uz_end;
                uz_b = uz_start;
                vz_a = vz_end;
                vz_b = vz_start;
                wz_a = wz_end;
                wz_b = wz_start;
            } else {
                y1 = y_start;
                y2 = y_end;
                uz_a = uz_start;
                uz_b = uz_end;
                vz_a = vz_start;
                vz_b = vz_end;
                wz_a = wz_start;
                wz_b = wz_end;
            }
            long subtexel_a = y1 % 4096;
            long subtexel_b = y2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            y2 >>= 12;
            if ((y1 >>= 12) < 0) {
                uz_a -= duz * y1;
                vz_a -= dvz * y1;
                wz_a -= dwz * y1;
                y1 = 0;
            }
            if (y2 > g3d.height) {
                uz_b -= duz * (y2 -= g3d.height);
                vz_b -= dvz * y2;
                wz_b -= dwz * y2;
                y2 = g3d.height;
            }
            if (wz_a == 0 || wz_b == 0) {
                return;
            }
            int length = y2 - y1;
            y1 = y1 * g3d.width + x;
            y2 = y2 * g3d.width + x;
            if (length != 0) {
                int col;
                int u = (int)(((long)uz_a << 12) / (long)wz_a);
                int v = (int)(((long)vz_a << 12) / (long)wz_a);
                int u_2 = (int)(((long)uz_b << 12) / (long)wz_b);
                int v_2 = (int)(((long)vz_b << 12) / (long)wz_b);
                int du = (u_2 - u) / length;
                int dv = (v_2 - v) / length;
                while (y2 - y1 >= width4) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[y1] = ((col & 0xFF00FF) * isz2 + f2 & 0xFF00FF00 | (col & 0xFF00) * isz2 + f22 & 0xFF0000) >>> 8;
                    }
                    y1 += g3d.width;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[y1] = ((col & 0xFF00FF) * isz2 + f2 & 0xFF00FF00 | (col & 0xFF00) * isz2 + f22 & 0xFF0000) >>> 8;
                    }
                    y1 += g3d.width;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[y1] = ((col & 0xFF00FF) * isz2 + f2 & 0xFF00FF00 | (col & 0xFF00) * isz2 + f22 & 0xFF0000) >>> 8;
                    }
                    y1 += g3d.width;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[y1] = ((col & 0xFF00FF) * isz2 + f2 & 0xFF00FF00 | (col & 0xFF00) * isz2 + f22 & 0xFF0000) >>> 8;
                    }
                    y1 += g3d.width;
                }
                while (y1 < y2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[y1] = ((col & 0xFF00FF) * isz2 + f2 & 0xFF00FF00 | (col & 0xFF00) * isz2 + f22 & 0xFF0000) >>> 8;
                    }
                    y1 += g3d.width;
                }
            }
            y_start += dy_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            y_end += dy_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
        }
    }

    static final void paintFloor_3(Graphics3D g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, int fogc, int sz2, Vertex a, Vertex b, Vertex c, int f_start, int f_end, int df_start, int df_end, int df) {
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int dv = 0;
        int du = 0;
        if (Graphics3D.fDist / 255 != 0) {
            sz2 = -TexturingPers.max(a.rz, b.rz, c.rz) / (Graphics3D.fDist / 255);
        }
        if (sz2 > 255) {
            sz2 = 255;
        }
        if (sz2 < 0) {
            sz2 = 0;
        }
        int isz2 = 255 - sz2;
        int f2 = (fogc & 0xFF00FF) * sz2;
        int f22 = (fogc & 0xFF00) * sz2;
        for (int y = y_start; y < y_end; ++y) {
            int wz_b;
            int wz_a;
            int vz_b;
            int vz_a;
            int uz_b;
            int uz_a;
            int x2;
            int x1;
            if (x_start > x_end) {
                x1 = x_end;
                x2 = x_start;
                uz_a = uz_end;
                uz_b = uz_start;
                vz_a = vz_end;
                vz_b = vz_start;
                wz_a = wz_end;
                wz_b = wz_start;
            } else {
                x1 = x_start;
                x2 = x_end;
                uz_a = uz_start;
                uz_b = uz_end;
                vz_a = vz_start;
                vz_b = vz_end;
                wz_a = wz_start;
                wz_b = wz_end;
            }
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            if (wz_a == 0 || wz_b == 0) {
                return;
            }
            int tempI = y * g3d.width;
            int length = (x2 += tempI) - (x1 += tempI);
            if (length != 0) {
                int col;
                int u = (int)(((long)uz_a << 12) / (long)wz_a);
                int v = (int)(((long)vz_a << 12) / (long)wz_a);
                int u_2 = (int)(((long)uz_b << 12) / (long)wz_b);
                int v_2 = (int)(((long)vz_b << 12) / (long)wz_b);
                du = (u_2 - u) / length;
                dv = (v_2 - v) / length;
                while (x2 - x1 >= 4) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 + f2 & 0xFF00FF00 | (col & 0xFF00) * isz2 + f22 & 0xFF0000) >>> 8;
                    }
                    if ((col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT]) != 0) {
                        rgb[x1 + 1] = ((col & 0xFF00FF) * isz2 + f2 & 0xFF00FF00 | (col & 0xFF00) * isz2 + f22 & 0xFF0000) >>> 8;
                    }
                    if ((col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT]) != 0) {
                        rgb[x1 + 2] = ((col & 0xFF00FF) * isz2 + f2 & 0xFF00FF00 | (col & 0xFF00) * isz2 + f22 & 0xFF0000) >>> 8;
                    }
                    if ((col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT]) != 0) {
                        rgb[x1 + 3] = ((col & 0xFF00FF) * isz2 + f2 & 0xFF00FF00 | (col & 0xFF00) * isz2 + f22 & 0xFF0000) >>> 8;
                    }
                    x1 += 4;
                }
                while (x1 < x2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 + f2 & 0xFF00FF00 | (col & 0xFF00) * isz2 + f22 & 0xFF0000) >>> 8;
                    }
                    x1 += g3d.width;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
        }
    }

    static final void paintWall_4(Graphics3D g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dy_start, int dwz_start, int duz_start, int dvz_start, int dy_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz) {
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int width2 = g3d.width * 2;
        int width4 = g3d.width * 4;
        for (int x = x_start; x < x_end; ++x) {
            int wz_b;
            int wz_a;
            int vz_b;
            int vz_a;
            int uz_b;
            int uz_a;
            int y2;
            int y1;
            if (y_start > y_end) {
                y1 = y_end;
                y2 = y_start;
                uz_a = uz_end;
                uz_b = uz_start;
                vz_a = vz_end;
                vz_b = vz_start;
                wz_a = wz_end;
                wz_b = wz_start;
            } else {
                y1 = y_start;
                y2 = y_end;
                uz_a = uz_start;
                uz_b = uz_end;
                vz_a = vz_start;
                vz_b = vz_end;
                wz_a = wz_start;
                wz_b = wz_end;
            }
            long subtexel_a = y1 % 4096;
            long subtexel_b = y2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            y2 >>= 12;
            if ((y1 >>= 12) < 0) {
                uz_a -= duz * y1;
                vz_a -= dvz * y1;
                wz_a -= dwz * y1;
                y1 = 0;
            }
            if (y2 > g3d.height) {
                uz_b -= duz * (y2 -= g3d.height);
                vz_b -= dvz * y2;
                wz_b -= dwz * y2;
                y2 = g3d.height;
            }
            if (wz_a == 0 || wz_b == 0) {
                return;
            }
            int length = y2 - y1;
            y1 = y1 * g3d.width + x;
            y2 = y2 * g3d.width + x;
            if (length != 0) {
                int cols;
                int ca;
                int col;
                int u = (int)(((long)uz_a << 12) / (long)wz_a);
                int v = (int)(((long)vz_a << 12) / (long)wz_a);
                int u_2 = (int)(((long)uz_b << 12) / (long)wz_b);
                int v_2 = (int)(((long)vz_b << 12) / (long)wz_b);
                int du = (u_2 - u) / length;
                int dv = (v_2 - v) / length;
                while (y2 - y1 >= width2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        ca = col >> 24 & 0xFF;
                        cols = rgb[y1];
                        rgb[y1] = ((col & 0xFF00FF) * ca + (cols & 0xFF00FF) * (255 - ca) & 0xFF00FF00 | (col & 0xFF00) * ca + (cols & 0xFF00) * (255 - ca) & 0xFF0000) >>> 8;
                    }
                    y1 += g3d.width;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        ca = col >> 24 & 0xFF;
                        cols = rgb[y1];
                        rgb[y1] = ((col & 0xFF00FF) * ca + (cols & 0xFF00FF) * (255 - ca) & 0xFF00FF00 | (col & 0xFF00) * ca + (cols & 0xFF00) * (255 - ca) & 0xFF0000) >>> 8;
                    }
                    y1 += g3d.width;
                }
                while (y1 < y2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        ca = col >> 24 & 0xFF;
                        cols = rgb[y1];
                        rgb[y1] = ((col & 0xFF00FF) * ca + (cols & 0xFF00FF) * (255 - ca) & 0xFF00FF00 | (col & 0xFF00) * ca + (cols & 0xFF00) * (255 - ca) & 0xFF0000) >>> 8;
                    }
                    y1 += g3d.width;
                }
            }
            y_start += dy_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            y_end += dy_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
        }
    }

    static final void paintFloor_4(Graphics3D g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz) {
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int dv = 0;
        int du = 0;
        for (int y = y_start; y < y_end; ++y) {
            int wz_b;
            int wz_a;
            int vz_b;
            int vz_a;
            int uz_b;
            int uz_a;
            int x2;
            int x1;
            if (x_start > x_end) {
                x1 = x_end;
                x2 = x_start;
                uz_a = uz_end;
                uz_b = uz_start;
                vz_a = vz_end;
                vz_b = vz_start;
                wz_a = wz_end;
                wz_b = wz_start;
            } else {
                x1 = x_start;
                x2 = x_end;
                uz_a = uz_start;
                uz_b = uz_end;
                vz_a = vz_start;
                vz_b = vz_end;
                wz_a = wz_start;
                wz_b = wz_end;
            }
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            if (wz_a == 0 || wz_b == 0) {
                return;
            }
            int tempI = y * g3d.width;
            int length = (x2 += tempI) - (x1 += tempI);
            if (length != 0) {
                int cols;
                int ca;
                int col;
                int u = (int)(((long)uz_a << 12) / (long)wz_a);
                int v = (int)(((long)vz_a << 12) / (long)wz_a);
                int u_2 = (int)(((long)uz_b << 12) / (long)wz_b);
                int v_2 = (int)(((long)vz_b << 12) / (long)wz_b);
                du = (u_2 - u) / length;
                dv = (v_2 - v) / length;
                while (x2 - x1 >= 3) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        ca = col >> 24 & 0xFF;
                        cols = rgb[x1];
                        rgb[x1] = ((col & 0xFF00FF) * ca + (cols & 0xFF00FF) * (255 - ca) & 0xFF00FF00 | (col & 0xFF00) * ca + (cols & 0xFF00) * (255 - ca) & 0xFF0000) >>> 8;
                    }
                    if ((col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT]) != 0) {
                        ca = col >> 24 & 0xFF;
                        cols = rgb[x1 + 1];
                        rgb[x1 + 1] = ((col & 0xFF00FF) * ca + (cols & 0xFF00FF) * (255 - ca) & 0xFF00FF00 | (col & 0xFF00) * ca + (cols & 0xFF00) * (255 - ca) & 0xFF0000) >>> 8;
                    }
                    if ((col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT]) != 0) {
                        ca = col >> 24 & 0xFF;
                        cols = rgb[x1 + 2];
                        rgb[x1 + 2] = ((col & 0xFF00FF) * ca + (cols & 0xFF00FF) * (255 - ca) & 0xFF00FF00 | (col & 0xFF00) * ca + (cols & 0xFF00) * (255 - ca) & 0xFF0000) >>> 8;
                    }
                    x1 += 3;
                }
                while (x1 < x2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        ca = col >> 24 & 0xFF;
                        cols = rgb[x1];
                        rgb[x1] = ((col & 0xFF00FF) * ca + (cols & 0xFF00FF) * (255 - ca) & 0xFF00FF00 | (col & 0xFF00) * ca + (cols & 0xFF00) * (255 - ca) & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
        }
    }

    static final void paintFloor_3_HQ(Graphics3D g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, Vertex a, Vertex b, Vertex c, int f_start, int f_end, int df_start, int df_end, int df) {
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int fogcolor = Graphics3D.fogc;
        int fogcolor2 = fogcolor & 0xFF00;
        fogcolor &= 0xFF00FF;
        for (int y = y_start; y < y_end; ++y) {
            int f;
            int wz_b;
            int wz_a;
            int vz_b;
            int vz_a;
            int uz_b;
            int uz_a;
            int x2;
            int x1;
            if (x_start > x_end) {
                x1 = x_end;
                x2 = x_start;
                uz_a = uz_end;
                uz_b = uz_start;
                vz_a = vz_end;
                vz_b = vz_start;
                wz_a = wz_end;
                wz_b = wz_start;
                f = f_end;
            } else {
                x1 = x_start;
                x2 = x_end;
                uz_a = uz_start;
                uz_b = uz_end;
                vz_a = vz_start;
                vz_b = vz_end;
                wz_a = wz_start;
                wz_b = wz_end;
                f = f_start;
            }
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                f -= df * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            int tempI = y * g3d.width;
            int length = (x2 += tempI) - (x1 += tempI);
            if (wz_a == 0) {
                return;
            }
            if (length > 0) {
                int col;
                int u = (int)(((long)uz_a << 12) / (long)wz_a);
                int v = (int)(((long)vz_a << 12) / (long)wz_a);
                int u_2 = (int)(((long)uz_b << 12) / (long)wz_b);
                int v_2 = (int)(((long)vz_b << 12) / (long)wz_b);
                int du = (u_2 - u) / length;
                int dv = (v_2 - v) / length;
                int isz2 = f >> 12;
                int isz = 255 - isz2;
                int c1 = fogcolor * isz;
                int c2 = fogcolor2 * isz;
                while (x2 - x1 >= 2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 + c1 & 0xFF00FF00 | (col & 0xFF00) * isz2 + c2 & 0xFF0000) >>> 8;
                    }
                    if ((col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT]) != 0) {
                        rgb[x1 + 1] = ((col & 0xFF00FF) * isz2 + c1 & 0xFF00FF00 | (col & 0xFF00) * isz2 + c2 & 0xFF0000) >>> 8;
                    }
                    x1 += 2;
                }
                while (x1 < x2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 + c1 & 0xFF00FF00 | (col & 0xFF00) * isz2 + c2 & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            f_start += df_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
            f_end += df_end;
        }
    }

    static final void paintWall_3_HQ(Graphics3D g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dy_start, int dwz_start, int duz_start, int dvz_start, int dy_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, Vertex a, Vertex b, Vertex c, int f_start, int f_end, int df_start, int df_end, int df) {
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int width2 = g3d.width * 2;
        int width4 = g3d.width * 4;
        int fogcolor = Graphics3D.fogc;
        int fogcolor2 = fogcolor & 0xFF00;
        fogcolor &= 0xFF00FF;
        if (df > 0) {
            --df;
        }
        if (df < 0) {
            ++df;
        }
        for (int x = x_start; x < x_end; ++x) {
            int f;
            int wz_b;
            int wz_a;
            int vz_b;
            int vz_a;
            int uz_b;
            int uz_a;
            int y2;
            int y1;
            if (y_start > y_end) {
                y1 = y_end;
                y2 = y_start;
                uz_a = uz_end;
                uz_b = uz_start;
                vz_a = vz_end;
                vz_b = vz_start;
                wz_a = wz_end;
                wz_b = wz_start;
                f = f_end;
            } else {
                y1 = y_start;
                y2 = y_end;
                uz_a = uz_start;
                uz_b = uz_end;
                vz_a = vz_start;
                vz_b = vz_end;
                wz_a = wz_start;
                wz_b = wz_end;
                f = f_start;
            }
            long subtexel_a = y1 % 4096;
            long subtexel_b = y2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            y2 >>= 12;
            if ((y1 >>= 12) < 0) {
                uz_a -= duz * y1;
                vz_a -= dvz * y1;
                wz_a -= dwz * y1;
                f -= df * y1;
                y1 = 0;
            }
            if (y2 > g3d.height) {
                uz_b -= duz * (y2 -= g3d.height);
                vz_b -= dvz * y2;
                wz_b -= dwz * y2;
                y2 = g3d.height;
            }
            if (wz_a == 0 || wz_b == 0) {
                return;
            }
            int length = y2 - y1;
            y1 = y1 * g3d.width + x;
            y2 = y2 * g3d.width + x;
            if (length != 0) {
                int col;
                int u = (int)(((long)uz_a << 12) / (long)wz_a);
                int v = (int)(((long)vz_a << 12) / (long)wz_a);
                int u_2 = (int)(((long)uz_b << 12) / (long)wz_b);
                int v_2 = (int)(((long)vz_b << 12) / (long)wz_b);
                int du = (u_2 - u) / length;
                int dv = (v_2 - v) / length;
                int isz2 = f >> 12;
                int isz = 255 - isz2;
                int c1 = fogcolor * isz;
                int c2 = fogcolor2 * isz;
                while (y2 - y1 >= width2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[y1] = ((col & 0xFF00FF) * isz2 + c1 & 0xFF00FF00 | (col & 0xFF00) * isz2 + c2 & 0xFF0000) >>> 8;
                    }
                    y1 += g3d.width;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[y1] = ((col & 0xFF00FF) * isz2 + c1 & 0xFF00FF00 | (col & 0xFF00) * isz2 + c2 & 0xFF0000) >>> 8;
                    }
                    y1 += g3d.width;
                }
                while (y1 < y2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[y1] = ((col & 0xFF00FF) * isz2 + c1 & 0xFF00FF00 | (col & 0xFF00) * isz2 + c2 & 0xFF0000) >>> 8;
                    }
                    y1 += g3d.width;
                }
            }
            y_start += dy_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            f_start += df_start;
            y_end += dy_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
            f_end += df_end;
        }
    }

    static final void paintWall_6_HQ(Graphics3D g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dy_start, int dwz_start, int duz_start, int dvz_start, int dy_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, Vertex a, Vertex b, Vertex c, int f_start, int f_end, int df_start, int df_end, int df) {
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int width2 = g3d.width * 2;
        int width4 = g3d.width * 4;
        if (df > 0) {
            --df;
        }
        if (df < 0) {
            ++df;
        }
        for (int x = x_start; x < x_end; ++x) {
            int f;
            int wz_b;
            int wz_a;
            int vz_b;
            int vz_a;
            int uz_b;
            int uz_a;
            int y2;
            int y1;
            if (y_start > y_end) {
                y1 = y_end;
                y2 = y_start;
                uz_a = uz_end;
                uz_b = uz_start;
                vz_a = vz_end;
                vz_b = vz_start;
                wz_a = wz_end;
                wz_b = wz_start;
                f = f_end;
            } else {
                y1 = y_start;
                y2 = y_end;
                uz_a = uz_start;
                uz_b = uz_end;
                vz_a = vz_start;
                vz_b = vz_end;
                wz_a = wz_start;
                wz_b = wz_end;
                f = f_start;
            }
            long subtexel_a = y1 % 4096;
            long subtexel_b = y2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            y2 >>= 12;
            if ((y1 >>= 12) < 0) {
                uz_a -= duz * y1;
                vz_a -= dvz * y1;
                wz_a -= dwz * y1;
                f -= df * y1;
                y1 = 0;
            }
            if (y2 > g3d.height) {
                uz_b -= duz * (y2 -= g3d.height);
                vz_b -= dvz * y2;
                wz_b -= dwz * y2;
                y2 = g3d.height;
            }
            if (wz_a == 0 || wz_b == 0) {
                return;
            }
            int length = y2 - y1;
            y1 = y1 * g3d.width + x;
            y2 = y2 * g3d.width + x;
            if (length != 0) {
                int col;
                int u = (int)(((long)uz_a << 12) / (long)wz_a);
                int v = (int)(((long)vz_a << 12) / (long)wz_a);
                int u_2 = (int)(((long)uz_b << 12) / (long)wz_b);
                int v_2 = (int)(((long)vz_b << 12) / (long)wz_b);
                int du = (u_2 - u) / length;
                int dv = (v_2 - v) / length;
                int isz2 = f >> 12;
                if (isz2 < 0) {
                    isz2 = 0;
                }
                if (isz2 > 255) {
                    isz2 = 255;
                }
                while (y2 - y1 >= width2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[y1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    y1 += g3d.width;
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[y1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    y1 += g3d.width;
                }
                while (y1 < y2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[y1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    y1 += g3d.width;
                }
            }
            y_start += dy_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            f_start += df_start;
            y_end += dy_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
            f_end += df_end;
        }
    }

    static final void paintWall_9_HQ(Graphics3D g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dy_start, int dwz_start, int duz_start, int dvz_start, int dy_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, Vertex a, Vertex b, Vertex c, int f_start, int f_end, int df_start, int df_end, int df) {
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        int width2 = g3d.width * 2;
        int width4 = g3d.width * 4;
        if (df > 0) {
            --df;
        }
        if (df < 0) {
            ++df;
        }
        for (int x = x_start; x < x_end; ++x) {
            int f;
            int wz_b;
            int wz_a;
            int vz_b;
            int vz_a;
            int uz_b;
            int uz_a;
            int y2;
            int y1;
            if (y_start > y_end) {
                y1 = y_end;
                y2 = y_start;
                uz_a = uz_end;
                uz_b = uz_start;
                vz_a = vz_end;
                vz_b = vz_start;
                wz_a = wz_end;
                wz_b = wz_start;
                f = f_end;
            } else {
                y1 = y_start;
                y2 = y_end;
                uz_a = uz_start;
                uz_b = uz_end;
                vz_a = vz_start;
                vz_b = vz_end;
                wz_a = wz_start;
                wz_b = wz_end;
                f = f_start;
            }
            long subtexel_a = y1 % 4096;
            long subtexel_b = y2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            y2 >>= 12;
            if ((y1 >>= 12) < 0) {
                uz_a -= duz * y1;
                vz_a -= dvz * y1;
                wz_a -= dwz * y1;
                f -= df * y1;
                y1 = 0;
            }
            if (y2 > g3d.height) {
                uz_b -= duz * (y2 -= g3d.height);
                vz_b -= dvz * y2;
                wz_b -= dwz * y2;
                y2 = g3d.height;
            }
            if (wz_a == 0 || wz_b == 0) {
                return;
            }
            int length = y2 - y1;
            y1 = y1 * g3d.width + x;
            y2 = y2 * g3d.width + x;
            if (length != 0) {
                int col;
                int isz2;
                int u = (int)(((long)uz_a << 12) / (long)wz_a);
                int v = (int)(((long)vz_a << 12) / (long)wz_a);
                int u_2 = (int)(((long)uz_b << 12) / (long)wz_b);
                int v_2 = (int)(((long)vz_b << 12) / (long)wz_b);
                int du = (u_2 - u) / length;
                int dv = (v_2 - v) / length;
                while (y2 - y1 >= width2) {
                    u += du;
                    v += dv;
                    isz2 = (f += df) >> 12;
                    if (isz2 < 0) {
                        isz2 = 0;
                    }
                    if ((col = tex[(v >> 12 << widthBIT) + (u >> 12) & lengthBIT]) != 0) {
                        rgb[y1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    u += du;
                    v += dv;
                    isz2 = (f += df) >> 12;
                    if (isz2 < 0) {
                        isz2 = 0;
                    }
                    if ((col = tex[(v >> 12 << widthBIT) + (u >> 12) & lengthBIT]) != 0) {
                        rgb[y1 + g3d.width] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    y1 += width2;
                }
                while (y1 < y2) {
                    u += du;
                    v += dv;
                    isz2 = (f += df) >> 12;
                    if (isz2 < 0) {
                        isz2 = 0;
                    }
                    if ((col = tex[(v >> 12 << widthBIT) + (u >> 12) & lengthBIT]) != 0) {
                        rgb[y1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    y1 += g3d.width;
                }
            }
            y_start += dy_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            f_start += df_start;
            y_end += dy_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
            f_end += df_end;
        }
    }

    static final void paintFloor_6_HQ(Graphics3D g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, Vertex a, Vertex b, Vertex c, int f_start, int f_end, int df_start, int df_end, int df) {
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        if (df > 0) {
            --df;
        }
        if (df < 0) {
            ++df;
        }
        for (int y = y_start; y < y_end; ++y) {
            int f;
            int wz_b;
            int wz_a;
            int vz_b;
            int vz_a;
            int uz_b;
            int uz_a;
            int x2;
            int x1;
            if (x_start > x_end) {
                x1 = x_end;
                x2 = x_start;
                uz_a = uz_end;
                uz_b = uz_start;
                vz_a = vz_end;
                vz_b = vz_start;
                wz_a = wz_end;
                wz_b = wz_start;
                f = f_end;
            } else {
                x1 = x_start;
                x2 = x_end;
                uz_a = uz_start;
                uz_b = uz_end;
                vz_a = vz_start;
                vz_b = vz_end;
                wz_a = wz_start;
                wz_b = wz_end;
                f = f_start;
            }
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                f -= df * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            int tempI = y * g3d.width;
            int length = (x2 += tempI) - (x1 += tempI);
            if (wz_a == 0) {
                return;
            }
            if (length > 0) {
                int col;
                int u = (int)(((long)uz_a << 12) / (long)wz_a);
                int v = (int)(((long)vz_a << 12) / (long)wz_a);
                int u_2 = (int)(((long)uz_b << 12) / (long)wz_b);
                int v_2 = (int)(((long)vz_b << 12) / (long)wz_b);
                int du = (u_2 - u) / length;
                int dv = (v_2 - v) / length;
                int isz2 = f >> 12;
                if (isz2 < 0) {
                    isz2 = 0;
                }
                while (x2 - x1 >= 2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    if ((col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT]) != 0) {
                        rgb[x1 + 1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    x1 += 2;
                }
                while (x1 < x2) {
                    col = tex[((v += dv) >> 12 << widthBIT) + ((u += du) >> 12) & lengthBIT];
                    if (col != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            f_start += df_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
            f_end += df_end;
        }
    }

    static final void paintFloor_9_HQ(Graphics3D g3d, Texture texture, int y_start, int y_end, int x_start, int wz_start, int uz_start, int vz_start, int x_end, int wz_end, int uz_end, int vz_end, int dx_start, int dwz_start, int duz_start, int dvz_start, int dx_end, int dwz_end, int duz_end, int dvz_end, int dwz, int duz, int dvz, Vertex a, Vertex b, Vertex c, int f_start, int f_end, int df_start, int df_end, int df) {
        int[] tex = texture.rImg.img;
        int lengthBIT = tex.length - 1;
        int widthBIT = texture.widthBIT;
        int[] rgb = g3d.display;
        if (df > 0) {
            --df;
        }
        if (df < 0) {
            ++df;
        }
        for (int y = y_start; y < y_end; ++y) {
            int f;
            int wz_b;
            int wz_a;
            int vz_b;
            int vz_a;
            int uz_b;
            int uz_a;
            int x2;
            int x1;
            if (x_start > x_end) {
                x1 = x_end;
                x2 = x_start;
                uz_a = uz_end;
                uz_b = uz_start;
                vz_a = vz_end;
                vz_b = vz_start;
                wz_a = wz_end;
                wz_b = wz_start;
                f = f_end;
            } else {
                x1 = x_start;
                x2 = x_end;
                uz_a = uz_start;
                uz_b = uz_end;
                vz_a = vz_start;
                vz_b = vz_end;
                wz_a = wz_start;
                wz_b = wz_end;
                f = f_start;
            }
            long subtexel_a = x1 % 4096;
            long subtexel_b = x2 % 4096;
            uz_a = (int)((long)uz_a - ((long)duz * subtexel_a >> 12));
            vz_a = (int)((long)vz_a - ((long)dvz * subtexel_a >> 12));
            wz_a = (int)((long)wz_a - ((long)dwz * subtexel_a >> 12));
            uz_b = (int)((long)uz_b - ((long)duz * subtexel_b >> 12));
            vz_b = (int)((long)vz_b - ((long)dvz * subtexel_b >> 12));
            wz_b = (int)((long)wz_b - ((long)dwz * subtexel_b >> 12));
            x2 >>= 12;
            if ((x1 >>= 12) < 0) {
                uz_a -= duz * x1;
                vz_a -= dvz * x1;
                wz_a -= dwz * x1;
                f -= df * x1;
                x1 = 0;
            }
            if (x2 > g3d.width) {
                uz_b -= duz * (x2 -= g3d.width);
                vz_b -= dvz * x2;
                wz_b -= dwz * x2;
                x2 = g3d.width;
            }
            int tempI = y * g3d.width;
            int length = (x2 += tempI) - (x1 += tempI);
            if (wz_a == 0) {
                return;
            }
            if (length > 0) {
                int col;
                int isz2;
                int u = (int)(((long)uz_a << 12) / (long)wz_a);
                int v = (int)(((long)vz_a << 12) / (long)wz_a);
                int u_2 = (int)(((long)uz_b << 12) / (long)wz_b);
                int v_2 = (int)(((long)vz_b << 12) / (long)wz_b);
                int du = (u_2 - u) / length;
                int dv = (v_2 - v) / length;
                while (x2 - x1 >= 2) {
                    u += du;
                    v += dv;
                    isz2 = (f += df) >> 12;
                    if (isz2 < 0) {
                        isz2 = 0;
                    }
                    if ((col = tex[(v >> 12 << widthBIT) + (u >> 12) & lengthBIT]) != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    u += du;
                    v += dv;
                    isz2 = (f += df) >> 12;
                    if (isz2 < 0) {
                        isz2 = 0;
                    }
                    if ((col = tex[(v >> 12 << widthBIT) + (u >> 12) & lengthBIT]) != 0) {
                        rgb[x1 + 1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    x1 += 2;
                }
                while (x1 < x2) {
                    u += du;
                    v += dv;
                    isz2 = (f += df) >> 12;
                    if (isz2 < 0) {
                        isz2 = 0;
                    }
                    if ((col = tex[(v >> 12 << widthBIT) + (u >> 12) & lengthBIT]) != 0) {
                        rgb[x1] = ((col & 0xFF00FF) * isz2 & 0xFF00FF00 | (col & 0xFF00) * isz2 & 0xFF0000) >>> 8;
                    }
                    ++x1;
                }
            }
            x_start += dx_start;
            wz_start += dwz_start;
            uz_start += duz_start;
            vz_start += dvz_start;
            f_start += df_start;
            x_end += dx_end;
            wz_end += dwz_end;
            uz_end += duz_end;
            vz_end += dvz_end;
            f_end += df_end;
        }
    }
}

