/*
 * Decompiled with CFR 0.152.
 */
package com.thq.Turrican;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class AnimatedSprite {
    public int SCREEN_WIDTH = 132;
    public int screenHeight = 137;
    public boolean isMultiSheet;
    public int sheetCount;
    public int framesPerSheet;
    public int currentFrame;
    private String resourceName;
    int frameScaleTotal;
    boolean isRotating = false;
    public Sprite[] sprites;
    public int sheetIndex;
    int frameInSheet;
    public int clipOffX;
    public int clipOffY;
    public int clipWidth;
    public int clipHeight;
    public static byte TRANSFORM_NONE = 0;
    public static byte TRANSFORM_MIRROR = 1;
    public static byte TRANSFORM_FLIP = (byte)2;
    public static byte TRANSFORM_ROT90 = (byte)3;
    private int transform = TRANSFORM_NONE;
    private int animDelay;
    private long lastAnimTime;
    public static byte ANIM_FORWARD = (byte)2;
    public static byte ANIM_BACKWARD = (byte)3;
    private int animDirection = ANIM_FORWARD;
    public static byte MODE_LOOP = (byte)4;
    public static byte MODE_REVERSE = (byte)5;
    public static byte MODE_ONCE = (byte)6;
    public static byte MODE_FROZEN = (byte)7;
    public boolean animComplete = false;
    private int playMode = MODE_LOOP;
    public int frameWidth;
    public int frameHeight;
    public int halfWidth;
    public int halfHeight;
    public int totalFrames;
    public Image image;
    private boolean flipped = false;
    private boolean hidden = false;
    private long[][] stateBuffer;
    private int stateIndex;
    private boolean[] stateSlotUsed;
    int savedClipX;
    int savedClipY;
    int savedClipW;
    int savedClipH;
    int drawWidth;

    public AnimatedSprite(String[] var1, int var2) {
        this.resourceName = var1[0];
        this.isMultiSheet = true;
        this.sheetCount = var1.length;
        this.framesPerSheet = var2;
        this.currentFrame = 0;
        this.totalFrames = 0;
        this.sprites = new Sprite[var1.length];
        int var3 = 0;
        while (var3 < var1.length) {
            try {
                this.totalFrames += var2;
                this.image = Image.createImage((String)var1[var3]);
                this.frameWidth = this.image.getWidth() / var2;
                this.halfWidth = this.frameWidth >> 1;
                this.frameHeight = this.image.getHeight();
                this.halfHeight = this.frameHeight >> 1;
                this.sheetIndex = var3;
                this.sprites[this.sheetIndex] = new Sprite(this.image, this.frameWidth, this.frameHeight);
                this.sprites[this.sheetIndex].defineReferencePixel(this.halfWidth, this.halfHeight);
                int[] var4 = new int[this.totalFrames];
                int var5 = 0;
                while (var5 < var2) {
                    var4[var5] = var5++;
                }
                this.setFrameSequence(var4);
                this.setCollisionBounds(0, 0, this.frameWidth, this.frameHeight);
            }
            catch (Exception var6) {
                System.out.println("Failed to load " + var1[var3]);
                var6.printStackTrace();
            }
            var3 = (byte)(var3 + 1);
        }
        this.setFrame(0);
        this.frameScaleTotal = this.totalFrames * 182;
    }

    public AnimatedSprite(String var1, int var2) {
        this.resourceName = var1;
        this.isMultiSheet = false;
        try {
            this.totalFrames = var2;
            this.image = Image.createImage((String)var1);
            this.frameWidth = this.image.getWidth() / this.totalFrames;
            this.halfWidth = this.frameWidth >> 1;
            this.frameHeight = this.image.getHeight();
            this.halfHeight = this.frameHeight >> 1;
            this.frameScaleTotal = this.totalFrames * 182;
            this.sheetIndex = 0;
            this.sprites = new Sprite[1];
            this.sprites[this.sheetIndex] = new Sprite(this.image, this.frameWidth, this.frameHeight);
            this.sprites[this.sheetIndex].defineReferencePixel(this.halfWidth, this.halfHeight);
            this.setFrame(0);
            int[] var3 = new int[this.totalFrames];
            int var4 = 0;
            while (var4 < this.totalFrames) {
                var3[var4] = var4++;
            }
            this.setFrameSequence(var3);
            this.setCollisionBounds(0, 0, this.frameWidth, this.frameHeight);
        }
        catch (Exception var5) {
            System.out.println("Failed to load " + var1);
            var5.printStackTrace();
        }
    }

    public void setRotationFrame(int var1) {
        try {
            this.setFrame(var1 * this.frameScaleTotal >> 16);
            this.setTransform(TRANSFORM_NONE);
            this.isRotating = true;
        }
        catch (Exception var3) {
            System.out.println("setRotationFrame(" + var1 + ") failed: divided by " + this.frameScaleTotal);
            this.setFrame(0);
        }
    }

    public void setFrame(int var1) {
        if (this.isMultiSheet) {
            this.frameInSheet = var1 % this.framesPerSheet;
            this.sheetIndex = var1 / this.framesPerSheet;
            this.sprites[this.sheetIndex].setFrame(this.frameInSheet);
            this.currentFrame = var1;
        } else {
            this.sprites[this.sheetIndex].setFrame(var1);
        }
    }

    public void setFrameSequence(int[] var1) {
        this.sprites[this.sheetIndex].setFrameSequence(var1);
    }

    public void resetAnimation() {
        this.setFrame(0);
        this.animComplete = false;
    }

    private void advanceFrame() {
        if (!this.isRotating) {
            if (this.isMultiSheet) {
                if (++this.currentFrame >= this.totalFrames - 1) {
                    this.currentFrame = 0;
                    if (this.playMode == MODE_ONCE) {
                        this.animComplete = true;
                        this.currentFrame = this.totalFrames - 1;
                    }
                }
                this.setFrame(this.currentFrame);
            } else if (this.playMode == MODE_ONCE) {
                if (this.sprites[this.sheetIndex].getFrame() >= this.sprites[this.sheetIndex].getFrameSequenceLength() - 1) {
                    this.animComplete = true;
                } else {
                    this.sprites[this.sheetIndex].nextFrame();
                }
            } else {
                this.sprites[this.sheetIndex].nextFrame();
            }
        }
    }

    private void prevFrame() {
        this.sprites[this.sheetIndex].prevFrame();
    }

    public void setCollisionBounds(int var1, int var2, int var3, int var4) {
        this.clipOffX = var1;
        this.clipOffY = var2;
        this.clipWidth = var3;
        this.clipHeight = var4;
    }

    public boolean collidesWith(int var1, int var2, int var3, int var4) {
        return this.intersects(var1, var2, var1 + var3, var2 + var4);
    }

    public boolean intersects(int var1, int var2, int var3, int var4) {
        boolean var5 = true;
        boolean var6 = true;
        if (this.sprites[this.sheetIndex].getX() + this.clipOffX + this.frameWidth > var1) {
            boolean bl = var5 = !var5;
        }
        if (this.sprites[this.sheetIndex].getX() + this.clipOffX < var3) {
            boolean bl = var5 = !var5;
        }
        if (this.sprites[this.sheetIndex].getY() + this.clipOffY + this.frameHeight > var2) {
            boolean bl = var6 = !var6;
        }
        if (this.sprites[this.sheetIndex].getY() + this.clipOffY < var4) {
            boolean bl = var6 = !var6;
        }
        return var5 && var6;
    }

    public boolean containsPoint(int var1, int var2, boolean var3) {
        return var1 >= this.sprites[this.sheetIndex].getX() && var1 <= this.sprites[this.sheetIndex].getX() + this.frameWidth && var2 >= this.sprites[this.sheetIndex].getY() && var2 <= this.sprites[this.sheetIndex].getY() + this.frameHeight;
    }

    public boolean collidesWithSprite(AnimatedSprite var1) {
        return this.collidesWith(var1.clipOffX + var1.sprites[var1.sheetIndex].getX(), var1.clipOffY + var1.sprites[var1.sheetIndex].getY(), var1.clipWidth, var1.clipHeight);
    }

    public void setTransform(int var1) {
        this.transform = var1;
        if (this.transform != TRANSFORM_NONE && !this.isRotating) {
            if (this.transform == TRANSFORM_MIRROR) {
                this.sprites[this.sheetIndex].setTransform(2);
            } else if (this.transform == TRANSFORM_FLIP) {
                this.sprites[this.sheetIndex].setTransform(3);
            } else if (this.transform == TRANSFORM_ROT90) {
                this.sprites[this.sheetIndex].setTransform(1);
            }
        } else {
            this.sprites[this.sheetIndex].setTransform(0);
        }
    }

    public void setAnimDelay(int var1) {
        this.animDelay = var1;
    }

    public void setPlayMode(byte var1) {
        this.playMode = var1;
    }

    public void setPosition(int var1, int var2) {
        this.sprites[this.sheetIndex].setRefPixelPosition(var1, var2);
    }

    public void initStatePool(int var1) {
        this.stateBuffer = new long[var1][10];
        this.stateIndex = 0;
        int var2 = 0;
        while (var2 < var1) {
            int var3 = 0;
            while (var3 < 10) {
                this.stateBuffer[var2][var3] = 0L;
                ++var3;
            }
            ++var2;
        }
        this.stateSlotUsed = new boolean[var1];
    }

    public void saveAndRestoreState(int var1) {
        try {
            this.stateBuffer[this.stateIndex][0] = this.sprites[this.sheetIndex].getX();
            this.stateBuffer[this.stateIndex][1] = this.sprites[this.sheetIndex].getY();
            this.stateBuffer[this.stateIndex][2] = this.transform;
            this.stateBuffer[this.stateIndex][3] = this.isRotating ? 1L : 0L;
            this.stateBuffer[this.stateIndex][4] = this.sprites[this.sheetIndex].getFrame();
            this.stateBuffer[this.stateIndex][6] = this.animComplete ? 1L : 0L;
            this.stateBuffer[this.stateIndex][7] = this.playMode;
            this.stateBuffer[this.stateIndex][8] = this.sheetIndex;
            this.stateBuffer[this.stateIndex][9] = this.currentFrame;
            if (var1 < this.stateBuffer.length) {
                this.sprites[this.sheetIndex].setPosition((int)this.stateBuffer[var1][0], (int)this.stateBuffer[var1][1]);
                this.transform = (int)this.stateBuffer[var1][2];
                if ((int)this.stateBuffer[var1][3] == 1) {
                    this.isRotating = true;
                    this.setTransform(TRANSFORM_NONE);
                } else {
                    this.isRotating = false;
                }
                this.animComplete = (int)this.stateBuffer[var1][6] == 1;
                this.playMode = (int)this.stateBuffer[this.stateIndex][7];
                this.sheetIndex = (int)this.stateBuffer[this.stateIndex][8];
                this.currentFrame = (int)this.stateBuffer[this.stateIndex][9];
                if (this.isMultiSheet) {
                    this.setFrame(this.currentFrame);
                } else {
                    this.setFrame((int)this.stateBuffer[var1][4]);
                }
                this.stateIndex = var1;
            }
        }
        catch (Exception var3) {
            System.out.println("setMIMPFocus() failure! > " + this.resourceName);
        }
    }

    public void releaseState(int var1) {
        try {
            this.saveAndRestoreState(var1);
            if (!this.isRotating) {
                this.setFrame(0);
                this.animComplete = false;
            }
            this.stateSlotUsed[var1] = false;
        }
        catch (Exception var3) {
            System.out.println("releaseMIMP() failure!");
        }
    }

    public int acquireState() {
        if (this.stateSlotUsed != null) {
            int var1 = 0;
            while (var1 < this.stateSlotUsed.length) {
                if (!this.stateSlotUsed[var1]) {
                    this.stateSlotUsed[var1] = true;
                    return var1;
                }
                ++var1;
            }
        }
        return -1;
    }

    public void drawSprite(Graphics var1) {
        this.savedClipX = var1.getClipX();
        this.savedClipY = var1.getClipY();
        this.savedClipW = var1.getClipWidth();
        this.savedClipH = var1.getClipHeight();
        if (this.sprites[this.sheetIndex].getX() <= this.SCREEN_WIDTH && this.sprites[this.sheetIndex].getY() <= this.screenHeight) {
            this.drawWidth = this.sprites[this.sheetIndex].getX() + this.frameWidth > this.SCREEN_WIDTH ? this.SCREEN_WIDTH - this.sprites[this.sheetIndex].getX() : this.frameWidth;
            if (this.sprites[this.sheetIndex].getY() + this.frameHeight > this.screenHeight) {
                var1.setClip(this.sprites[this.sheetIndex].getX(), this.sprites[this.sheetIndex].getY(), this.drawWidth, this.screenHeight - this.sprites[this.sheetIndex].getY());
            } else {
                var1.setClip(this.sprites[this.sheetIndex].getX(), this.sprites[this.sheetIndex].getY(), this.drawWidth, this.frameHeight);
            }
            this.sprites[this.sheetIndex].paint(var1);
            var1.setClip(this.savedClipX, this.savedClipY, this.savedClipW, this.savedClipH);
            if (this.stateBuffer != null) {
                this.lastAnimTime = this.stateBuffer[this.stateIndex][5];
            }
            if (this.playMode != MODE_FROZEN && System.currentTimeMillis() - this.lastAnimTime > (long)this.animDelay && !this.animComplete) {
                if (this.animDirection == ANIM_FORWARD) {
                    this.advanceFrame();
                } else {
                    this.prevFrame();
                }
                this.lastAnimTime = System.currentTimeMillis();
                if (this.stateBuffer != null) {
                    this.stateBuffer[this.stateIndex][5] = this.lastAnimTime;
                }
            }
        }
    }
}

