/*
 * Decompiled with CFR 0.152.
 */
package com.astrolink;

import com.astrolink.CanvasGame;
import com.astrolink.CanvasMenu;
import com.astrolink.Common;
import com.astrolink.MidletPuzzle;
import com.astrolink.ResourceManager;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;

class CanvasSelectLevel
extends Canvas {
    int state;
    public static final int LEVEL = 0;
    public static final int PROMPT = 1;
    public static final String dataPath = "/res/data/level.txt";
    public static final int COLS = 4;
    public static final int MARGIN_Y = 5;
    int indexSelect;
    int rectX;
    int rectY;
    int widthRect;
    int heightRect;
    int completedX;
    int completeY;
    int heightLargeFont = Common.largeFont.getHeight();
    public CanvasGame canvasGame;
    public static String[] levelData;
    int curLevel;
    int yMenu;
    int yInfo;
    static boolean isFirst;

    public CanvasSelectLevel() {
        this.setFullScreenMode(true);
        this.widthRect = ResourceManager.imgSelectLevel.getWidth();
        this.heightRect = ResourceManager.imgSelectLevel.getHeight();
        this.rectX = Common.WIDTH - this.widthRect * 4 >>> 1;
        this.rectY = Common.HEIGHT - this.heightRect * 5 >>> 1;
        this.completedX = (this.widthRect - ResourceManager.imgCompleted.getWidth() >>> 1) + this.rectX;
        this.completeY = (this.heightRect - ResourceManager.imgCompleted.getHeight() >>> 1) + this.rectY;
        this.yMenu = this.rectY - Common.largeFont.getHeight() >>> 1;
    }

    public final void setLevelData() {
        if (levelData == null) {
            String content = Common.getInstance().loadText(dataPath);
            levelData = Common.spliteString(content);
        }
    }

    protected void paint(Graphics g) {
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, Common.WIDTH, Common.HEIGHT);
        try {
            g.setFont(Common.largeFont);
            g.drawImage(ResourceManager.imgBackground, 0, 0, 20);
            switch (this.state) {
                case 0: {
                    int i;
                    g.drawImage(ResourceManager.imgStage, Common.HALF_WIDTH, Common.HALF_HEIGHT, 3);
                    g.drawImage(ResourceManager.imgGameMenuFocus[CanvasMenu.curMode], Common.HALF_WIDTH, this.yMenu, 17);
                    if (CanvasMenu.completeMode[CanvasMenu.curMode]) {
                        g.drawImage(ResourceManager.imgCompleted, Common.HALF_WIDTH + ResourceManager.imgGameMenuFocus[CanvasMenu.curMode].getWidth() / 2, this.yMenu, 20);
                    }
                    g.drawImage(ResourceManager.imgSelectLevel, this.rectX + this.widthRect * (this.indexSelect % 4), this.rectY + this.heightRect * (this.indexSelect / 4), 20);
                    for (i = 0; i < 20; ++i) {
                        if (!Common.PASS_LEVEL[CanvasMenu.curMode * 20 + i]) continue;
                        g.drawImage(ResourceManager.imgCompleted, this.completedX + this.widthRect * (i % 4), this.completeY + this.heightRect * (i / 4), 20);
                    }
                    g.setColor(0);
                    for (i = 0; i < 20; ++i) {
                        String num = CanvasMenu.curMode * 20 + i + 1 + "";
                        int widthNum = Common.largeFont.stringWidth(num);
                        int x = this.rectX + (this.widthRect - widthNum >>> 1);
                        int y = this.rectY + (this.heightRect - this.heightLargeFont >>> 1);
                        g.drawString(num, x + this.widthRect * (i % 4), y + this.heightRect * (i / 4), 20);
                    }
                    g.drawImage(ResourceManager.imgEnter, 0, Common.HEIGHT, 36);
                    g.drawImage(ResourceManager.imgBack, Common.WIDTH, Common.HEIGHT, 40);
                    break;
                }
                case 1: {
                    g.drawImage(ResourceManager.imgHelp, Common.HALF_WIDTH, Common.HALF_HEIGHT, 3);
                    g.drawImage(ResourceManager.imgOK, 0, Common.HEIGHT, 36);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void pointerReleased(int x, int y) {
        switch (this.state) {
            case 0: {
                if (CanvasGame.pointArea(x, y, 0, Common.HEIGHT - 50, 50, 50)) {
                    this.keyReleased(Common.KEY_SOFT_LEFT);
                    break;
                }
                if (CanvasGame.pointArea(x, y, Common.WIDTH - 50, Common.HEIGHT - 50, 50, 50)) {
                    this.keyReleased(Common.KEY_SOFT_RIGHT);
                    break;
                }
                if (!CanvasGame.pointArea(x, y, this.rectX, this.rectY, this.widthRect * 4, this.heightRect * 5)) break;
                this.indexSelect = (y - this.rectY) / this.heightRect * 4 + (x - this.rectX) / this.widthRect;
                this.repaint();
                this.keyReleased(Common.KEY_SOFT_LEFT);
                break;
            }
            case 1: {
                this.keyReleased(Common.KEY_FIRE);
            }
        }
    }

    protected void keyReleased(int key) {
        if (this.state == 1) {
            if (key == Common.KEY_SOFT_LEFT || key == Common.KEY_FIRE || key == 53) {
                this.state = 0;
                this.keyReleased(Common.KEY_FIRE);
            }
        } else if (key == Common.KEY_UP || key == 50) {
            this.indexSelect -= 4;
            if (this.indexSelect < 0) {
                this.indexSelect = 20 + this.indexSelect;
            }
            this.repaint();
        } else if (key == Common.KEY_DOWN || key == 56) {
            this.indexSelect += 4;
            if (this.indexSelect >= 20) {
                this.indexSelect -= 20;
            }
            this.repaint();
        } else if (key == Common.KEY_LEFT || key == 52) {
            --this.indexSelect;
            if (this.indexSelect < 0) {
                this.indexSelect = 19;
            }
            this.repaint();
        } else if (key == Common.KEY_RIGHT || key == 54) {
            ++this.indexSelect;
            if (this.indexSelect >= 20) {
                this.indexSelect = 0;
            }
            this.repaint();
        } else if (key == Common.KEY_FIRE || key == 53 || key == Common.KEY_SOFT_LEFT) {
            if (isFirst) {
                isFirst = false;
                ResourceManager.loadHelp();
                this.state = 1;
                this.repaint();
            } else {
                this.showGame();
            }
        } else if (key == Common.KEY_SOFT_RIGHT) {
            MidletPuzzle.midlet.showCanvasMenu();
        }
    }

    public static final int[] getLevelData(String source, char ch) {
        int i;
        if (source == null) {
            return null;
        }
        int[] result = null;
        Vector<String> vector = new Vector<String>();
        int startIndex = 0;
        String element = null;
        for (i = 0; i < source.length(); ++i) {
            if (source.charAt(i) == ch) {
                element = source.substring(startIndex, i);
                vector.addElement(element);
                startIndex = i + 1;
                continue;
            }
            if (i != source.length() - 1) continue;
            element = source.substring(startIndex);
            vector.addElement(element);
            break;
        }
        result = new int[vector.size()];
        for (i = 0; i < result.length; ++i) {
            String num = (String)vector.elementAt(i);
            result[i] = Integer.parseInt(num);
        }
        return result;
    }

    public final void showGame() {
        this.setLevelData();
        ResourceManager.loadGame();
        this.curLevel = this.indexSelect + CanvasMenu.curMode * 20;
        this.canvasGame = new CanvasGame(this.curLevel);
        MidletPuzzle.display.setCurrent((Displayable)this.canvasGame);
    }

    static {
        isFirst = true;
    }
}

