/*
 * Decompiled with CFR 0.152.
 */
package com.astrolink;

import com.astrolink.CanvasGame;
import com.astrolink.CanvasMenu;
import com.astrolink.Common;
import com.astrolink.ResourceManager;
import javax.microedition.lcdui.Image;

public class Brick {
    public static final int ROWS = 6;
    public static final int COLS = 6;
    public static final boolean[][] STUFFED_BRICK = new boolean[6][6];
    public static int WIDTH_CELL = ResourceManager.imgBricks[0].getWidth() >>> 1;
    public static final int X_START = Common.WIDTH - WIDTH_CELL * 6 >>> 1;
    public static final int Y_START = Common.HEIGHT - WIDTH_CELL * 6 >>> 1;
    public static final int X_HALF = (WIDTH_CELL * 6 >>> 1) + X_START;
    public static final int Y_HALF = (WIDTH_CELL * 6 >>> 1) + Y_START;
    public static final int[] CODES_BRICK = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 42, 35, Common.KEY_FIRE};
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int SHORTTER = 2;
    public static final int LONGER = 3;
    private boolean isKey;
    private boolean isActivity;
    private int positionX;
    private int positionY;
    public int x;
    public int y;
    private int type;
    private int size;
    private int width;
    private int height;
    private int code;
    public Image image;
    public Image imgCode;
    public int xCode;
    public int yCode;
    public int index;
    public static boolean isWin;
    private int boundPosition;
    private boolean reachBound;

    public Brick(int[] data, int index) {
        this.index = index;
        this.setPositionX(data[0]);
        this.setPositionY(data[1]);
        this.x = X_START + this.getPositionX() * WIDTH_CELL;
        this.y = Y_START + this.getPositionY() * WIDTH_CELL;
        this.setType(data[2]);
        this.setSize(data[3]);
        this.setDimention();
        this.setCode();
        this.setStuffed();
    }

    public static final void resetStuffed() {
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 6; ++j) {
                Brick.STUFFED_BRICK[i][j] = false;
            }
        }
    }

    final void setStuffed() {
        switch (this.type) {
            case 0: {
                for (int i = this.positionX; i < this.positionX + this.size; ++i) {
                    Brick.STUFFED_BRICK[i][this.positionY] = true;
                }
                break;
            }
            case 1: {
                for (int i = this.positionY; i < this.positionY + this.size; ++i) {
                    Brick.STUFFED_BRICK[this.positionX][i] = true;
                }
                break;
            }
        }
    }

    public final void setKeyBrickCode() {
        this.setCode(CODES_BRICK[CODES_BRICK.length - 1]);
        this.imgCode = ResourceManager.imgNums[CODES_BRICK.length - 1];
        this.setCodePosition();
    }

    public final void setCode() {
        this.setCode(CODES_BRICK[this.index]);
        this.imgCode = ResourceManager.imgNums[this.index];
        this.setCodePosition();
    }

    final void setCodePosition() {
        this.xCode = this.x + (this.width - this.imgCode.getWidth() >>> 1);
        this.yCode = this.y + (this.height - this.imgCode.getHeight() >>> 1);
    }

    public final void moveUp() {
        if (this.type == 1) {
            if ((this.getPositionY() == 0 || STUFFED_BRICK[this.positionX][this.positionY - 1]) && CanvasMenu.hasMusic) {
                CanvasGame.playHit();
            }
            if (this.getPositionY() > 0 && !STUFFED_BRICK[this.positionX][this.positionY - 1]) {
                Brick.STUFFED_BRICK[this.positionX][this.positionY - 1] = true;
                Brick.STUFFED_BRICK[this.positionX][this.positionY + this.size - 1] = false;
                this.setPositionY(this.getPositionY() - 1);
                if ((this.getPositionY() == 0 || this.getPositionY() > 0 && STUFFED_BRICK[this.positionX][this.positionY - 1]) && CanvasMenu.hasMusic) {
                    CanvasGame.playHit();
                }
                this.y -= WIDTH_CELL;
                this.setCodePosition();
            }
        }
    }

    public final void moveDown() {
        if (this.type == 1) {
            if ((this.getPositionY() + this.size == 6 || STUFFED_BRICK[this.positionX][this.positionY + this.size]) && CanvasMenu.hasMusic) {
                CanvasGame.playHit();
            }
            if (this.getPositionY() + this.size < 6 && !STUFFED_BRICK[this.positionX][this.positionY + this.size]) {
                Brick.STUFFED_BRICK[this.positionX][this.positionY + this.size] = true;
                Brick.STUFFED_BRICK[this.positionX][this.positionY] = false;
                this.setPositionY(this.getPositionY() + 1);
                if ((this.getPositionY() + this.size == 6 || this.getPositionY() + this.size < 6 && STUFFED_BRICK[this.positionX][this.positionY + this.size]) && CanvasMenu.hasMusic) {
                    CanvasGame.playHit();
                }
                this.y += WIDTH_CELL;
                this.setCodePosition();
            }
        }
    }

    public final void moveLeft() {
        if (this.type == 0) {
            if ((this.getPositionX() == 0 || STUFFED_BRICK[this.positionX - 1][this.positionY]) && CanvasMenu.hasMusic) {
                CanvasGame.playHit();
            }
            if (this.getPositionX() > 0 && !STUFFED_BRICK[this.positionX - 1][this.positionY]) {
                Brick.STUFFED_BRICK[this.positionX - 1][this.positionY] = true;
                Brick.STUFFED_BRICK[this.positionX + this.size - 1][this.positionY] = false;
                this.setPositionX(this.getPositionX() - 1);
                if ((this.getPositionX() == 0 || this.getPositionX() > 0 && STUFFED_BRICK[this.positionX - 1][this.positionY]) && CanvasMenu.hasMusic) {
                    CanvasGame.playHit();
                }
                this.x -= WIDTH_CELL;
                this.setCodePosition();
            }
        }
    }

    public final void moveRight() {
        if (this.type == 0) {
            if ((this.getPositionX() + this.size == 6 || STUFFED_BRICK[this.positionX + this.size][this.positionY]) && CanvasMenu.hasMusic) {
                CanvasGame.playHit();
            }
            if (this.getPositionX() + this.size < 6 && !STUFFED_BRICK[this.positionX + this.size][this.positionY]) {
                Brick.STUFFED_BRICK[this.positionX + this.size][this.positionY] = true;
                Brick.STUFFED_BRICK[this.positionX][this.positionY] = false;
                this.setPositionX(this.getPositionX() + 1);
                this.x += WIDTH_CELL;
                this.setCodePosition();
                if (this.getIsKey() && this.positionX + this.size >= 6) {
                    isWin = true;
                } else if ((this.getPositionX() + this.size == 6 || this.getPositionX() + this.size < 6 && STUFFED_BRICK[this.positionX + this.size][this.positionY]) && CanvasMenu.hasMusic) {
                    CanvasGame.playHit();
                }
            }
        }
    }

    public void setImage() {
        block0 : switch (this.type) {
            case 0: {
                switch (this.size) {
                    case 2: {
                        if (this.getIsKey()) {
                            this.image = ResourceManager.imgBricks[0];
                            break;
                        }
                        this.image = ResourceManager.imgBricks[1];
                        break;
                    }
                    case 3: {
                        this.image = ResourceManager.imgBricks[2];
                    }
                }
                break;
            }
            case 1: {
                switch (this.size) {
                    case 2: {
                        this.image = ResourceManager.imgBricks[3];
                        break block0;
                    }
                    case 3: {
                        this.image = ResourceManager.imgBricks[4];
                    }
                }
            }
        }
    }

    public void setDimention() {
        block0 : switch (this.type) {
            case 0: {
                switch (this.size) {
                    case 2: {
                        this.setWidth(2 * WIDTH_CELL);
                        this.setHeight(WIDTH_CELL);
                        break;
                    }
                    case 3: {
                        this.setWidth(3 * WIDTH_CELL);
                        this.setHeight(WIDTH_CELL);
                    }
                }
                break;
            }
            case 1: {
                switch (this.size) {
                    case 2: {
                        this.setWidth(WIDTH_CELL);
                        this.setHeight(2 * WIDTH_CELL);
                        break block0;
                    }
                    case 3: {
                        this.setWidth(WIDTH_CELL);
                        this.setHeight(3 * WIDTH_CELL);
                    }
                }
            }
        }
    }

    public boolean getIsKey() {
        return this.isKey;
    }

    public void setIsKey(boolean isKey) {
        this.isKey = isKey;
        if (isKey) {
            this.setType(0);
            this.setSize(2);
        }
        this.setKeyBrickCode();
    }

    public boolean getIsActivity() {
        return this.isActivity;
    }

    public void setIsActivity(boolean isActivity) {
        this.isActivity = isActivity;
    }

    public int getPositionX() {
        return this.positionX;
    }

    public void setPositionX(int positionX) {
        this.positionX = positionX;
    }

    public int getPositionY() {
        return this.positionY;
    }

    public void setPositionY(int positionY) {
        this.positionY = positionY;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public int getBoundPosition() {
        return this.boundPosition;
    }

    public void setBoundPosition(int x) {
        this.boundPosition = x;
    }

    public void setBoundPosition() {
        switch (this.type) {
            case 0: {
                if (this.x < X_HALF) {
                    this.boundPosition = (this.positionX - 6 + 1) * WIDTH_CELL;
                    break;
                }
                this.boundPosition = this.positionX * WIDTH_CELL + Common.WIDTH;
                break;
            }
            case 1: {
                this.boundPosition = this.y < Y_HALF ? (this.positionY - 6 + 1) * WIDTH_CELL : this.positionY * WIDTH_CELL + Common.HEIGHT;
            }
        }
    }

    public boolean isReachBound() {
        return this.reachBound;
    }

    public void setReachBound(boolean reachBound) {
        this.reachBound = reachBound;
    }
}

