/*
 * Decompiled with CFR 0.152.
 */
package com.vodafone.v10.sound;

import com.vodafone.v10.sound.SoundTrack;

public class SoundPlayer {
    private static final int MAX_TRACKS = 16;
    private SoundTrack[] tracks = new SoundTrack[16];

    private SoundPlayer() {
    }

    public void disposePlayer() {
    }

    public void disposeTrack(SoundTrack t) {
        if (t == null) {
            throw new NullPointerException("soundTrack is null!");
        }
        int i2 = 0;
        while (i2 < 16) {
            if (this.tracks[i2] == t) {
                this.tracks[i2] = null;
            }
            ++i2;
        }
    }

    public static SoundPlayer getPlayer() {
        return new SoundPlayer();
    }

    public SoundTrack getTrack() {
        int i2 = 0;
        while (i2 < 16) {
            if (this.tracks[i2] == null) {
                this.tracks[i2] = new SoundTrack();
                return this.tracks[i2];
            }
            ++i2;
        }
        throw new IllegalStateException("no more tracks available!");
    }

    public SoundTrack getTrack(int track) {
        if (track >= 16 || track < 0) {
            throw new IllegalArgumentException();
        }
        if (this.tracks[track] != null) {
            throw new IllegalStateException("track is in use");
        }
        this.tracks[track] = new SoundTrack();
        return this.tracks[track];
    }

    public int getTrackCount() {
        int count = 0;
        int i2 = 0;
        while (i2 < 16) {
            if (this.tracks[i2] == null) {
                ++count;
            }
            ++i2;
        }
        return count;
    }

    public void kill() {
        int i2 = 0;
        while (i2 < 16) {
            SoundTrack st = this.tracks[i2];
            if (st != null) {
                st.stop();
                st.setSound(null);
            }
            ++i2;
        }
    }

    public void pause() {
        int i2 = 0;
        while (i2 < 16) {
            SoundTrack st = this.tracks[i2];
            if (st != null) {
                st.pause();
            }
            ++i2;
        }
    }

    public void resume() {
        int i2 = 0;
        while (i2 < 16) {
            SoundTrack st = this.tracks[i2];
            if (st != null) {
                st.resume();
            }
            ++i2;
        }
    }
}

