/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.io;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connection;
import ole.pstros.MainApp;
import ole.pstros.io.ConnectionManager;
import ole.pstros.io.ConnectionProvider;

public class Connector {
    public static final int READ = 1;
    public static final int READ_WRITE = 3;
    public static final int WRITE = 2;
    private static boolean initialised;
    private static final String NOT_SUPPORTED = "pstros: not supported. Scheme=";

    public static Connection open(String name) throws IOException {
        if (MainApp.verbose) {
            System.out.println("Connector.open name=" + name);
        }
        ConnectionProvider cp = Connector.getProvider(name);
        return cp.open(name, 3, false);
    }

    public static Connection open(String name, int mode) throws IOException {
        if (MainApp.verbose) {
            System.out.println("Connector.open name=" + name + " mode=" + mode);
        }
        ConnectionProvider cp = Connector.getProvider(name);
        return cp.open(name, mode, false);
    }

    public static Connection open(String name, int mode, boolean timeouts) throws IOException {
        if (MainApp.verbose) {
            System.out.println("Connector.open name=" + name + " mode=" + mode + " timeouts=" + timeouts);
        }
        ConnectionProvider cp = Connector.getProvider(name);
        return cp.open(name, mode, timeouts);
    }

    public static DataInputStream openDataInputStream(String name) throws IOException {
        if (MainApp.verbose) {
            System.out.println("Connector.openDataInputStream name=" + name);
        }
        ConnectionProvider cp = Connector.getProvider(name);
        return cp.openDataInputStream(name);
    }

    public static DataOutputStream openDataOutputStream(String name) throws IOException {
        if (MainApp.verbose) {
            System.out.println("Connector.openDataOutputStream name=" + name);
        }
        ConnectionProvider cp = Connector.getProvider(name);
        return cp.openDataOutputStream(name);
    }

    public static InputStream openInputStream(String name) throws IOException {
        if (MainApp.verbose) {
            System.out.println("Connector.openInputStream name=" + name);
        }
        ConnectionProvider cp = Connector.getProvider(name);
        return cp.openInputStream(name);
    }

    public static OutputStream openOutputStream(String name) throws IOException {
        if (MainApp.verbose) {
            System.out.println("Connector.openOutputStream name=" + name);
        }
        ConnectionProvider cp = Connector.getProvider(name);
        return cp.openOutputStream(name);
    }

    private static String getScheme(String name) {
        int i2 = name.indexOf(":");
        if (i2 < 0) {
            return null;
        }
        return name.substring(0, i2);
    }

    private static ConnectionProvider getProvider(String name) throws IOException {
        String scheme = Connector.getScheme(name);
        ConnectionProvider cp = ConnectionManager.getProvider(scheme);
        if (cp == null) {
            throw new IOException(NOT_SUPPORTED + scheme);
        }
        return cp;
    }
}

