/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.awt.Graphics;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.EmuCommandListener;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.Screen;
import ole.pstros.MainApp;

public class Alert
extends Screen {
    public static final Command DISMISS_COMMAND = new Command("Dismiss", 4, 0);
    public static final int FOREVER = -2;
    private String text;
    private Image image;
    private AlertType alertType;
    private int timeout;
    private Displayable emuNextDisplayable;

    public Alert(String title) {
        this(title, null, null, null);
    }

    public Alert(String title, String alertText, Image alertImage, AlertType alertType) {
        this.setTitle(title);
        this.text = alertText;
        this.image = alertImage;
        this.alertType = alertType;
        this.timeout = 3000;
        if (MainApp.verbose) {
            System.out.println("Alert created: type=" + alertType.type + " title=" + title);
        }
        this.leftCommand = DISMISS_COMMAND;
    }

    public int getDefaultTimeout() {
        return 3000;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int time) {
        if (MainApp.verbose) {
            System.out.println("Alert: setTimeout=" + time);
        }
        this.timeout = time;
    }

    public AlertType getType() {
        return this.alertType;
    }

    public void setType(AlertType type) {
        if (MainApp.verbose) {
            System.out.println("Alert: setType=" + this.alertType);
        }
        this.alertType = type;
    }

    public String getString() {
        return this.text;
    }

    public void setString(String str) {
        this.text = str;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image img) {
        this.image = img;
    }

    public void addCommand(Command cmd) {
        if (this.leftCommand == DISMISS_COMMAND) {
            this.leftCommand = null;
        }
        super.addCommand(cmd);
    }

    public void removeCommand(Command cmd) {
        this.leftCommand = DISMISS_COMMAND;
    }

    public void setCommandListener(CommandListener l2) {
        super.setCommandListener(l2);
    }

    void emuPaintScreenContent(Graphics g2) {
        int y = 28;
        if (this.image != null) {
            g2.drawImage(this.image.emuGetImage(0), (Display.WIDTH - this.image.getWidth()) / 2, y, null);
            y += this.image.getHeight() + 4;
        }
        if (this.text != null) {
            Item.emuDrawMultiLine(g2, this.text, 0, y, true);
        }
    }

    void emuSetNextDisplayable(Displayable d2) {
        this.emuNextDisplayable = d2;
        EmuCommandListener ecl = new EmuCommandListener(this.emuNextDisplayable, 0);
        this.setCommandListener(ecl);
    }

    Displayable emuGetNextDisplayable() {
        return this.emuNextDisplayable;
    }
}

