/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Item;
import javax.microedition.midlet.MIDlet;
import ole.pstros.ConfigData;
import ole.pstros.EmuCanvas;
import ole.pstros.MainApp;
import ole.pstros.utils.AlertTimerTask;

public class Display {
    public static final int COLOR_BACKGROUND = 0;
    public static final int COLOR_FOREGROUND = 1;
    public static final int COLOR_HIGHLIGHTED_BACKGROUND = 2;
    public static final int COLOR_HIGHLIGHTED_FOREGROUND = 3;
    public static final int COLOR_BORDER = 4;
    public static final int COLOR_HIGHLIGHTED_BORDER = 5;
    public static int keySoftLeft = 90;
    public static int keySoftLeft2 = 112;
    public static int keySoftRight = 67;
    public static int keySoftRight2 = 113;
    public static int keySoftCenter = 88;
    public static int keyLeft = 37;
    public static int keyUp = 38;
    public static int keyRight = 39;
    public static int keyDown = 40;
    public static int keyFire = 17;
    public static int keyFire2 = 10;
    public static int keyNum0 = 96;
    public static int keyNum7 = 97;
    public static int keyNum8 = 98;
    public static int keyNum9 = 99;
    public static int keyNum4 = 100;
    public static int keyNum5 = 101;
    public static int keyNum6 = 102;
    public static int keyNum1 = 103;
    public static int keyNum2 = 104;
    public static int keyNum3 = 105;
    public static int keyStar = 106;
    public static int keyCross = 111;
    public static int keyRotate = 115;
    public static int keyPause = 116;
    public static int keyVirtual1 = 117;
    public static int keyVirtual2 = 118;
    public static int keyVirtual3 = 119;
    public static int keyScreenShot = 122;
    public static int keyCaptureVideo = 123;
    public static int keyShowHideNotify = 120;
    public static int WIDTH = 176;
    public static int HEIGHT = 220;
    private static final String titleName = "Pstros";
    private static HashMap displays = new HashMap();
    private static Displayable displayable;
    private static Frame emuFrame;
    private static EmuCanvas emuCanvas;
    private static Runnable emuSerialRunner;
    private static boolean emulationStarted;

    static {
        emulationStarted = false;
    }

    public static void emuDestroyFrame() {
        if (emuFrame != null) {
            WindowEvent ev = new WindowEvent(emuFrame, 201, null, 200, 202);
            emuFrame.dispatchEvent(ev);
            emuFrame.dispose();
            emuCanvas = null;
            emuFrame = null;
        } else if (!ConfigData.slaveMode) {
            System.out.println("Emu frame is null!");
        }
        if (!ConfigData.slaveMode) {
            System.exit(0);
        } else {
            MainApp.midletBridge.handleEvent(4, MainApp.midlet);
            MainApp.getInstance().setEvent("emuClosed", null);
        }
    }

    void emuBackupFrame() {
        emuCanvas.backupImage();
    }

    void emuRestoreFrame() {
        emuCanvas.restoreImage();
    }

    public static synchronized boolean emuRunSerialRunner() {
        if (emuSerialRunner != null) {
            if (MainApp.verbose) {
                System.out.println("EmuCanvas: calling the runner=" + emuSerialRunner);
            }
            Runnable tmp = emuSerialRunner;
            emuSerialRunner = null;
            tmp.run();
            return true;
        }
        return false;
    }

    public static Display getDisplay(MIDlet m2) {
        Object d2 = displays.get(m2);
        if (d2 == null) {
            d2 = new Display();
            displays.put(m2, d2);
        }
        if (MainApp.verbose) {
            System.out.println("EmuCanvas: getDisplay=" + d2);
        }
        return (Display)d2;
    }

    public void emuRepaintDisplay() {
        if (emuCanvas != null) {
            emuCanvas.setEmuPaintRequest(0, 0, WIDTH, HEIGHT);
            emuCanvas.repaint();
        }
    }

    private Display() {
    }

    public boolean isColor() {
        return true;
    }

    public int numColors() {
        return 415030;
    }

    public int numAlphaLevels() {
        return 255;
    }

    public void setCurrent(Alert alert, Displayable nextDisplayable) {
        if (alert == null || nextDisplayable == null) {
            throw new NullPointerException();
        }
        if (alert == nextDisplayable) {
            throw new IllegalArgumentException();
        }
        if (MainApp.verbose) {
            System.out.println("Display: setCurrent Alert! nextDisplayable=" + nextDisplayable);
        }
        alert.emuSetNextDisplayable(nextDisplayable);
        this.setCurrent(alert);
    }

    public void setCurrent(Displayable nextDisplayable) {
        if (MainApp.verbose) {
            if (nextDisplayable != null) {
                System.out.println("Display: setCurrent displayable=" + nextDisplayable.toString() + " old displayable=" + displayable);
            } else {
                System.out.println("Display: setCurrent displayable=null");
            }
        }
        if (displayable != null) {
            Display.displayable.shown = false;
        }
        if (nextDisplayable == null) {
            return;
        }
        if (nextDisplayable instanceof Alert) {
            Alert alert = (Alert)nextDisplayable;
            if (alert.getTimeout() > 0) {
                Displayable displayableAfterAlert = displayable;
                if (alert.emuGetNextDisplayable() != null) {
                    displayableAfterAlert = alert.emuGetNextDisplayable();
                }
                AlertTimerTask tt = new AlertTimerTask(this, displayableAfterAlert);
                Timer alertTimer = new Timer();
                alertTimer.schedule((TimerTask)tt, alert.getTimeout());
            } else if (alert.emuGetNextDisplayable() == null && displayable != null) {
                alert.emuSetNextDisplayable(displayable);
            }
        }
        if ((displayable = nextDisplayable) != null) {
            Display.displayable.shown = true;
        }
        Display.emuRunEmulation();
        emuCanvas.setContent(displayable, Display.displayable.emuLcduiBridge);
    }

    public Displayable getCurrent() {
        return displayable;
    }

    public void setCurrentItem(Item item) {
        Displayable d2 = item.emuGetDisplayable();
        if (d2 instanceof Alert) {
            throw new IllegalStateException("item owned by Alert");
        }
        if (d2 == null) {
            throw new IllegalStateException("item not owned by a container");
        }
        if (d2 != this.getCurrent()) {
            this.setCurrent(d2);
        }
    }

    public boolean vibrate(int duration) {
        if (duration < 0) {
            throw new IllegalArgumentException("Duration is negative : value=" + duration);
        }
        return true;
    }

    public synchronized void callSerially(Runnable r2) {
        if (MainApp.verbose) {
            System.out.println("Pstros: Display.callSerially r=" + r2);
        }
        emuSerialRunner = r2;
    }

    public boolean flashBacklight(int duration) {
        if (MainApp.verbose) {
            System.out.println("Pstros: flashBacklight duration=" + duration);
        }
        return emulationStarted;
    }

    public int getBestImageWidth(int imageType) {
        return 0;
    }

    public int getBestImageHeight(int imageType) {
        return 0;
    }

    public int getBorderStyle(boolean highlighted) {
        return 0;
    }

    public int getColor(int colorSpecifier) {
        switch (colorSpecifier) {
            case 0: {
                return 0x808080;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 0x989898;
            }
            case 3: {
                return 0xFF0000;
            }
            case 4: {
                return 0x606060;
            }
            case 5: {
                return 0xFF0000;
            }
        }
        throw new IllegalArgumentException();
    }

    public static void emuRotateDisplay() {
        if (!emulationStarted) {
            return;
        }
        if (ConfigData.slaveMode) {
            return;
        }
        if (MainApp.verbose) {
            System.out.println("emuRotateDisplay");
        }
        int w = WIDTH;
        int h2 = HEIGHT;
        if (ConfigData.originalScreenWidth > 0) {
            if (w == ConfigData.originalScreenWidth) {
                WIDTH = ConfigData.rotatedScreenWidth;
                HEIGHT = ConfigData.rotatedScreenHeight;
            } else {
                WIDTH = ConfigData.originalScreenWidth;
                HEIGHT = ConfigData.originalScreenHeight;
            }
        } else {
            WIDTH = h2;
            HEIGHT = w;
        }
        Display.emuInitFrame();
        emuCanvas.init();
    }

    private static void emuInitFrame() {
        if (emuFrame != null) {
            emuFrame.setVisible(false);
            emuFrame.dispose();
        }
        emuFrame = new Frame();
        int w = WIDTH * ConfigData.scale;
        int h2 = HEIGHT * ConfigData.scale;
        if (ConfigData.skinWidth > 0 && ConfigData.skinHeight > 0) {
            w = ConfigData.skinWidth;
            h2 = ConfigData.skinHeight;
        } else {
            ConfigData.skinScreenX = 0;
            ConfigData.skinScreenY = 0;
        }
        emuFrame.setSize(10, 10);
        emuFrame.setResizable(false);
        emuFrame.setLocation(ConfigData.windowPositionX, ConfigData.windowPositionY);
        emuFrame.addWindowListener(emuCanvas);
        emuFrame.add(emuCanvas);
        Display.emuSetTitle(0, 0, ConfigData.videoMemoryLimit >> 10, 0);
        emuFrame.show();
        Insets insets = emuFrame.getInsets();
        emuFrame.setSize(w += insets.right + insets.left, h2 += insets.bottom + insets.top);
        emuFrame.doLayout();
    }

    public static void emuRunEmulation() {
        if (emulationStarted) {
            return;
        }
        emulationStarted = true;
        if (MainApp.verbose) {
            System.out.println("runEmuFrame!");
        }
        emuCanvas = EmuCanvas.getInstance();
        emuCanvas.setParentComponent(MainApp.parentComponent);
        if (!ConfigData.slaveMode) {
            Display.emuInitFrame();
        }
        emuCanvas.init();
    }

    public static void emuSetTitle(int imageSize, int peakSize, int limit, int fps) {
        if (emuFrame != null) {
            emuFrame.setTitle("Pstros [" + imageSize + "/" + peakSize + "/" + limit + "] " + fps + " fps");
        }
    }

    public static void emuResizeEmuFrame() {
        if (emuFrame == null) {
            return;
        }
        if (ConfigData.skinWidth > 0 || ConfigData.skinHeight > 0) {
            return;
        }
        int w = WIDTH * ConfigData.scale;
        int h2 = HEIGHT * ConfigData.scale;
        Insets insets = emuFrame.getInsets();
        emuFrame.setSize(w += insets.right + insets.left, h2 += insets.bottom + insets.top);
        emuFrame.doLayout();
    }
}

