/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.awt.Graphics;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.EmuCommandListener;
import javax.microedition.lcdui.EmuLcduiBridge;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.Ticker;
import ole.pstros.ConfigData;
import ole.pstros.EmuCanvas;
import ole.pstros.IEmuBridge;
import ole.pstros.MainApp;

public abstract class Displayable {
    Command leftCommand;
    Command rightCommand;
    CommandListener listener;
    Form commandForm;
    EmuCommandListener commandFormListener;
    int displaybableAreaWidth;
    int displaybableAreaHeight;
    boolean shown;
    String title;
    Ticker ticker;
    EmuCanvas emuCanvas;
    int emuKeyStates;
    int emuNumStates;
    IEmuBridge emuLcduiBridge;

    abstract void emuPaint(Graphics var1);

    void emuCreateBridge() {
        this.emuLcduiBridge = new EmuLcduiBridge();
        this.emuLcduiBridge.handleEvent(0, this);
    }

    private boolean isOkCommandtype(Command c2) {
        return c2.getCommandType() == 4;
    }

    public void addCommand(Command cmd) throws NullPointerException {
        if (MainApp.verbose) {
            System.out.println("Displayable.addCommand =" + cmd.getLabel() + " type=" + cmd.getCommandType() + " command=" + cmd);
        }
        if (cmd == null) {
            throw new NullPointerException("command is null!");
        }
        if (this.leftCommand == cmd || this.rightCommand == cmd) {
            return;
        }
        boolean update = false;
        int commandType = cmd.getCommandType();
        if (this.leftCommand != null && this.rightCommand != null || this.commandForm != null) {
            if (this.commandForm == null) {
                this.commandForm = new Form(this.title);
                this.commandForm.append(this.leftCommand.getLabel());
                this.commandForm.append(this.rightCommand.getLabel());
                this.commandForm.addCommand(new Command("Select", 4, 1));
                this.commandForm.addCommand(new Command("Back", 2, 1));
                this.commandFormListener = new EmuCommandListener(this, 1);
                this.commandFormListener.addCommand(this.leftCommand);
                this.commandFormListener.addCommand(this.rightCommand);
                this.commandForm.listener = this.commandFormListener;
                this.leftCommand = new Command("Options", 1, 1);
                this.rightCommand = null;
                this.listener = new EmuCommandListener(this.commandForm, 0);
                update = true;
            }
            if (!this.commandForm.emuHasStringItem(cmd.getLabel())) {
                this.commandForm.append(cmd.getLabel());
                this.commandFormListener.addCommand(cmd);
            }
        } else if (commandType == 4) {
            update = this.addOkCommand(cmd);
        } else if (commandType == 2 || commandType == 3 || commandType == 7 || commandType == 8) {
            update = this.addBackCommand(cmd);
        } else if (this.leftCommand == null) {
            this.leftCommand = cmd;
            update = true;
        } else if (this.rightCommand == null) {
            this.rightCommand = cmd;
            update = true;
        }
        if (update) {
            this.emuUpdateScreen();
        }
    }

    private boolean addOkCommand(Command cmd) {
        if (ConfigData.keyLeftSoft == ConfigData.keySelect) {
            if (this.leftCommand == null || !this.isOkCommandtype(this.leftCommand)) {
                this.leftCommand = cmd;
                return true;
            }
        } else if (this.rightCommand == null) {
            this.rightCommand = cmd;
            return true;
        }
        return false;
    }

    private boolean addBackCommand(Command cmd) {
        if (ConfigData.keyLeftSoft != ConfigData.keySelect) {
            if (this.leftCommand == null) {
                this.leftCommand = cmd;
                return true;
            }
            return this.addOkCommand(cmd);
        }
        if (this.rightCommand == null) {
            this.rightCommand = cmd;
            return true;
        }
        return this.addOkCommand(cmd);
    }

    public void removeCommand(Command cmd) {
        if (cmd == null) {
            return;
        }
        boolean update = false;
        if (cmd == this.leftCommand) {
            this.leftCommand = null;
            update = true;
        } else if (cmd == this.rightCommand) {
            this.rightCommand = null;
            update = true;
        }
        if (update) {
            this.emuUpdateScreen();
        }
    }

    public void setCommandListener(CommandListener l2) {
        if (MainApp.verbose) {
            System.out.println("Displayable: setCommandListener to=" + this + " listener=" + l2);
        }
        if (this.commandForm != null) {
            this.commandFormListener.setCommandListener(l2);
        } else {
            this.listener = l2;
        }
    }

    public int getWidth() {
        return this.displaybableAreaWidth;
    }

    public int getHeight() {
        return this.displaybableAreaHeight;
    }

    protected void sizeChanged(int w, int h2) {
    }

    public boolean isShown() {
        return this.shown;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String s2) {
        this.title = s2;
        this.emuUpdateScreen();
    }

    public Ticker getTicker() {
        return this.ticker;
    }

    public void setTicker(Ticker t) {
        this.ticker = t;
        this.emuUpdateScreen();
    }

    void emuSetEmuCanvas(EmuCanvas c2) {
        this.emuKeyStates = 0;
        this.emuCanvas = c2;
    }

    void emuUpdateScreen() {
        if (this.emuCanvas != null) {
            if (ConfigData.slaveMode) {
                this.emuCanvas.update();
            } else {
                this.emuCanvas.repaint();
            }
        }
    }

    Command emuGetLeftCommand() {
        return this.leftCommand;
    }

    Command emuGetRightCommand() {
        return this.rightCommand;
    }

    boolean emuIsFullScreen() {
        return false;
    }

    boolean emuKeyAction(int key, int keyChar, int modifiers, int action) {
        if (MainApp.verbose) {
            System.out.println("Displayable.emuKeyAction key=" + key + " action=" + action + " ecs=" + Integer.toHexString(this.emuKeyStates));
        }
        if (action == 0) {
            if ((key == Display.keySoftLeft || key == Display.keySoftLeft2) && modifiers == 0) {
                if ((this.emuKeyStates & 0x1000000) == 0) {
                    this.emuKeyStates |= 0x1000000;
                    if (this.leftCommand != null) {
                        if (MainApp.verbose) {
                            System.out.println("pressed LEFT, command=" + this.leftCommand);
                        }
                        ItemCommandListener itemListener = null;
                        Object owner = this.leftCommand.owner;
                        Item item = null;
                        if (owner instanceof Item) {
                            item = (Item)owner;
                            itemListener = item.emuGetItemCommandListener();
                        }
                        if (itemListener != null) {
                            itemListener.commandAction(this.leftCommand, item);
                        } else if (this.listener != null) {
                            this.listener.commandAction(this.leftCommand, this);
                            return true;
                        }
                    }
                }
            } else if ((key == Display.keySoftRight || key == Display.keySoftRight2) && modifiers == 0) {
                if ((this.emuKeyStates & 0x4000000) == 0) {
                    this.emuKeyStates |= 0x4000000;
                    if (this.rightCommand != null) {
                        if (MainApp.verbose) {
                            System.out.println("pressed RIGHT, command=" + this.rightCommand);
                        }
                        ItemCommandListener itemListener = null;
                        Object owner = this.rightCommand.owner;
                        Item item = null;
                        if (owner instanceof Item) {
                            item = (Item)owner;
                            itemListener = item.emuGetItemCommandListener();
                        }
                        if (itemListener != null) {
                            itemListener.commandAction(this.rightCommand, item);
                        } else if (this.listener != null) {
                            this.listener.commandAction(this.rightCommand, this);
                        }
                        return true;
                    }
                }
            } else if (key == Display.keyFire2 || key == Display.keyFire) {
                if ((this.emuKeyStates & 0x100) == 0) {
                    this.emuKeyStates |= 0x100;
                }
            } else if (key == Display.keyLeft) {
                if ((this.emuKeyStates & 4) == 0) {
                    this.emuKeyStates |= 4;
                }
            } else if (key == Display.keyRight) {
                if ((this.emuKeyStates & 0x20) == 0) {
                    this.emuKeyStates |= 0x20;
                }
            } else if (key == Display.keyUp) {
                if ((this.emuKeyStates & 2) == 0) {
                    this.emuKeyStates |= 2;
                }
            } else if (key == Display.keyDown && (this.emuKeyStates & 0x40) == 0) {
                this.emuKeyStates |= 0x40;
            }
        } else if (action == 1) {
            if ((key == Display.keySoftLeft || key == Display.keySoftLeft2) && modifiers == 0) {
                if ((this.emuKeyStates & 0x1000000) != 0) {
                    this.emuKeyStates &= 0xFEFFFFFF;
                    if (this.listener != null && this.leftCommand != null) {
                        return true;
                    }
                }
            } else if ((key == Display.keySoftRight || key == Display.keySoftRight2) && modifiers == 0) {
                if ((this.emuKeyStates & 0x4000000) != 0) {
                    this.emuKeyStates &= 0xFBFFFFFF;
                    if (this.listener != null && this.leftCommand != null) {
                        return true;
                    }
                }
            } else if (key == Display.keyLeft) {
                if ((this.emuKeyStates & 4) != 0) {
                    this.emuKeyStates &= 0xFFFFFFFB;
                }
            } else if (key == Display.keyRight) {
                if ((this.emuKeyStates & 0x20) != 0) {
                    this.emuKeyStates &= 0xFFFFFFDF;
                }
            } else if (key == Display.keyUp) {
                if ((this.emuKeyStates & 2) != 0) {
                    this.emuKeyStates &= 0xFFFFFFFD;
                }
            } else if (key == Display.keyDown) {
                if ((this.emuKeyStates & 0x40) != 0) {
                    this.emuKeyStates &= 0xFFFFFFBF;
                }
            } else if ((key == Display.keyFire2 || key == Display.keyFire) && (this.emuKeyStates & 0x100) != 0) {
                this.emuKeyStates &= 0xFFFFFEFF;
            }
        }
        return false;
    }

    void emuSetShown(boolean state) {
        this.shown = state;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "@" + this.hashCode();
    }
}

