/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.util.Vector;

public class Font {
    public static final int STYLE_PLAIN = 0;
    public static final int STYLE_BOLD = 1;
    public static final int STYLE_ITALIC = 2;
    public static final int STYLE_UNDERLINED = 4;
    public static final int SIZE_SMALL = 8;
    public static final int SIZE_MEDIUM = 0;
    public static final int SIZE_LARGE = 16;
    public static final int FACE_SYSTEM = 0;
    public static final int FACE_MONOSPACE = 32;
    public static final int FACE_PROPORTIONAL = 64;
    public static final int FONT_STATIC_TEXT = 0;
    public static final int FONT_INPUT_TEXT = 1;
    private static Vector fontCache = new Vector();
    private int face;
    private int style;
    private int size;
    private java.awt.Font emuFont;
    private static Font defaultFont = new Font(0, 0, 0);
    static FontRenderContext fontContext = new FontRenderContext(null, false, false);
    private static char[] charBuff = new char[1];

    private Font(int face, int style, int size) {
        String fontName;
        this.face = face;
        this.style = style;
        this.size = size;
        switch (face) {
            case 32: {
                fontName = "Monospaced";
                break;
            }
            case 64: {
                fontName = "Serif";
                break;
            }
            default: {
                fontName = "Dialog";
            }
        }
        int fontSize = 12;
        switch (size) {
            case 8: {
                fontSize = 10;
                break;
            }
            case 16: {
                fontSize = 14;
            }
        }
        this.emuFont = new java.awt.Font(fontName, style, fontSize);
    }

    public static Font getDefaultFont() {
        return defaultFont;
    }

    public static Font getFont(int fontSpecifier) {
        int size;
        int style;
        int face;
        switch (fontSpecifier) {
            case 0: {
                face = 64;
                style = 0;
                size = 8;
                break;
            }
            case 1: {
                face = 32;
                style = 0;
                size = 8;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid font specifier: " + fontSpecifier);
            }
        }
        return Font.getFont(face, style, size);
    }

    public static Font getFont(int face, int style, int size) {
        Font font;
        int cacheSize = fontCache.size();
        int i2 = 0;
        while (i2 < cacheSize) {
            font = (Font)fontCache.get(i2);
            if (font.getFace() == face && font.getStyle() == style && font.getSize() == size) {
                return font;
            }
            ++i2;
        }
        font = new Font(face, style, size);
        fontCache.add(font);
        return font;
    }

    public java.awt.Font emuGetFont() {
        return this.emuFont;
    }

    public int getStyle() {
        return this.style;
    }

    public int getSize() {
        return this.size;
    }

    public int getFace() {
        return this.face;
    }

    public boolean isPlain() {
        return this.style == 0;
    }

    public boolean isBold() {
        return (this.style & 1) != 0;
    }

    public boolean isItalic() {
        return (this.style & 2) != 0;
    }

    public boolean isUnderlined() {
        return (this.style & 4) != 0;
    }

    public int charWidth(char ch) {
        Font.charBuff[0] = ch;
        Rectangle2D rect = this.emuFont.getStringBounds(charBuff, 0, 1, fontContext);
        return (int)rect.getWidth();
    }

    public int charsWidth(char[] ch, int offset, int length) {
        return this.stringWidth(String.valueOf(ch, offset, length));
    }

    public int stringWidth(String str) {
        Rectangle2D rect = this.emuFont.getStringBounds(str, fontContext);
        return (int)rect.getWidth();
    }

    public int substringWidth(String str, int offset, int len) {
        return this.stringWidth(str.substring(offset, offset + len));
    }

    public int getHeight() {
        return this.emuFont.getSize() + 4;
    }

    public int getBaselinePosition() {
        LineMetrics lm = this.emuFont.getLineMetrics("pstros", fontContext);
        return (int)(lm.getAscent() + lm.getLeading());
    }
}

