/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.awt.Color;
import java.awt.Graphics;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.Screen;
import javax.microedition.lcdui.StringItem;

public class Form
extends Screen {
    private ItemStateListener itemListener;
    private int emuOffsY;

    public Form(String title) {
        this.setTitle(title);
    }

    public Form(String title, Item[] it) {
        this(title);
        this.setItems(it);
    }

    boolean emuHasStringItem(String text) {
        int max = this.items.size();
        int i2 = 0;
        while (i2 < max) {
            Object item = this.items.get(i2);
            if (item instanceof StringItem && ((StringItem)item).getText().equals(text)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public int append(Item item) {
        this.items.add(item);
        item.emuSetDisplayable(this);
        int position = this.items.indexOf(item);
        if (position == 0) {
            item.emuSetActive(true);
            Command itemCommand = item.emuGetDefaultCommand();
            if (itemCommand != null) {
                this.addCommand(itemCommand);
            }
        }
        return position;
    }

    public int append(String str) {
        StringItem i2 = new StringItem(null, str);
        i2.emuSetDisplayable(this);
        return this.append(i2);
    }

    public int append(Image img) {
        ImageItem i2 = new ImageItem(null, img, 0, null);
        i2.emuSetDisplayable(this);
        return this.append(i2);
    }

    public void insert(int itemNum, Item item) {
        item.emuSetDisplayable(this);
        this.items.add(itemNum, item);
    }

    public void delete(int itemNum) {
        this.items.remove(itemNum);
    }

    public void deleteAll() {
        this.items.clear();
    }

    public void set(int itemNum, Item item) {
        item.emuSetDisplayable(this);
        this.items.set(itemNum, item);
    }

    public Item get(int itemNum) {
        return (Item)this.items.get(itemNum);
    }

    public void setItemStateListener(ItemStateListener iListener) {
        this.itemListener = iListener;
    }

    public int size() {
        return this.items.size();
    }

    private void setItems(Item[] it) {
        if (it == null || it.length < 1) {
            return;
        }
        this.items.clear();
        int i2 = 0;
        while (i2 < it.length) {
            it[i2].emuSetActive(i2 == 0);
            this.items.add(it[i2]);
            ++i2;
        }
    }

    void emuPaintScreenContent(Graphics g2) {
        int itemHeight;
        Item item;
        int size = this.items.size();
        int sliderY = 0;
        int sliderH = 0;
        if (size < 1) {
            return;
        }
        g2.getClipBounds(tmpRect);
        int y = 0;
        int i2 = 0;
        while (i2 < size && i2 < this.selected) {
            item = (Item)this.items.get(i2);
            itemHeight = item.emuGetHeight(g2);
            y += itemHeight;
            ++i2;
        }
        sliderY = y;
        item = (Item)this.items.get(i2);
        if (item.emuIsMultiElement()) {
            itemHeight = item.emuGetElementHeight(g2);
            sliderH = item.emuGetHeight(g2);
        } else {
            sliderH = itemHeight = item.emuGetHeight(g2);
        }
        if (this.emuOffsY + y + itemHeight > Form.tmpRect.height) {
            this.emuOffsY = Form.tmpRect.height - y - itemHeight;
        } else if (this.emuOffsY + y < 0) {
            this.emuOffsY = -y;
        }
        y = 0;
        i2 = 0;
        while (i2 < size) {
            item = (Item)this.items.get(i2);
            int shiftY = item.emuGetYSpace(g2);
            int height = item.emuPaint(g2, 0, this.emuOffsY + y + shiftY + Form.tmpRect.y);
            y += height;
            ++i2;
        }
        if (y > Form.tmpRect.height) {
            g2.setColor(Item.COLOR_HIGHLIGT);
            g2.fillRect(Display.WIDTH - 2, Form.tmpRect.y, 2, Form.tmpRect.height);
            int posY = sliderY * Form.tmpRect.height / y;
            int sliderSize = sliderH * Form.tmpRect.height / y + 1;
            g2.setColor(Color.RED);
            g2.fillRect(Display.WIDTH - 2, Form.tmpRect.y + posY, 2, sliderSize);
        }
    }

    boolean emuKeyAction(int key, int keyChar, int modifiers, int action) {
        Command itemCommand;
        if (action == 1) {
            super.emuKeyAction(key, keyChar, modifiers, action);
            return true;
        }
        Item item = null;
        if (this.selected >= 0) {
            try {
                item = (Item)this.items.get(this.selected);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (item != null) {
                item.emuSetActive(false);
            }
        }
        int oldSelected = this.selected;
        super.emuKeyAction(key, keyChar, modifiers, action);
        if (oldSelected >= 0 && this.selected != oldSelected && (item = (Item)this.items.get(oldSelected)) != null && (itemCommand = item.emuGetDefaultCommand()) != null) {
            this.removeCommand(itemCommand);
        }
        if (this.selected >= 0 && (item = (Item)this.items.get(this.selected)) != null) {
            itemCommand = item.emuGetDefaultCommand();
            if (itemCommand != null) {
                this.addCommand(itemCommand);
            }
            item.emuSetActive(true);
            if (item.emuIsInteractive()) {
                item.emuKeyAction(key, keyChar, action);
            }
        }
        this.emuUpdateScreen();
        return true;
    }

    void emuFirePressed() {
        int max = this.items.size();
        if (max < 1 || this.selected < 0 || this.selected > max - 1) {
            return;
        }
        Item item = (Item)this.items.get(this.selected);
        if (item.emuIsInteractive()) {
            item.emuActionPressed();
            if (this.itemListener != null) {
                this.itemListener.itemStateChanged(item);
            }
        }
    }
}

