/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import com.nokia.mid.ui.DirectGraphics;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Image;
import ole.pstros.ConfigData;
import ole.pstros.MainApp;
import ole.pstros.exterior.ObjectProvider;
import ole.pstros.utils.ImageCreator;

public class Graphics
implements DirectGraphics,
ObjectProvider {
    private static final int EMU_BUFF_WIDTH = 480;
    private static final int EMU_BUFF_HEIGHT = 640;
    private static BufferedImage bi;
    private static int biWidth;
    private static int biHeight;
    private static java.awt.Graphics biGraphics;
    private static int[] pixelData;
    private static int[] polygonX;
    private static int[] polygonY;
    private static int[] polygonPointsX;
    private static int[] polygonPointsY;
    private static int[] tmpRgbData;
    private static final String lock = "Lock";
    public static final int HCENTER = 1;
    public static final int VCENTER = 2;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    public static final int TOP = 16;
    public static final int BOTTOM = 32;
    public static final int BASELINE = 64;
    public static final int SOLID = 0;
    public static final int DOTTED = 1;
    private static Rectangle emuTmpRect;
    protected int trX;
    protected int trY;
    private int color;
    private int strokeStyle;
    private int clX;
    private int clY;
    private int clW;
    private int clH;
    private Font font = Font.getDefaultFont();
    protected java.awt.Graphics emuGraphics;
    protected BufferedImage emuGraphicsImage;
    protected Image emuImage;
    int emuActionCounter;
    int emuDrawRegionCounter;

    static {
        polygonX = new int[32];
        polygonY = new int[32];
        emuTmpRect = new Rectangle();
    }

    public Graphics() {
        if (bi == null) {
            this.initBufferedImage(480, 640);
        }
    }

    private void initBufferedImage(int w, int h2) {
        int maxPixels = 307200;
        if (w * h2 > maxPixels) {
            if (w > 480) {
                h2 = maxPixels / 480;
            } else {
                w = maxPixels / 640;
            }
        }
        biWidth = w;
        biHeight = h2;
        bi = new BufferedImage(w, h2, 2);
        biGraphics = bi.getGraphics();
        pixelData = new int[307200];
    }

    public void emuSetImage(Image img) {
        this.emuImage = img;
    }

    public void emuSetGraphics(java.awt.Graphics eg) {
        this.emuGraphics = eg;
    }

    public java.awt.Graphics emuGetGraphics() {
        return this.emuGraphics;
    }

    public void emuSetGraphicsImage(BufferedImage bi) {
        this.emuGraphicsImage = bi;
    }

    public BufferedImage emuGetGraphicsImage() {
        return this.emuGraphicsImage;
    }

    public void translate(int x, int y) {
        if (MainApp.verbose) {
            System.out.println("Graphics: translate x=" + x + " y=" + y);
        }
        this.trX += x;
        this.trY += y;
    }

    public int getTranslateX() {
        return this.trX;
    }

    public int getTranslateY() {
        return this.trY;
    }

    public int getColor() {
        return this.color;
    }

    public int getDisplayColor(int col) {
        return col;
    }

    public int getRedComponent() {
        return this.color >> 16 & 0xFF;
    }

    public int getGreenComponent() {
        return this.color >> 8 & 0xFF;
    }

    public int getBlueComponent() {
        return this.color & 0xFF;
    }

    public int getGrayScale() {
        return (this.getRedComponent() + this.getGreenComponent() + this.getBlueComponent()) / 3;
    }

    public void setColor(int red, int green, int blue) {
        this.setColor(((red & 0xFF) << 16) + ((green & 0xFF) << 8) + (blue & 0xFF));
    }

    public void setColor(int RGB) {
        if (MainApp.verbose) {
            System.out.println("Graphics: setColor: color=" + RGB);
        }
        this.color = 0xFF000000 | RGB;
        this.emuGraphics.setColor(new Color(this.color));
    }

    public void setGrayScale(int value) {
        this.setColor(value, value, value);
    }

    public Font getFont() {
        if (MainApp.verbose) {
            System.out.println("Graphics:" + this.hashCode() + "  getFont() " + this.font);
        }
        return this.font;
    }

    public void setStrokeStyle(int style) {
        this.strokeStyle = style;
    }

    public int getStrokeStyle() {
        return this.strokeStyle;
    }

    public void setFont(Font f2) {
        if (MainApp.verbose) {
            System.out.println("Graphics:" + this.hashCode() + "  setFont=" + this.font);
        }
        this.font = f2 == null ? Font.getDefaultFont() : f2;
    }

    public int getClipX() {
        if (MainApp.verbose) {
            System.out.println("Graphics:" + this.hashCode() + "  getClipX=" + this.clX + " trX=" + this.trX);
        }
        return this.clX - this.trX;
    }

    public int getClipY() {
        if (MainApp.verbose) {
            System.out.println("Graphics:" + this.hashCode() + "  getClipY=" + this.clY + " trY=" + this.trY);
        }
        return this.clY - this.trY;
    }

    public int getClipWidth() {
        if (MainApp.verbose) {
            System.out.println("Graphics:" + this.hashCode() + "  getClipW=" + this.clW);
        }
        return this.clW;
    }

    public int getClipHeight() {
        if (MainApp.verbose) {
            System.out.println("Graphics:" + this.hashCode() + "  getClipH=" + this.clH);
        }
        return this.clH;
    }

    public void setClip(int x, int y, int width, int height) {
        if (MainApp.verbose) {
            System.out.println("Graphics:" + this.hashCode() + " setClip" + " x=" + x + " y=" + y + " w=" + width + " h=" + height + " trX=" + this.trX + " trY=" + this.trY);
        }
        this.clX = this.trX + x;
        this.clY = this.trY + y;
        this.clW = width;
        this.clH = height;
        this.emuGraphics.setClip(this.clX, this.clY, width, height);
    }

    public void clipRect(int x, int y, int width, int height) {
        if (MainApp.verbose) {
            System.out.println("Graphics:" + this.hashCode() + "  clipRct" + " x=" + x + " y=" + y + " w=" + width + " h=" + height + " trX=" + this.trX + " trY=" + this.trY);
        }
        int clX1 = this.clX + this.clW;
        int clY1 = this.clY + this.clH;
        int clX2 = this.trX + x + width;
        int clY2 = this.trY + y + height;
        if (this.trX + x > this.clX) {
            this.clX = this.trX + x;
        }
        if (clX2 < clX1) {
            clX1 = clX2;
        }
        this.clW = clX1 - this.clX;
        if (this.trY + y > this.clY) {
            this.clY = this.trY + y;
        }
        if (clY2 < clY1) {
            clY1 = clY2;
        }
        this.clH = clY1 - this.clY;
        this.emuGraphics.clipRect(this.trX + x, this.trY + y, width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyArea(int x_src, int y_src, int width, int height, int x_dest, int y_dest, int anchor) {
        int srcX = x_src + this.trX;
        int srcY = y_src + this.trY;
        if (this.emuImage == null) {
            throw new IllegalStateException();
        }
        if (srcX < 0 || srcY < 0 || srcX + width > this.emuImage.getWidth() || srcY + height > this.emuImage.getHeight()) {
            throw new IllegalArgumentException();
        }
        if (MainApp.verbose) {
            System.out.println("Graphics:" + this.hashCode() + "  copyArea x_src=" + x_src + " y_src=" + y_src + " w=" + width + " h=" + height + " x_dest=" + x_dest + " y_dest=" + y_dest + " anchor=" + anchor + " trX=" + this.trX + " trY=" + this.trY);
        }
        String string = lock;
        synchronized (lock) {
            int anX = 0;
            int anY = 0;
            int size = width * height;
            if (tmpRgbData == null || tmpRgbData.length < size) {
                tmpRgbData = new int[size];
            }
            this.emuImage.getRGB(tmpRgbData, 0, width, srcX, srcY, width, height);
            if ((anchor & 1) != 0) {
                anX = width >> 1;
            } else if ((anchor & 8) != 0) {
                anX = width;
            }
            if ((anchor & 2) != 0) {
                anY = height >> 1;
            } else if ((anchor & 0x20) != 0) {
                anY = height;
            }
            this.drawRGB(tmpRgbData, 0, width, x_dest - anX, y_dest - anY, width, height, false);
            // ** MonitorExit[var10_10] (shouldn't be in output)
            ++this.emuActionCounter;
            return;
        }
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        if (MainApp.verbose) {
            System.out.println("Graphics:" + this.hashCode() + "  drawLine x1=" + x1 + " y1=" + y1 + " x2=" + x2 + " y2=" + y2);
        }
        this.emuGraphics.drawLine(x1 + this.trX, y1 + this.trY, x2 + this.trX, y2 + this.trY);
        ++this.emuActionCounter;
    }

    public void fillTriangle(int x1, int y1, int x2, int y2, int x3, int y3) {
        Graphics.polygonX[0] = x1 + this.trX;
        Graphics.polygonX[1] = x2 + this.trX;
        Graphics.polygonX[2] = x3 + this.trX;
        Graphics.polygonY[0] = y1 + this.trY;
        Graphics.polygonY[1] = y2 + this.trY;
        Graphics.polygonY[2] = y3 + this.trY;
        this.emuGraphics.fillPolygon(polygonX, polygonY, 3);
        ++this.emuActionCounter;
    }

    public void fillRect(int x, int y, int width, int height) {
        if (MainApp.verbose) {
            System.out.println("fill rect x=" + x + " y=" + y + " w=" + width + " h=" + height);
        }
        this.emuGraphics.fillRect(x + this.trX, y + this.trY, width, height);
        ++this.emuActionCounter;
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (MainApp.verbose) {
            System.out.println("fill round rect x=" + x + " y=" + y + " w=" + width + " h=" + height);
        }
        this.emuGraphics.fillRoundRect(x + this.trX, y + this.trY, width, height, arcWidth, arcHeight);
        ++this.emuActionCounter;
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.emuGraphics.fillArc(x + this.trX, y + this.trY, width, height, startAngle, arcAngle);
        ++this.emuActionCounter;
    }

    public void drawRect(int x, int y, int width, int height) {
        if (MainApp.verbose) {
            System.out.println("draw rect clip=" + this.emuGraphics.getClip());
        }
        this.emuGraphics.drawRect(x + this.trX, y + this.trY, width, height);
        ++this.emuActionCounter;
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (MainApp.verbose) {
            System.out.println("draw round rect x=" + x + " y=" + y + " w=" + width + " h=" + height);
        }
        this.emuGraphics.drawRoundRect(x + this.trX, y + this.trY, width, height, arcWidth, arcHeight);
        ++this.emuActionCounter;
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.emuGraphics.drawArc(x + this.trX, y + this.trY, width, height, startAngle, arcAngle);
        ++this.emuActionCounter;
    }

    public void drawChars(char[] data, int offset, int length, int x, int y, int anchor) {
        String line = new String(data, offset, length);
        this.drawString(line, x, y, anchor);
        ++this.emuActionCounter;
    }

    public void drawChar(char character, int x, int y, int anchor) {
        String line = String.valueOf(character);
        this.drawString(line, x, y, anchor);
        ++this.emuActionCounter;
    }

    public void drawSubstring(String str, int offset, int len, int x, int y, int anchor) {
        this.drawString(str.substring(offset, offset + len), x, y, anchor);
        ++this.emuActionCounter;
    }

    public void drawString(String str, int x, int y, int anchor) {
        if (MainApp.verbose) {
            System.out.println("Graphics:" + this.hashCode() + " draw string=" + str + " x=" + x + " y=" + y + " anchor=" + anchor + " trX=" + this.trX + " trY=" + this.trY + " clX=" + this.clX + " clY=" + this.clY + " clW=" + this.clW + " clH=" + this.clH);
        }
        int anX = 0;
        int anY = 0;
        if ((anchor & 1) != 0) {
            anX = this.font.stringWidth(str) >> 1;
        } else if ((anchor & 8) != 0) {
            anX = this.font.stringWidth(str);
        }
        if ((anchor & 2) != 0) {
            anY = this.font.getHeight() >> 1;
        } else if ((anchor & 0x20) != 0) {
            anY = this.font.getHeight();
        } else if ((anchor & 0x40) != 0) {
            anY = this.font.getBaselinePosition();
        }
        this.emuGraphics.setFont(this.font.emuGetFont());
        this.emuGraphics.drawString(str, x + this.trX - anX, y + this.trY - anY + this.font.getHeight() - 4);
        ++this.emuActionCounter;
    }

    public void drawImage(Image img, int x, int y, int anchor) {
        if (img == null) {
            return;
        }
        this.emuDrawImage(img.emuGetImage(0), x, y, anchor, img.getWidth(), img.getHeight());
        ++this.emuActionCounter;
    }

    void emuDrawImage(java.awt.Image image, int x, int y, int anchor, int width, int height) {
        int anX = 0;
        int anY = 0;
        if (MainApp.verbose) {
            System.out.println("Graphics:" + this.hashCode() + "  drawImage: img=" + image.hashCode() + " x=" + x + " y=" + y + " anchor=" + anchor + " trX=" + this.trX + " trY=" + this.trY + " w=" + image.getWidth(null) + " h=" + image.getHeight(null));
        }
        if ((anchor & 1) != 0) {
            anX = width >> 1;
        } else if ((anchor & 8) != 0) {
            anX = width;
        }
        if ((anchor & 2) != 0) {
            anY = height >> 1;
        } else if ((anchor & 0x20) != 0) {
            anY = height;
        }
        this.emuGraphics.drawImage(image, x + this.trX - anX, y + this.trY - anY, null);
        if (this.emuImage != null) {
            this.emuImage.emuInvalidate();
        }
    }

    public void drawRGB(int[] rgbData, int offset, int scanlength, int x, int y, int width, int height, boolean processAlpha) {
        if (MainApp.verbose) {
            System.out.println("Graphics: drawRGB() x=" + x + " y=" + y + " w=" + width + " h=" + height + " offset=" + offset + " scanl=" + scanlength + " alpha=" + processAlpha);
        }
        if (!processAlpha) {
            rgbData = this.emuGetOpaqueRGB(rgbData, offset, width, height, scanlength);
            offset = 0;
            scanlength = width;
        }
        bi.setRGB(0, 0, width, height, rgbData, offset, scanlength);
        this.emuPushClip();
        this.emuGraphics.clipRect(x + this.trX, y + this.trY, width, height);
        this.emuGraphics.drawImage(bi, x + this.trX, y + this.trY, null);
        this.emuPopClip();
        ++this.emuActionCounter;
    }

    private int[] emuGetOpaqueRGB(int[] srcData, int offset, int width, int height, int scanlength) {
        int srcOffset = offset;
        int dstOffset = 0;
        int size = height * width;
        int skip = scanlength - width;
        if (pixelData.length < size) {
            pixelData = new int[size];
        }
        while (dstOffset < size) {
            int i2 = 0;
            while (i2 < width) {
                Graphics.pixelData[dstOffset] = srcData[srcOffset] | 0xFF000000;
                ++dstOffset;
                ++srcOffset;
                ++i2;
            }
            srcOffset += skip;
        }
        return pixelData;
    }

    protected void emuPushClip() {
        this.emuGraphics.getClipBounds(emuTmpRect);
    }

    protected void emuPopClip() {
        this.emuGraphics.setClip(Graphics.emuTmpRect.x, Graphics.emuTmpRect.y, Graphics.emuTmpRect.width, Graphics.emuTmpRect.height);
    }

    public void drawRegion(Image img, int x_src, int y_src, int width, int height, int transform, int x_dest, int y_dest, int anchor) {
        if (x_src < 0 || y_src < 0 || x_src + width > img.getWidth() || y_src + height > img.getHeight()) {
            throw new IllegalArgumentException("region to be copied exceeds the bounds of the source image");
        }
        this.emuGraphics.getClipBounds(emuTmpRect);
        if (MainApp.verbose) {
            System.out.println("Graphics:" + this.hashCode() + " draw region! image=" + img.hashCode() + " x_src=" + x_src + " y_src=" + y_src + " w=" + width + " h=" + height + " transform=" + transform + " x_dst=" + x_dest + " y_dst=" + y_dest + " anchor=" + anchor + " trX=" + this.trX + " trY=" + this.trY);
            System.out.println(" current clip x=" + Graphics.emuTmpRect.x + " y=" + Graphics.emuTmpRect.y + " w=" + Graphics.emuTmpRect.width + " h=" + Graphics.emuTmpRect.height);
        }
        int anX = 0;
        int anY = 0;
        switch (transform) {
            case 1: {
                y_src = img.getHeight() - y_src - height;
                break;
            }
            case 2: {
                x_src = img.getWidth() - x_src - width;
                break;
            }
            case 3: {
                y_src = img.getHeight() - y_src - height;
                x_src = img.getWidth() - x_src - width;
                break;
            }
            case 4: {
                int tmp = width;
                width = height;
                height = tmp;
                tmp = x_src;
                x_src = y_src;
                y_src = tmp;
                break;
            }
            case 5: {
                int tmp = width;
                width = height;
                height = tmp;
                tmp = x_src;
                x_src = y_src;
                y_src = tmp;
                x_src = img.getHeight() - x_src - width;
                break;
            }
            case 6: {
                int tmp = width;
                width = height;
                height = tmp;
                tmp = x_src;
                x_src = y_src;
                y_src = tmp;
                y_src = img.getWidth() - y_src - height;
                break;
            }
            case 7: {
                int tmp = width;
                width = height;
                height = tmp;
                tmp = x_src;
                x_src = y_src;
                y_src = tmp;
                y_src = img.getWidth() - y_src - height;
                x_src = img.getHeight() - x_src - width;
                break;
            }
            default: {
                if (transform == 0) break;
                throw new IllegalArgumentException("unsupported transform ! " + transform);
            }
        }
        if ((anchor & 1) != 0) {
            anX = width >> 1;
        } else if ((anchor & 8) != 0) {
            anX = width;
        }
        if ((anchor & 2) != 0) {
            anY = height >> 1;
        } else if ((anchor & 0x20) != 0) {
            anY = height;
        }
        this.emuGraphics.clipRect(x_dest + this.trX - anX, y_dest + this.trY - anY, width, height);
        if (transform != 0 && img.graphics != null && img.graphics.emuDrawRegionCounter != img.graphics.emuActionCounter) {
            img.graphics.emuDrawRegionCounter = img.graphics.emuActionCounter;
            img.emuInvalidate();
        }
        this.emuGraphics.drawImage(img.emuGetImage(transform), x_dest + this.trX - anX - x_src, y_dest + this.trY - anY - y_src, null);
        this.emuGraphics.setClip(Graphics.emuTmpRect.x, Graphics.emuTmpRect.y, Graphics.emuTmpRect.width, Graphics.emuTmpRect.height);
        ++this.emuActionCounter;
    }

    public void emuDrawImage(java.awt.Image img, int x, int y) {
        this.emuGraphics.drawImage(img, x + this.trX, y + this.trY, null);
    }

    public void emuDrawRegionSimple(java.awt.Image img, int x_src, int y_src, int width, int height, int x_dest, int y_dest) {
        this.emuGraphics.getClipBounds(emuTmpRect);
        this.emuGraphics.setClip(x_dest + this.trX, y_dest + this.trY, width, height);
        this.emuGraphics.drawImage(img, x_dest + this.trX - x_src, y_dest + this.trY - y_src, null);
        if (Graphics.emuTmpRect.width == 0) {
            Graphics.emuTmpRect.width = Display.WIDTH;
            Graphics.emuTmpRect.height = Display.HEIGHT;
        }
        this.emuGraphics.setClip(Graphics.emuTmpRect.x, Graphics.emuTmpRect.y, Graphics.emuTmpRect.width, Graphics.emuTmpRect.height);
    }

    public void drawImage(Image img, int x, int y, int anchor, int manipulation) {
        int transform = 0;
        Color color = null;
        switch (manipulation) {
            case 8192: {
                transform = 2;
                color = Color.BLUE;
                break;
            }
            case 16384: {
                transform = 1;
                color = Color.YELLOW;
                break;
            }
            case 180: {
                transform = 3;
                color = Color.MAGENTA;
                break;
            }
            case 90: {
                transform = 6;
                color = Color.CYAN;
                break;
            }
            case 270: {
                transform = 5;
                break;
            }
            case 8282: {
                transform = 7;
                break;
            }
            case 8372: {
                transform = 1;
                break;
            }
            case 8462: {
                transform = 4;
                color = Color.GREEN;
                break;
            }
            case 16474: {
                transform = 4;
                break;
            }
            case 16564: {
                transform = 2;
                break;
            }
            case 16654: {
                transform = 7;
                color = Color.RED;
                break;
            }
            case 24576: {
                transform = 3;
                break;
            }
            case 24666: {
                transform = 5;
                break;
            }
            case 24756: {
                transform = 0;
                break;
            }
            case 24846: {
                transform = 6;
                break;
            }
            default: {
                if (manipulation == 0) break;
                System.out.println("Pstros: ExtendedGraphics.drawImage: unknow transform! " + manipulation);
            }
        }
        if (MainApp.verbose) {
            System.out.println("ExtendedGraphics: " + this.hashCode() + " drawImage...) " + img.hashCode() + " x=" + x + " y=" + y + " manipulation=" + manipulation + " trX=" + this.trX + " trY=" + this.trY + " anchor=" + anchor + " w=" + img.getWidth() + " h=" + img.getHeight() + " transform=" + transform);
        }
        this.drawRegion(img, 0, 0, img.getWidth(), img.getHeight(), transform, x, y, anchor);
        ++this.emuActionCounter;
    }

    public void drawPixels(byte[] pixels, byte[] transparencyMask, int offset, int scanlength, int x, int y, int width, int height, int manipulation, int format) {
        System.out.println("ExtendedGraphics: drawPixels(byte[],...) format=" + format + " NOT IMPLEMENTED!");
    }

    public void drawPixels(int[] pixels, boolean transparency, int offset, int scanlength, int x, int y, int width, int height, int manipulation, int format) {
        if (MainApp.verbose) {
            System.out.println("ExtendedGraphics: drawPixels(int[],...) format=" + format);
        }
        int manipX = 1;
        int manipY = 1;
        switch (manipulation) {
            case 8192: {
                manipX = -1;
                manipY = 1;
                break;
            }
            case 16384: {
                manipX = 1;
                manipY = -1;
                break;
            }
            case 180: 
            case 24576: {
                manipX = -1;
                manipY = -1;
            }
        }
        switch (format) {
            case 888: {
                Graphics.emuConvertPixelData888(pixels, width, height);
                break;
            }
            case 8888: {
                Graphics.emuConvertPixelData8888(pixels, width, height, offset, scanlength, manipX, manipY);
            }
        }
        if (ConfigData.storeImages) {
            int n2 = ImageCreator.savePixels(pixelData, width, height);
        }
        bi.setRGB(0, 0, width, height, pixelData, 0, width);
        this.emuPushClip();
        this.emuGraphics.clipRect(x + this.trX, y + this.trY, width, height);
        this.emuDrawImage(bi, x, y, 0, width, height);
        this.emuPopClip();
        ++this.emuActionCounter;
    }

    public void drawPixels(short[] pixels, boolean transparency, int offset, int scanlength, int x, int y, int width, int height, int manipulation, int format) {
        if (MainApp.verbose) {
            System.out.println("ExtendedGraphics: drawPixels(short[],...) format=" + format + " tr=" + transparency + " offset=" + offset + " scan=" + scanlength + " x=" + x + " y=" + y + " w=" + width + " h=" + height + " man=" + manipulation);
        }
        int manipX = 1;
        int manipY = 1;
        switch (manipulation) {
            case 8192: {
                manipX = -1;
                manipY = 1;
                break;
            }
            case 16384: {
                manipX = 1;
                manipY = -1;
                break;
            }
            case 180: 
            case 24576: {
                manipX = -1;
                manipY = -1;
            }
        }
        switch (format) {
            case 444: {
                Graphics.emuConvertPixelData444(pixels, width, height);
                break;
            }
            case 4444: {
                Graphics.emuConvertPixelData4444(pixels, width, height, offset, scanlength, manipX, manipY);
            }
        }
        if (ConfigData.storeImages) {
            int num = ImageCreator.savePixels(pixelData, width, height);
            if (MainApp.verbose) {
                System.out.println("ExtendedGraphics: drawPixels imgIndex=" + num);
            }
        }
        if (width > biWidth) {
            this.initBufferedImage(width, 640);
        } else if (height > biHeight) {
            this.initBufferedImage(480, height);
        }
        bi.setRGB(0, 0, width, height, pixelData, 0, width);
        this.emuPushClip();
        this.emuGraphics.clipRect(x + this.trX, y + this.trY, width, height);
        this.emuDrawImage(bi, x, y, 0, width, height);
        this.emuPopClip();
        ++this.emuActionCounter;
    }

    public void drawPolygon(int[] xPoints, int xOffset, int[] yPoints, int yOffset, int nPoints, int argbColor) {
        if (MainApp.verbose) {
            System.out.println("ExtendedGraphics: drawPolygon()");
        }
        if (xPoints == null || yPoints == null || nPoints == 0) {
            return;
        }
        if (polygonX.length < nPoints) {
            polygonX = new int[nPoints];
            polygonY = new int[nPoints];
        }
        int maxX = Graphics.polygonX[0] = xPoints[xOffset] + this.trX;
        int minX = Graphics.polygonX[0];
        int maxY = Graphics.polygonY[0] = yPoints[yOffset] + this.trY;
        int minY = Graphics.polygonY[0];
        int i2 = 1;
        while (i2 < nPoints) {
            int valX = Graphics.polygonX[i2] = xPoints[i2 + xOffset] + this.trX;
            int valY = Graphics.polygonY[i2] = yPoints[i2 + yOffset] + this.trY;
            if (valX < minX) {
                minX = valX;
            } else if (valX > maxX) {
                maxX = valX;
            }
            if (valY < minY) {
                minY = valY;
            } else if (valY > maxY) {
                maxY = valY;
            }
            ++i2;
        }
        ++maxX;
        ++maxY;
        if (minX < this.clX) {
            minX = this.clX;
        }
        if (minY < this.clY) {
            minY = this.clY;
        }
        if (maxX > this.clX + this.clW) {
            maxX = this.clX + this.clW;
        }
        if (maxY > this.clY + this.clH) {
            maxY = this.clY + this.clH;
        }
        if (minX < 0) {
            minX = 0;
        }
        if (maxX > Display.WIDTH) {
            maxX = Display.WIDTH;
        }
        if (minY < 0) {
            minY = 0;
        }
        if (maxY > Display.HEIGHT) {
            maxY = Display.HEIGHT;
        }
        this.emuCleanBi(minX, minY, maxX, maxY);
        biGraphics.setColor(new Color(-1));
        biGraphics.drawPolygon(polygonX, polygonY, nPoints);
        this.emuApplyAlpha(minX, minY, maxX, maxY, argbColor);
        this.emuPushClip();
        this.emuGraphics.clipRect(minX + this.trX, minY + this.trY, maxX - minX, maxY - minY);
        this.emuGraphics.drawImage(bi, this.trX, this.trY, null);
        this.emuPopClip();
        ++this.emuActionCounter;
    }

    public void drawTriangle(int x1, int y1, int x2, int y2, int x3, int y3, int argbColor) {
        int maxY;
        int maxX;
        if (MainApp.verbose) {
            System.out.println("ExtendedGraphics: drawTriangle()");
        }
        Graphics.polygonX[0] = x1 + this.trX;
        Graphics.polygonX[1] = x2 + this.trX;
        Graphics.polygonX[2] = x3 + this.trX;
        Graphics.polygonY[0] = y1 + this.trY;
        Graphics.polygonY[1] = y2 + this.trY;
        Graphics.polygonY[2] = y3 + this.trY;
        int minX = maxX = polygonX[0];
        int minY = maxY = polygonY[0];
        int i2 = 1;
        while (i2 < 3) {
            int valX = polygonX[i2];
            int valY = polygonY[i2];
            if (valX < minX) {
                minX = valX;
            } else if (valX > maxX) {
                maxX = valX;
            }
            if (valY < minY) {
                minY = valY;
            } else if (valY > maxY) {
                maxY = valY;
            }
            ++i2;
        }
        ++maxX;
        ++maxY;
        if (minX < this.clX) {
            minX = this.clX;
        }
        if (minY < this.clY) {
            minY = this.clY;
        }
        if (maxX > this.clX + this.clW) {
            maxX = this.clX + this.clW;
        }
        if (maxY > this.clY + this.clH) {
            maxY = this.clY + this.clH;
        }
        if (minX < 0) {
            minX = 0;
        }
        if (maxX > Display.WIDTH) {
            maxX = Display.WIDTH;
        }
        if (minY < 0) {
            minY = 0;
        }
        if (maxY > Display.HEIGHT) {
            maxY = Display.HEIGHT;
        }
        this.emuCleanBi(minX, minY, maxX, maxY);
        biGraphics.setColor(new Color(-1));
        biGraphics.drawPolygon(polygonX, polygonY, 3);
        this.emuApplyAlpha(minX, minY, maxX, maxY, argbColor);
        this.emuPushClip();
        this.emuGraphics.clipRect(minX + this.trX, minY + this.trY, maxX - minX, maxY - minY);
        this.emuGraphics.drawImage(bi, this.trX, this.trY, null);
        this.emuPopClip();
        ++this.emuActionCounter;
    }

    public void fillPolygon(int[] xPoints, int xOffset, int[] yPoints, int yOffset, int nPoints, int argbColor) {
        if (MainApp.verbose) {
            System.out.println("ExtendedGraphics: fillPolygon()  coloralpha=" + (argbColor >> 24) + " color=" + Integer.toHexString(argbColor) + " xOffset=" + xOffset + " yOffset=" + yOffset + " nPoints=" + nPoints + " size=" + xPoints.length);
        }
        if (xPoints == null || yPoints == null || nPoints == 0) {
            return;
        }
        if (polygonX.length < nPoints) {
            polygonX = new int[nPoints];
            polygonY = new int[nPoints];
        }
        int maxX = Graphics.polygonX[0] = xPoints[xOffset] + this.trX;
        int minX = Graphics.polygonX[0];
        int maxY = Graphics.polygonY[0] = yPoints[yOffset] + this.trY;
        int minY = Graphics.polygonY[0];
        int i2 = 1;
        while (i2 < nPoints) {
            int valX = Graphics.polygonX[i2] = xPoints[i2 + xOffset] + this.trX;
            int valY = Graphics.polygonY[i2] = yPoints[i2 + yOffset] + this.trY;
            if (valX < minX) {
                minX = valX;
            } else if (valX > maxX) {
                maxX = valX;
            }
            if (valY < minY) {
                minY = valY;
            } else if (valY > maxY) {
                maxY = valY;
            }
            ++i2;
        }
        if (minX < this.clX) {
            minX = this.clX;
        }
        if (minY < this.clY) {
            minY = this.clY;
        }
        if (maxX > this.clX + this.clW) {
            maxX = this.clX + this.clW;
        }
        if (maxY > this.clY + this.clH) {
            maxY = this.clY + this.clH;
        }
        if (minX < 0) {
            minX = 0;
        }
        if (maxX > Display.WIDTH) {
            maxX = Display.WIDTH;
        }
        if (minY < 0) {
            minY = 0;
        }
        if (maxY > Display.HEIGHT) {
            maxY = Display.HEIGHT;
        }
        this.emuCleanBi(minX, minY, maxX, maxY);
        biGraphics.setColor(new Color(-1));
        biGraphics.fillPolygon(polygonX, polygonY, nPoints);
        this.emuApplyAlpha(minX, minY, maxX, maxY, argbColor);
        this.emuPushClip();
        this.emuGraphics.clipRect(minX, minY, maxX - minX, maxY - minY);
        this.emuGraphics.drawImage(bi, 0, 0, null);
        this.emuPopClip();
        ++this.emuActionCounter;
    }

    public void fillTriangle(int x1, int y1, int x2, int y2, int x3, int y3, int argbColor) {
        int maxY;
        int maxX;
        if (MainApp.verbose) {
            System.out.println("ExtendedGraphics: fillTriangle() alpha=" + (argbColor >> 24));
        }
        Graphics.polygonX[0] = x1 + this.trX;
        Graphics.polygonX[1] = x2 + this.trX;
        Graphics.polygonX[2] = x3 + this.trX;
        Graphics.polygonY[0] = y1 + this.trY;
        Graphics.polygonY[1] = y2 + this.trY;
        Graphics.polygonY[2] = y3 + this.trY;
        int minX = maxX = polygonX[0];
        int minY = maxY = polygonY[0];
        int i2 = 1;
        while (i2 < 3) {
            int valX = polygonX[i2];
            int valY = polygonY[i2];
            if (valX < minX) {
                minX = valX;
            } else if (valX > maxX) {
                maxX = valX;
            }
            if (valY < minY) {
                minY = valY;
            } else if (valY > maxY) {
                maxY = valY;
            }
            ++i2;
        }
        if (minX < this.clX) {
            minX = this.clX;
        }
        if (minY < this.clY) {
            minY = this.clY;
        }
        if (maxX > this.clX + this.clW) {
            maxX = this.clX + this.clW;
        }
        if (maxY > this.clY + this.clH) {
            maxY = this.clY + this.clH;
        }
        if (minX < 0) {
            minX = 0;
        }
        if (maxX > Display.WIDTH) {
            maxX = Display.WIDTH;
        }
        if (minY < 0) {
            minY = 0;
        }
        if (maxY > Display.HEIGHT) {
            maxY = Display.HEIGHT;
        }
        this.emuCleanBi(minX, minY, maxX, maxY);
        biGraphics.setColor(new Color(-1));
        biGraphics.fillPolygon(polygonX, polygonY, 3);
        this.emuApplyAlpha(minX, minY, maxX, maxY, argbColor);
        this.emuPushClip();
        this.emuGraphics.clipRect(minX, minY, maxX - minX, maxY - minY);
        this.emuGraphics.drawImage(bi, 0, 0, null);
        this.emuPopClip();
        ++this.emuActionCounter;
    }

    private void emuCleanBi(int x1, int y1, int x2, int y2) {
        int j2 = y1;
        while (j2 < y2) {
            int base = j2 * 480 + x1;
            int i2 = x1;
            while (i2 < x2) {
                Graphics.pixelData[base++] = 0;
                ++i2;
            }
            ++j2;
        }
        bi.setRGB(x1, y1, x2 - x1, y2 - y1, pixelData, y1 * 480 + x1, 480);
        biGraphics = bi.getGraphics();
    }

    private void emuApplyAlpha(int x1, int y1, int x2, int y2, int alpha) {
        int height = y2 - y1;
        int width = x2 - x1;
        bi.getRGB(x1, y1, width, height, pixelData, 0, 480);
        int j2 = 0;
        while (j2 < height) {
            int base = j2 * 480;
            int i2 = 0;
            while (i2 < width) {
                if (pixelData[base] == -1) {
                    Graphics.pixelData[base] = alpha;
                }
                ++base;
                ++i2;
            }
            ++j2;
        }
        bi.setRGB(x1, y1, width, height, pixelData, 0, 480);
    }

    public int getAlphaComponent() {
        if (MainApp.verbose) {
            System.out.println("ExtendedGraphics: getAlphaComponent()");
        }
        return (this.color & 0xFF000000) >>> 24;
    }

    public int getNativePixelFormat() {
        return 4444;
    }

    public void getPixels(byte[] pixels, byte[] transparencyMask, int offset, int scanlength, int x, int y, int width, int height, int format) {
        System.out.println("ExtendedGraphics: getPixels(byte[])  format" + format + " !NOT IMPLEMENTED!");
    }

    public void getPixels(int[] pixels, int offset, int scanlength, int x, int y, int width, int height, int format) {
        if (MainApp.verbose) {
            System.out.println("ExtendedGraphics: getPixels(int[])  format" + format);
        }
        BufferedImage img = this.emuGetGraphicsImage();
        img.getRGB(x + this.trX, y + this.trY, width, height, pixelData, 0, width);
        switch (format) {
            case 888: 
            case 8888: {
                this.emuStorePixelData8888(pixels, offset, scanlength, width, height);
            }
        }
    }

    public void getPixels(short[] pixels, int offset, int scanlength, int x, int y, int width, int height, int format) {
        if (MainApp.verbose) {
            System.out.println("ExtendedGraphics: getPixels(short[])  format=" + format + " x=" + x + " y=" + y + " w=" + width + " h=" + height);
        }
        BufferedImage img = this.emuGetGraphicsImage();
        img.getRGB(x + this.trX, y + this.trY, width, height, pixelData, 0, width);
        switch (format) {
            case 4444: {
                this.emuStorePixelData4444(pixels, offset, scanlength, width, height);
                break;
            }
            case 444: {
                this.emuStorePixelData444(pixels, offset, scanlength, width, height);
            }
        }
    }

    public void setARGBColor(int argbColor) {
        if (MainApp.verbose) {
            System.out.println("ExtendedGraphics: setARGBColor() " + Integer.toHexString(argbColor));
        }
        this.color = argbColor;
        this.emuGraphics.setColor(new Color(this.color >> 16 & 0xFF, this.color >> 8 & 0xFF, this.color & 0xFF, this.color >> 24 & 0xFF));
    }

    private static void emuConvertPixelData4444(short[] pixels, int width, int height, int offset, int scan, int manipX, int manipY) {
        int srcOffset = 0;
        int dstOffset = 0;
        boolean debug = false;
        if (MainApp.verbose && width == 16 && height == 16) {
            debug = true;
            System.out.println("!pixel debug:");
        }
        int y = 0;
        while (y < height) {
            srcOffset = offset + y * scan;
            dstOffset = manipY > 0 ? y * width : (height - y - 1) * width;
            if (manipX < 0) {
                dstOffset += width - 1;
            }
            int x = 0;
            while (x < width) {
                short srcPix = pixels[srcOffset++];
                if (debug) {
                    System.out.print(Integer.toHexString(srcPix));
                }
                int dstPix = (srcPix & 0xF) << 4;
                dstPix |= (srcPix & 0xF0) << 8;
                dstPix |= (srcPix & 0xF00) << 12;
                dstPix |= (srcPix & 0xF000) << 16;
                dstPix |= dstPix >> 4;
                Graphics.pixelData[dstOffset] = dstPix;
                dstOffset += manipX;
                ++x;
            }
            ++y;
        }
        if (debug) {
            System.out.println();
        }
    }

    private static void emuConvertPixelData444(short[] pixels, int width, int height) {
        int offset = 0;
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                short srcPix = pixels[offset];
                int dstPix = (srcPix & 0xF) << 4;
                dstPix |= (srcPix & 0xF0) << 8;
                dstPix |= (srcPix & 0xF00) << 12;
                dstPix |= 0xF0000000;
                dstPix |= dstPix >> 4;
                Graphics.pixelData[offset++] = dstPix;
                ++x;
            }
            ++y;
        }
    }

    private void emuStorePixelData444(short[] pixels, int offset, int scan, int width, int height) {
        int srcOffset = 0;
        int dstOffset = 0;
        int y = 0;
        while (y < height) {
            srcOffset = y * width;
            dstOffset = offset + y * scan;
            int x = 0;
            while (x < width) {
                int srcPix = pixelData[srcOffset++];
                int dstPix = -4096;
                dstPix = (short)(dstPix | (srcPix & 0xF0) >> 4);
                dstPix = (short)(dstPix | (srcPix & 0xF000) >> 8);
                dstPix = (short)(dstPix | (srcPix & 0xF00000) >> 12);
                pixels[dstOffset++] = dstPix;
                ++x;
            }
            ++y;
        }
    }

    private void emuStorePixelData4444(short[] pixels, int offset, int scan, int width, int height) {
        int srcOffset = 0;
        int dstOffset = 0;
        int y = 0;
        while (y < height) {
            srcOffset = y * width;
            dstOffset = offset + y * scan;
            int x = 0;
            while (x < width) {
                int srcPix = pixelData[srcOffset++];
                short dstPix = (short)((srcPix & 0xF0000000) >> 16);
                dstPix = (short)(dstPix | (srcPix & 0xF0) >> 4);
                dstPix = (short)(dstPix | (srcPix & 0xF000) >> 8);
                dstPix = (short)(dstPix | (srcPix & 0xF00000) >> 12);
                pixels[dstOffset++] = dstPix;
                ++x;
            }
            ++y;
        }
    }

    private void emuStorePixelData8888(int[] pixels, int offset, int scan, int width, int height) {
        int srcOffset = 0;
        int dstOffset = 0;
        int y = 0;
        while (y < height) {
            srcOffset = y * width;
            dstOffset = offset + y * scan;
            int x = 0;
            while (x < width) {
                int srcPix = pixelData[srcOffset++];
                pixels[dstOffset++] = srcPix;
                ++x;
            }
            ++y;
        }
    }

    private static void emuConvertPixelData8888(int[] pixels, int width, int height, int offset, int scan, int manipX, int manipY) {
        int srcOffset = 0;
        int dstOffset = 0;
        int y = 0;
        while (y < height) {
            srcOffset = offset + y * scan;
            dstOffset = manipY > 0 ? y * width : (height - y - 1) * width;
            if (manipX < 0) {
                dstOffset += width - 1;
            }
            int x = 0;
            while (x < width) {
                int srcPix;
                Graphics.pixelData[dstOffset] = srcPix = pixels[srcOffset++];
                dstOffset += manipX;
                ++x;
            }
            ++y;
        }
    }

    private static void emuConvertPixelData888(int[] pixels, int width, int height) {
        int offset = 0;
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int srcPix = pixels[offset];
                Graphics.pixelData[offset++] = 0xFF000000 | srcPix & 0xFFFFFF;
                ++x;
            }
            ++y;
        }
    }

    public Object getObject() {
        return this.emuGraphics;
    }
}

