/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.awt.Color;
import java.awt.Graphics;
import javax.microedition.lcdui.Choice;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.Screen;
import ole.pstros.MainApp;
import ole.pstros.utils.Pair;

public class List
extends Screen
implements Choice {
    public static final Command SELECT_COMMAND = new Command("Select", 1, 0);
    private int type;
    private Command selectCommand;
    private int emuOffsY;
    private int fitPolicy;

    private List() {
        this.addCommand(SELECT_COMMAND);
        this.fitPolicy = 0;
    }

    public List(String title, int listType) {
        this();
        this.setTitle(title);
        this.type = listType;
    }

    public List(String title, int listType, String[] stringElements, Image[] imageElements) {
        this(title, listType);
        int size = stringElements.length;
        int i2 = 0;
        while (i2 < size) {
            Image img = null;
            if (imageElements != null) {
                img = imageElements[i2];
            }
            this.append(stringElements[i2], img);
            ++i2;
        }
    }

    public int append(String stringPart, Image imagePart) {
        if (this.selected == -1) {
            this.selected = 0;
        }
        if (MainApp.verbose) {
            System.out.println("append: " + stringPart + " image=" + imagePart);
        }
        Pair p2 = new Pair(stringPart, imagePart);
        this.items.add(p2);
        return this.items.indexOf(p2);
    }

    public void delete(int elementNum) {
        this.items.remove(elementNum);
        this.selected = 0;
        if (this.items.size() < 1) {
            this.selected = 0;
        }
    }

    public void deleteAll() {
        this.items.clear();
        this.selected = 0;
    }

    public int getSelectedFlags(boolean[] selectedArray_return) {
        return 0;
    }

    public int getSelectedIndex() {
        return this.selected;
    }

    public void insert(int elementNum, String stringPart, Image imagePart) {
        if (!MainApp.verbose) {
            System.out.println("append: " + stringPart + " image=" + imagePart);
        }
        Pair p2 = new Pair(stringPart, imagePart);
        this.items.insertElementAt(p2, elementNum);
    }

    public boolean isSelected(int elementNum) {
        return this.selected == elementNum;
    }

    public void set(int elementNum, String stringPart, Image imagePart) {
        Pair p2 = (Pair)this.items.get(elementNum);
        p2.set(stringPart, imagePart);
    }

    public void setSelectedFlags(boolean[] selectedArray) {
    }

    public void setSelectedIndex(int elementNum, boolean selected) {
        this.selected = this.selected == elementNum && !selected ? 0 : elementNum;
    }

    public void setSelectCommand(Command c2) {
        this.selectCommand = c2;
        if (c2 == null) {
            super.removeCommand(SELECT_COMMAND);
        } else {
            this.addCommand(c2);
        }
    }

    public void setFont(int elementNum, Font font) {
    }

    public Font getFont(int elementNum) {
        return Font.getDefaultFont();
    }

    public void removeCommand(Command cmd) {
        if (this.selectCommand == cmd) {
            this.selectCommand = null;
        }
        super.removeCommand(cmd);
    }

    public void setFitPolicy(int fitPolicy) {
        this.fitPolicy = fitPolicy;
    }

    public int getFitPolicy() {
        return this.fitPolicy;
    }

    public int size() {
        return this.items.size();
    }

    public String getString(int elementNum) {
        Pair pair = (Pair)this.items.get(elementNum);
        if (pair == null) {
            return null;
        }
        return (String)pair.getFirst();
    }

    public Image getImage(int elementNum) {
        Pair pair = (Pair)this.items.get(elementNum);
        if (pair == null) {
            return null;
        }
        return (Image)pair.getSecond();
    }

    void emuFirePressed() {
        int max = this.items.size();
        if (max < 1 || this.selected < 0 || this.selected > max - 1) {
            return;
        }
        if (this.selectCommand != null && this.listener != null) {
            this.listener.commandAction(this.selectCommand, this);
        }
    }

    void emuPaintScreenContent(Graphics g2) {
        int y;
        int size = this.items.size();
        int sliderY = 0;
        int sliderH = 0;
        java.awt.Font font = g2.getFont();
        int itemHeight = font.getSize() + 4;
        g2.getClipBounds(tmpRect);
        sliderY = y = this.selected * itemHeight;
        sliderH = itemHeight;
        if (this.emuOffsY + y + itemHeight > List.tmpRect.height) {
            this.emuOffsY = List.tmpRect.height - y - itemHeight;
        } else if (this.emuOffsY + y < 0) {
            this.emuOffsY = -y;
        }
        y = 0;
        int i2 = 0;
        while (i2 < size) {
            Pair item = (Pair)this.items.get(i2);
            y += this.emuPaintItem(g2, 0, this.emuOffsY + y + List.tmpRect.y + itemHeight, (String)item.getFirst(), (Image)item.getSecond(), i2 == this.selected, itemHeight);
            ++i2;
        }
        if (y > List.tmpRect.height) {
            g2.setColor(Item.COLOR_HIGHLIGT);
            g2.fillRect(Display.WIDTH - 2, List.tmpRect.y, 2, List.tmpRect.height);
            int posY = sliderY * List.tmpRect.height / y;
            int sliderSize = sliderH * List.tmpRect.height / y + 1;
            g2.setColor(Color.RED);
            g2.fillRect(Display.WIDTH - 2, List.tmpRect.y + posY, 2, sliderSize);
        }
    }

    private int emuPaintItem(Graphics g2, int x, int y, String text, Image icon, boolean selected, int itemHeight) {
        if (text == null) {
            return 0;
        }
        if (selected) {
            g2.setColor(Item.COLOR_HIGHLIGT);
            g2.fillRect(x, y - itemHeight, Display.WIDTH - 4, itemHeight);
            g2.setColor(Color.RED);
        } else {
            g2.setColor(Color.BLACK);
        }
        if (icon != null) {
            g2.drawImage(icon.emuGetImage(0), x + 2, y - itemHeight, null);
            x += icon.getWidth();
        }
        g2.drawString(text, x + 2, y - 2);
        return itemHeight;
    }
}

