/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.awt.Color;
import java.awt.Graphics;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Item;

public class StringItem
extends Item {
    private static final int[] DEFAULT_POINT = new int[3];
    private String text;
    private int mode;
    private Font emuFont;

    public StringItem(String label, String text) {
        this.setLabel(label);
        this.text = text;
    }

    public StringItem(String label, String text, int appearanceMode) {
        this(label, text);
        this.mode = appearanceMode;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.emuUpdateScreen();
    }

    public int getAppearanceMode() {
        return this.mode;
    }

    public void setFont(Font font) {
        this.emuFont = font;
    }

    public Font getFont() {
        return this.emuFont;
    }

    int emuPaint(Graphics g2, int x, int y) {
        if (this.text == null && this.label == null) {
            return 0;
        }
        String l2 = this.getLabel();
        int[] point = DEFAULT_POINT;
        int origX = x++;
        int origY = y;
        if (!this.emuActive) {
            g2.setColor(Color.BLACK);
        } else {
            int areaH = this.emuGetHeight(g2);
            int fontH = g2.getFont().getSize();
            g2.setColor(Item.COLOR_HIGHLIGT);
            g2.fillRect(x, y - fontH, Display.WIDTH - 4, areaH);
            g2.setColor(Color.RED);
        }
        if (l2 != null) {
            java.awt.Font origFont = g2.getFont();
            java.awt.Font font = new java.awt.Font(origFont.getFontName(), 1, origFont.getSize());
            g2.setFont(font);
            point = Item.emuDrawMultiLine(g2, l2, x, y + 2, true);
            x += point[0];
            y += point[1];
            g2.setFont(origFont);
        }
        if (this.text != null) {
            point = Item.emuDrawMultiLine(g2, this.text, x, y + 2, true);
            y += point[1];
            x += point[0];
        }
        if (this.getAppearanceMode() == 2) {
            g2.drawRect(origX, origY - point[2] / 2 - 3, x - origX, y - origY + point[2]);
        }
        return y - origY + point[2];
    }

    int emuGetHeight(Graphics g2) {
        if (this.text == null && this.label == null) {
            return 0;
        }
        int[] point = DEFAULT_POINT;
        String l2 = this.getLabel();
        int x = 0;
        int y = 0;
        if (l2 != null) {
            java.awt.Font origFont = g2.getFont();
            java.awt.Font font = new java.awt.Font(origFont.getFontName(), 1, origFont.getSize());
            g2.setFont(font);
            point = Item.emuDrawMultiLine(g2, l2, x, y + 2, false);
            x += point[0];
            y += point[1];
            g2.setFont(origFont);
        }
        if (this.text != null) {
            point = Item.emuDrawMultiLine(g2, this.text, x, y + 2, false);
            y += point[1];
            x += point[0];
        }
        return y + point[2];
    }

    int emuGetYSpace(Graphics g2) {
        if (this.text == null && this.label == null) {
            return 0;
        }
        java.awt.Font font = g2.getFont();
        return font.getSize() + 2;
    }
}

