/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.awt.Graphics;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Screen;

public class TextBox
extends Screen {
    private static int MAX_SIZE = 8192;
    private String text;
    private int maxSize;
    private int constraints;
    private int caretPosition;
    private String charSubset;

    public TextBox(String title, String text, int maxSize, int constraints) {
        this.setTitle(title);
        this.setMaxSize(maxSize);
        this.text = text;
        this.constraints = constraints;
    }

    public String getString() {
        return this.text;
    }

    public void setString(String text) {
        this.text = text;
    }

    public int getChars(char[] data) {
        if (this.text == null) {
            return 0;
        }
        int length = this.text.length();
        this.text.getChars(0, length, data, 0);
        return length;
    }

    public void setChars(char[] data, int offset, int length) {
        String newText;
        this.text = newText = new String(data, offset, length);
    }

    public void insert(String src, int position) {
        StringBuffer sb = new StringBuffer(this.text);
        sb.insert(position, src);
        this.text = sb.toString();
    }

    public void insert(char[] data, int offset, int length, int position) {
        String newString = new String(data, offset, length);
        this.insert(newString, position);
    }

    public void delete(int offset, int length) {
        StringBuffer sb = new StringBuffer(this.text);
        sb.delete(offset, offset + length);
        this.text = sb.toString();
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int setMaxSize(int maxSize) {
        if (maxSize > MAX_SIZE) {
            maxSize = MAX_SIZE;
        }
        this.maxSize = maxSize;
        if (this.text != null && this.text.length() > maxSize) {
            this.text = this.text.substring(0, maxSize);
        }
        return maxSize;
    }

    public int size() {
        return this.text == null ? 0 : this.text.length();
    }

    public int getCaretPosition() {
        return this.caretPosition;
    }

    public void setConstraints(int constraints) {
        this.constraints = constraints;
    }

    public int getConstraints() {
        return this.constraints;
    }

    public void setInitialInputMode(String characterSubset) {
        this.charSubset = characterSubset;
    }

    void emuPaintScreenContent(Graphics g2) {
        int y = 30;
        if (this.text != null) {
            g2.drawString(this.text, 0, y);
        }
    }

    boolean emuKeyAction(int key, int keyChar, int modifiers, int action) {
        super.emuKeyAction(key, keyChar, modifiers, action);
        if (action == 0) {
            if (key == Display.keyLeft) {
                if (this.text != null) {
                    int length = this.text.length();
                    ++this.caretPosition;
                    if (this.caretPosition > length) {
                        this.caretPosition = length;
                    }
                }
            } else if (key == Display.keyRight && this.text != null) {
                --this.caretPosition;
                if (this.caretPosition < 0) {
                    this.caretPosition = 0;
                }
            }
        }
        return true;
    }
}

