/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Item;

public class TextField
extends Item {
    public static final int ANY = 0;
    public static final int EMAILADDR = 1;
    public static final int NUMERIC = 2;
    public static final int PHONENUMBER = 3;
    public static final int URL = 4;
    public static final int DECIMAL = 5;
    public static final int PASSWORD = 65536;
    public static final int UNEDITABLE = 131072;
    public static final int SENSITIVE = 262144;
    public static final int NON_PREDICTIVE = 524288;
    public static final int INITIAL_CAPS_WORD = 0x100000;
    public static final int INITIAL_CAPS_SENTENCE = 0x200000;
    public static final int CONSTRAINT_MASK = 65535;
    protected String text;
    protected int constraints;
    protected int maxSize;

    public TextField(String label, String text, int maxSize, int constraints) {
        this.setLabel(label);
        this.text = text;
        this.maxSize = maxSize;
        this.constraints = constraints;
        if (maxSize < 1) {
            throw new IllegalArgumentException(" maxSize < 1: maxSize=" + maxSize);
        }
        this.emuInteractive = true;
    }

    public String getString() {
        return this.text;
    }

    public void setString(String text) {
        this.text = text;
    }

    public int getChars(char[] data) {
        int size = data.length;
        char[] src = this.text.toCharArray();
        if (src.length < size) {
            size = src.length;
        }
        System.arraycopy(src, 0, data, 0, size);
        return size;
    }

    public void setChars(char[] data, int offset, int length) {
        this.text = new String(data, offset, length);
    }

    public void insert(String src, int position) {
    }

    public void insert(char[] data, int offset, int length, int position) {
    }

    public void delete(int offset, int length) {
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int setMaxSize(int maxSize) {
        this.maxSize = maxSize;
        return maxSize;
    }

    public int size() {
        return this.text.length();
    }

    public int getCaretPosition() {
        return 0;
    }

    public void setConstraints(int constraints) {
        this.constraints = constraints;
    }

    public int getConstraints() {
        return this.constraints;
    }

    public void setInitialInputMode(String characterSubset) {
    }

    void emuKeyAction(int key, int keyChar, int action) {
        if (Character.getNumericValue((char)keyChar) != -1) {
            if (this.text == null) {
                this.text = "";
            }
            this.text = String.valueOf(this.text) + (char)keyChar;
            this.emuUpdateScreen();
        } else if (key == 8 && this.text.length() > 0) {
            this.text = this.text.substring(0, this.text.length() - 1);
        } else {
            if (keyChar == 65535 || keyChar == 127) {
                return;
            }
            if (this.text == null) {
                this.text = "";
            }
            this.text = String.valueOf(this.text) + (char)keyChar;
            this.emuUpdateScreen();
        }
    }

    int emuPaint(Graphics g2, int x, int y) {
        Font font = g2.getFont();
        int height = font.getSize() + 2;
        int width = Display.WIDTH - x - 2;
        int origY = y;
        Color paintColor = Color.BLACK;
        if (this.emuActive) {
            paintColor = Color.RED;
        }
        g2.setColor(paintColor);
        if (this.label != null) {
            g2.drawString(this.label, x + 2, y + 1);
            y += height + 2;
        }
        if (this.emuActive) {
            g2.setColor(COLOR_HIGHLIGT);
            g2.fillRect(x, y - height + 2, Display.WIDTH - 4, height + 2);
            g2.setColor(paintColor);
        }
        if (this.text != null) {
            g2.drawString(this.text, x + 2, y + 1);
        }
        g2.drawRect(x, y - height + 2, Display.WIDTH - 4, height + 2);
        y += height + 2;
        return (y += 4) - origY;
    }

    int emuGetHeight(Graphics g2) {
        int h2;
        Font font = g2.getFont();
        int height = font.getSize();
        height = h2 = height + 4;
        if (this.label != null && this.label.length() > 0) {
            height += h2;
        }
        return height + 4;
    }

    int emuGetYSpace(Graphics g2) {
        Font font = g2.getFont();
        return font.getSize() + 3;
    }
}

