/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui.game;

import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Layer;
import ole.pstros.MainApp;

public class LayerManager {
    private Vector layers = new Vector();
    private int winX;
    private int winY;
    private int winW;
    private int winH;

    public LayerManager() {
        this.setViewWindow(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void append(Layer l2) {
        if (l2 == null) {
            throw new NullPointerException();
        }
        this.layers.add(l2);
    }

    public void insert(Layer l2, int index) {
        if (l2 == null) {
            throw new NullPointerException();
        }
        int currentIndex = this.layers.indexOf(l2);
        if (currentIndex > -1) {
            this.layers.remove(currentIndex);
        }
        this.layers.insertElementAt(l2, index);
    }

    public Layer getLayerAt(int index) {
        return (Layer)this.layers.get(index);
    }

    public int getSize() {
        return this.layers.size();
    }

    public void remove(Layer l2) {
        if (l2 == null) {
            throw new NullPointerException();
        }
        this.layers.remove(l2);
    }

    public void setViewWindow(int x, int y, int width, int height) {
        this.winX = x;
        this.winY = y;
        this.winW = width;
        this.winH = height;
        if (MainApp.verbose) {
            System.out.println("LayerManager.setViewWindow() x=" + x + " y=" + y + " w=" + width + " h=" + height);
        }
    }

    public void paint(Graphics g2, int x, int y) {
        int trX = g2.getTranslateX();
        int trY = g2.getTranslateY();
        int size = this.layers.size();
        if (MainApp.verbose) {
            System.out.println("Pstros:LayerManager.paint() x=" + x + " y=" + y + " wX=" + this.winX + " wY=" + this.winY + " wW=" + this.winW + " wH=" + this.winH + " tr X=" + trX + " Y=" + trY + " layer count=" + size);
        }
        if (size < 1) {
            return;
        }
        int origClipX = g2.getClipX();
        int origClipY = g2.getClipY();
        int origClipW = g2.getClipWidth();
        int origClipH = g2.getClipHeight();
        int boundX = this.winX + this.winW;
        int boundY = this.winY + this.winH;
        g2.setClip(x, y, this.winW, this.winH);
        g2.translate(-this.winX + x, -this.winY + y);
        int i2 = size - 1;
        while (i2 > -1) {
            Layer l2 = (Layer)this.layers.get(i2);
            l2.paint(g2);
            --i2;
        }
        g2.translate(this.winX - x, this.winY - y);
        g2.setClip(origClipX, origClipY, origClipW, origClipH);
    }
}

