/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui.game;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.TiledLayer;
import ole.pstros.EmuCanvas;
import ole.pstros.IEmuBridge;
import ole.pstros.MainApp;

public class Sprite
extends Layer {
    private static final int ANCHOR = 20;
    public static final int TRANS_NONE = 0;
    public static final int TRANS_MIRROR_ROT180 = 1;
    public static final int TRANS_MIRROR = 2;
    public static final int TRANS_ROT180 = 3;
    public static final int TRANS_MIRROR_ROT270 = 4;
    public static final int TRANS_ROT90 = 5;
    public static final int TRANS_ROT270 = 6;
    public static final int TRANS_MIRROR_ROT90 = 7;
    private static int[] tmpPoint = new int[4];
    Image image;
    int frameW;
    int frameH;
    int[] frameSeq;
    int imgW;
    int imgH;
    int transform;
    int transformDX;
    int transformDY;
    int spotX;
    int spotY;
    private int posX;
    private int posY;
    private int curFrame;
    int collisionX;
    int collisionY;
    int collisionW;
    int collisionH;
    int cX;
    int cY;
    int cW;
    int cH;

    public Sprite(Image image) {
        this(image, image.getWidth(), image.getHeight());
    }

    public Sprite(Image image, int frameWidth, int frameHeight) {
        this.setImage(image, frameWidth, frameHeight);
        this.setVisible(true);
    }

    public Sprite(Sprite s2) {
        this(s2.image, s2.frameW, s2.frameH);
        this.setFrameSequence(s2.frameSeq);
        this.spotX = s2.spotX;
        this.spotY = s2.spotY;
        this.transform = s2.transform;
        this.transformDX = s2.transformDX;
        this.transformDY = s2.transformDY;
        this.cX = s2.cX;
        this.cY = s2.cY;
        this.cW = s2.cW;
        this.cH = s2.cH;
    }

    public void setFrameSequence(int[] sequence) {
        this.frameSeq = sequence;
    }

    public void defineReferencePixel(int rX, int rY) {
        this.posX += rX - this.spotX;
        this.posY += rY - this.spotY;
        this.spotX = rX;
        this.spotY = rY;
    }

    public void setRefPixelPosition(int rX, int rY) {
        this.posX = rX;
        this.posY = rY;
        this.emuUpdateTransformedDistances();
    }

    public int getRefPixelX() {
        return this.posX;
    }

    public int getRefPixelY() {
        return this.posY;
    }

    public void setPosition(int pX, int pY) {
        this.posX = pX + this.spotX - this.transformDX;
        this.posY = pY + this.spotY - this.transformDY;
        super.setPosition(pX, pY);
    }

    public void move(int dx, int dy) {
        this.posX += dx;
        this.posY += dy;
        super.move(dx, dy);
    }

    public void setFrame(int sequenceIndex) {
        this.curFrame = sequenceIndex;
    }

    public final int getFrame() {
        return this.curFrame;
    }

    public int getRawFrameCount() {
        return this.imgW * this.imgH;
    }

    public int getFrameSequenceLength() {
        if (this.frameSeq == null) {
            return this.imgW * this.imgH;
        }
        return this.frameSeq.length;
    }

    public void nextFrame() {
        int max = this.frameSeq == null ? this.imgW * this.imgH : this.frameSeq.length;
        ++this.curFrame;
        if (this.curFrame >= max) {
            this.curFrame = 0;
        }
    }

    public void prevFrame() {
        int max = this.frameSeq == null ? this.imgW * this.imgH : this.frameSeq.length;
        --this.curFrame;
        if (this.curFrame < 0) {
            this.curFrame = max - 1;
        }
    }

    public void setImage(Image img, int frameWidth, int frameHeight) {
        this.image = img;
        if (this.frameW != frameWidth || this.frameH != frameHeight) {
            this.collisionX = 0;
            this.collisionY = 0;
            this.collisionW = this.cW = frameWidth;
            this.collisionH = this.cH = frameHeight;
        }
        this.frameW = frameWidth;
        this.frameH = frameHeight;
        this.imgW = this.image.getWidth() / this.frameW;
        this.imgH = this.image.getHeight() / this.frameH;
        this.layerWidth = frameWidth;
        this.layerHeight = frameHeight;
        this.frameSeq = null;
        this.curFrame = 0;
    }

    public void setTransform(int transform) {
        switch (transform) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.layerWidth = this.frameW;
                this.layerHeight = this.frameH;
                this.cW = this.collisionW;
                this.cH = this.collisionH;
                this.transform = transform;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.layerWidth = this.frameH;
                this.layerHeight = this.frameW;
                this.cW = this.collisionH;
                this.cH = this.collisionW;
                this.transform = transform;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid transform=" + transform);
            }
        }
        this.emuUpdateTransformedDistances();
    }

    private void emuUpdateTransformedDistances() {
        switch (this.transform) {
            case 0: {
                this.transformDX = 0;
                this.transformDY = 0;
                this.cX = this.collisionX;
                this.cY = this.collisionY;
                break;
            }
            case 1: {
                this.transformDX = 0;
                this.transformDY = -(this.frameH - 1 - 2 * this.spotY);
                this.cX = this.collisionX;
                this.cY = this.frameH - this.collisionY - this.collisionH;
                break;
            }
            case 2: {
                this.transformDX = -(this.frameW - 1 - 2 * this.spotX);
                this.transformDY = 0;
                this.cX = this.frameW - this.collisionX - this.collisionW;
                this.cY = this.collisionY;
                break;
            }
            case 3: {
                this.transformDX = -(this.frameW - 1 - 2 * this.spotX);
                this.transformDY = -(this.frameH - 1 - 2 * this.spotY);
                this.cX = this.frameW - this.collisionX - this.collisionW;
                this.cY = this.frameH - this.collisionY - this.collisionH;
                break;
            }
            case 4: {
                this.transformDX = this.spotX - this.spotY;
                this.transformDY = -(this.spotX - this.spotY);
                this.cX = this.collisionY;
                this.cY = this.collisionX;
                break;
            }
            case 5: {
                this.transformDX = -(this.frameH - this.spotX - this.spotY - 1);
                this.transformDY = -(this.spotX - this.spotY);
                this.cX = this.frameH - this.collisionY - this.collisionH;
                this.cY = this.collisionX;
                break;
            }
            case 6: {
                this.transformDX = this.spotX - this.spotY;
                this.transformDY = -(this.frameW - this.spotX - this.spotY - 1);
                this.cX = this.collisionY;
                this.cY = this.frameW - this.collisionX - this.collisionW;
                break;
            }
            case 7: {
                this.transformDX = -(this.frameH - this.spotX - this.spotY - 1);
                this.transformDY = -(this.frameW - this.spotX - this.spotY - 1);
                this.cX = this.frameH - this.collisionY - this.collisionH;
                this.cY = this.frameW - this.collisionX - this.collisionW;
            }
        }
        this.x = this.posX - this.spotX + this.transformDX;
        this.y = this.posY - this.spotY + this.transformDY;
    }

    public void defineCollisionRectangle(int x, int y, int width, int height) {
        this.collisionX = x;
        this.collisionY = y;
        this.collisionW = this.cW = width;
        this.collisionH = this.cH = height;
        this.emuUpdateTransformedDistances();
    }

    private boolean emuRectCollision(int sx, int sw, int sy, int sh, int dx, int dw, int dy, int dh) {
        int sx1 = sx;
        int sx2 = sx + sw;
        int sy1 = sy;
        int sy2 = sy + sh;
        int dx1 = dx;
        int dx2 = dx + dw;
        int dy1 = dy;
        int dy2 = dy + dh;
        return sx2 >= dx1 && sx1 <= dx2 && sy2 >= dy1 && sy1 <= dy2;
    }

    private boolean emuPixelCollision(int sx, int sw, int sy, int sh, int dx, int dw, int dy, int dh, int sOffset, int sScanLength, boolean[] sSolid, int dOffset, int dScanLength, boolean[] dSolid) {
        int sx1 = sx;
        int sx2 = sx + sw;
        int sy1 = sy;
        int sy2 = sy + sh;
        int dx1 = dx;
        int dx2 = dx + dw;
        int dy1 = dy;
        int dy2 = dy + dh;
        int rectX = sx > dx ? sx : dx;
        int rectY = sy > dy ? sy : dy;
        int rectW = sx2 > dx2 ? dx2 - rectX : sx2 - rectX;
        int rectH = sy2 > dy2 ? dy2 - rectY : sy2 - rectY;
        int sOffsX = rectX - sx;
        int dOffsX = rectX - dx;
        int sOffsY = rectY - sy;
        int dOffsY = rectY - dy;
        if (dSolid == null) {
            System.out.println("!!! dsolid is null");
            return false;
        }
        if (sSolid == null) {
            System.out.println("!!! ssolid is null");
            return false;
        }
        int y = 0;
        while (y < rectH) {
            int sIndex = sOffset + (sOffsY + y) * sScanLength + sOffsX;
            int dIndex = dOffset + (dOffsY + y) * dScanLength + dOffsX;
            int x = 0;
            while (x < rectW) {
                if (sIndex > sSolid.length) {
                    System.out.println("!! Source: max=" + sSolid.length);
                }
                if (dIndex > dSolid.length) {
                    System.out.println("!! Destin: max=" + dSolid.length + " current=" + dIndex + " rW=" + rectW + " rH=" + rectH + " dOY=" + dOffsY + " y=" + y + " x=" + x + " dScan=" + dScanLength + " dOffs=" + dOffset + " imgW=" + this.image.getWidth() + " imgH=" + this.image.getHeight());
                }
                if (sSolid[sIndex++] && dSolid[dIndex++]) {
                    return true;
                }
                ++x;
            }
            ++y;
        }
        return false;
    }

    int emuGetFrameIndex() {
        if (this.frameSeq == null) {
            return this.curFrame;
        }
        if (this.curFrame >= this.frameSeq.length) {
            this.curFrame = 0;
        }
        return this.frameSeq[this.curFrame];
    }

    void emuTranformCoordinate(int x_src, int y_src, int width, int height, int[] result) {
        Image img = this.image;
        int imgWidth = 0;
        switch (this.transform) {
            case 0: {
                imgWidth = img.getWidth();
                break;
            }
            case 1: {
                y_src = img.getHeight() - y_src - height;
                imgWidth = img.getWidth();
                break;
            }
            case 2: {
                x_src = img.getWidth() - x_src - width;
                imgWidth = img.getWidth();
                break;
            }
            case 3: {
                y_src = img.getHeight() - y_src - height;
                x_src = img.getWidth() - x_src - width;
                imgWidth = img.getWidth();
                break;
            }
            case 4: {
                int tmp = width;
                width = height;
                height = tmp;
                tmp = x_src;
                x_src = y_src;
                y_src = tmp;
                imgWidth = img.getHeight();
                break;
            }
            case 5: {
                imgWidth = img.getHeight();
                int tmp = width;
                width = height;
                height = tmp;
                tmp = x_src;
                x_src = y_src;
                y_src = tmp;
                x_src = img.getHeight() - x_src - width;
                break;
            }
            case 6: {
                imgWidth = img.getHeight();
                int tmp = width;
                width = height;
                height = tmp;
                tmp = x_src;
                x_src = y_src;
                y_src = tmp;
                y_src = img.getWidth() - y_src - height;
                break;
            }
            case 7: {
                imgWidth = img.getHeight();
                int tmp = width;
                width = height;
                height = tmp;
                tmp = x_src;
                x_src = y_src;
                y_src = tmp;
                y_src = img.getWidth() - y_src - height;
                x_src = img.getHeight() - x_src - width;
                break;
            }
            default: {
                if (this.transform == 0) break;
                System.out.println(" unsupported transform ! " + this.transform);
                return;
            }
        }
        result[0] = x_src;
        result[1] = y_src;
        result[2] = imgWidth;
    }

    public final boolean collidesWith(Sprite s2, boolean pixelLevel) {
        int dstY;
        int dstX;
        int srcY;
        if (MainApp.verbose) {
            System.out.println("Sprite@" + this.hashCode() + " collidesWith(Sprite) pixelLevel=" + pixelLevel);
        }
        if (!this.isVisible() || !s2.isVisible()) {
            return false;
        }
        int srcX = this.getX() + this.cX;
        boolean result = this.emuRectCollision(srcX, this.cW, srcY = this.getY() + this.cY, this.cH, dstX = s2.getX() + s2.cX, s2.cW, dstY = s2.getY() + s2.cY, s2.cH);
        if (result && pixelLevel) {
            int sImgIndex = this.emuGetFrameIndex();
            int dImgIndex = s2.emuGetFrameIndex();
            int sImgPosX = sImgIndex % this.imgW * this.frameW;
            int sImgPosY = sImgIndex / this.imgW * this.frameH;
            this.emuTranformCoordinate(sImgPosX, sImgPosY, this.frameW, this.frameH, tmpPoint);
            sImgPosX = tmpPoint[0];
            sImgPosY = tmpPoint[1];
            int sScanLength = tmpPoint[2];
            int sOffset = (sImgPosY + this.cY) * sScanLength + (sImgPosX + this.cX);
            int dImgPosX = dImgIndex % s2.imgW * s2.frameW;
            int dImgPosY = dImgIndex / s2.imgW * s2.frameH;
            s2.emuTranformCoordinate(dImgPosX, dImgPosY, s2.frameW, s2.frameH, tmpPoint);
            dImgPosX = tmpPoint[0];
            dImgPosY = tmpPoint[1];
            int dScanLength = tmpPoint[2];
            int dOffset = (dImgPosY + s2.cY) * dScanLength + (dImgPosX + s2.cX);
            IEmuBridge bridge = EmuCanvas.instance.lcduiBridge;
            if (bridge == null) {
                return false;
            }
            Sprite.tmpPoint[0] = this.transform;
            boolean[] srcCollision = (boolean[])bridge.handleEvent(21, this.image, tmpPoint);
            Sprite.tmpPoint[0] = s2.transform;
            boolean[] dstCollision = (boolean[])bridge.handleEvent(21, s2.image, tmpPoint);
            result = this.emuPixelCollision(srcX, this.cW, srcY, this.cH, dstX, s2.cW, dstY, s2.cH, sOffset, sScanLength, srcCollision, dOffset, dScanLength, dstCollision);
        }
        return result;
    }

    public final boolean collidesWith(TiledLayer t, boolean pixelLevel) {
        if (MainApp.verbose) {
            System.out.println("Sprite@" + this.hashCode() + " collidesWith(TiledLayer)  pixelLevel=" + pixelLevel);
        }
        if (t == null || !t.isVisible() || !this.isVisible()) {
            return false;
        }
        int srcX = this.getX() + this.cX;
        int srcY = this.getY() + this.cY;
        if (!pixelLevel) {
            if (t.emuCollideWithPoint(srcX, srcY)) {
                return true;
            }
            if (t.emuCollideWithPoint(srcX + this.cW, srcY)) {
                return true;
            }
            if (t.emuCollideWithPoint(srcX, srcY + this.cH)) {
                return true;
            }
            return t.emuCollideWithPoint(srcX + this.cW, srcY + this.cH);
        }
        boolean c1 = t.emuCollideWithPoint(srcX, srcY);
        boolean c2 = t.emuCollideWithPoint(srcX + this.cW, srcY);
        boolean c3 = t.emuCollideWithPoint(srcX, srcY + this.cH);
        boolean c4 = t.emuCollideWithPoint(srcX + this.cW, srcY + this.cH);
        if (c1 || c2 || c3 || c4) {
            int sImgIndex = this.emuGetFrameIndex();
            int sImgPosX = sImgIndex % this.imgW * this.frameW;
            int sImgPosY = sImgIndex / this.imgW * this.frameH;
            this.emuTranformCoordinate(sImgPosX, sImgPosY, this.frameW, this.frameH, tmpPoint);
            sImgPosX = tmpPoint[0];
            sImgPosY = tmpPoint[1];
            int sScanLength = tmpPoint[2];
            int sOffset = (sImgPosY + this.cY) * sScanLength + (sImgPosX + this.cX);
            IEmuBridge bridge = EmuCanvas.instance.lcduiBridge;
            if (bridge == null) {
                return false;
            }
            Sprite.tmpPoint[0] = this.transform;
            boolean[] srcCollision = (boolean[])bridge.handleEvent(21, this.image, tmpPoint);
            return t.emuPixelCollision(srcX, this.cW, srcY, this.cH, sOffset, sScanLength, srcCollision);
        }
        return false;
    }

    public final boolean collidesWith(Image image, int x, int y, boolean pixelLevel) {
        if (MainApp.verbose) {
            System.out.println("Sprite@" + this.hashCode() + " collidesWith(Image)");
        }
        return this.emuRectCollision(this.getX() + this.cX, this.cW, this.getY() + this.cY, this.cH, x, image.getWidth(), y, image.getHeight());
    }

    public void paint(Graphics g2) {
        if (!this.isVisible()) {
            return;
        }
        int imgIndex = this.emuGetFrameIndex();
        int paintX = this.getX();
        int paintY = this.getY();
        if (MainApp.verbose) {
            System.out.println("Sprite@" + this.hashCode() + " paint x=" + paintX + " y=" + paintY + " spotX=" + this.spotX + " spotY=" + this.spotY + " frW=" + this.frameW + " frameH=" + this.frameH + " transform=" + this.transform);
        }
        int imgPosX = imgIndex % this.imgW * this.frameW;
        int imgPosY = imgIndex / this.imgW * this.frameH;
        g2.drawRegion(this.image, imgPosX, imgPosY, this.frameW, this.frameH, this.transform, paintX, paintY, 20);
    }
}

