/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui.game;

import java.awt.image.BufferedImage;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import ole.pstros.EmuCanvas;

public class TiledLayer
extends Layer {
    private static final int MAX_ANIM_TILES = 64;
    private static final int ANCHOR = 20;
    int maxX;
    int maxY;
    int imageW;
    int imageH;
    int imageX;
    int imageY;
    int tileW;
    int tileH;
    Image image;
    java.awt.Image[] tiles;
    boolean[][] solid;
    short[] tMap;
    int mapSize;
    short[] aMap;
    int aMax;

    public TiledLayer(int columns, int rows, Image image, int tileWidth, int tileHeight) {
        if (image == null) {
            throw new NullPointerException("image is null!");
        }
        if (columns < 1 || rows < 1) {
            throw new IllegalArgumentException("columns=" + columns + " rows=" + rows);
        }
        this.maxX = columns;
        this.maxY = rows;
        this.mapSize = this.maxX * this.maxY;
        this.tMap = new short[this.mapSize];
        this.aMax = 0;
        this.aMap = new short[64];
        this.setStaticTileSet(image, tileWidth, tileHeight);
        this.setVisible(true);
    }

    public void setStaticTileSet(Image image, int tileWidth, int tileHeight) {
        if (image == null) {
            throw new NullPointerException("image is null!");
        }
        if (tileWidth < 1 || tileHeight < 1) {
            throw new IllegalArgumentException("tileWidth=" + tileWidth + " tileHeight=" + tileHeight);
        }
        int oldTileCount = this.imageX * this.imageY;
        int imageW = image.getWidth();
        int imageH = image.getHeight();
        if (imageW % tileWidth != 0) {
            throw new IllegalArgumentException("not an integer multiple! tileWidth=" + tileWidth + " imageWidth=" + imageW);
        }
        if (imageH % tileHeight != 0) {
            throw new IllegalArgumentException("not an integer multiple! tileHeight=" + tileHeight + " imageHeight=" + imageH);
        }
        this.image = image;
        this.tileW = tileWidth;
        this.tileH = tileHeight;
        this.imageX = imageW / this.tileW;
        this.imageY = imageH / this.tileH;
        this.layerWidth = this.maxX * this.tileW;
        this.layerHeight = this.maxY * this.tileH;
        int size = this.imageX * this.imageY;
        this.tiles = new java.awt.Image[size];
        this.solid = new boolean[size][];
        java.awt.Image img = (java.awt.Image)EmuCanvas.instance.lcduiBridge.handleEvent(20, image, new int[1]);
        int i2 = 0;
        while (i2 < size) {
            this.tiles[i2] = new BufferedImage(this.tileW, this.tileH, 2);
            java.awt.Graphics g2 = this.tiles[i2].getGraphics();
            int tileX = i2 % this.imageX;
            int tileY = i2 / this.imageX;
            g2.drawImage(img, -tileX * this.tileW, -tileY * this.tileH, null);
            ++i2;
        }
        if (size < oldTileCount) {
            i2 = 0;
            while (i2 < this.mapSize) {
                this.tMap[i2] = 0;
                ++i2;
            }
            i2 = 0;
            while (i2 < this.aMax) {
                this.aMap[i2] = 0;
                ++i2;
            }
            this.aMax = 0;
        }
    }

    public int createAnimatedTile(int staticTileIndex) {
        if (staticTileIndex < 1 || staticTileIndex > this.imageX * this.imageY) {
            throw new IndexOutOfBoundsException("staticTileIndex=" + staticTileIndex + " max allowed value=" + this.imageX * this.imageY);
        }
        this.aMap[this.aMax] = (short)staticTileIndex;
        ++this.aMax;
        return -this.aMax;
    }

    public void setAnimatedTile(int animatedTileIndex, int staticTileIndex) {
        if (staticTileIndex < 1 || staticTileIndex > this.imageX * this.imageY) {
            throw new IndexOutOfBoundsException("staticTileIndex=" + staticTileIndex + " max allowed value=" + this.imageX * this.imageY);
        }
        if (-animatedTileIndex > this.aMax) {
            throw new IndexOutOfBoundsException("animatedTileIndex=" + animatedTileIndex + " max allowed value=" + -this.aMax);
        }
        this.aMap[-animatedTileIndex - 1] = (short)staticTileIndex;
    }

    public int getAnimatedTile(int animatedTileIndex) {
        if (-animatedTileIndex > this.aMax) {
            throw new IndexOutOfBoundsException("animatedTileIndex=" + animatedTileIndex + " max allowed value=" + -this.aMax);
        }
        return this.aMap[-animatedTileIndex - 1];
    }

    public void setCell(int col, int row, int tileIndex) {
        if (col >= this.maxX || row >= this.maxY) {
            throw new IndexOutOfBoundsException("col=" + col + " max allowed column=" + this.maxX + " row=" + row + " max alowed row=" + this.maxY);
        }
        this.tMap[row * this.maxX + col] = (short)tileIndex;
    }

    public int getCell(int col, int row) {
        if (col >= this.maxX || row >= this.maxY) {
            throw new IndexOutOfBoundsException("col=" + col + " max allowed column=" + this.maxX + " row=" + row + " max alowed row=" + this.maxY);
        }
        return this.tMap[row * this.maxX + col];
    }

    public final int getCellWidth() {
        return this.tileW;
    }

    public final int getCellHeight() {
        return this.tileH;
    }

    public final int getColumns() {
        return this.maxX;
    }

    public final int getRows() {
        return this.maxY;
    }

    public void fillCells(int col, int row, int numCols, int numRows, int tileIndex) {
        int maxRow = row + numRows;
        int maxCol = col + numCols;
        if (numCols < 1 || numRows < 0 || col >= this.maxX || maxCol > this.maxX || row >= this.maxY || maxRow > this.maxY) {
            throw new IllegalArgumentException("invalid region specified!");
        }
        int j2 = row;
        while (j2 < maxRow) {
            int idx = j2 * this.maxX + col;
            int i2 = col;
            while (i2 < maxCol) {
                this.tMap[idx] = (short)tileIndex;
                ++idx;
                ++i2;
            }
            ++j2;
        }
    }

    public void paint(Graphics g2) {
        if (!this.isVisible()) {
            return;
        }
        int x = this.getX();
        int y = this.getY();
        int trX = g2.getTranslateX();
        int trY = g2.getTranslateY();
        int x1 = (-x - trX) / this.tileW;
        int x2 = x1 + Display.WIDTH / this.tileW + 2;
        int y1 = (-y - trY) / this.tileH;
        int y2 = y1 + Display.HEIGHT / this.tileH + 2;
        if (x1 < 0) {
            x1 = 0;
        }
        if (x2 > this.maxX) {
            x2 = this.maxX;
        }
        if (y1 < 0) {
            y1 = 0;
        }
        if (y2 > this.maxY) {
            y2 = this.maxY;
        }
        int j2 = y1;
        while (j2 < y2) {
            int mapIndex = j2 * this.maxX + x1;
            int posY = y + j2 * this.tileH;
            int posX = x + x1 * this.tileW;
            int i2 = x1;
            while (i2 < x2) {
                int tileIndex = this.tMap[mapIndex];
                if (tileIndex != 0) {
                    if (tileIndex < 0) {
                        tileIndex = this.aMap[-tileIndex - 1];
                    }
                    if (--tileIndex > -1) {
                        if (tileIndex < this.tiles.length) {
                            g2.emuDrawImage(this.tiles[tileIndex], posX, posY);
                        } else {
                            System.out.println("Pstros: internal error: TiledLayer: oti=" + this.tMap[mapIndex] + " max=" + this.tiles.length);
                        }
                    }
                }
                ++mapIndex;
                posX += this.tileW;
                ++i2;
            }
            ++j2;
        }
    }

    private boolean[] emuCreateSolid(int tileIndex) {
        BufferedImage bi = (BufferedImage)this.tiles[tileIndex];
        int[] rgb = new int[this.tileW * this.tileH];
        boolean[] data = new boolean[this.tileW * this.tileH];
        bi.getRGB(0, 0, this.tileW, this.tileH, rgb, 0, this.tileW);
        int i2 = 0;
        while (i2 < data.length) {
            data[i2] = (rgb[i2] & 0xFF000000) == -16777216;
            ++i2;
        }
        return data;
    }

    boolean emuCollideWithPoint(int pointX, int pointY) {
        int x = this.getX();
        int y = this.getY();
        int x1 = (-x + pointX) / this.tileW;
        int y1 = (-y + pointY) / this.tileH;
        if (x1 < 0 || y1 < 0 || x1 >= this.maxX || y1 >= this.maxY) {
            return false;
        }
        int mapIndex = y1 * this.maxX + x1;
        short tileIndex = this.tMap[mapIndex];
        return tileIndex != 0;
    }

    boolean emuPixelCollision(int sX, int sW, int sY, int sH, int sOffset, int sScanLength, boolean[] sSolid) {
        int cX = this.getX();
        int cY = this.getY();
        int pointY = 0;
        while (pointY < sH) {
            int y1;
            int sIndex = sOffset + sScanLength * pointY;
            int pixelY = y1 = -cY + pointY + sY;
            int y2 = y1 % this.tileH;
            if (pixelY >= 0 && (y1 /= this.tileH) < this.maxY) {
                int pointX = 0;
                while (pointX < sW) {
                    if (sSolid[sIndex]) {
                        int mapIndex;
                        int tileIndex;
                        int x1;
                        int pixelX = x1 = -cX + pointX + sX;
                        int x2 = x1 % this.tileW;
                        if (pixelX >= 0 && (x1 /= this.tileW) < this.maxX && (tileIndex = this.tMap[mapIndex = y1 * this.maxX + x1]) != 0) {
                            if (tileIndex < 0) {
                                tileIndex = this.aMap[-tileIndex - 1];
                            }
                            if (--tileIndex >= 0) {
                                boolean[] dSolid = this.solid[tileIndex];
                                if (dSolid == null) {
                                    dSolid = this.emuCreateSolid(tileIndex);
                                    this.solid[tileIndex] = dSolid;
                                }
                                if (dSolid[y2 * this.tileW + x2]) {
                                    return true;
                                }
                            }
                        }
                    }
                    ++sIndex;
                    ++pointX;
                }
            }
            ++pointY;
        }
        return false;
    }
}

