/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.rms;

import java.util.Vector;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordComparator;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordFilter;
import javax.microedition.rms.RecordListener;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;
import ole.pstros.MainApp;
import ole.pstros.rms.RmsEnumeration;
import ole.pstros.rms.RmsGroup;
import ole.pstros.rms.RmsManager;
import ole.pstros.rms.RmsRecord;

public class RecordStore {
    private static final int EVENT_ADD = 0;
    private static final int EVENT_CHANGE = 1;
    private static final int EVENT_DELETE = 2;
    public static final int AUTHMODE_PRIVATE = 0;
    public static final int AUTHMODE_ANY = 1;
    private static RmsManager emuRmsManager = RmsManager.getInstance();
    private RmsGroup emuRmsGroup;
    private int version;
    private Vector listeners;
    private boolean closed;

    private RecordStore(RmsGroup group) {
        this.emuRmsGroup = group;
        this.version = 1;
    }

    public static RecordStore openRecordStore(String recordStoreName, boolean createIfNecessary) throws RecordStoreException, RecordStoreFullException, RecordStoreNotFoundException {
        if (MainApp.verbose) {
            System.out.println("openRecordStore, midp1");
        }
        return RecordStore.openRecordStore(recordStoreName, MainApp.getApplicationName(), false, createIfNecessary);
    }

    public static RecordStore openRecordStore(String recordStoreName, boolean createIfNecessary, int authmode, boolean writable) throws RecordStoreException, RecordStoreFullException, RecordStoreNotFoundException {
        if (MainApp.verbose) {
            System.out.println("openRecordStore, midp2");
        }
        boolean authMode = false;
        if (authmode == 1) {
            authMode = true;
        }
        return RecordStore.openRecordStore(recordStoreName, MainApp.getApplicationName(), authMode, createIfNecessary);
    }

    public static RecordStore openRecordStore(String recordStoreName, String vendorName, String suiteName) throws RecordStoreException, RecordStoreNotFoundException {
        boolean authMode = false;
        if (MainApp.verbose) {
            System.out.println("openRecordStore, midp2, vendor=" + vendorName);
        }
        if (suiteName == null || !suiteName.equals(MainApp.getApplicationName())) {
            authMode = true;
        }
        return RecordStore.openRecordStore(recordStoreName, suiteName, authMode, false);
    }

    private static RecordStore openRecordStore(String recordStoreName, String appName, boolean publicAuth, boolean createIfNecessary) throws RecordStoreException, RecordStoreFullException, RecordStoreNotFoundException {
        if (MainApp.verbose) {
            System.out.println("  -> openRecordStore: name=" + recordStoreName + " create=" + createIfNecessary + " application=" + MainApp.getApplicationName() + " public=" + publicAuth);
        }
        if (recordStoreName == null || recordStoreName.length() > 32) {
            throw new IllegalArgumentException("Invalid store name:" + recordStoreName);
        }
        RmsGroup group = emuRmsManager.getRmsGroup(appName, recordStoreName, publicAuth, createIfNecessary);
        if (group == null) {
            if (MainApp.verbose) {
                System.out.println("openRecordStore: record store not found! name=" + recordStoreName);
            }
            throw new RecordStoreNotFoundException("Record store not found! name=" + recordStoreName);
        }
        return new RecordStore(group);
    }

    public void setMode(int authmode, boolean writable) throws RecordStoreException {
        if (this.emuRmsGroup == null) {
            throw new RecordStoreException("record store is corrupted.");
        }
        if (!MainApp.getApplicationName().equals(this.emuRmsGroup.getApplicationName())) {
            throw new SecurityException("change is not allowed");
        }
        if (authmode != 1 && authmode != 0) {
            throw new IllegalArgumentException("unsupported auth mode=" + authmode);
        }
        this.emuRmsGroup.setAuthMode(authmode == 1);
    }

    public static void deleteRecordStore(String recordStoreName) throws RecordStoreException, RecordStoreNotFoundException {
        boolean result;
        if (MainApp.verbose) {
            System.out.println("deleteRecordStore: name=" + recordStoreName + " application=" + MainApp.getApplicationName());
        }
        if (!(result = emuRmsManager.removeGroup(MainApp.getApplicationName(), recordStoreName))) {
            throw new RecordStoreNotFoundException("recordStoreName=" + recordStoreName);
        }
    }

    public static String[] listRecordStores() {
        if (MainApp.verbose) {
            System.out.println("Record store: listRecordStores()");
        }
        return emuRmsManager.getGroupNames(MainApp.getApplicationName());
    }

    public int addRecord(byte[] data, int offset, int numBytes) throws RecordStoreNotOpenException, RecordStoreException, RecordStoreFullException {
        if (MainApp.verbose) {
            System.out.println("RecordStore: addRecord dataSize=" + data.length + " offset=" + offset + " numBytes=" + numBytes);
        }
        if (this.closed) {
            throw new RecordStoreNotOpenException();
        }
        ++this.version;
        int result = this.emuRmsGroup.addRecord(data, offset, numBytes);
        this.setEvent(0, result);
        return result;
    }

    public void closeRecordStore() throws RecordStoreNotOpenException, RecordStoreException {
        if (MainApp.verbose) {
            System.out.println("RecordStore.closeRecordStore()");
        }
        if (this.closed) {
            throw new RecordStoreNotOpenException();
        }
        this.closed = true;
        if (this.listeners != null) {
            this.listeners.clear();
        }
    }

    public void deleteRecord(int recordId) throws RecordStoreNotOpenException, InvalidRecordIDException, RecordStoreException {
        if (MainApp.verbose) {
            System.out.println("RecordStore.deleteRecord(id) " + recordId);
        }
        if (this.closed) {
            throw new RecordStoreNotOpenException();
        }
        boolean result = this.emuRmsGroup.removeRecord(recordId);
        if (!result) {
            throw new InvalidRecordIDException("id=" + recordId);
        }
        ++this.version;
        this.setEvent(2, recordId);
    }

    public String getName() throws RecordStoreNotOpenException {
        if (MainApp.verbose) {
            System.out.println("RecordStore.getName()");
        }
        if (this.closed) {
            throw new RecordStoreNotOpenException();
        }
        return this.emuRmsGroup.getName();
    }

    public int getNextRecordID() throws RecordStoreNotOpenException, RecordStoreException {
        if (MainApp.verbose) {
            System.out.println("RecordStore.getNextRecordId()");
        }
        if (this.closed) {
            throw new RecordStoreNotOpenException();
        }
        return this.emuRmsGroup.getNextRecordId();
    }

    public int getNumRecords() throws RecordStoreNotOpenException {
        if (MainApp.verbose) {
            System.out.println("RecordStore.getNumRecords()");
        }
        if (this.closed) {
            throw new RecordStoreNotOpenException();
        }
        if (MainApp.verbose) {
            System.out.println("  -->returned " + this.emuRmsGroup.getSize());
        }
        return this.emuRmsGroup.getSize();
    }

    public byte[] getRecord(int recordId) throws RecordStoreNotOpenException, InvalidRecordIDException, RecordStoreException {
        if (MainApp.verbose) {
            System.out.println("RecordStore.getRecord(id) groupName=" + this.emuRmsGroup.getName() + " groupSize=" + this.emuRmsGroup.getSize());
        }
        if (this.closed) {
            throw new RecordStoreNotOpenException();
        }
        byte[] src = this.emuRmsGroup.getRecordData(recordId);
        if (src == null) {
            throw new InvalidRecordIDException("recordId=" + recordId);
        }
        byte[] dst = new byte[src.length];
        if (src.length > 0) {
            System.arraycopy(src, 0, dst, 0, src.length);
        }
        if (MainApp.verbose) {
            System.out.println("  --> returned size " + dst.length);
        }
        return dst;
    }

    public int getRecord(int recordId, byte[] buffer, int offset) throws RecordStoreNotOpenException, InvalidRecordIDException, RecordStoreException {
        if (MainApp.verbose) {
            System.out.println("RecordStore.getRecord(id, buffer, offset) groupName=" + this.emuRmsGroup.getName() + " groupSize=" + this.emuRmsGroup.getSize() + " id=" + recordId);
        }
        if (this.closed) {
            throw new RecordStoreNotOpenException();
        }
        byte[] src = this.emuRmsGroup.getRecordData(recordId);
        if (src == null) {
            throw new InvalidRecordIDException("recordId=" + recordId);
        }
        if (buffer.length - offset < src.length) {
            throw new ArrayIndexOutOfBoundsException("recordId=" + recordId);
        }
        if (src.length > 0) {
            System.arraycopy(src, 0, buffer, offset, src.length);
        }
        return src.length;
    }

    public int getRecordSize(int recordId) throws RecordStoreNotOpenException, InvalidRecordIDException, RecordStoreException {
        if (MainApp.verbose) {
            System.out.println("RecordStore.getRecordSize()");
        }
        if (this.closed) {
            throw new RecordStoreNotOpenException();
        }
        byte[] src = this.emuRmsGroup.getRecordData(recordId);
        if (src == null) {
            throw new InvalidRecordIDException("recordId=" + recordId);
        }
        return src.length;
    }

    public int getSize() throws RecordStoreNotOpenException {
        if (MainApp.verbose) {
            System.out.println("RecordStore.getSize()");
        }
        if (this.closed) {
            throw new RecordStoreNotOpenException();
        }
        return this.emuRmsGroup.getDataSize();
    }

    public int getSizeAvailable() throws RecordStoreNotOpenException {
        if (MainApp.verbose) {
            System.out.println("RecordStore.getSizeAvailable()");
        }
        if (this.closed) {
            throw new RecordStoreNotOpenException();
        }
        return 0x100000;
    }

    public int getVersion() throws RecordStoreNotOpenException {
        if (MainApp.verbose) {
            System.out.println("RecordStore.getVersion()");
        }
        if (this.closed) {
            throw new RecordStoreNotOpenException();
        }
        return this.version;
    }

    public long getLastModified() {
        if (MainApp.verbose) {
            System.out.println("RecordStore.getLastModified()");
        }
        return 0L;
    }

    public void setRecord(int recordId, byte[] newData, int offset, int numBytes) throws RecordStoreNotOpenException, InvalidRecordIDException, RecordStoreException, RecordStoreFullException {
        if (MainApp.verbose) {
            System.out.println("RecordStore.setRecord() recordId=" + recordId + " dataSize=" + newData.length + " offset=" + offset + " numBytes=" + numBytes);
        }
        if (this.closed) {
            throw new RecordStoreNotOpenException();
        }
        RmsRecord record = this.emuRmsGroup.getRecord(recordId);
        if (record == null) {
            throw new InvalidRecordIDException("recordId=" + recordId);
        }
        record.setData(newData, offset, numBytes);
        ++this.version;
        this.setEvent(1, recordId);
    }

    public void addRecordListener(RecordListener listener) {
        if (MainApp.verbose) {
            System.out.println("RecordStore.addListener()");
        }
        if (listener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeRecordListener(RecordListener listener) {
        if (MainApp.verbose) {
            System.out.println("RecordStore.removeListener()");
        }
        if (listener == null || this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    private void setEvent(int type, int recordId) {
        if (this.listeners == null) {
            return;
        }
        int size = this.listeners.size();
        int i2 = 0;
        while (i2 < size) {
            RecordListener listener = (RecordListener)this.listeners.get(i2);
            switch (type) {
                case 0: {
                    listener.recordAdded(this, recordId);
                    break;
                }
                case 1: {
                    listener.recordChanged(this, recordId);
                    break;
                }
                case 2: {
                    listener.recordDeleted(this, recordId);
                }
            }
            ++i2;
        }
    }

    public RecordEnumeration enumerateRecords(RecordFilter filter, RecordComparator comparator, boolean keepUpdated) throws RecordStoreNotOpenException {
        if (MainApp.verbose) {
            System.out.println("RecordStore.enumerateRecord()");
        }
        if (this.closed) {
            throw new RecordStoreNotOpenException();
        }
        return new RmsEnumeration(filter, comparator, this.emuRmsGroup);
    }
}

