/*
 * Decompiled with CFR 0.152.
 */
package ole.pstros;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.ScrollPaneAdjustable;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Screen;
import ole.pstros.ConfigData;
import ole.pstros.IEmuBridge;
import ole.pstros.MainApp;
import ole.pstros.monitor.ClassManager;
import ole.pstros.reference.ImageReferenceManager;
import ole.pstros.rms.RmsManager;
import ole.pstros.utils.ImageViewer;
import ole.pstros.utils.MonitorFrame;
import ole.pstros.utils.ParamWriter;
import ole.pstros.utils.StreamSaver;
import ole.pstros.utils.TgaWriter;
import ole.pstros.utils.ZoomViewer;

public class EmuCanvas
extends java.awt.Canvas
implements KeyListener,
WindowListener,
MouseListener,
MouseMotionListener {
    private static Color COLOR_BLACK = new Color(0);
    private static Color COLOR_WHITE = new Color(0xFFFFFF);
    private static Color COLOR_BLUE = new Color(255);
    private static Color COLOR_LIGHT_GRAY = new Color(0xBBBBBB);
    private static Color COLOR_GRAY = new Color(0x909090);
    public static final int MASK_ALT = 8;
    public static EmuCanvas instance;
    private static Rectangle tmpClipRect;
    private Displayable displayable;
    private Image emuImage;
    private BufferedImage scaledImage;
    private Graphics emuGraph;
    private Graphics scaledGraph;
    private javax.microedition.lcdui.Graphics deviceGraph;
    private static int emuFrameCounter;
    private int[] scaledSrc;
    private int[] scaledDst;
    private int lastScale;
    private boolean capture;
    private boolean screenShot;
    private int scrShotIndex;
    private int captureWidth;
    private int captureHeight;
    private int captureOffsetY;
    private boolean painting;
    private boolean emuPaintRequest;
    private boolean hideNotifyTest;
    private boolean debugKeys = false;
    private boolean distanceMode = false;
    private int mouseX;
    private int mouseY;
    private int repaintX;
    private int repaintY;
    private int repaintW;
    private int repaintH;
    private Component parentComponent;
    private java.awt.Font consoleFont;
    private FontRenderContext frc;
    public int[] paintLock = new int[1];
    private int[] pauseLock = new int[1];
    private int[] tmpInt = new int[4];
    private boolean showImageView = false;
    private boolean showZoom = false;
    private Frame imageViewerFrame;
    private Frame zoomFrame;
    private ZoomViewer zoomViewer;
    private MonitorFrame classMonitorFrame;
    private long lastTime;
    private int fps;
    private boolean paused;
    public IEmuBridge lcduiBridge;
    private int[] frameBackupRGB;
    private boolean restoreFrame;

    static {
        tmpClipRect = new Rectangle();
    }

    public static EmuCanvas getInstance() {
        if (instance == null) {
            instance = new EmuCanvas();
        }
        return instance;
    }

    private EmuCanvas() {
        this.setBackground(COLOR_WHITE);
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setParentComponent(Component c2) {
        this.parentComponent = c2;
    }

    public void backupImage() {
        if (!(this.emuImage instanceof BufferedImage)) {
            return;
        }
        BufferedImage img = (BufferedImage)this.emuImage;
        int w = img.getWidth();
        int h2 = img.getHeight();
        this.frameBackupRGB = new int[w * h2];
        img.getRGB(0, 0, w, h2, this.frameBackupRGB, 0, w);
    }

    public void restoreImage() {
        this.restoreFrame = true;
    }

    public javax.microedition.lcdui.Graphics createGraphics() {
        Image img = this.createImage(Display.WIDTH, Display.HEIGHT);
        if (img == null && this.parentComponent != null) {
            img = this.parentComponent.createImage(Display.WIDTH, Display.HEIGHT);
        }
        if (img == null) {
            img = new BufferedImage(Display.WIDTH, Display.HEIGHT, 2);
        }
        Graphics eg = img.getGraphics();
        eg.setColor(COLOR_BLACK);
        eg.fillRect(0, 0, Display.WIDTH, Display.HEIGHT);
        javax.microedition.lcdui.Graphics dg = new javax.microedition.lcdui.Graphics();
        dg.emuSetGraphics(eg);
        dg.emuSetGraphicsImage((BufferedImage)img);
        dg.setClip(0, 0, Display.WIDTH, Display.HEIGHT);
        return dg;
    }

    public void init() {
        this.emuImage = null;
        this.emuImage = this.createImage(Display.WIDTH, Display.HEIGHT);
        if (this.emuImage == null && this.parentComponent != null) {
            this.emuImage = this.parentComponent.createImage(Display.WIDTH, Display.HEIGHT);
        }
        if (this.emuImage == null) {
            this.emuImage = new BufferedImage(Display.WIDTH, Display.HEIGHT, 2);
        }
        this.initScaledGraphics();
        this.emuGraph = this.emuImage.getGraphics();
        this.emuGraph.setColor(COLOR_BLACK);
        this.emuGraph.fillRect(0, 0, Display.WIDTH, Display.HEIGHT);
        this.deviceGraph = new javax.microedition.lcdui.Graphics();
        this.deviceGraph.emuSetGraphics(this.emuGraph);
        this.deviceGraph.emuSetGraphicsImage((BufferedImage)this.emuImage);
        this.deviceGraph.setClip(0, 0, Display.WIDTH, Display.HEIGHT);
        this.consoleFont = ConfigData.bottomConsoleHeight > 0 ? new java.awt.Font(null, 0, ConfigData.bottomConsoleHeight - 4) : new java.awt.Font(null, 0, 12);
        this.frc = new FontRenderContext(null, false, false);
        this.mouseX = -1;
        this.mouseY = -1;
    }

    public javax.microedition.lcdui.Graphics getDeviceGraphics() {
        return this.deviceGraph;
    }

    public BufferedImage getEmuImage() {
        return (BufferedImage)this.emuImage;
    }

    public void setEmuPaintRequest(int x, int y, int w, int h2) {
        if (!this.emuPaintRequest) {
            this.repaintX = x;
            this.repaintY = y;
            this.repaintW = w;
            this.repaintH = h2;
        } else {
            int repaintX2 = this.repaintX + this.repaintW;
            int repaintY2 = this.repaintY + this.repaintH;
            int x2 = x + w;
            int y2 = y + w;
            if (x < this.repaintX) {
                this.repaintX = x;
            }
            if (y < this.repaintY) {
                this.repaintY = y;
            }
            if (repaintX2 < x2) {
                repaintX2 = x2;
            }
            if (repaintY2 < y2) {
                repaintY2 = y2;
            }
            this.repaintW = repaintX2 - this.repaintX;
            this.repaintH = repaintY2 - this.repaintY;
        }
        this.emuPaintRequest = true;
    }

    public void setBridge(IEmuBridge bridge) {
        this.lcduiBridge = bridge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContent(Displayable d2, IEmuBridge bridge) {
        if (this.displayable instanceof Canvas) {
            this.lcduiBridge.handleEvent(2, this.displayable);
        }
        this.displayable = d2;
        this.lcduiBridge = bridge;
        if (this.displayable != null) {
            this.lcduiBridge.handleEvent(7, this.displayable, this);
        }
        this.deviceGraph.translate(-this.deviceGraph.getTranslateX(), -this.deviceGraph.getTranslateY());
        this.deviceGraph.setClip(0, 0, 1000, 1000);
        if (this.displayable instanceof Canvas) {
            Displayable displayable = this.displayable;
            synchronized (displayable) {
                this.lcduiBridge.handleEvent(1, this.displayable);
            }
        }
        if (MainApp.verbose) {
            System.out.println("EmuCanvas.setContent:" + d2);
        }
        if (ConfigData.slaveMode) {
            if (d2 != null) {
                this.setEmuPaintRequest(0, 0, d2.getWidth(), d2.getHeight());
                this.update();
            }
        } else if (d2 != null) {
            this.setEmuPaintRequest(0, 0, d2.getWidth(), d2.getHeight());
            this.repaint();
        }
    }

    public void update(Graphics g2) {
        if (MainApp.verbose) {
            System.out.println("EmuCanvas: update:" + g2);
        }
        if (g2 == null) {
            g2 = this.getGraphics();
        }
        if (this.hideNotifyTest) {
            g2.setColor(Color.CYAN);
            g2.setClip(0, 0, 1000, 1000);
            g2.fillRect(0, 0, 1000, 1000);
            g2.setColor(Color.RED);
            int i2 = 0;
            while (i2 < 100) {
                g2.fillRect(0, i2 * 20, 1000, 10);
                ++i2;
            }
        } else {
            this.paintContent(g2);
        }
    }

    public void update() {
        this.paintContent(null);
    }

    public int getFps() {
        return this.fps;
    }

    public void paint() {
        if (MainApp.verbose) {
            System.out.println("EmuCanvas: paint()...");
        }
        Graphics g2 = this.getGraphics();
        this.paintContent(g2);
        g2.dispose();
    }

    public boolean paintRequestValid() {
        return this.emuPaintRequest;
    }

    public void paint(Graphics g2) {
        if (MainApp.verbose) {
            System.out.println("EmuCanvas: paint(g)...");
        }
        if (ConfigData.skinImage != null) {
            g2.drawImage(ConfigData.skinImage, 0, 0, null);
        }
        this.paintContent(g2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintContent(Graphics g2) {
        int[] nArray = this.paintLock;
        synchronized (this.paintLock) {
            this.painting = true;
            if (this.emuGraph == null) {
                if (MainApp.verbose) {
                    System.out.println("EmuCanvas: paintContent() emuGraph is null.");
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (this.restoreFrame) {
                if (this.frameBackupRGB != null) {
                    int w = this.emuImage.getWidth(null);
                    int h2 = this.emuImage.getHeight(null);
                    this.deviceGraph.drawRGB(this.frameBackupRGB, 0, w, 0, 0, w, h2, true);
                    this.frameBackupRGB = null;
                }
                this.restoreFrame = false;
            }
            if (this.displayable instanceof Screen) {
                this.paintScreen(g2, (Screen)this.displayable);
            } else if (this.displayable instanceof Canvas) {
                this.paintCanvas(g2, (Canvas)this.displayable);
            } else if (MainApp.verbose) {
                System.out.println("Pstros : paint unknown displayable! " + this.displayable);
            }
            if (this.distanceMode && this.zoomViewer != null && this.zoomViewer.isShowing()) {
                this.zoomViewer.repaint();
            }
            this.painting = false;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public boolean callRunner() {
        if (!this.painting) {
            return Display.emuRunSerialRunner();
        }
        return false;
    }

    public boolean isPainting() {
        return this.painting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void togglePause() {
        int[] nArray = this.pauseLock;
        synchronized (this.pauseLock) {
            boolean stop = this.paused = !this.paused;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return;
        }
    }

    public void flushGraphics(Image img) {
        if (img == null) {
            img = this.emuImage;
        }
        if (ConfigData.slaveMode) {
            this.paintCanvasContent(null, this.displayable, img, true);
        } else {
            Graphics g2 = this.getGraphics();
            this.paintCanvasContent(g2, this.displayable, img, true);
            if (g2 != null) {
                g2.dispose();
                this.updateFps();
            }
        }
        if (ConfigData.drawWait > 0) {
            try {
                Thread.sleep(ConfigData.drawWait);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void checkPause() {
        if (ConfigData.slaveMode) {
            return;
        }
        var2_1 = this.pauseLock;
        // MONITORENTER : this.pauseLock
        stop = this.paused;
        // MONITOREXIT : var2_1
        if (true) ** GOTO lbl27
        do {
            var2_1 = this.pauseLock;
            // MONITORENTER : this.pauseLock
            stop = this.paused;
            // MONITOREXIT : var2_1
            try {
                Thread.sleep(5L);
            }
            catch (Exception e) {
                System.out.println(e);
            }
lbl27:
            // 3 sources

        } while (stop);
    }

    private void paintScreen(Graphics g2, Screen screen) {
        this.lcduiBridge.handleEvent(8, this.emuGraph);
        if (g2 != null) {
            int x = ConfigData.skinScreenX;
            int y = ConfigData.skinScreenY;
            int w = Display.WIDTH * ConfigData.scale;
            int h2 = Display.HEIGHT * ConfigData.scale;
            g2.drawImage(this.emuImage, x, y, x + w, y + h2, 0, 0, Display.WIDTH, Display.HEIGHT, this);
        } else {
            MainApp.getInstance().setEvent("emuRefreshDisplay", this.emuImage);
        }
    }

    private void updateFps() {
        if (++emuFrameCounter % 40 == 0) {
            long now = System.currentTimeMillis();
            if (this.lastTime > 0L) {
                int divisor = (int)(now - this.lastTime);
                if (divisor == 0) {
                    divisor = 5;
                    try {
                        Thread.sleep(5L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.fps = 40000 / divisor;
            }
            this.lastTime = now;
        }
    }

    private void paintCanvas(Graphics g2, Canvas canvas) {
        boolean wasEmuRequested = this.emuPaintRequest;
        if (this.emuPaintRequest) {
            this.emuPaintRequest = false;
            try {
                if (MainApp.verbose) {
                    System.out.println("-------------Pstros:EmuCanvas.paint ------ frame=" + emuFrameCounter);
                }
                this.updateFps();
                this.deviceGraph.setColor(0);
                this.deviceGraph.translate(-this.deviceGraph.getTranslateX(), -this.deviceGraph.getTranslateY());
                this.deviceGraph.setClip(this.repaintX, this.repaintY, this.repaintW, this.repaintH);
                this.deviceGraph.setFont(Font.getDefaultFont());
                this.deviceGraph.setStrokeStyle(0);
                this.lcduiBridge.handleEvent(9, canvas, this);
                this.lcduiBridge.handleEvent(8, this.deviceGraph, this);
                if (ConfigData.drawWait > 0) {
                    try {
                        Thread.sleep(ConfigData.drawWait);
                    }
                    catch (Exception e2) {
                        System.out.println("thread.sleep interrupted! " + e2);
                    }
                }
            }
            catch (Exception e3) {
                System.out.println("Pstros: unhandled exception in J2ME code! Error:" + e3);
                e3.printStackTrace();
            }
        }
        this.paintCanvasContent(g2, canvas, this.emuImage, wasEmuRequested);
    }

    private void paintCanvasContent(Graphics g2, Displayable disp, Image img, boolean wasEmuRequest) {
        int topH = ConfigData.topConsoleHeight;
        int botH = ConfigData.bottomConsoleHeight;
        int x = ConfigData.skinScreenX;
        int y = ConfigData.skinScreenY;
        int w = Display.WIDTH * ConfigData.scale;
        int h2 = (Display.HEIGHT - topH) * ConfigData.scale;
        if (disp == null) {
            return;
        }
        if (this.lcduiBridge.handleEvent(10, disp) != null) {
            topH = 0;
            botH = 0;
            h2 = Display.HEIGHT * ConfigData.scale;
        }
        Color currColor = null;
        int ths = topH * ConfigData.scale;
        if (topH > 0 && g2 != null) {
            currColor = this.emuGraph.getColor();
            this.emuGraph.getClipBounds(tmpClipRect);
            g2.setColor(COLOR_LIGHT_GRAY);
            g2.setClip(x, y, w, ths);
            g2.fillRect(x, y, w, ths);
        }
        if (botH > 0) {
            if (currColor == null) {
                currColor = this.emuGraph.getColor();
                this.emuGraph.getClipBounds(tmpClipRect);
            }
            this.emuGraph.setClip(0, 0, Display.WIDTH, Display.HEIGHT);
            this.emuGraph.setColor(COLOR_LIGHT_GRAY);
            this.emuGraph.fillRect(0, Display.HEIGHT - botH - topH, Display.WIDTH, botH);
            Object lc = this.lcduiBridge.handleEvent(11, disp);
            Object rc = this.lcduiBridge.handleEvent(12, disp);
            if (lc != null) {
                java.awt.Font currentFont = this.emuGraph.getFont();
                this.emuGraph.setColor(Color.BLACK);
                this.emuGraph.setFont(this.consoleFont);
                this.emuGraph.drawString(((Command)lc).getLabel(), 0, Display.HEIGHT - 4 - topH);
                this.emuGraph.setFont(currentFont);
            }
            if (rc != null) {
                String label = ((Command)rc).getLabel();
                Rectangle2D rect = this.consoleFont.getStringBounds(label, this.frc);
                java.awt.Font currentFont = this.emuGraph.getFont();
                this.emuGraph.setColor(Color.BLACK);
                this.emuGraph.setFont(this.consoleFont);
                this.emuGraph.drawString(label, Display.WIDTH - (int)rect.getWidth() - 1, Display.HEIGHT - 4 - topH);
                this.emuGraph.setFont(currentFont);
            }
        }
        if (currColor != null) {
            this.emuGraph.setClip(tmpClipRect);
            this.emuGraph.setColor(currColor);
        }
        if (g2 != null) {
            if (wasEmuRequest) {
                g2.setClip(x + this.repaintX * ConfigData.scale, y + this.repaintY * ConfigData.scale, this.repaintW * ConfigData.scale, this.repaintH * ConfigData.scale);
            } else {
                g2.setClip(x, y, 1024, 1024);
            }
            if (!ConfigData.externalScaler && ConfigData.displayGamma % 100 == 0 || ConfigData.scale == 1 && ConfigData.displayGamma % 100 == 0) {
                g2.drawImage(img, x, y + ths, x + w, y + ths + h2, 0, 0, Display.WIDTH, Display.HEIGHT - topH, this);
            } else {
                this.rescale(false, img);
                g2.drawImage(this.scaledImage, x, y + ths, this);
            }
        } else if (ConfigData.slaveMode) {
            MainApp.getInstance().setEvent("emuRefreshDisplay", img);
        }
        if (this.capture) {
            StreamSaver.saveImageData((BufferedImage)img, this.captureWidth, this.captureHeight, this.captureOffsetY);
        }
        if (this.screenShot) {
            this.screenShot = false;
            TgaWriter.saveImage("scrShot", (BufferedImage)img, this.captureWidth, this.captureHeight, this.captureOffsetY, this.scrShotIndex++);
        }
    }

    private void setCaptureSize() {
        this.captureWidth = Display.WIDTH;
        this.captureHeight = Display.HEIGHT;
        if (ConfigData.captureHeight > 0 && this.captureHeight >= ConfigData.captureHeight) {
            this.captureOffsetY = (this.captureHeight - ConfigData.captureHeight) / 2;
            if (ConfigData.captureOffsetY > 0 && this.captureHeight >= ConfigData.captureOffsetY + ConfigData.captureHeight) {
                this.captureOffsetY = ConfigData.captureOffsetY;
            }
            this.captureHeight = ConfigData.captureHeight;
        }
    }

    public void keyAction(int actionType, int key) {
        if (this.displayable != null) {
            this.tmpInt[0] = key;
            this.tmpInt[1] = 32;
            this.tmpInt[2] = 0;
            this.tmpInt[3] = actionType;
            this.lcduiBridge.handleEvent(13, this.displayable, this.tmpInt);
        }
    }

    private void initScaledGraphics() {
        if (!ConfigData.slaveMode && (ConfigData.externalScaler || ConfigData.displayGamma % 100 != 0)) {
            this.scaledImage = new BufferedImage(Display.WIDTH * ConfigData.scale, Display.HEIGHT * ConfigData.scale, 2);
            this.scaledGraph = this.scaledImage.getGraphics();
        }
    }

    private void runCallEvent(Canvas gCanvas) {
        if (ConfigData.callEvent == null) {
            this.lcduiBridge.handleEvent(2, gCanvas);
            this.hideNotifyTest = true;
            Graphics g2 = this.getGraphics();
            this.update(g2);
            g2.dispose();
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Thread.yield();
            this.hideNotifyTest = false;
            this.lcduiBridge.handleEvent(1, gCanvas);
        } else {
            if (MainApp.verbose) {
                System.out.println("Pstros: device.callEvent=" + ConfigData.callEvent);
            }
            StringTokenizer st = new StringTokenizer(ConfigData.callEvent, ",; ");
            int size = st.countTokens();
            int i2 = 0;
            while (i2 < size) {
                String command = st.nextToken();
                if (MainApp.verbose) {
                    System.out.println("pstros: event command=" + command);
                }
                if (command.equals("pauseApp") || command.equals("pa")) {
                    if (MainApp.midlet != null) {
                        MainApp.midletBridge.handleEvent(5, MainApp.midlet);
                    }
                } else if (command.equals("startApp") || command.equals("sa")) {
                    if (MainApp.midlet != null) {
                        MainApp.midletBridge.handleEvent(6, MainApp.midlet);
                    }
                } else if (command.equals("hideNotify") || command.equals("hn")) {
                    this.lcduiBridge.handleEvent(2, gCanvas);
                } else if (command.equals("showNotify") || command.equals("sn")) {
                    this.lcduiBridge.handleEvent(1, gCanvas);
                } else if (command.equals("screenOff") || command.equals("s0")) {
                    this.hideNotifyTest = true;
                    Graphics g3 = this.getGraphics();
                    this.update(g3);
                    g3.dispose();
                } else if (command.equals("screenOn") || command.equals("s1")) {
                    this.hideNotifyTest = false;
                } else if (command.startsWith("wait") || command.startsWith("w")) {
                    String number = command.startsWith("wait") ? command.substring(4) : command.substring(1);
                    if (number == null || number.length() < 1) {
                        number = "1000";
                    }
                    int value = Integer.parseInt(number);
                    try {
                        Thread.sleep(value);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++i2;
            }
        }
    }

    public void keyPressed(KeyEvent e2) {
        int keyCode = e2.getKeyCode();
        char keyChar = e2.getKeyChar();
        int modifiers = e2.getModifiers();
        if (this.debugKeys) {
            System.out.println("EmuCanvas.keyPressed key=" + keyCode + " modifiers=" + Integer.toHexString(modifiers) + " diplayable=" + this.displayable);
        }
        if (this.displayable != null) {
            this.tmpInt[0] = keyCode;
            this.tmpInt[1] = keyChar;
            this.tmpInt[2] = modifiers;
            this.tmpInt[3] = 0;
            this.lcduiBridge.handleEvent(13, this.displayable, this.tmpInt);
        }
        if (keyCode >= 49 && keyCode <= 51 && (modifiers & 8) != 0) {
            ConfigData.scale = keyCode - 48;
            Display.emuResizeEmuFrame();
        } else if (keyCode == 20) {
            this.debugKeys = !this.debugKeys;
        } else if (keyCode == 77 && (modifiers & 8) != 0) {
            this.showClassMonitor();
        } else if (keyCode == 75 && (modifiers & 8) != 0) {
            boolean bl = ConfigData.numKeySwap = !ConfigData.numKeySwap;
            if (this.displayable instanceof Canvas) {
                this.lcduiBridge.handleEvent(22, this.displayable, this.tmpInt);
            }
        } else if (keyCode == 86 && (modifiers & 8) != 0) {
            MainApp.verbose = !MainApp.verbose;
        } else if (keyCode == 73 && (modifiers & 8) != 0) {
            this.showImageInfo();
        } else if (keyCode == 71 && (modifiers & 8) != 0) {
            MainApp.forceGC();
        } else if (keyCode == 68 && (modifiers & 8) != 0) {
            this.distanceMode = true;
            this.showZoomFrame();
        } else if (keyCode == Display.keyRotate) {
            this.rotateDisplay();
        } else if (keyCode == Display.keyPause) {
            this.togglePause();
        } else if (keyCode == Display.keyScreenShot) {
            this.screenShot = true;
            this.setCaptureSize();
            System.out.println("Screen shot taken!  offsetY=" + this.captureOffsetY + " height=" + this.captureHeight);
        } else if (keyCode == Display.keyCaptureVideo) {
            if (this.capture) {
                this.capture = false;
                StreamSaver.close();
                System.out.println("Capture stop!");
            } else {
                this.setCaptureSize();
                StreamSaver.setFileName(String.valueOf(ConfigData.captureFile) + ".orv");
                try {
                    if ((modifiers & 8) == 0) {
                        StreamSaver.init(this.captureWidth, this.captureHeight, 1);
                    } else {
                        StreamSaver.init(this.captureWidth, this.captureHeight, 0);
                    }
                    System.out.println("Capture start!  offsetY=" + this.captureOffsetY + " height=" + this.captureHeight);
                    this.capture = true;
                }
                catch (Exception exc) {
                    System.out.println("Capture init error:" + exc);
                }
            }
        } else if (keyCode == Display.keyShowHideNotify && this.displayable instanceof Canvas) {
            Canvas gCanvas = (Canvas)this.displayable;
            this.runCallEvent(gCanvas);
        }
        if (keyCode == 8) {
            this.setEmuPaintRequest(this.repaintX, this.repaintY, this.repaintW, this.repaintH);
            this.repaint();
        } else if (keyCode == 9) {
            this.callRunner();
        } else if (keyCode == 88) {
            Display.emuDestroyFrame();
        }
    }

    public void keyReleased(KeyEvent e2) {
        if (this.displayable != null) {
            this.tmpInt[0] = e2.getKeyCode();
            this.tmpInt[1] = e2.getKeyChar();
            this.tmpInt[2] = e2.getModifiers();
            this.tmpInt[3] = 1;
            this.lcduiBridge.handleEvent(13, this.displayable, this.tmpInt);
        }
    }

    public void keyTyped(KeyEvent e2) {
    }

    public void windowActivated(WindowEvent e2) {
        this.requestFocus();
    }

    public void windowClosed(WindowEvent e2) {
    }

    public void windowClosing(WindowEvent e2) {
        if (ConfigData.saveParams) {
            if (this.classMonitorFrame != null && this.classMonitorFrame.isVisible()) {
                this.classMonitorFrame.setVisible(false);
                this.classMonitorFrame.dispose();
                this.classMonitorFrame = null;
            }
            if (this.imageViewerFrame != null && this.imageViewerFrame.isVisible()) {
                ConfigData.imageViewerBounds = this.imageViewerFrame.getBounds();
                this.imageViewerFrame.setVisible(false);
                this.imageViewerFrame.dispose();
                this.imageViewerFrame = null;
            }
            Point point = e2.getWindow().getLocation();
            ConfigData.windowPositionX = point.x;
            ConfigData.windowPositionY = point.y;
            ParamWriter.saveParams();
        }
        if (MainApp.midlet != null) {
            MainApp.midletBridge.handleEvent(4, MainApp.midlet);
        }
        RmsManager.getInstance().saveData();
        this.setContent(null, null);
        this.emuGraph.dispose();
        try {
            System.exit(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void windowDeactivated(WindowEvent e2) {
    }

    public void windowDeiconified(WindowEvent e2) {
    }

    public void windowIconified(WindowEvent e2) {
    }

    public void windowOpened(WindowEvent e2) {
        if (this.showImageView) {
            this.showImageView = false;
            this.showImageInfo();
        }
        if (this.showZoom) {
            this.showZoom = false;
            this.showZoomFrame();
        }
    }

    private void rotateDisplay() {
        if (this.imageViewerFrame != null && this.imageViewerFrame.isShowing()) {
            this.showImageView = true;
            this.imageViewerFrame.setVisible(false);
            this.imageViewerFrame.dispose();
            this.imageViewerFrame = null;
        }
        if (this.zoomFrame != null && this.zoomFrame.isShowing()) {
            this.showZoom = true;
            this.zoomFrame.setVisible(false);
            this.zoomFrame.dispose();
            this.zoomFrame = null;
        }
        if (this.classMonitorFrame != null && this.classMonitorFrame.isShowing()) {
            this.classMonitorFrame.setVisible(false);
            this.classMonitorFrame.dispose();
            this.classMonitorFrame = null;
        }
        Display.emuRotateDisplay();
        if (this.displayable instanceof Canvas) {
            this.tmpInt[0] = Display.WIDTH;
            this.tmpInt[1] = Display.HEIGHT;
            this.lcduiBridge.handleEvent(23, this.displayable, this.tmpInt);
        }
    }

    private void showImageInfo() {
        if (ConfigData.slaveMode) {
            return;
        }
        if (this.imageViewerFrame != null && this.imageViewerFrame.isShowing()) {
            System.out.println("Pstros: image viewer already shown! close it first!");
            return;
        }
        MainApp.forceGC();
        Vector images = ImageReferenceManager.getImages();
        this.imageViewerFrame = new Frame();
        ScrollPane scrollPane = new ScrollPane(0);
        ImageViewer viewer = new ImageViewer(images, this.imageViewerFrame, scrollPane);
        viewer.setVerticalScroll((ScrollPaneAdjustable)scrollPane.getVAdjustable());
        scrollPane.add(viewer);
        this.imageViewerFrame.setTitle("Image viewer");
        this.imageViewerFrame.addWindowListener(viewer);
        this.imageViewerFrame.add(scrollPane);
        if (ConfigData.imageViewerBounds != null) {
            this.imageViewerFrame.setBounds(ConfigData.imageViewerBounds);
        } else {
            this.imageViewerFrame.setSize(260, 515);
        }
        this.imageViewerFrame.setVisible(true);
    }

    private void showZoomFrame() {
        if (ConfigData.slaveMode) {
            return;
        }
        if (this.imageViewerFrame != null && this.imageViewerFrame.isShowing()) {
            return;
        }
        this.zoomFrame = new Frame();
        this.zoomViewer = new ZoomViewer(this.zoomFrame, this.emuImage, ConfigData.zoomSize);
        this.zoomFrame.setTitle("Zoom");
        this.zoomFrame.setResizable(false);
        this.zoomFrame.addWindowListener(this.zoomViewer);
        this.zoomFrame.add(this.zoomViewer);
        int w = this.zoomViewer.getCurrentWidth();
        int h2 = this.zoomViewer.getCurrentHeight();
        this.zoomFrame.setSize(w, h2);
        if (ConfigData.zoomViewerBounds != null) {
            this.zoomFrame.setBounds(ConfigData.zoomViewerBounds);
        }
        this.zoomFrame.setVisible(true);
        Insets insets = this.zoomFrame.getInsets();
        this.zoomFrame.setSize(w += insets.right + insets.left, h2 += insets.bottom + insets.top);
        this.zoomFrame.doLayout();
    }

    private void showClassMonitor() {
        if (ConfigData.slaveMode || !ConfigData.classMonitor) {
            return;
        }
        if (this.classMonitorFrame != null && this.classMonitorFrame.isShowing()) {
            return;
        }
        this.classMonitorFrame = new MonitorFrame();
        ClassManager cm = ClassManager.getInstance();
        cm.invalidateCurrentProfile();
        cm.setProfile(MainApp.getApplicationName(), MainApp.midlet);
        if (ConfigData.classMonitorBounds != null) {
            this.classMonitorFrame.setBounds(ConfigData.classMonitorBounds);
        } else {
            this.classMonitorFrame.setSize(260, 515);
        }
        this.classMonitorFrame.setVisible(true);
        this.classMonitorFrame.selectProfileChoice(cm.getCurrentProfileName());
    }

    public void updateClassMonitor() {
        if (ConfigData.slaveMode || !ConfigData.classMonitor) {
            return;
        }
        if (this.classMonitorFrame == null || !this.classMonitorFrame.isShowing()) {
            return;
        }
        this.classMonitorFrame.updateItems();
    }

    private void rescale(boolean setGammaOnly, Image img) {
        int pixel;
        if (this.lastScale != ConfigData.scale) {
            this.lastScale = ConfigData.scale;
            if (this.scaledSrc == null) {
                this.scaledSrc = new int[Display.WIDTH * Display.HEIGHT];
            }
            int newSize = Display.WIDTH * Display.HEIGHT * this.lastScale * this.lastScale;
            if (this.scaledDst == null || this.scaledDst.length < newSize) {
                this.scaledDst = new int[newSize];
            }
            this.initScaledGraphics();
        }
        if (img instanceof BufferedImage) {
            ((BufferedImage)this.emuImage).getRGB(0, 0, Display.WIDTH, Display.HEIGHT, this.scaledSrc, 0, Display.WIDTH);
        } else {
            this.scaledGraph.drawImage(img, 0, 0, null);
            this.scaledImage.getRGB(0, 0, Display.WIDTH, Display.HEIGHT, this.scaledSrc, 0, Display.WIDTH);
        }
        if (ConfigData.displayGamma % 100 != 0) {
            int cB;
            int cG;
            int cR;
            int i2;
            int dif = (ConfigData.displayGamma - 100) * 255 / 100;
            int max = Display.WIDTH * Display.HEIGHT;
            if (dif > 0) {
                i2 = 0;
                while (i2 < max) {
                    pixel = this.scaledSrc[i2];
                    cR = (pixel & 0xFF0000) >> 16;
                    cG = (pixel & 0xFF00) >> 8;
                    cB = pixel & 0xFF;
                    cR += (255 - cR) * dif >> 8;
                    cG += (255 - cG) * dif >> 8;
                    cB += (255 - cB) * dif >> 8;
                    if (cR > 255) {
                        cR = 255;
                    }
                    if (cG > 255) {
                        cG = 255;
                    }
                    if (cB > 255) {
                        cB = 255;
                    }
                    this.scaledSrc[i2] = 0xFF000000 | cR << 16 | cG << 8 | cB;
                    ++i2;
                }
            } else {
                i2 = 0;
                while (i2 < max) {
                    pixel = this.scaledSrc[i2];
                    cR = (pixel & 0xFF0000) >> 16;
                    cG = (pixel & 0xFF00) >> 8;
                    cB = pixel & 0xFF;
                    cR += cR * dif >> 8;
                    cG += cG * dif >> 8;
                    cB += cB * dif >> 8;
                    if (cR < 0) {
                        cR = 0;
                    }
                    if (cG < 0) {
                        cG = 0;
                    }
                    if (cB < 0) {
                        cB = 0;
                    }
                    this.scaledSrc[i2] = 0xFF000000 | cR << 16 | cG << 8 | cB;
                    ++i2;
                }
            }
        }
        if (this.lastScale != 1) {
            int dstWidth = Display.WIDTH * this.lastScale;
            int dstI = 0;
            int y = 0;
            while (y < Display.HEIGHT) {
                int i3;
                int srcBaseY = y * Display.WIDTH;
                int dstBaseY = y * dstWidth * this.lastScale;
                int x = 0;
                while (x < Display.WIDTH) {
                    pixel = this.scaledSrc[srcBaseY + x];
                    i3 = 0;
                    while (i3 < this.lastScale) {
                        this.scaledDst[dstI++] = pixel;
                        ++i3;
                    }
                    ++x;
                }
                i3 = 1;
                while (i3 < this.lastScale) {
                    System.arraycopy(this.scaledDst, dstBaseY, this.scaledDst, dstBaseY + i3 * dstWidth, dstWidth);
                    dstI += dstWidth;
                    ++i3;
                }
                ++y;
            }
            this.scaledImage.setRGB(0, 0, dstWidth, Display.HEIGHT * this.lastScale, this.scaledDst, 0, dstWidth);
        } else {
            this.scaledImage.setRGB(0, 0, Display.WIDTH, Display.HEIGHT, this.scaledSrc, 0, Display.WIDTH);
        }
    }

    public void hideNotify() {
        if (this.displayable instanceof Canvas) {
            this.lcduiBridge.handleEvent(2, this.displayable);
        }
    }

    public void showNotify() {
        if (this.displayable instanceof Canvas) {
            this.lcduiBridge.handleEvent(1, this.displayable);
        }
    }

    public void mouseClicked(MouseEvent e2) {
        int x = ConfigData.skinScreenX;
        int y = ConfigData.skinScreenY;
        int button = e2.getButton();
        this.mouseX = e2.getX();
        this.mouseY = e2.getY();
        if (button != 3) {
            if (this.zoomViewer != null && this.zoomViewer.isShowing()) {
                this.zoomViewer.setSpot((this.mouseX - x) / ConfigData.scale, (this.mouseY - y) / ConfigData.scale);
            }
        } else {
            boolean bl = this.distanceMode = !this.distanceMode;
            if (this.distanceMode) {
                this.showZoomFrame();
                if (this.zoomViewer != null && this.zoomViewer.isShowing()) {
                    this.zoomViewer.updateView((this.mouseX - x) / ConfigData.scale, (this.mouseY - y) / ConfigData.scale, true);
                }
            } else if (this.zoomFrame != null && this.zoomFrame.isShowing()) {
                this.zoomViewer.storeBounds();
                this.zoomFrame.setVisible(false);
                this.zoomFrame.dispose();
            }
        }
    }

    public void mouseEntered(MouseEvent e2) {
    }

    public void mouseExited(MouseEvent e2) {
    }

    public void mousePressed(MouseEvent e2) {
        int x = ConfigData.skinScreenX;
        int y = ConfigData.skinScreenY;
        int button = e2.getButton();
        if (button == 1 && this.zoomFrame == null && this.displayable instanceof Canvas) {
            this.tmpInt[0] = (e2.getX() - x) / ConfigData.scale;
            this.tmpInt[1] = (e2.getY() - y) / ConfigData.scale;
            this.lcduiBridge.handleEvent(14, this.displayable, this.tmpInt);
        }
    }

    public void mouseReleased(MouseEvent e2) {
        int x = ConfigData.skinScreenX;
        int y = ConfigData.skinScreenY;
        int button = e2.getButton();
        if (button == 1 && this.zoomFrame == null && this.displayable instanceof Canvas) {
            this.tmpInt[0] = (e2.getX() - x) / ConfigData.scale;
            this.tmpInt[1] = (e2.getY() - y) / ConfigData.scale;
            this.lcduiBridge.handleEvent(15, this.displayable, this.tmpInt);
        }
    }

    public void mouseDragged(MouseEvent e2) {
        int x = ConfigData.skinScreenX;
        int y = ConfigData.skinScreenY;
        int button = e2.getButton();
        if (button != 3 && this.zoomFrame == null && this.displayable instanceof Canvas) {
            this.tmpInt[0] = (e2.getX() - x) / ConfigData.scale;
            this.tmpInt[1] = (e2.getY() - y) / ConfigData.scale;
            this.lcduiBridge.handleEvent(16, this.displayable, this.tmpInt);
        }
    }

    public void mouseMoved(MouseEvent e2) {
        this.mouseX = e2.getX();
        this.mouseY = e2.getY();
        int x = ConfigData.skinScreenX;
        int y = ConfigData.skinScreenY + ConfigData.topConsoleHeight * ConfigData.scale;
        if (this.zoomViewer != null && this.zoomViewer.isShowing()) {
            this.zoomViewer.updateView((this.mouseX - x) / ConfigData.scale, (this.mouseY - y) / ConfigData.scale, false);
        }
    }
}

