/*
 * Decompiled with CFR 0.152.
 */
package ole.pstros;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.AccessControlException;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.microedition.lcdui.Display;
import javax.microedition.media.Manager;
import javax.microedition.midlet.MIDlet;
import ole.pstros.ConfigData;
import ole.pstros.EmuCanvas;
import ole.pstros.EmuExecutor;
import ole.pstros.EmuListener;
import ole.pstros.IEmuBridge;
import ole.pstros.io.ConnectionManager;
import ole.pstros.reference.ImageReferenceManager;
import ole.pstros.rms.RmsManager;
import ole.pstros.rms.RmsReader;
import ole.pstros.utils.BaseClassLoader;
import ole.pstros.utils.ConfigLoader;
import ole.pstros.utils.DirectoryClassLoader;
import ole.pstros.utils.JadFileParser;
import ole.pstros.utils.JarClassLoader;
import ole.pstros.utils.Orv2Tga;
import ole.pstros.utils.OrvPlayer;
import ole.pstros.utils.ParamReader;

public class MainApp
implements EmuExecutor,
Runnable {
    public static boolean verbose = false;
    public static boolean soundVerbose = false;
    static final int CLASS_LOADER_SYSTEM = 0;
    static final int CLASS_LOADER_JAD = 1;
    static final int CLASS_LOADER_DIR = 2;
    static final int CLASS_LOADER_EXTERNAL = 3;
    static int classLoaderType = 0;
    private static String execClassName;
    private static String jarFileName;
    private static String basePath;
    private static String appName;
    private static String fileName;
    private static String orvName;
    private static String orvExportPath;
    private static ClassLoader externalClassLoader;
    private static BaseClassLoader classLoader;
    public static MIDlet midlet;
    private static MainApp executor;
    private static int parametersCount;
    public static Component parentComponent;
    private static int imageMemorySize;
    private static int fps;
    private static boolean runPlayer;
    public static IEmuBridge midletBridge;
    private EmuListener emuListener = null;
    static /* synthetic */ Class class$0;

    static {
        appName = "app";
        orvExportPath = "./";
        parametersCount = 0;
        imageMemorySize = 0;
    }

    public static void main(String[] args) {
        Thread.currentThread().setName("Pstros");
        MainApp.printHeader();
        ParamReader.readParams();
        if (verbose) {
            System.out.println("pstros started!");
        }
        MainApp.checkArguments(args);
        MainApp.setSystemProperties();
        MainApp.executeEmu();
    }

    private static void setSystemProperties() {
        if (ConfigData.slaveMode) {
            return;
        }
        if (System.getProperty("microedition.profiles") == null) {
            System.setProperty("microedition.profiles", "MIDP-2");
        }
    }

    private static boolean executeEmu() {
        if (execClassName != null) {
            System.out.println("jarName   :" + jarFileName);
            System.out.println("jarPath   :" + basePath);
            System.out.println("className :" + execClassName);
            System.out.println("appName   :" + appName);
            RmsReader reader = new RmsReader();
            reader.readRms();
            MainApp.executeClass();
            return true;
        }
        if (orvName != null && !runPlayer) {
            try {
                Orv2Tga.process(new FileInputStream(orvName), orvExportPath, null);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            return true;
        }
        if (runPlayer) {
            if (orvName != null) {
                fileName = orvName;
            }
            OrvPlayer player = new OrvPlayer(fileName, Display.WIDTH, Display.HEIGHT);
            player.open();
            return true;
        }
        MainApp.printHelp();
        return false;
    }

    private static void printHeader() {
        System.out.println("Pstros: the J2ME execution environment. ver 1.6.0f");
        System.out.println("(c)2005-2008 Marek Olejnik ");
        System.out.println("see www.volny.cz/molej/pstros for further information");
        System.out.println();
    }

    private static void printHelp() {
        System.out.println("usage:");
        System.out.println("java -Xbootclasspath/a:pstros.jar;application.jar -jar pstros.jar -CMyMidlet -w176 -h208");
        System.out.println("java -jar pstros.jar application.jad -w176 -h208");
        System.out.println("parameters:");
        System.out.println("-wXX : set device screen width to XX pixels (default 176)");
        System.out.println("-hXX : set device screen height to XX pixels (default 220)");
        System.out.println("-sXX : set device screen scale ratio (default 1)");
        System.out.println("-as  : use alternative scaling method");
        System.out.println("-tXX : set delay of repaint in msecs (default 5, value of -1 means no delay)");
        System.out.println("-CclassName : set start class name - should be ancestor of the MIDlet class");
        System.out.println("-AappName : set start application name - usefull for RMS record distinction");
        System.out.println("-U : don't run update thread - disables Display.callSerially() functionality");
        System.out.println("-iPPP : store images to path PPP");
        System.out.println("-v : verbose mode");
        System.out.println("-dcl : use directory class loader - load from current directory");
        System.out.println("-dcl= : use directory class loader - load from specified directories delimited by ;");
        System.out.println("-dn=name: set device name. Rms will be read and stored to file rms_name.xml");
        System.out.println("-cm: enable class monitor (disabled by default)");
        System.out.println("-mute: disable sound output");
        System.out.println("-gamma=XXX: set gamma for color output, default=100, valid from 40 to 160");
        System.out.println("-fc=drive1;path1[;drive2;path2]: set file connection mapping (example: -fc=E:/;./eDrive/");
        System.out.println("-rcp=className;params: register connection provider");
        System.out.println("-rs=XXX: set read speed XXX msecs per 1kbyte of data size ");
        System.out.println("-ks: swap numeric block keys (1-7,2-8,3-9)");
        System.out.println("keyboard controls:");
        System.out.println(" Cursor keys - directional arrows");
        System.out.println(" Enter - center soft / fire ");
        System.out.println(" Esc - quit emulator");
        System.out.println(" F1 - left soft key");
        System.out.println(" F2 - right soft key");
        System.out.println(" NumPad * - star");
        System.out.println(" NumPad / - cross");
        System.out.println(" NumPad numbers - phone numbers");
        System.out.println(" F4 - rotate display");
        System.out.println(" F5 - pause/resume");
        System.out.println(" F9 - hide / show notify test");
        System.out.println(" F11 - capture screen shot");
        System.out.println(" F12 - capture video stream start / stop");
        System.out.println(" Alt+i - open image viewer");
        System.out.println(" Alt+m - open class monitor (class monitor must be enabled)");
        System.out.println(" Alt+d - open zoom/distance/color viewer");
        System.out.println(" Alt+k - swap numeric block keys (1-7,2-8,3-9)");
        System.out.println(" Alt+1,2,3 - set screen scale");
        System.out.println("Key controls customizable via ~/.pstros/params.cnf. Set 'control.config = 1' to enable it.");
        System.out.println(" hint: press CapsLock to view key-press codes");
        System.out.println("To bypass null-pointer-exception when reading resources use the parameter:");
        System.out.println(" -Djava.system.class.loader=ole.pstros.utils.JarClassLoader");
    }

    public static BaseClassLoader getClassLoader() {
        return classLoader;
    }

    public static String getApplicationName() {
        return appName;
    }

    private static void checkArguments(String[] args) {
        if (args == null || args.length < 1) {
            return;
        }
        int i2 = 0;
        while (i2 < args.length) {
            String arg = args[i2];
            MainApp.setEmuParameter(arg, i2);
            ++i2;
        }
        ConfigLoader.setScreenHeight();
    }

    private static void setEmuParameter(String arg, int index) {
        if (index == 0) {
            if (arg.endsWith(".jar") || arg.endsWith("JAR")) {
                try {
                    File file = new File(arg);
                    if (!file.exists()) {
                        return;
                    }
                    JarFile jarFile = new JarFile(arg);
                    Enumeration<JarEntry> entries = jarFile.entries();
                    ZipEntry entry = jarFile.getEntry("META-INF/MANIFEST.MF");
                    InputStream stream = jarFile.getInputStream(entry);
                    JadFileParser parser = new JadFileParser(stream);
                    execClassName = parser.getClassName();
                    jarFileName = parser.getPackageName(arg);
                    basePath = file.getParent();
                    appName = parser.getApplicationName();
                    classLoaderType = 1;
                    stream.close();
                }
                catch (Exception e2) {
                    System.out.println("Pstros: error opening jar file:" + e2);
                }
            }
            if (arg.endsWith(".jad") || arg.endsWith(".JAD")) {
                JadFileParser parser = new JadFileParser(arg);
                execClassName = parser.getClassName();
                jarFileName = parser.getPackageName();
                basePath = parser.getPackagePath();
                appName = parser.getApplicationName();
                classLoaderType = 1;
            } else if (arg.endsWith(".orv") || arg.endsWith(".ORV")) {
                orvName = arg;
            } else if (!arg.startsWith("-")) {
                fileName = arg;
            }
        }
        if (arg.startsWith("-player")) {
            runPlayer = true;
        } else if (arg.startsWith("-rw")) {
            ConfigData.rotatedScreenWidth = Integer.parseInt(arg.substring(3));
            if (ConfigData.rotatedScreenHeight < 0) {
                ConfigData.rotatedScreenHeight = Display.WIDTH;
            }
            ConfigData.originalScreenWidth = Display.WIDTH;
            ConfigData.originalScreenHeight = Display.HEIGHT;
        } else if (arg.startsWith("-rh")) {
            ConfigData.rotatedScreenHeight = Integer.parseInt(arg.substring(3));
            if (ConfigData.rotatedScreenWidth < 0) {
                ConfigData.rotatedScreenWidth = Display.HEIGHT;
            }
            ConfigData.originalScreenWidth = Display.WIDTH;
            ConfigData.originalScreenHeight = Display.HEIGHT;
        } else if (arg.startsWith("-w")) {
            Display.WIDTH = Integer.parseInt(arg.substring(2));
            if (ConfigData.originalScreenWidth > 0) {
                ConfigData.originalScreenWidth = Display.WIDTH;
            }
        } else if (arg.startsWith("-h")) {
            Display.HEIGHT = Integer.parseInt(arg.substring(2));
            if (ConfigData.originalScreenHeight > 0) {
                ConfigData.originalScreenHeight = Display.HEIGHT;
            }
        } else if (arg.equals("-ro")) {
            ConfigData.readOnly = true;
        } else if (arg.equals("-cm")) {
            ConfigData.classMonitor = true;
        } else if (arg.startsWith("-c")) {
            ConfigLoader.readConfig(arg.substring(2));
        } else if (arg.startsWith("-o")) {
            orvExportPath = arg.substring(2);
        } else if (arg.startsWith("-i")) {
            String path = arg.substring(2);
            if (!path.endsWith("/") && !path.endsWith("\\")) {
                path = String.valueOf(path) + '/';
            }
            ConfigData.storeImages = true;
            ConfigData.storeImagePath = path;
        } else if (arg.startsWith("-fc=")) {
            ConfigData.fileConnectionMapping = arg.substring(4);
        } else if (arg.startsWith("-rcp=")) {
            String line = arg.substring(5);
            int separatorIndex = line.indexOf(";");
            if (separatorIndex > 0) {
                String className = line.substring(0, separatorIndex);
                String params = line.substring(separatorIndex + 1);
                ConnectionManager.addConnectionProvider(className, params, true);
            } else {
                System.out.println("Ppstros Error: wrong parameter" + arg);
            }
        }
        if (arg.startsWith("-gamma=")) {
            ConfigData.displayGamma = Integer.parseInt(arg.substring(7));
            if (ConfigData.displayGamma > 160) {
                ConfigData.displayGamma = 160;
            } else if (ConfigData.displayGamma < 40) {
                ConfigData.displayGamma = 40;
            }
        } else if (arg.startsWith("-rs=")) {
            ConfigData.readSpeed = Integer.parseInt(arg.substring(4));
        } else if (arg.startsWith("-C")) {
            execClassName = arg.substring(2);
        } else if (arg.startsWith("-A")) {
            appName = arg.substring(2);
        } else if (arg.startsWith("-t")) {
            ConfigData.drawWait = Integer.parseInt(arg.substring(2));
        } else if (arg.startsWith("-s")) {
            ConfigData.scale = Integer.parseInt(arg.substring(2));
            if (ConfigData.scale > 3) {
                ConfigData.scale = 3;
            } else if (ConfigData.scale < 1) {
                ConfigData.scale = 1;
            }
        } else if (arg.startsWith("-dn=")) {
            ConfigData.deviceName = arg.substring(4);
        } else if (arg.startsWith("-as")) {
            ConfigData.externalScaler = true;
        } else if (arg.equals("-ks")) {
            ConfigData.numKeySwap = true;
        } else if (arg.startsWith("-xcaptureH=")) {
            ConfigData.captureHeight = Integer.parseInt(arg.substring(11));
        } else if (arg.startsWith("-xcaptureY=")) {
            ConfigData.captureOffsetY = Integer.parseInt(arg.substring(11));
        } else if (arg.startsWith("-xtch=")) {
            ConfigData.topConsoleHeight = Integer.parseInt(arg.substring(6));
        } else if (arg.startsWith("-xbch=")) {
            ConfigData.bottomConsoleHeight = Integer.parseInt(arg.substring(6));
        } else if (arg.equals("-dcl")) {
            classLoaderType = 2;
        } else if (arg.startsWith("-dcl=")) {
            classLoaderType = 2;
            basePath = arg.substring(5);
        } else if (arg.startsWith("-device.")) {
            ConfigLoader.parseLine(arg.substring(1));
        } else if (arg.equals("-mute")) {
            ConfigData.forceMute = true;
        } else if (arg.startsWith("-U")) {
            ConfigData.updateSerialRunner = false;
        } else if (arg.startsWith("-v")) {
            verbose = true;
        }
    }

    private static void executeClass() {
        if (execClassName == null) {
            return;
        }
        try {
            Class<?> execClass;
            ClassLoader currentClassLoader = null;
            if (verbose) {
                System.out.println("Pstros: ClassLoader type=" + classLoaderType);
            }
            if (classLoaderType != 0) {
                if (classLoaderType == 1) {
                    String fileName = basePath != null ? String.valueOf(basePath) + File.separator + jarFileName : jarFileName;
                    classLoader = JarClassLoader.getInstance(fileName);
                    currentClassLoader = classLoader;
                } else if (classLoaderType == 2) {
                    String fileName = basePath == null || basePath.length() < 1 ? new File("./").getAbsolutePath() : basePath;
                    classLoader = new DirectoryClassLoader(fileName);
                    currentClassLoader = classLoader;
                } else if (classLoaderType == 3) {
                    currentClassLoader = externalClassLoader;
                }
                if (verbose) {
                    System.out.println("Pstros: CL=" + currentClassLoader);
                    if (currentClassLoader != null && !ConfigData.readOnly) {
                        System.out.println("Pstros: CL parent=" + currentClassLoader.getParent());
                    }
                }
                execClass = currentClassLoader == null ? Class.forName(execClassName) : Class.forName(execClassName, true, currentClassLoader);
            } else {
                try {
                    currentClassLoader = ClassLoader.getSystemClassLoader();
                }
                catch (AccessControlException e2) {
                    System.out.println(e2);
                }
                if (verbose) {
                    System.out.println("Pstros: CL=" + currentClassLoader);
                    if (currentClassLoader != null && !ConfigData.readOnly) {
                        System.out.println("Pstros: CL parent=" + currentClassLoader.getParent());
                    }
                }
                if (currentClassLoader == null) {
                    execClass = Class.forName(execClassName);
                } else {
                    if (currentClassLoader instanceof JarClassLoader) {
                        fileName = basePath != null ? String.valueOf(basePath) + File.separator + jarFileName : jarFileName;
                        ((JarClassLoader)currentClassLoader).setJarFilename(fileName);
                    }
                    execClass = Class.forName(execClassName, true, currentClassLoader);
                }
            }
            Class<?> clazz = execClass.getSuperclass();
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("javax.microedition.midlet.MIDlet");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz != clazz2) {
                System.out.println("Warning: class is not an MIDlet, class=" + execClass.getName());
            }
            MainApp.executeMidlet(execClass);
        }
        catch (Exception e3) {
            System.out.println("Error: pstros:" + e3);
            e3.printStackTrace();
        }
    }

    private static void executeMidlet(final Class execClass) {
        final EmuCanvas emuCanvas = EmuCanvas.getInstance();
        final ThreadGroup tg = new ThreadGroup("pstrosTG");
        new Thread(tg, "pstros"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    MIDlet md;
                    midlet = md = (MIDlet)execClass.newInstance();
                    Thread.currentThread().setName("Pstros-mainLoop");
                    midletBridge.handleEvent(3, midlet);
                    int monitorCounter = 0;
                    if (ConfigData.updateSerialRunner) {
                        long time = 500L;
                        int checkCount = 1000 / (int)time;
                        boolean runnerExists = false;
                        while (midlet.emuIsRunning()) {
                            EmuCanvas emuCanvas2 = emuCanvas;
                            synchronized (emuCanvas2) {
                                runnerExists = emuCanvas.callRunner();
                            }
                            if (runnerExists) {
                                time = 10L;
                                checkCount = 1000 / (int)time;
                            }
                            if (checkCount-- < 0) {
                                Manager.emuUpdatePlayers();
                                checkCount = 1000 / (int)time;
                            }
                            Thread.sleep(5L);
                            if (!MainApp.updateReferenceInfo()) {
                                MainApp.refreshFrameTitle(false);
                            }
                            if (++monitorCounter % 8 != 0) continue;
                            emuCanvas.updateClassMonitor();
                        }
                    } else {
                        while (midlet.emuIsRunning()) {
                            Thread.sleep(100L);
                            MainApp.updateReferenceInfo();
                            MainApp.refreshFrameTitle(false);
                        }
                    }
                    Manager.emuStopPlayers();
                    System.out.println("Pstros ended execution.");
                    try {
                        int activeCount = tg.activeCount();
                        int safetyCheck = 10;
                        while (true) {
                            if (activeCount <= 0 || safetyCheck <= 0) {
                                if (activeCount <= 0) return;
                                if (verbose) {
                                    System.out.println("Pstros: force TG to stop! active thread count=" + activeCount);
                                }
                                try {
                                    tg.stop();
                                    return;
                                }
                                catch (ThreadDeath threadDeath) {
                                    return;
                                }
                            }
                            Thread.sleep(50L);
                            --safetyCheck;
                            activeCount = tg.activeCount();
                        }
                    }
                    catch (Exception e2) {
                        System.out.println("Pstros: Thread group stop:" + e2);
                        return;
                    }
                }
                catch (Exception e3) {
                    System.out.println("Error: pstros:" + e3);
                    e3.printStackTrace();
                }
            }
        }.start();
    }

    private static void refreshFrameTitle(boolean force) {
        int currentFps = EmuCanvas.getInstance().getFps();
        if (force || currentFps != fps) {
            Display.emuSetTitle(imageMemorySize >> 10, ImageReferenceManager.getPeakMemorySize() >> 10, ConfigData.videoMemoryLimit >> 10, currentFps);
            fps = currentFps;
        }
    }

    public static void forceGC() {
        if (ConfigData.slaveMode) {
            return;
        }
        System.out.println("Pstros: gc called!");
        Thread.yield();
        System.gc();
        Thread.yield();
        imageMemorySize = ImageReferenceManager.update();
        MainApp.refreshFrameTitle(true);
    }

    private static boolean updateReferenceInfo() {
        int oldMemorySize = imageMemorySize;
        if (oldMemorySize != (imageMemorySize = ImageReferenceManager.update())) {
            MainApp.refreshFrameTitle(true);
            if (imageMemorySize > ConfigData.videoMemoryLimit / 2) {
                Thread.yield();
                System.gc();
                Thread.yield();
            }
            return true;
        }
        return false;
    }

    static void repaintDisplay() {
        if (midlet != null) {
            Display d2 = Display.getDisplay(midlet);
            d2.emuRepaintDisplay();
        }
    }

    public static MainApp getInstance() {
        return executor;
    }

    public static EmuExecutor getEmuExecutor() {
        if (executor == null) {
            executor = new MainApp();
        }
        ParamReader.readParams();
        parametersCount = 0;
        return executor;
    }

    public static EmuExecutor getEmuExecutorRo() {
        if (executor == null) {
            executor = new MainApp();
        }
        parametersCount = 0;
        return executor;
    }

    private MainApp() {
        parametersCount = 0;
    }

    public void setEmuListener(EmuListener listener) {
        this.emuListener = listener;
    }

    public void keyPressed(KeyEvent e2) {
        EmuCanvas.getInstance().keyPressed(e2);
    }

    public void keyReleased(KeyEvent e2) {
        EmuCanvas.getInstance().keyReleased(e2);
    }

    public void keyAction(int actionType, int key) {
        EmuCanvas.getInstance().keyAction(actionType, key);
    }

    public void setClassLoader(ClassLoader cLoader) {
        externalClassLoader = cLoader;
        if (externalClassLoader != null) {
            classLoaderType = 3;
            classLoader = null;
        }
    }

    public void setParameter(String arg) {
        MainApp.setEmuParameter(arg, parametersCount);
        ++parametersCount;
    }

    public Object getParameter(String param) {
        if (param.equals("-w")) {
            return new Integer(Display.WIDTH);
        }
        if (param.equals("-h")) {
            return new Integer(Display.HEIGHT);
        }
        return ConfigData.getParameter(param);
    }

    public boolean execute() {
        Thread thread = new Thread(this);
        thread.start();
        return true;
    }

    public void terminate() {
        if (midlet != null) {
            midletBridge.handleEvent(4, midlet);
        }
        RmsManager.getInstance().saveData();
    }

    public void pauseApp() {
        if (midlet != null) {
            midletBridge.handleEvent(5, midlet);
        }
    }

    public void startApp() {
        if (midlet != null) {
            midletBridge.handleEvent(6, midlet);
        }
    }

    public void showNotify() {
        EmuCanvas.getInstance().showNotify();
    }

    public void hideNotify() {
        EmuCanvas.getInstance().hideNotify();
    }

    public void setParentComponent(Component component) {
        parentComponent = component;
    }

    public void run() {
        ConfigData.slaveMode = true;
        MainApp.executeEmu();
    }

    public void setEvent(String event, Object data) {
        if (this.emuListener != null) {
            this.emuListener.emuUpadate(event, data);
        }
    }
}

