/*
 * Decompiled with CFR 0.152.
 */
package ole.pstros;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.StringTokenizer;
import ole.pstros.EmuExecutor;
import ole.pstros.EmuListener;
import ole.pstros.MainApp;

public class MainWeb
extends Applet
implements Runnable,
EmuListener,
KeyListener {
    private static final boolean DEMO = false;
    private static MainWeb instance;
    private String jarName;
    private String midlet;
    private String message = null;
    private EmuExecutor executor;
    private Image image;
    private boolean emuStart;
    private int appletWidth;
    private int appletHeight;
    private String params;
    private int[] paintLock;
    private static int[] bitmark;
    private Image watermark;

    static {
        int[] nArray = new int[32];
        nArray[0] = -1;
        nArray[1] = -1;
        nArray[6] = 1070068735;
        nArray[7] = 1070068220;
        nArray[8] = 969814131;
        nArray[9] = 969831308;
        nArray[10] = 969801840;
        nArray[11] = 969831296;
        nArray[12] = 969801840;
        nArray[13] = 965636992;
        nArray[14] = 1065873520;
        nArray[15] = 1057911036;
        nArray[16] = 939552880;
        nArray[17] = 969830428;
        nArray[18] = 939552880;
        nArray[19] = 969830428;
        nArray[20] = 939552880;
        nArray[21] = 969830428;
        nArray[22] = 940339312;
        nArray[23] = 969831196;
        nArray[24] = 940564592;
        nArray[25] = 969925624;
        nArray[30] = -1;
        nArray[31] = -1;
        bitmark = nArray;
    }

    public String getAppletInfo() {
        return "Pstros: the J2ME execution environment. \n(c)2005-2007 Marek Olejnik";
    }

    public String[][] getParameterInfo() {
        String[][] pinfo = new String[][]{{"midlet", "string", "name of the MIDlet class"}, {"jarName", "string", "optional name of the jar package"}};
        return pinfo;
    }

    public void init() {
        this.paintLock = new int[1];
        while (instance != null) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        instance = this;
        this.jarName = this.getParameter("jarName");
        this.midlet = this.getParameter("midlet");
        this.params = this.getParameter("parameters");
        System.out.println("Pstros: jarName=" + this.jarName);
        this.addKeyListener(this);
        this.appletWidth = this.getWidth();
        this.appletHeight = this.getHeight();
    }

    public void start() {
        new Thread(this).start();
    }

    public void stop() {
        instance = null;
        if (this.executor != null) {
            this.cleanEnvironment();
        }
    }

    public void run() {
        try {
            Thread.currentThread().setPriority(1);
            this.emuStart = this.runEmu();
            this.requestFocus();
            long startTime = System.currentTimeMillis();
            while (instance != null) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.cleanEnvironment();
        }
        catch (Exception e2) {
            System.out.println(e2);
        }
    }

    private boolean runEmu() {
        this.executor = MainApp.getEmuExecutorRo();
        this.executor.setEmuListener(this);
        this.executor.setParameter("-ro");
        this.executor.setParameter("-w" + this.appletWidth);
        this.executor.setParameter("-h" + this.appletHeight);
        this.executor.setParameter("-C" + this.midlet);
        if (this.params != null && this.params.length() > 1) {
            StringTokenizer st = new StringTokenizer(this.params, " ");
            int size = st.countTokens();
            int i2 = 0;
            while (i2 < size) {
                this.executor.setParameter(st.nextToken());
                ++i2;
            }
        }
        try {
            if (this.jarName != null) {
                URL url = new URL(this.jarName);
                URL[] urls = new URL[]{url};
                URLClassLoader cl = new URLClassLoader(urls);
                this.executor.setClassLoader(cl);
            } else {
                this.executor.setClassLoader(null);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.executor.setParentComponent(this);
        return this.executor.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g2) {
        int[] nArray = this.paintLock;
        synchronized (this.paintLock) {
            if (this.image != null) {
                g2.drawImage(this.image, 0, 0, null);
            } else {
                g2.setColor(Color.white);
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                g2.setColor(Color.black);
                if (this.message == null) {
                    this.message = "...Pstros...";
                }
                g2.drawString(this.message, 0, 20);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void cleanEnvironment() {
        this.image = null;
        if (this.executor != null) {
            this.executor.setEmuListener(null);
            this.executor.terminate();
            this.executor = null;
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void emuUpadate(String event, Object data) {
        if (event == "emuRefreshDisplay") {
            int[] nArray = this.paintLock;
            synchronized (this.paintLock) {
                this.image = (Image)data;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                this.repaint();
                Thread.yield();
            }
        } else if (event == "emuClosed") {
            this.cleanEnvironment();
        }
    }

    public void keyPressed(KeyEvent e2) {
        if (this.executor != null) {
            this.executor.keyPressed(e2);
        }
    }

    public void keyReleased(KeyEvent e2) {
        if (this.executor != null) {
            this.executor.keyReleased(e2);
        }
    }

    public void keyTyped(KeyEvent e2) {
    }

    public void update(Graphics g2) {
        this.paint(g2);
    }

    private void createWatermark() {
        if (this.watermark != null) {
            return;
        }
        int w = 64;
        int h2 = 16;
        int[] water = new int[w * h2];
        int offset = 0;
        int j2 = 0;
        while (j2 < h2) {
            int i2 = 0;
            while (i2 < w) {
                int pixel = bitmark[offset / 32];
                int bitmask = 31 - offset % 32;
                bitmask = 1 << bitmask;
                water[offset++] = (pixel & bitmask) == 0 ? 2134917184 : 0x7FEEEEEE;
                ++i2;
            }
            ++j2;
        }
        BufferedImage bi = new BufferedImage(w, h2, 2);
        bi.setRGB(0, 0, w, h2, water, 0, w);
        this.watermark = bi;
    }
}

