/*
 * Decompiled with CFR 0.152.
 */
package ole.pstros.io;

import java.util.Vector;
import ole.pstros.ConfigData;
import ole.pstros.io.ConnectionProvider;
import ole.pstros.io.FileConnectionProvider;

public class ConnectionManager {
    private static Vector providers;

    private static void init() {
        FileConnectionProvider cp;
        if (providers != null) {
            return;
        }
        providers = new Vector();
        if (ConfigData.fileConnectionMapping != null && (cp = new FileConnectionProvider()).init(ConfigData.fileConnectionMapping)) {
            ConnectionManager.addConnectionProvider(cp, true);
        }
    }

    public static void addConnectionProvider(ConnectionProvider p2, boolean replace) {
        if (p2 == null) {
            throw new IllegalArgumentException("provider is null!");
        }
        ConnectionManager.init();
        String scheme = p2.getScheme();
        if (scheme == null) {
            throw new IllegalArgumentException("provider scheme is null!");
        }
        int size = providers.size();
        int i2 = 0;
        while (i2 < size) {
            ConnectionProvider cp = (ConnectionProvider)providers.get(i2);
            if (scheme.equals(cp.getScheme())) {
                if (replace) {
                    providers.remove(i2);
                    providers.add(p2);
                    return;
                }
                throw new IllegalArgumentException("provider with the same scheme already registered!");
            }
            ++i2;
        }
        providers.add(p2);
    }

    public static void addConnectionProvider(String className, String params, boolean replace) {
        try {
            Class<?> c2 = Class.forName(className);
            Object o2 = c2.newInstance();
            if (o2 instanceof ConnectionProvider) {
                ConnectionProvider cp = (ConnectionProvider)o2;
                if (cp.init(params)) {
                    ConnectionManager.addConnectionProvider(cp, replace);
                }
            } else {
                System.out.println("Pstros: class=" + className + " is not instance of the ConnectionProvider!");
            }
        }
        catch (Exception e2) {
            System.out.println(e2);
        }
    }

    public static ConnectionProvider getProvider(String scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException("scheme is null!");
        }
        ConnectionManager.init();
        int size = providers.size();
        int i2 = 0;
        while (i2 < size) {
            ConnectionProvider cp = (ConnectionProvider)providers.get(i2);
            if (scheme.equals(cp.getScheme())) {
                return cp;
            }
            ++i2;
        }
        return null;
    }
}

