/*
 * Decompiled with CFR 0.152.
 */
package ole.pstros.monitor;

import java.lang.reflect.Field;
import java.util.Vector;
import ole.pstros.monitor.ClassManager;
import ole.pstros.monitor.Variable;
import ole.pstros.utils.ListItem;

class ClassMonitor {
    private Class baseClass;
    private Vector variables;
    private Vector watchedVars;
    private static ListItem[] items;

    public ClassMonitor(Class newClass) {
        if (newClass == null) {
            throw new NullPointerException();
        }
        this.baseClass = newClass;
        this.variables = new Vector();
        this.watchedVars = new Vector();
        this.init();
    }

    private void init() {
        this.variables.removeAllElements();
        Field[] fields = this.baseClass.getDeclaredFields();
        int size = fields.length;
        int i2 = 0;
        while (i2 < size) {
            Variable v = new Variable(this.baseClass, fields[i2], this);
            this.variables.add(v);
            ++i2;
        }
        SecurityManager sm = System.getSecurityManager();
    }

    public Class getBaseClass() {
        return this.baseClass;
    }

    private int getArrayIndex(String name) {
        int startIndex = name.indexOf(91);
        int endIndex = name.indexOf(93, startIndex);
        if (startIndex < 0 || endIndex < 0) {
            return -1;
        }
        try {
            return Integer.parseInt(name.substring(startIndex + 1, endIndex));
        }
        catch (Exception e2) {
            return -1;
        }
    }

    private String getArrayName(String name) {
        int startIndex = name.indexOf(91);
        if (startIndex < 0) {
            return name;
        }
        return name.substring(0, startIndex);
    }

    private String getVariableName(String fullName, int level) {
        if (level < 0) {
            return null;
        }
        int startOffs = 0;
        int endOffs = 0;
        if (level > 0) {
            startOffs = -1;
            int i2 = 0;
            while (i2 < level) {
                ++startOffs;
                startOffs = fullName.indexOf(46, startOffs);
                ++i2;
            }
            if (startOffs < 0) {
                return null;
            }
            ++startOffs;
        }
        if ((endOffs = fullName.indexOf(46, startOffs)) < 0) {
            endOffs = fullName.length();
        }
        return fullName.substring(startOffs, endOffs);
    }

    public boolean isWatched(String fullName) {
        int size = this.watchedVars.size();
        int i2 = 0;
        while (i2 < size) {
            Variable v = (Variable)this.watchedVars.get(i2);
            if (fullName.equals(v.getFulName())) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public int addWatchedVariable(String fullName, int level) {
        int size = this.variables.size();
        Variable v = null;
        if (this.isWatched(fullName)) {
            return level;
        }
        String varName = this.getVariableName(fullName, level);
        if (varName == null) {
            return level;
        }
        int arrayIndex = this.getArrayIndex(varName);
        if (arrayIndex > -1) {
            varName = this.getArrayName(varName);
        }
        int i2 = 0;
        while (i2 < size) {
            v = (Variable)this.variables.get(i2);
            if (varName.equals(v.getName())) break;
            v = null;
            ++i2;
        }
        if (v != null) {
            Variable watchVariable = new Variable(v, arrayIndex);
            Class cl = watchVariable.getType();
            watchVariable.setFullName(fullName);
            this.watchedVars.add(watchVariable);
            if (cl.isPrimitive()) {
                watchVariable.setLeaf(true);
            } else {
                ClassManager man = ClassManager.getInstance();
                ClassMonitor mon = man.getClassMonitor(cl);
                if (mon != null) {
                    int newLevel = mon.addWatchedVariable(fullName, level + 1);
                    if (newLevel > level + 1) {
                        watchVariable.setClassMonitor(mon);
                    } else {
                        watchVariable.setLeaf(true);
                        watchVariable.setClassMonitor(this);
                    }
                }
            }
            return level + 1;
        }
        return level;
    }

    public void cleanWatchedVariables() {
        this.watchedVars.clear();
    }

    public int getVariableCount() {
        return this.watchedVars.size();
    }

    public ListItem[] getVariables(Object object) {
        int size = this.watchedVars.size();
        if (items == null || items.length < size) {
            items = new ListItem[size];
            int i2 = 0;
            while (i2 < size) {
                ClassMonitor.items[i2] = new ListItem(2);
                ++i2;
            }
        }
        int i3 = 0;
        while (i3 < size) {
            Variable v = (Variable)this.watchedVars.get(i3);
            this.dumpVar(v, object, v.getFulName(), items[i3]);
            ++i3;
        }
        return items;
    }

    public void dumpVariable(Object object, String fullName, ListItem listItem) {
        int size = this.watchedVars.size();
        int i2 = 0;
        while (i2 < size) {
            Variable v = (Variable)this.watchedVars.get(i2);
            if (fullName.equals(v.getFulName())) {
                this.dumpVar(v, object, fullName, listItem);
            }
            ++i2;
        }
    }

    private void dumpVar(Variable v, Object object, String fullName, ListItem listItem) {
        ClassMonitor cm = v.getClassMonitor();
        if (cm == this) {
            v.update(object);
            listItem.setColumnValue(0, v.getFulName());
            listItem.setColumnValue(1, v.getStringValue());
            listItem.setChanged(v.hasChanged());
        } else if (cm != null) {
            cm.dumpVariable(v.getValue(object, v.getArrayIndex()), fullName, listItem);
        }
    }
}

