/*
 * Decompiled with CFR 0.152.
 */
package ole.pstros.monitor;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import ole.pstros.monitor.ClassMonitor;

class Variable {
    protected Class parent;
    protected Field field;
    protected ClassMonitor monitor;
    private boolean change;
    private String value;
    private boolean leaf;
    private String fullName;
    private int arrayIndex;

    public Variable(Class parent, Field field, ClassMonitor cm) {
        if (parent == null || field == null) {
            throw new NullPointerException();
        }
        this.parent = parent;
        this.field = field;
        this.monitor = cm;
        field.setAccessible(true);
        this.update(null);
    }

    public Variable(Variable v) {
        this(v, -1);
    }

    public Variable(Variable v, int arrayIndex) {
        this(v.parent, v.field, v.monitor);
        this.arrayIndex = arrayIndex;
    }

    public void update(Object object) {
        String newValue = "";
        if (object != null) {
            try {
                Object result = this.field.get(object);
                if (result != null) {
                    if (result.getClass().isArray()) {
                        try {
                            newValue = Array.get(result, this.arrayIndex).toString();
                        }
                        catch (ArrayIndexOutOfBoundsException e2) {
                            newValue = "array index out of bounds!";
                        }
                        catch (Exception e3) {
                            newValue = "error";
                        }
                    } else {
                        newValue = result.toString();
                    }
                } else {
                    newValue = "null";
                }
            }
            catch (Exception e4) {
                System.out.println("Error: " + e4 + " object=" + object);
                e4.printStackTrace();
            }
        }
        this.change = false;
        if (!newValue.equals(this.value)) {
            this.change = true;
        }
        this.value = newValue;
    }

    public Object getValue(Object object, int arIndex) {
        Object result;
        block5: {
            try {
                result = this.field.get(object);
                if (!result.getClass().isArray()) break block5;
                try {
                    return Array.get(result, arIndex);
                }
                catch (Exception e2) {
                    return null;
                }
            }
            catch (Exception e3) {
                System.out.println("Error: " + e3);
                return null;
            }
        }
        return result;
    }

    public int getArrayIndex() {
        return this.arrayIndex;
    }

    public boolean hasChanged() {
        return this.change;
    }

    public String getName() {
        return this.field.getName();
    }

    public String getStringValue() {
        return this.value;
    }

    public Class getType() {
        return this.field.getType();
    }

    public void setLeaf(boolean state) {
        this.leaf = state;
    }

    public boolean isLeaf() {
        return this.leaf;
    }

    public void setClassMonitor(ClassMonitor cm) {
        this.monitor = cm;
    }

    public ClassMonitor getClassMonitor() {
        return this.monitor;
    }

    public void setFullName(String name) {
        this.fullName = name;
    }

    public String getFulName() {
        return this.fullName;
    }
}

