/*
 * Decompiled with CFR 0.152.
 */
package ole.pstros.reference;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Vector;
import javax.microedition.lcdui.Image;
import ole.pstros.ConfigData;
import ole.pstros.reference.ImageWeakReference;

public class ImageReferenceManager {
    private static ReferenceQueue referenceQueue = new ReferenceQueue();
    private static Vector references = new Vector();
    private static int imageMemorySize = 0;
    private static int peakMemorySize = 0;

    public static void addImage(Image image) throws Exception {
        ImageWeakReference iwr = new ImageWeakReference(image, referenceQueue);
        references.add(iwr);
        if ((imageMemorySize += iwr.getImageSize()) > peakMemorySize) {
            peakMemorySize = imageMemorySize;
        }
        if (imageMemorySize > ConfigData.videoMemoryLimit) {
            throw new Exception("not enough video memory ! allocated=" + imageMemorySize + " limit=" + ConfigData.videoMemoryLimit);
        }
    }

    public static int getImageMemorySize() {
        return imageMemorySize;
    }

    public static int getPeakMemorySize() {
        return peakMemorySize;
    }

    public static int update() {
        Reference ir = referenceQueue.poll();
        while (ir != null) {
            imageMemorySize -= ((ImageWeakReference)ir).getImageSize();
            references.remove(ir);
            ir = referenceQueue.poll();
        }
        return imageMemorySize;
    }

    public static Vector getImages() {
        Vector result = new Vector();
        int size = references.size();
        int memorySize = 0;
        int i2 = 0;
        while (i2 < size) {
            ImageWeakReference wr = (ImageWeakReference)references.get(i2);
            if (wr != null) {
                Object object = wr.get();
                if (object != null) {
                    result.add(object);
                }
                if (object instanceof Image) {
                    Image img = (Image)object;
                    memorySize += img.getWidth() * img.getHeight();
                }
            }
            ++i2;
        }
        System.out.println("Pstros: total size of the images :" + (memorySize >> 10) + " kPix");
        return result;
    }
}

