/*
 * Decompiled with CFR 0.152.
 */
package ole.pstros.rms;

import java.util.Vector;
import ole.pstros.rms.RmsRecord;

public class RmsGroup {
    private String name;
    private String app;
    private Vector records;
    private boolean publicGroup;
    private int recordCounter;

    public RmsGroup(String appName, String name) {
        this.app = appName;
        this.name = name;
        this.records = new Vector();
        this.recordCounter = 1;
    }

    public String getName() {
        return this.name;
    }

    public String getApplicationName() {
        return this.app;
    }

    public int addRecord(byte[] data) {
        RmsRecord record = new RmsRecord(this.recordCounter, data);
        ++this.recordCounter;
        this.records.add(record);
        return record.getId();
    }

    public int addRecord(byte[] data, int pos, int length) {
        RmsRecord record = new RmsRecord(this.recordCounter, data, pos, length);
        ++this.recordCounter;
        this.records.add(record);
        return record.getId();
    }

    public boolean removeRecord(int recordId) {
        RmsRecord record = this.findRecord(recordId);
        if (record == null) {
            return false;
        }
        return this.records.remove(record);
    }

    public RmsRecord findRecord(int recordId) {
        int size = this.records.size();
        int i2 = 0;
        while (i2 < size) {
            RmsRecord item = (RmsRecord)this.records.get(i2);
            if (item.getId() == recordId) {
                return item;
            }
            ++i2;
        }
        return null;
    }

    public int getNextRecordId() {
        return this.recordCounter;
    }

    public int getSize() {
        return this.records.size();
    }

    public byte[] getRecordData(int recordId) {
        RmsRecord result = this.findRecord(recordId);
        if (result == null) {
            return null;
        }
        return result.getData();
    }

    public RmsRecord getRecord(int recordId) {
        RmsRecord result = this.findRecord(recordId);
        if (result == null) {
            return null;
        }
        return result;
    }

    public int getDataSize() {
        int total = 0;
        int size = this.records.size();
        int i2 = 0;
        while (i2 < size) {
            RmsRecord item = (RmsRecord)this.records.get(i2);
            total += item.getData().length;
            ++i2;
        }
        return total;
    }

    public void setAuthMode(boolean publicMode) {
        this.publicGroup = publicMode;
    }

    public boolean isPublic() {
        return this.publicGroup;
    }

    public boolean isPrivate() {
        return !this.publicGroup;
    }
}

